/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.service.exporter.support;

import java.util.Arrays;
import java.util.Dictionary;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.Ordered;
import org.springframework.osgi.context.BundleContextAware;
import org.springframework.osgi.context.internal.classloader.ClassLoaderFactory;
import org.springframework.osgi.context.support.internal.OsgiBundleScope;
import org.springframework.osgi.service.exporter.OsgiServicePropertiesResolver;
import org.springframework.osgi.service.exporter.support.AbstractOsgiServiceExporter;
import org.springframework.osgi.service.exporter.support.AutoExport;
import org.springframework.osgi.service.exporter.support.BeanNameServicePropertiesResolver;
import org.springframework.osgi.service.exporter.support.ExportContextClassLoader;
import org.springframework.osgi.service.exporter.support.internal.controller.ExporterController;
import org.springframework.osgi.service.exporter.support.internal.controller.ExporterInternalActions;
import org.springframework.osgi.service.exporter.support.internal.support.PublishingServiceFactory;
import org.springframework.osgi.util.OsgiServiceUtils;
import org.springframework.osgi.util.internal.ClassUtils;
import org.springframework.osgi.util.internal.MapBasedDictionary;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class OsgiServiceFactoryBean
extends AbstractOsgiServiceExporter
implements BeanClassLoaderAware,
BeanFactoryAware,
BeanNameAware,
BundleContextAware,
FactoryBean,
InitializingBean,
Ordered {
    private static final Log log = LogFactory.getLog((Class)OsgiServiceFactoryBean.class);
    private BundleContext bundleContext;
    private OsgiServicePropertiesResolver propertiesResolver;
    private BeanFactory beanFactory;
    private ServiceRegistration serviceRegistration;
    private Map serviceProperties;
    private int ranking;
    private String targetBeanName;
    private boolean hasNamedBean;
    private Class[] interfaces;
    private AutoExport autoExport = AutoExport.DISABLED;
    private ExportContextClassLoader contextClassLoader = ExportContextClassLoader.UNMANAGED;
    private Object target;
    private Class targetClass;
    private int order = Integer.MAX_VALUE;
    private ClassLoader classLoader;
    private ClassLoader aopClassLoader;
    private String beanName;
    private boolean serviceRegistered = false;
    private boolean registerAtStartup = true;
    private boolean registerService = true;
    private final Object lock = new Object();
    private final ExporterController controller = new ExporterController(new Executor());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() throws Exception {
        boolean shouldRegisterAtStartup;
        Assert.notNull((Object)this.bundleContext, (String)"required property 'bundleContext' has not been set");
        this.hasNamedBean = StringUtils.hasText((String)this.targetBeanName);
        Assert.isTrue((this.hasNamedBean || this.target != null ? 1 : 0) != 0, (String)"Either 'targetBeanName' or 'target' properties have to be set.");
        if (this.hasNamedBean) {
            Assert.notNull((Object)this.beanFactory, (String)"Required property 'beanFactory' has not been set.");
        }
        if (this.hasNamedBean) {
            Assert.isTrue((boolean)this.beanFactory.containsBean(this.targetBeanName), (String)("Cannot locate bean named '" + this.targetBeanName + "' inside the running bean factory."));
            if (this.beanFactory.isSingleton(this.targetBeanName)) {
                this.target = this.beanFactory.getBean(this.targetBeanName);
                this.targetClass = this.target.getClass();
            } else {
                this.targetClass = this.beanFactory.getType(this.targetBeanName);
            }
            this.addBeanFactoryDependency();
        } else {
            this.targetClass = this.target.getClass();
        }
        if (this.propertiesResolver == null) {
            this.propertiesResolver = new BeanNameServicePropertiesResolver();
            ((BeanNameServicePropertiesResolver)this.propertiesResolver).setBundleContext(this.bundleContext);
        }
        if (this.interfaces == null) {
            if (AutoExport.DISABLED.equals((Object)this.autoExport)) {
                throw new IllegalArgumentException("No service interface(s) specified and auto-export discovery disabled; change at least one of these properties.");
            }
            this.interfaces = new Class[0];
        } else if (!ServiceFactory.class.isAssignableFrom(this.targetClass)) {
            for (int interfaceIndex = 0; interfaceIndex < this.interfaces.length; ++interfaceIndex) {
                Class intf = this.interfaces[interfaceIndex];
                Assert.isAssignable((Class)intf, (Class)this.targetClass, (String)"Exported service object does not implement the given interface: ");
            }
        }
        Object object = this.lock;
        synchronized (object) {
            shouldRegisterAtStartup = this.registerAtStartup;
        }
        if (shouldRegisterAtStartup) {
            this.registerService();
        }
    }

    private void addBeanFactoryDependency() {
        if (this.beanFactory instanceof ConfigurableBeanFactory) {
            ConfigurableBeanFactory cbf = (ConfigurableBeanFactory)this.beanFactory;
            if (StringUtils.hasText((String)this.beanName) && cbf.containsBean(this.beanName)) {
                cbf.registerDependentBean(this.targetBeanName, "&" + this.beanName);
                cbf.registerDependentBean(this.targetBeanName, this.beanName);
            }
        } else {
            log.warn((Object)"The running bean factory cannot support dependencies between beans - importer/exporter dependency cannot be enforced");
        }
    }

    private Dictionary mergeServiceProperties(String beanName) {
        MapBasedDictionary props = new MapBasedDictionary(this.propertiesResolver.getServiceProperties(beanName));
        props.putAll((Map)props);
        if (this.serviceProperties != null) {
            props.putAll(this.serviceProperties);
        }
        if (this.ranking != 0) {
            props.put("service.ranking", new Integer(this.ranking));
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerService() {
        Object object = this.lock;
        synchronized (object) {
            if (this.serviceRegistered || !this.registerService) {
                return;
            }
            this.serviceRegistered = true;
        }
        String beanName = !this.hasNamedBean ? ObjectUtils.getIdentityHexString((Object)this.target) : this.targetBeanName;
        Dictionary serviceProperties = this.mergeServiceProperties(beanName);
        Class[] intfs = this.interfaces;
        ClassLoader beanClassLoader = ClassUtils.getClassLoader(this.targetClass);
        Object[] autoDetectedClasses = ClassUtils.getVisibleClasses(this.autoExport.getExportedClasses(this.targetClass), beanClassLoader);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Autoexport mode [" + (Object)((Object)this.autoExport) + "] discovered on class [" + this.targetClass + "] classes " + ObjectUtils.nullSafeToString((Object[])autoDetectedClasses)));
        }
        LinkedHashSet classes = new LinkedHashSet(intfs.length + autoDetectedClasses.length);
        CollectionUtils.mergeArrayIntoCollection((Object)intfs, classes);
        CollectionUtils.mergeArrayIntoCollection((Object)autoDetectedClasses, classes);
        Class[] mergedClasses = classes.toArray(new Class[classes.size()]);
        ServiceRegistration reg = this.registerService(mergedClasses, serviceProperties);
        this.serviceRegistration = this.notifyListeners(this.target, (Map)((Object)serviceProperties), reg);
    }

    ServiceRegistration registerService(Class[] classes, Dictionary serviceProperties) {
        Assert.notEmpty((Object[])classes, (String)"at least one class has to be specified for exporting (if autoExport is enabled then maybe the object doesn't implement any interface)");
        Object[] names = ClassUtils.toStringArray(classes);
        Arrays.sort(names);
        log.info((Object)("Publishing service under classes [" + ObjectUtils.nullSafeToString((Object[])names) + "]"));
        Object serviceFactory = new PublishingServiceFactory(classes, this.target, this.beanFactory, this.targetBeanName, this.contextClassLoader == ExportContextClassLoader.SERVICE_PROVIDER, this.classLoader, this.aopClassLoader, this.bundleContext);
        if (this.isBeanBundleScoped()) {
            serviceFactory = new OsgiBundleScope.BundleScopeServiceFactory((ServiceFactory)serviceFactory);
        }
        return this.bundleContext.registerService((String[])names, serviceFactory, serviceProperties);
    }

    private boolean isBeanBundleScoped() {
        boolean bundleScoped = false;
        if (this.targetBeanName != null) {
            if (this.beanFactory instanceof ConfigurableListableBeanFactory) {
                String beanScope = ((ConfigurableListableBeanFactory)this.beanFactory).getMergedBeanDefinition(this.targetBeanName).getScope();
                bundleScoped = "bundle".equals(beanScope);
            } else {
                bundleScoped = true;
            }
        }
        return bundleScoped;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.aopClassLoader = ClassLoaderFactory.getAopClassLoaderFor(classLoader);
    }

    public Object getObject() throws Exception {
        return this.serviceRegistration;
    }

    public Class getObjectType() {
        return this.serviceRegistration != null ? this.serviceRegistration.getClass() : ServiceRegistration.class;
    }

    public boolean isSingleton() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterService() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.serviceRegistered) {
                return;
            }
            this.serviceRegistered = false;
        }
        this.unregisterService(this.serviceRegistration);
        this.serviceRegistration = null;
    }

    void unregisterService(ServiceRegistration registration) {
        if (OsgiServiceUtils.unregisterService(registration)) {
            log.info((Object)("Unregistered service [" + registration + "]"));
        }
    }

    public void setContextClassLoader(ExportContextClassLoader ccl) {
        Assert.notNull((Object)((Object)ccl));
        this.contextClassLoader = ccl;
    }

    public Object getTarget() {
        return this.target;
    }

    public void setTarget(Object target) {
        this.target = target;
    }

    public String getTargetBeanName() {
        return this.targetBeanName;
    }

    public void setTargetBeanName(String name) {
        this.targetBeanName = name;
    }

    public void setAutoExport(AutoExport classExporter) {
        Assert.notNull((Object)((Object)classExporter));
        this.autoExport = classExporter;
    }

    public Map getServiceProperties() {
        return this.serviceProperties;
    }

    public void setServiceProperties(Map serviceProperties) {
        this.serviceProperties = serviceProperties;
    }

    public int getRanking() {
        return this.ranking;
    }

    public void setRanking(int ranking) {
        this.ranking = ranking;
    }

    public void setRegisterService(boolean register) {
        this.registerService = register;
        if (this.registerService && this.targetClass != null) {
            this.registerService();
        }
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setBundleContext(BundleContext context) {
        this.bundleContext = context;
    }

    public OsgiServicePropertiesResolver getResolver() {
        return this.propertiesResolver;
    }

    public void setResolver(OsgiServicePropertiesResolver resolver) {
        this.propertiesResolver = resolver;
    }

    public Class[] getInterfaces() {
        return this.interfaces;
    }

    public void setInterfaces(Class[] interfaces) {
        this.interfaces = interfaces;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    private class Executor
    implements ExporterInternalActions {
        private Executor() {
        }

        public void registerService() {
            OsgiServiceFactoryBean.this.registerService();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void registerServiceAtStartup(boolean register) {
            Object object = OsgiServiceFactoryBean.this.lock;
            synchronized (object) {
                OsgiServiceFactoryBean.this.registerAtStartup = register;
            }
        }

        public void unregisterService() {
            OsgiServiceFactoryBean.this.unregisterService();
        }
    }
}

