/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.internal;

import java.util.Objects;
import org.apache.sis.referencing.ImmutableIdentifier;
import org.apache.sis.util.Deprecable;
import org.opengis.metadata.citation.Citation;
import org.opengis.util.InternationalString;

public final class DeprecatedCode
extends ImmutableIdentifier
implements Deprecable {
    private static final long serialVersionUID = 8186104136524932846L;
    public final String replacedBy;
    private final InternationalString remarks;

    public DeprecatedCode(Citation authority, String codeSpace, String code, String version, InternationalString description, String replacedBy, InternationalString remarks) {
        super(authority, codeSpace, code, version, remarks);
        this.replacedBy = replacedBy;
        this.remarks = remarks;
    }

    public boolean isDeprecated() {
        return true;
    }

    public InternationalString getRemarks() {
        return this.remarks;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 37 * Objects.hash(this.replacedBy, this.remarks);
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            DeprecatedCode other = (DeprecatedCode)obj;
            return Objects.equals(this.replacedBy, other.replacedBy) && Objects.equals(this.remarks, other.remarks);
        }
        return false;
    }
}

