/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.baidu.brpc3;

import com.baidu.brpc.client.channel.ServiceInstance;
import com.baidu.brpc.protocol.Request;
import com.baidu.brpc.protocol.Response;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceConstructorInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;

public class ClientInterceptor
implements InstanceMethodsAroundInterceptor,
InstanceConstructorInterceptor {
    public void onConstruct(EnhancedInstance enhancedInstance, Object[] objects) throws Throwable {
        ServiceInstance url = (ServiceInstance)objects[0];
        enhancedInstance.setSkyWalkingDynamicField((Object)(url.getIp() + ":" + url.getPort()));
    }

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        String peer = (String)objInst.getSkyWalkingDynamicField();
        Request request = (Request)allArguments[0];
        String operationName = this.generateOperationName(request);
        ContextCarrier contextCarrier = new ContextCarrier();
        AbstractSpan span = ContextManager.createExitSpan((String)operationName, (ContextCarrier)contextCarrier, (String)peer);
        CarrierItem next = contextCarrier.items();
        if (request.getKvAttachment() == null) {
            request.setKvAttachment(new HashMap());
        }
        while (next.hasNext()) {
            next = next.next();
            request.getKvAttachment().put(next.getHeadKey(), next.getHeadValue());
        }
        span.setComponent((Component)ComponentsDefine.BRPC_JAVA);
        SpanLayer.asRPCFramework((AbstractSpan)span);
        Tags.URL.set(span, peer + "/" + operationName);
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        Response response = (Response)allArguments[1];
        if (response != null && response.getException() != null) {
            this.dealException(response.getException());
        }
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        this.dealException(t);
    }

    private void dealException(Throwable throwable) {
        AbstractSpan span = ContextManager.activeSpan();
        span.log(throwable);
    }

    private String generateOperationName(Request request) {
        StringBuilder operationName = new StringBuilder();
        operationName.append(request.getServiceName() + "." + request.getMethodName());
        return operationName.toString();
    }
}

