/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.redisson.v3;

import java.lang.reflect.Method;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.redisson.api.RFuture;
import org.redisson.api.RLock;

public class RedissonLockInterceptor
implements InstanceMethodsAroundInterceptor {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        AbstractSpan span = ContextManager.createLocalSpan((String)"Redisson/LOCK");
        span.setComponent((Component)ComponentsDefine.REDISSON);
        SpanLayer.asCache((AbstractSpan)span);
        RLock rLock = (RLock)objInst;
        Tags.LOCK_NAME.set(span, rLock.getName());
        Tags.CACHE_TYPE.set(span, "Redis");
        TimeUnit unit = (TimeUnit)((Object)allArguments[1]);
        Tags.LEASE_TIME.set(span, String.valueOf(unit.toMillis((Long)allArguments[0])));
        Tags.THREAD_ID.set(span, String.valueOf(allArguments[2]));
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        AbstractSpan span = ContextManager.activeSpan();
        span.prepareForAsync();
        ContextManager.stopSpan();
        RFuture future = (RFuture)ret;
        CompletableFuture completableFuture = future.toCompletableFuture();
        completableFuture.whenComplete((res, ex) -> {
            if (ex != null) {
                span.errorOccurred();
                span.log(ex);
            }
            span.asyncFinish();
        });
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        ContextManager.activeSpan().log(t);
    }
}

