# Contributing to Apache SkyWalking Ruby

Firstly, thanks for your interest in contributing! We hope that this will be a pleasant experience for you,
so that you will return to continue contributing.

## Code of Conduct

The project and everyone participating in it is governed by the Apache software Foundation's [Code of Conduct](http://www.apache.org/foundation/policies/conduct.html).
By participating, you are expected to adhere to this code. If you are aware of unacceptable behavior, please visit the [Reporting Guidelines page](http://www.apache.org/foundation/policies/conduct.html#reporting-guidelines)
and follow the instructions there.

## Contribute

Most of the contributions that we receive are code contributions, but you can also contribute to the documentation or simply report solid bugs for us to fix.

## Report a bug

* **Ensure the bug was not already reported** by searching on GitHub under [Issues](https://github.com/apache/skywalking/issues).

* If you're unable to find an issue addressing the problem, [open a new one](https://github.com/apache/skywalking/issues/new).
Be sure to include a **title and clear description**, as much relevant information as possible, and a **code sample** or an **executable test case** demonstrating the expected behavior that is not happening.

## Compiling and building

We recommend using a Ruby base image of at least 3.0 to build skywalking-ruby project

```shell
docker run -it --rm -v $(pwd)/skywalking-ruby:/workspace -w /workspace ruby:3.0 bash
```

Then run the following commands to build the project:

```shell
gem build skywalking.gemspec
```

## Add a new feature or enhance an existing one

_Before making any significant changes, please [open an issue](https://github.com/apache/skywalking/issues)._
Discussing your proposed changes ahead of time will make the contribution process smooth for everyone.

Once we've discussed your changes and you've got your code ready, make sure that tests are passing and open your pull request. Your PR is most likely to be accepted if it:

* Update the README.md with details of changes to the interface.
* Includes tests for new functionality.
* References the original issue in description, e.g. "Resolves #123", "Closes #123", or "Fixes #123", etc.
* Has a [good commit message](http://tbaggery.com/2008/04/19/a-note-about-git-commit-messages.html).

## Questions about the source code

* Join `#skywalking` channel at [Apache Slack](https://s.apache.org/slack-invite)
