/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.caconfig.bndplugin;

import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Clazz;
import aQute.bnd.osgi.Instruction;
import aQute.bnd.service.AnalyzerPlugin;
import aQute.bnd.service.Plugin;
import aQute.service.reporter.Reporter;
import java.util.Collection;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;

public class ConfigurationClassScannerPlugin
implements AnalyzerPlugin,
Plugin {
    static final String CONFIGURATION_ANNOTATION_CLASS = "org.apache.sling.caconfig.annotation.Configuration";
    static final String CONFIGURATION_CLASSES_HEADER = "Sling-ContextAware-Configuration-Classes";
    private Reporter reporter;

    public void setProperties(Map<String, String> map) throws Exception {
    }

    public void setReporter(Reporter reporter) {
        this.reporter = reporter;
    }

    public boolean analyzeJar(Analyzer analyzer) throws Exception {
        Collection<String> classNames = this.getClassesWithAnnotation(CONFIGURATION_ANNOTATION_CLASS, analyzer);
        if (!classNames.isEmpty()) {
            analyzer.set(CONFIGURATION_CLASSES_HEADER, StringUtils.join(classNames, (String)","));
        }
        return false;
    }

    private Collection<String> getClassesWithAnnotation(String annotationClassName, Analyzer analyzer) {
        TreeSet<String> classNames = new TreeSet<String>();
        Collection clazzes = analyzer.getClassspace().values();
        Instruction instruction = new Instruction(annotationClassName);
        try {
            for (Clazz clazz : clazzes) {
                if (!clazz.isAnnotation() || !clazz.is(Clazz.QUERY.ANNOTATED, instruction, analyzer)) continue;
                classNames.add(clazz.getClassName().getFQN());
            }
        }
        catch (Exception ex) {
            this.reporter.exception((Throwable)ex, "Error querying for classes with annotation: " + annotationClassName, new Object[0]);
        }
        return classNames;
    }
}

