/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.html.util;

import java.util.Map;
import java.util.function.Consumer;
import org.apache.sling.commons.html.AttrValue;
import org.apache.sling.commons.html.HtmlElement;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.Attributes2Impl;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.ext.LexicalHandler;

public class HtmlSAXSupport
implements Consumer<HtmlElement> {
    private static final DefaultHandler2 handler = new DefaultHandler2();
    private ContentHandler contentHandler = handler;
    private LexicalHandler lexicalHandler = handler;
    private boolean initialized;

    public HtmlSAXSupport(ContentHandler ch, LexicalHandler lh) {
        if (ch != null) {
            this.contentHandler = ch;
        }
        if (lh != null) {
            this.lexicalHandler = lh;
        }
    }

    @Override
    public void accept(HtmlElement element) {
        try {
            if (!this.initialized) {
                this.contentHandler.startDocument();
                this.initialized = true;
            }
            String value = element.getValue();
            switch (element.getType()) {
                case COMMENT: {
                    this.lexicalHandler.comment(value.toCharArray(), 0, value.length());
                    break;
                }
                case DOCTYPE: {
                    break;
                }
                case END_TAG: {
                    this.lexicalHandler.endEntity(value);
                    this.contentHandler.endElement("", value, value);
                    break;
                }
                case EOF: {
                    this.contentHandler.endDocument();
                    break;
                }
                case START_TAG: {
                    this.lexicalHandler.startEntity(value);
                    this.contentHandler.startElement("", value, value, HtmlSAXSupport.convert(element.getAttributes()));
                    break;
                }
                case TEXT: {
                    this.contentHandler.characters(value.toCharArray(), 0, value.toCharArray().length);
                    break;
                }
            }
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    public static Attributes convert(Map<String, AttrValue> attributes) {
        Attributes2Impl response = new Attributes2Impl();
        attributes.entrySet().forEach(attr -> response.addAttribute("", (String)attr.getKey(), (String)attr.getKey(), "xsi:String", ((AttrValue)attr.getValue()).toString()));
        return response;
    }
}

