/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.analyser.task.impl;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import org.apache.jackrabbit.vault.packaging.Dependency;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.apache.jackrabbit.vault.packaging.PackageManager;
import org.apache.jackrabbit.vault.packaging.VaultPackage;
import org.apache.jackrabbit.vault.packaging.impl.PackageManagerImpl;
import org.apache.sling.feature.analyser.task.AnalyserTask;
import org.apache.sling.feature.analyser.task.AnalyserTaskContext;
import org.apache.sling.feature.io.IOUtils;
import org.apache.sling.feature.scanner.ArtifactDescriptor;
import org.apache.sling.feature.scanner.ContentPackageDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckContentPackagesDependencies
implements AnalyserTask {
    private final PackageManager packageManager = new PackageManagerImpl();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public String getId() {
        return "content-packages-dependencies";
    }

    @Override
    public String getName() {
        return "Content packages dependencies checker";
    }

    @Override
    public void execute(AnalyserTaskContext ctx) throws Exception {
        HashMap<PackageId, Dependency[]> dependenciesMap = new HashMap<PackageId, Dependency[]>();
        for (ArtifactDescriptor artifactDescriptor : ctx.getFeatureDescriptor().getDescriptors(ContentPackageDescriptor.class)) {
            this.onDescriptor(ctx, artifactDescriptor, dependenciesMap);
        }
        for (PackageId packageId : dependenciesMap.keySet()) {
            this.verifyDependenciesTree(ctx, packageId, dependenciesMap);
        }
    }

    private void onDescriptor(AnalyserTaskContext ctx, ArtifactDescriptor descriptor, Map<PackageId, Dependency[]> dependenciesMap) throws Exception {
        URL resourceUrl = descriptor.getArtifactFile();
        if (resourceUrl != null) {
            File artifactFile = IOUtils.getFileFromURL((URL)resourceUrl, (boolean)true, null);
            if (!artifactFile.exists() || !artifactFile.isFile()) {
                ctx.reportArtifactError(descriptor.getArtifact().getId(), "Artifact file " + artifactFile + " does not exist or it is not a file");
                return;
            }
            try (VaultPackage vaultPackage = this.packageManager.open(artifactFile, true);){
                PackageId packageId = vaultPackage.getId();
                this.logger.debug("Collecting " + packageId + " dependencies...");
                dependenciesMap.put(packageId, vaultPackage.getDependencies());
                this.logger.debug(packageId + " dependencies collected.");
            }
        } else {
            ctx.reportArtifactError(descriptor.getArtifact().getId(), "Ignoring " + descriptor.getName() + " as file could not be found");
        }
    }

    private void verifyDependenciesTree(AnalyserTaskContext ctx, PackageId root, Map<PackageId, Dependency[]> dependenciesMap) {
        this.logger.debug("Verifying " + root + " transitive dependencies...");
        LinkedList<Dependency> toBeVisited = new LinkedList<Dependency>();
        CheckContentPackagesDependencies.enqueue(toBeVisited, dependenciesMap.get(root));
        HashSet<Dependency> alreadyVisited = new HashSet<Dependency>();
        while (!toBeVisited.isEmpty()) {
            Dependency current = (Dependency)toBeVisited.poll();
            if (!alreadyVisited.add(current)) continue;
            boolean found = false;
            for (Map.Entry<PackageId, Dependency[]> entry : dependenciesMap.entrySet()) {
                if (!current.matches(entry.getKey())) continue;
                CheckContentPackagesDependencies.enqueue(toBeVisited, entry.getValue());
                found = true;
                break;
            }
            if (found) continue;
            ctx.reportError("Missing " + current + " dependency for " + root);
        }
    }

    private static void enqueue(Queue<Dependency> target, Dependency ... dependencies) {
        if (dependencies == null) {
            return;
        }
        for (Dependency dependency : dependencies) {
            target.offer(dependency);
        }
    }
}

