/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.scanner;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.sling.feature.MatchingRequirement;
import org.apache.sling.feature.scanner.PackageInfo;
import org.apache.sling.feature.scanner.impl.NamespacedSets;
import org.jetbrains.annotations.Contract;
import org.osgi.resource.Capability;

public abstract class Descriptor {
    private final String name;
    private boolean locked;
    private final NamespacedSets<PackageInfo> exports = new NamespacedSets<PackageInfo>(PackageInfo.class, PackageInfo::getName);
    private final Set<PackageInfo> imports = new HashSet<PackageInfo>();
    private final Set<PackageInfo> dynImports = new HashSet<PackageInfo>();
    private final Set<MatchingRequirement> reqs = new HashSet<MatchingRequirement>();
    private final NamespacedSets<Capability> caps = new NamespacedSets<Capability>(Capability.class, Capability::getNamespace);

    protected Descriptor(String name) {
        this.name = name;
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
    }

    public void lock() {
        this.locked = true;
    }

    public final boolean isLocked() {
        return this.locked;
    }

    protected void checkLocked() {
        if (this.locked) {
            throw new IllegalStateException("Descriptor is locked.");
        }
    }

    protected void aggregate(Descriptor d) {
        this.reqs.addAll(d.getRequirements());
        d.getCapabilities().forEach(this.caps::add);
        this.dynImports.addAll(d.getDynamicImportedPackages());
        this.imports.addAll(d.getImportedPackages());
        d.getExportedPackages().forEach(this.exports::add);
    }

    public final Set<PackageInfo> getExportedPackages() {
        return this.unmodifiableIfLocked(this.exports.asSet());
    }

    public final Set<PackageInfo> getExportedPackages(String packageName) {
        return this.unmodifiableIfLocked(this.exports.getNamespacedSet(packageName));
    }

    public final Set<PackageInfo> getImportedPackages() {
        return this.unmodifiableIfLocked(this.imports);
    }

    public final Set<PackageInfo> getDynamicImportedPackages() {
        return this.unmodifiableIfLocked(this.dynImports);
    }

    public String getName() {
        return this.name;
    }

    public final Set<MatchingRequirement> getRequirements() {
        return this.unmodifiableIfLocked(this.reqs);
    }

    public final Set<Capability> getCapabilities() {
        return this.unmodifiableIfLocked(this.caps.asSet());
    }

    public final Set<Capability> getCapabilities(String namespace) {
        return this.unmodifiableIfLocked(this.caps.getNamespacedSet(namespace));
    }

    @Contract(value="null -> null; !null -> !null")
    private <T> Set<T> unmodifiableIfLocked(Set<T> set) {
        return this.locked && set != null ? Collections.unmodifiableSet(set) : set;
    }

    public String toString() {
        return this.name;
    }
}

