/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.core.impl.console;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.sling.installer.api.info.InfoProvider;
import org.apache.sling.installer.api.info.InstallationState;
import org.apache.sling.installer.api.info.Resource;
import org.apache.sling.installer.api.info.ResourceGroup;
import org.apache.sling.installer.api.tasks.RegisteredResource;
import org.apache.sling.installer.api.tasks.ResourceState;
import org.apache.sling.installer.core.impl.console.AbstractWebConsolePlugin;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={Servlet.class}, property={"service.vendor=The Apache Software Foundation", "service.description=Apache Sling OSGi Installer Web Console Plugin", "felix.webconsole.label=osgi-installer", "felix.webconsole.title=OSGi Installer", "felix.webconsole.category=OSGi", "felix.webconsole.configprinter.modes=zip", "felix.webconsole.configprinter.modes=txt", "felix.webconsole.css=osgi-installer/res/ui/list.css"})
public class OsgiInstallerWebConsolePlugin
extends AbstractWebConsolePlugin {
    public static final String LABEL = "osgi-installer";
    protected static final String RES_LOC = "osgi-installer/res/ui/";
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private InfoProvider installer;
    private final DateFormat dateFormat = new SimpleDateFormat("HH:mm:ss:SSS yyyy-MMM-dd");

    private String getType(RegisteredResource rsrc) {
        String type = rsrc.getType();
        if (type.equals("bundle")) {
            return "Bundles";
        }
        if (type.equals("config")) {
            return "Configurations";
        }
        if (type.equals("file")) {
            return "Files";
        }
        if (type.equals("properties")) {
            return "Properties";
        }
        return type;
    }

    private String getEntityId(RegisteredResource rsrc, String alias) {
        String id = rsrc.getEntityId();
        int pos = id.indexOf(58);
        if (pos != -1) {
            id = id.substring(pos + 1);
        }
        return alias == null ? id : id + '\n' + alias;
    }

    private String getURL(Resource rsrc) {
        if (rsrc.getVersion() != null) {
            return rsrc.getURL() + " (" + rsrc.getVersion() + ")";
        }
        return rsrc.getURL();
    }

    private String getState(Resource rsrc) {
        String stateInfo = rsrc.getState().toString();
        if (rsrc.getState() == ResourceState.INSTALLED) {
            if (rsrc.getAttribute("org.apache.sling.installer.api.resource.install.excluded") != null) {
                stateInfo = "EXCLUDED";
            }
            if (rsrc.getAttribute("org.apache.sling.installer.api.resource.install.info") != null) {
                stateInfo = stateInfo + "(*)";
            }
        }
        return stateInfo;
    }

    private String getError(Resource rsrc) {
        String error = rsrc.getError();
        return error != null ? error : "";
    }

    private String getInfo(RegisteredResource rsrc) {
        return rsrc.getDigest() + '/' + String.valueOf(rsrc.getPriority());
    }

    private synchronized String formatDate(long time) {
        if (time == -1L) {
            return "-";
        }
        Date d = new Date(time);
        return this.dateFormat.format(d);
    }

    public void service(ServletRequest req, ServletResponse res) throws IOException {
        StringWriter bufferedWriter = new StringWriter();
        PrintWriter bufferedPw = new PrintWriter(bufferedWriter);
        PrintWriter pw = res.getWriter();
        InstallationState state = this.installer.getInstallationState();
        pw.print("<p class='statline ui-state-highlight'>Apache Sling OSGi Installer");
        if (state.getActiveResources().size() == 0 && state.getInstalledResources().size() == 0 && state.getUntransformedResources().size() == 0) {
            pw.print(" - no resources registered.");
        }
        pw.print("</p>");
        pw.println("<ul class=list>");
        pw.println("<li>Active Resources");
        pw.println("<ul>");
        String rt = null;
        for (ResourceGroup group : state.getActiveResources()) {
            Resource toActivate = (Resource)group.getResources().get(0);
            if (!toActivate.getType().equals(rt)) {
                if (rt != null) {
                    bufferedPw.println("</tbody></table>");
                }
                String anchor = "active-" + this.escapeXml(this.getType((RegisteredResource)toActivate));
                pw.println("<li><a href='#" + anchor + "'>" + this.escapeXml(this.getType((RegisteredResource)toActivate)) + "</a></li>");
                bufferedPw.println("<div id='" + anchor + "' class='ui-widget-header ui-corner-top buttonGroup' style='height: 15px;'>");
                bufferedPw.printf("<span style='float: left; margin-left: 1em;'>Active Resources - %s</span>", this.getType((RegisteredResource)toActivate));
                bufferedPw.println("</div>");
                bufferedPw.println("<table class='nicetable'><tbody>");
                bufferedPw.printf("<tr><th>Entity ID</th><th>Digest/Priority</th><th>URL (Version)</th><th>State</th><th>Error</th></tr>", new Object[0]);
                rt = toActivate.getType();
            }
            bufferedPw.printf("<tr><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td></tr>", this.escapeXml(this.getEntityId((RegisteredResource)toActivate, group.getAlias())), this.escapeXml(this.getInfo((RegisteredResource)toActivate)), this.escapeXml(this.getURL(toActivate)), this.escapeXml(toActivate.getState().toString()), this.escapeXml(this.getError(toActivate)));
        }
        if (rt != null) {
            bufferedPw.println("</tbody></table>");
        } else {
            pw.println("<li>none</li>");
        }
        rt = null;
        pw.println("</ul></li>");
        pw.println("<li>Processed Resources");
        pw.println("<ul>");
        for (ResourceGroup group : state.getInstalledResources()) {
            long lastChange;
            List resources = group.getResources();
            if (resources.size() <= 0) continue;
            Iterator iter = resources.iterator();
            Resource first = (Resource)iter.next();
            if (!first.getType().equals(rt)) {
                if (rt != null) {
                    bufferedPw.println("</tbody></table>");
                }
                String anchor = "processed-" + this.escapeXml(this.getType((RegisteredResource)first));
                pw.println("<li><a href='#" + anchor + "'>" + this.escapeXml(this.getType((RegisteredResource)first)) + "</a></li>");
                bufferedPw.println("<div id='" + anchor + "' class='ui-widget-header ui-corner-top buttonGroup' style='height: 15px;'>");
                bufferedPw.printf("<span style='float: left; margin-left: 1em;'>Processed Resources - %s</span>", this.getType((RegisteredResource)first));
                bufferedPw.println("</div>");
                bufferedPw.println("<table class='nicetable'><tbody>");
                bufferedPw.printf("<tr><th>Entity ID</th><th>Digest/Priority</th><th>URL (Version)</th><th>State</th><th>Error</th></tr>", new Object[0]);
                rt = first.getType();
            }
            bufferedPw.print("<tr><td>");
            bufferedPw.print(this.escapeXml(this.getEntityId((RegisteredResource)first, group.getAlias())));
            bufferedPw.print("</td><td>");
            bufferedPw.print(this.escapeXml(this.getInfo((RegisteredResource)first)));
            bufferedPw.print("</td><td>");
            bufferedPw.print(this.escapeXml(this.getURL(first)));
            bufferedPw.print("</td><td>");
            bufferedPw.print(this.escapeXml(this.getState(first)));
            if (first.getState() == ResourceState.INSTALLED && (lastChange = first.getLastChange()) > 0L) {
                bufferedPw.print("<br/>");
                bufferedPw.print(this.formatDate(lastChange));
            }
            bufferedPw.print("</td><td>");
            bufferedPw.print(this.escapeXml(this.getError(first)));
            bufferedPw.print("</td></tr>");
            if (first.getAttribute("org.apache.sling.installer.api.resource.install.excluded") != null) {
                bufferedPw.printf("<tr><td></td><td colspan='2'>%s</td><td></td><td></td></tr>", this.escapeXml(first.getAttribute("org.apache.sling.installer.api.resource.install.excluded").toString()));
            }
            if (first.getAttribute("org.apache.sling.installer.api.resource.install.info") != null) {
                bufferedPw.printf("<tr><td></td><td colspan='2'>%s</td><td></td><td></td></tr>", this.escapeXml(first.getAttribute("org.apache.sling.installer.api.resource.install.info").toString()));
            }
            while (iter.hasNext()) {
                Resource resource = (Resource)iter.next();
                bufferedPw.printf("<tr><td></td><td>%s</td><td>%s</td><td>%s</td><td>%s</td></tr>", this.escapeXml(this.getInfo((RegisteredResource)resource)), this.escapeXml(this.getURL(resource)), this.escapeXml(resource.getState().toString()), this.escapeXml(this.getError(resource)));
            }
        }
        if (rt != null) {
            bufferedPw.println("</tbody></table>");
        } else {
            pw.println("<li>none</li>");
        }
        pw.println("</ul></li>");
        pw.println("<li>Untransformed Resources");
        pw.println("<ul>");
        rt = null;
        for (RegisteredResource registeredResource : state.getUntransformedResources()) {
            if (!registeredResource.getType().equals(rt)) {
                if (rt != null) {
                    bufferedPw.println("</tbody></table>");
                }
                String anchor = "untransformed-" + this.escapeXml(this.getType(registeredResource));
                pw.println("<li><a href='#" + anchor + "'>" + this.escapeXml(this.getType(registeredResource)) + "</a></li>");
                bufferedPw.println("<div id='" + anchor + "' class='ui-widget-header ui-corner-top buttonGroup' style='height: 15px;'>");
                bufferedPw.printf("<span style='float: left; margin-left: 1em;'>Untransformed Resources - %s</span>", this.getType(registeredResource));
                bufferedPw.println("</div>");
                bufferedPw.println("<table class='nicetable'><tbody>");
                bufferedPw.printf("<tr><th>Digest/Priority</th><th>URL</th></tr>", new Object[0]);
                rt = registeredResource.getType();
            }
            bufferedPw.printf("<tr><td>%s</td><td>%s</td></tr>", this.escapeXml(this.getInfo(registeredResource)), this.escapeXml(registeredResource.getURL()));
        }
        if (rt != null) {
            bufferedPw.println("</tbody></table>");
        } else {
            pw.println("<li>none</li>");
        }
        pw.println("</ul></li>");
        pw.println("</ul>");
        pw.print(bufferedWriter.toString());
    }

    public void printConfiguration(PrintWriter pw, String mode) {
        if (!"zip".equals(mode) && !"txt".equals(mode)) {
            return;
        }
        pw.println("Apache Sling OSGi Installer");
        pw.println("===========================");
        InstallationState state = this.installer.getInstallationState();
        pw.println("Active Resources");
        pw.println("----------------");
        String rt = null;
        for (ResourceGroup group : state.getActiveResources()) {
            Resource toActivate = (Resource)group.getResources().get(0);
            if (!toActivate.getType().equals(rt)) {
                pw.printf("%s:%n", this.getType((RegisteredResource)toActivate));
                rt = toActivate.getType();
            }
            pw.printf("- %s: %s, %s, %s, %s%n", this.getEntityId((RegisteredResource)toActivate, group.getAlias()), this.getInfo((RegisteredResource)toActivate), this.getURL(toActivate), toActivate.getState(), this.getError(toActivate));
        }
        pw.println();
        pw.println("Processed Resources");
        pw.println("-------------------");
        rt = null;
        for (ResourceGroup group : state.getInstalledResources()) {
            List resources = group.getResources();
            if (resources.size() <= 0) continue;
            Iterator iter = resources.iterator();
            Resource first = (Resource)iter.next();
            if (!first.getType().equals(rt)) {
                pw.printf("%s:%n", this.getType((RegisteredResource)first));
                rt = first.getType();
            }
            pw.printf("* %s: %s, %s, %s, %s%n", this.getEntityId((RegisteredResource)first, group.getAlias()), this.getInfo((RegisteredResource)first), this.getURL(first), this.getState(first), this.getError(first));
            if (first.getAttribute("org.apache.sling.installer.api.resource.install.excluded") != null) {
                pw.printf("  : %s", first.getAttribute("org.apache.sling.installer.api.resource.install.excluded"));
            }
            if (first.getAttribute("org.apache.sling.installer.api.resource.install.info") != null) {
                pw.printf("  : %s", first.getAttribute("org.apache.sling.installer.api.resource.install.info"));
            }
            while (iter.hasNext()) {
                Resource resource = (Resource)iter.next();
                pw.printf("  - %s, %s, %s, %s%n", this.getInfo((RegisteredResource)resource), this.getURL(resource), resource.getState(), this.getError(resource));
            }
        }
        pw.println();
        pw.println("Untransformed Resources");
        pw.println("-----------------------");
        rt = null;
        for (RegisteredResource registeredResource : state.getUntransformedResources()) {
            if (!registeredResource.getType().equals(rt)) {
                pw.printf("%s:%n", this.getType(registeredResource));
                rt = registeredResource.getType();
            }
            pw.printf("- %s, %s%n", this.getInfo(registeredResource), registeredResource.getURL());
        }
    }

    @Override
    String getRelativeResourcePrefix() {
        return RES_LOC;
    }
}

