/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.core.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.apache.sling.installer.api.info.InfoProvider;
import org.apache.sling.installer.api.info.Resource;
import org.apache.sling.installer.api.info.ResourceGroup;
import org.apache.sling.installer.api.tasks.ResourceState;
import org.apache.sling.installer.core.impl.tasks.AbstractBundleTask;
import org.osgi.service.url.AbstractURLStreamHandlerService;
import org.osgi.service.url.URLStreamHandlerService;

public class InstallerResourceUrlHandler
extends AbstractURLStreamHandlerService
implements URLStreamHandlerService {
    private final InfoProvider installerInfo;

    public InstallerResourceUrlHandler(InfoProvider installerInfo) {
        this.installerInfo = installerInfo;
    }

    private InputStream getInputStreamFromInstallerResourceUrl(URL url) throws IOException {
        for (ResourceGroup resourceGroup : this.installerInfo.getInstallationState().getInstalledResources()) {
            for (Resource resource : resourceGroup.getResources()) {
                String bundleLocation = AbstractBundleTask.getBundleLocation(resource);
                if (!url.toString().equals(bundleLocation) || !resource.getState().equals((Object)ResourceState.INSTALLED)) continue;
                return resource.getInputStream();
            }
        }
        throw new IOException("Could not find OSGi installer resource with location " + url);
    }

    public URLConnection openConnection(URL url) throws IOException {
        return new InputStreamConnection(url, this.getInputStreamFromInstallerResourceUrl(url));
    }

    private static final class InputStreamConnection
    extends URLConnection {
        private final InputStream input;

        protected InputStreamConnection(URL url, InputStream input) {
            super(url);
            this.input = input;
        }

        @Override
        public void connect() throws IOException {
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.input;
        }
    }
}

