/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.core.impl.tasks;

import org.apache.sling.installer.api.tasks.InstallationContext;
import org.apache.sling.installer.api.tasks.ResourceState;
import org.apache.sling.installer.api.tasks.TaskResourceGroup;
import org.apache.sling.installer.core.impl.tasks.AbstractBundleTask;
import org.apache.sling.installer.core.impl.tasks.BundleInfo;
import org.apache.sling.installer.core.impl.tasks.BundleUtil;
import org.apache.sling.installer.core.impl.tasks.RefreshBundlesTask;
import org.apache.sling.installer.core.impl.tasks.TaskSupport;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class BundleRemoveTask
extends AbstractBundleTask {
    private static final String BUNDLE_REMOVE_ORDER = "30-";

    public BundleRemoveTask(TaskResourceGroup r, TaskSupport creator) {
        super(r, creator);
    }

    @Override
    public void execute(InstallationContext ctx) {
        String symbolicName = (String)this.getResource().getAttribute("Bundle-SymbolicName");
        String version = (String)this.getResource().getAttribute("Bundle-Version");
        Bundle b = BundleInfo.getMatchingBundle(this.getBundleContext(), symbolicName, version);
        if (b == null) {
            this.setFinishedState(ResourceState.UNINSTALLED);
            return;
        }
        int state = b.getState();
        try {
            if (state == 32 || state == 8) {
                b.stop();
            }
            b.uninstall();
            ctx.log("Uninstalled bundle {} from resource {}", b, this.getResource());
            if (BundleUtil.getFragmentHostHeader(b) == null) {
                RefreshBundlesTask.markBundleForRefresh(ctx, this.getTaskSupport(), b);
            }
            this.setFinishedState(ResourceState.UNINSTALLED);
        }
        catch (BundleException be) {
            this.getLogger().info("Exception during removal of bundle " + this.getResource() + " : " + be.getMessage() + ". Retrying later.", (Throwable)be);
        }
    }

    @Override
    public String getSortKey() {
        return BUNDLE_REMOVE_ORDER + this.getResource().getURL();
    }
}

