/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.maven.mojos.apis;

import jakarta.json.Json;
import jakarta.json.stream.JsonGenerator;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import org.apache.sling.feature.maven.mojos.apis.spi.Processor;
import org.apache.sling.feature.maven.mojos.apis.spi.ProcessorContext;
import org.apache.sling.feature.maven.mojos.apis.spi.Source;
import org.osgi.annotation.versioning.ProviderType;

public class ClassFileProcessor
implements Processor {
    private static final String NAME = "api-info.json";

    @Override
    public void processBinaries(ProcessorContext ctx, List<Source> sources) {
        block14: {
            try {
                String extension = ".class";
                ArrayList<String> providerTypes = new ArrayList<String>();
                for (Source s : sources) {
                    for (File f : s.getFiles()) {
                        String pckName = this.getPackageName(s.getBaseDirectory(), f, ".class");
                        if (pckName == null) continue;
                        this.processClassFile(pckName, s.getBaseDirectory(), f, providerTypes);
                    }
                }
                File out = new File(ctx.getOutputDirectory(), ctx.getApiRegion().getName().concat("-").concat(NAME));
                if (!providerTypes.isEmpty()) {
                    out.getParentFile().mkdirs();
                    try (JsonGenerator gen = Json.createGenerator((OutputStream)Files.newOutputStream(out.toPath(), new OpenOption[0]));){
                        gen.writeStartObject();
                        gen.writeStartArray("providerTypes");
                        for (String p : providerTypes) {
                            gen.write(p);
                        }
                        gen.writeEnd();
                        gen.writeEnd();
                    }
                    ctx.addResource("META-INF/".concat(NAME), out);
                    break block14;
                }
                if (out.exists()) {
                    out.delete();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void processSources(ProcessorContext ctx, List<Source> sources) {
    }

    private String getPackageName(File baseDirectory, File file, String extension) {
        String path;
        int lastSlash;
        String name = file.getName();
        if (name.endsWith(extension) && (lastSlash = (path = file.getAbsolutePath().substring(baseDirectory.getAbsolutePath().length() + 1)).lastIndexOf(File.separatorChar)) != -1) {
            String pckName = path.substring(0, lastSlash).replace(File.separatorChar, '.');
            return pckName;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processClassFile(String pckName, File baseDirectory, File f, List<String> providerTypes) throws Exception {
        CtClass cc = ClassPool.getDefault().makeClass((InputStream)new FileInputStream(f));
        try {
            cc.setName(pckName.concat(".").concat(f.getName().substring(0, f.getName().length() - 6)));
            ClassFile cfile = cc.getClassFile();
            for (AttributeInfo attr : cfile.getAttributes()) {
                AnnotationsAttribute ann;
                if (!(attr instanceof AnnotationsAttribute) || (ann = (AnnotationsAttribute)attr).getAnnotation(ProviderType.class.getName()) == null) continue;
                providerTypes.add(cc.getName());
            }
        }
        finally {
            cc.detach();
        }
    }
}

