/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.maven.mojos.reports;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.Configuration;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.ExtensionType;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.maven.mojos.reports.ReportContext;
import org.apache.sling.feature.maven.mojos.reports.Reporter;

public class DuplicatesReporter
implements Reporter {
    @Override
    public String getName() {
        return "duplicates";
    }

    @Override
    public void generateReport(ReportContext ctx) throws MojoExecutionException {
        TreeMap<String, Set<String>> artifactMap = new TreeMap<String, Set<String>>();
        TreeMap<String, Set<String>> bundleMap = new TreeMap<String, Set<String>>();
        TreeMap<String, Set<String>> configMap = new TreeMap<String, Set<String>>();
        TreeMap<String, Set<String>> propsMap = new TreeMap<String, Set<String>>();
        for (Feature feature : ctx.getFeatures()) {
            for (Extension ext : feature.getExtensions()) {
                if (ext.getType() != ExtensionType.ARTIFACTS) continue;
                for (Artifact a : ext.getArtifacts()) {
                    String key = a.getId().changeVersion("0").toMvnId();
                    artifactMap.computeIfAbsent(key, k -> new HashSet()).add(feature.getId().getClassifier().concat("(").concat(a.getId().getVersion()).concat(")"));
                }
            }
            for (Object a : feature.getBundles()) {
                String key = a.getId().changeVersion("0").toMvnId();
                bundleMap.computeIfAbsent(key, k -> new HashSet()).add(feature.getId().getClassifier().concat("(").concat(a.getId().getVersion()).concat(")"));
            }
            for (Configuration c : feature.getConfigurations()) {
                configMap.computeIfAbsent(c.getPid(), k -> new HashSet()).add(feature.getId().getClassifier());
            }
            for (Object a : feature.getFrameworkProperties().keySet()) {
                propsMap.computeIfAbsent((String)a, k -> new HashSet()).add(feature.getId().getClassifier());
            }
        }
        ArrayList<String> output = new ArrayList<String>();
        this.outputDuplicates(output, "framework-properties", propsMap);
        this.outputDuplicates(output, "bundles", bundleMap);
        this.outputDuplicates(output, "configurations", configMap);
        this.outputDuplicates(output, "artifacts", artifactMap);
        if (output.isEmpty()) {
            output.add("No duplicates found");
        }
        ctx.addReport(this.getName().concat(".txt"), output);
    }

    private void outputDuplicates(List<String> output, String key, Map<String, Set<String>> duplicates) {
        if (!duplicates.isEmpty()) {
            boolean writeHeader = true;
            for (Map.Entry<String, Set<String>> entry : duplicates.entrySet()) {
                if (entry.getValue().size() <= 1) continue;
                if (writeHeader) {
                    writeHeader = false;
                    output.add(key);
                    output.add("-------------------------------------------");
                }
                output.add(entry.getKey().concat(" : ").concat(entry.getValue().toString()));
            }
            if (!writeHeader) {
                output.add("");
            }
        }
    }
}

