/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin;

import java.io.IOException;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinGenerateResultOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashSet;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashSetResult;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashTableResult;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VectorMapJoinLeftSemiGenerateResultOperator
extends VectorMapJoinGenerateResultOperator {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger((String)VectorMapJoinLeftSemiGenerateResultOperator.class.getName());
    protected transient VectorMapJoinHashSetResult[] hashSetResults;
    protected transient int[] allMatchs;
    protected transient int[] spills;
    protected transient int[] spillHashMapResultIndices;

    protected VectorMapJoinLeftSemiGenerateResultOperator() {
    }

    public VectorMapJoinLeftSemiGenerateResultOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    public VectorMapJoinLeftSemiGenerateResultOperator(CompilationOpContext ctx, VectorizationContext vContext, OperatorDesc conf) throws HiveException {
        super(ctx, vContext, conf);
    }

    @Override
    protected void commonSetup(VectorizedRowBatch batch) throws HiveException {
        super.commonSetup(batch);
        VectorMapJoinHashSet baseHashSet = (VectorMapJoinHashSet)this.vectorMapJoinHashTable;
        this.hashSetResults = new VectorMapJoinHashSetResult[1024];
        for (int i = 0; i < this.hashSetResults.length; ++i) {
            this.hashSetResults[i] = baseHashSet.createHashSetResult();
        }
        this.allMatchs = new int[1024];
        this.spills = new int[1024];
        this.spillHashMapResultIndices = new int[1024];
    }

    protected void finishLeftSemi(VectorizedRowBatch batch, int allMatchCount, int spillCount, VectorMapJoinHashTableResult[] hashTableResults) throws HiveException, IOException {
        int numSel;
        if (spillCount > 0) {
            this.spillHashMapBatch(batch, hashTableResults, this.spills, this.spillHashMapResultIndices, spillCount);
        }
        if (allMatchCount > 0 && this.bigTableValueExpressions != null) {
            this.performValueExpressions(batch, this.allMatchs, allMatchCount);
        }
        batch.size = numSel = this.generateHashSetResults(batch, this.allMatchs, allMatchCount);
        batch.selectedInUse = true;
    }

    private int generateHashSetResults(VectorizedRowBatch batch, int[] allMatchs, int allMatchCount) throws HiveException, IOException {
        int numSel = 0;
        for (int i = 0; i < allMatchCount; ++i) {
            int batchIndex = allMatchs[i];
            batch.selected[numSel++] = batchIndex;
        }
        return numSel;
    }

    protected int generateHashSetResultRepeatedAll(VectorizedRowBatch batch) throws HiveException {
        if (!batch.selectedInUse) {
            int[] selected = batch.selected;
            for (int i = 0; i < batch.size; ++i) {
                selected[i] = i;
            }
            batch.selectedInUse = true;
        }
        return batch.size;
    }

    protected void finishLeftSemiRepeated(VectorizedRowBatch batch, JoinUtil.JoinResult joinResult, VectorMapJoinHashTableResult hashSetResult) throws HiveException, IOException {
        switch (joinResult) {
            case MATCH: {
                int numSel;
                if (this.bigTableValueExpressions != null) {
                    for (VectorExpression ve : this.bigTableValueExpressions) {
                        ve.evaluate(batch);
                    }
                }
                batch.size = numSel = this.generateHashSetResultRepeatedAll(batch);
                batch.selectedInUse = true;
                break;
            }
            case SPILL: {
                this.spillBatchRepeated(batch, hashSetResult);
                batch.size = 0;
                break;
            }
            case NOMATCH: {
                batch.size = 0;
            }
        }
    }
}

