/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;

@Description(name="sort_array_by", value="_FUNC_(array(obj1, obj2,...),'f1','f2',...,['ASC','DESC']) - Sorts the input tuple array in user specified order(ASC,DESC) by desired field[s] name If sorting order is not mentioned by user then dafault sorting order is ascending", extended="Example:\n  > SELECT _FUNC_(array(struct('g',100),struct('b',200)),'col1','ASC') FROM src LIMIT 1;\n array(struct('b',200),struct('g',100)) ")
public class GenericUDFSortArrayByField
extends GenericUDF {
    private transient ObjectInspectorConverters.Converter[] converters;
    private transient PrimitiveObjectInspector.PrimitiveCategory[] inputTypes;
    private final List<Object> ret = new ArrayList<Object>();
    private transient ListObjectInspector listObjectInspector;
    private transient StructObjectInspector structObjectInspector;
    private transient StructField[] fields;
    private transient int noOfInputFields;
    private transient SORT_ORDER_TYPE sortOrder = SORT_ORDER_TYPE.ASC;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        GenericUDFUtils.ReturnObjectInspectorResolver returnOIResolver = new GenericUDFUtils.ReturnObjectInspectorResolver(true);
        if (arguments.length < 2) {
            throw new UDFArgumentLengthException("SORT_ARRAY_BY requires minimum 2 arguments, got " + arguments.length);
        }
        switch (arguments[0].getCategory()) {
            case LIST: {
                this.listObjectInspector = (ListObjectInspector)arguments[0];
                break;
            }
            default: {
                throw new UDFArgumentTypeException(0, "Argument 1 of function SORT_ARRAY_BY must be array, but " + arguments[0].getTypeName() + " was found.");
            }
        }
        switch (this.listObjectInspector.getListElementObjectInspector().getCategory()) {
            case STRUCT: {
                this.structObjectInspector = (StructObjectInspector)this.listObjectInspector.getListElementObjectInspector();
                break;
            }
            default: {
                throw new UDFArgumentTypeException(0, "Element[s] of first argument array in function SORT_ARRAY_BY must be struct, but " + this.listObjectInspector.getTypeName() + " was found.");
            }
        }
        this.converters = new ObjectInspectorConverters.Converter[arguments.length];
        this.inputTypes = new PrimitiveObjectInspector.PrimitiveCategory[arguments.length];
        this.fields = new StructField[arguments.length - 1];
        this.noOfInputFields = arguments.length - 1;
        for (int i = 1; i < arguments.length; ++i) {
            this.checkArgPrimitive(arguments, i);
            this.checkArgGroups(arguments, i, this.inputTypes, PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP);
            if (arguments[i] instanceof ConstantObjectInspector) {
                String fieldName = this.getConstantStringValue(arguments, i);
                if (i != 1 && i == arguments.length - 1 && (fieldName.trim().toUpperCase().equals(SORT_ORDER_TYPE.ASC.name()) || fieldName.trim().toUpperCase().equals(SORT_ORDER_TYPE.DESC.name()))) {
                    this.sortOrder = SORT_ORDER_TYPE.valueOf(fieldName.trim().toUpperCase());
                    --this.noOfInputFields;
                    continue;
                }
                this.fields[i - 1] = this.structObjectInspector.getStructFieldRef(this.getConstantStringValue(arguments, i));
            }
            this.obtainStringConverter(arguments, i, this.inputTypes, this.converters);
        }
        ObjectInspector returnOI = returnOIResolver.get((ObjectInspector)this.structObjectInspector);
        this.converters[0] = ObjectInspectorConverters.getConverter((ObjectInspector)this.structObjectInspector, (ObjectInspector)returnOI);
        return ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)this.structObjectInspector);
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        if (arguments[0].get() == null) {
            return null;
        }
        String field = null;
        for (int i = 0; i < this.noOfInputFields && this.fields[i] == null; ++i) {
            field = this.getStringValue(arguments, i + 1, this.converters);
            if (i != 0 && i == arguments.length - 2 && (field.trim().toUpperCase().equals(SORT_ORDER_TYPE.ASC.name()) || field.trim().toUpperCase().equals(SORT_ORDER_TYPE.DESC.name()))) {
                --this.noOfInputFields;
                this.sortOrder = SORT_ORDER_TYPE.valueOf(field.trim().toUpperCase());
                continue;
            }
            this.fields[i] = this.structObjectInspector.getStructFieldRef(field);
        }
        Object array = arguments[0].get();
        List retArray = this.listObjectInspector.getList(array);
        Collections.sort(retArray, new Comparator<Object>(){

            @Override
            public int compare(Object object1, Object object2) {
                int result = 0;
                for (int i = 0; i < GenericUDFSortArrayByField.this.noOfInputFields; ++i) {
                    Object o1 = GenericUDFSortArrayByField.this.structObjectInspector.getStructFieldData(object1, GenericUDFSortArrayByField.this.fields[i]);
                    Object o2 = GenericUDFSortArrayByField.this.structObjectInspector.getStructFieldData(object2, GenericUDFSortArrayByField.this.fields[i]);
                    result = ObjectInspectorUtils.compare((Object)o1, (ObjectInspector)GenericUDFSortArrayByField.this.fields[i].getFieldObjectInspector(), (Object)o2, (ObjectInspector)GenericUDFSortArrayByField.this.fields[i].getFieldObjectInspector());
                    if (result == 0) continue;
                    if (GenericUDFSortArrayByField.this.sortOrder == SORT_ORDER_TYPE.DESC) {
                        result *= -1;
                    }
                    return result;
                }
                return result;
            }
        });
        this.ret.clear();
        for (int i = 0; i < retArray.size(); ++i) {
            this.ret.add(this.converters[0].convert(retArray.get(i)));
        }
        return this.ret;
    }

    @Override
    public String getDisplayString(String[] children) {
        return this.getStandardDisplayString("sort_array_by", children);
    }

    private static enum SORT_ORDER_TYPE {
        ASC,
        DESC;

    }
}

