/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import org.apache.datasketches.Family;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.datasketches.kll.KllMemoryValidate;
import org.apache.datasketches.kll.KllPreambleUtil;
import org.apache.datasketches.kll.KllSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.WritableMemory;

class KllDirectFloatsSketch
extends KllFloatsSketch {
    KllDirectFloatsSketch(WritableMemory wmem, MemoryRequestServer memReqSvr, KllMemoryValidate memVal) {
        super(wmem, memReqSvr);
        this.levelsArr = memVal.levelsArr;
    }

    static KllDirectFloatsSketch newDirectInstance(int k, int m, WritableMemory dstMem, MemoryRequestServer memReqSvr) {
        KllPreambleUtil.setMemoryPreInts(dstMem, 5);
        KllPreambleUtil.setMemorySerVer(dstMem, 3);
        KllPreambleUtil.setMemoryFamilyID(dstMem, Family.KLL.getID());
        KllPreambleUtil.setMemoryFlags(dstMem, 16);
        KllPreambleUtil.setMemoryK(dstMem, k);
        KllPreambleUtil.setMemoryM(dstMem, m);
        KllPreambleUtil.setMemoryN(dstMem, 0L);
        KllPreambleUtil.setMemoryMinK(dstMem, k);
        KllPreambleUtil.setMemoryNumLevels(dstMem, 1);
        int offset = 20;
        dstMem.putIntArray((long)offset, new int[]{k, k}, 0, 2);
        dstMem.putFloatArray((long)(offset += 8), new float[]{Float.NaN, Float.NaN}, 0, 2);
        dstMem.putFloatArray((long)(offset += 8), new float[k], 0, k);
        KllMemoryValidate memVal = new KllMemoryValidate((Memory)dstMem);
        return new KllDirectFloatsSketch(dstMem, memReqSvr, memVal);
    }

    @Override
    public int getK() {
        return KllPreambleUtil.getMemoryK((Memory)this.wmem);
    }

    @Override
    public long getN() {
        return KllPreambleUtil.getMemoryN((Memory)this.wmem);
    }

    @Override
    double getDoubleSingleItem() {
        KllSketch.Error.kllSketchThrow(KllSketch.Error.MUST_NOT_CALL);
        return Double.NaN;
    }

    @Override
    float[] getFloatItemsArray() {
        int capacityItems = this.levelsArr[this.getNumLevels()];
        float[] itemsArr = new float[capacityItems];
        int levelsBytes = this.levelsArr.length * 4;
        int offset = 20 + levelsBytes + 8;
        this.wmem.getFloatArray((long)offset, itemsArr, 0, capacityItems);
        return itemsArr;
    }

    @Override
    float getFloatSingleItem() {
        if (!this.isSingleItem()) {
            KllSketch.Error.kllSketchThrow(KllSketch.Error.NOT_SINGLE_ITEM);
            return Float.NaN;
        }
        int k = this.getK();
        int offset = 28 + (2 + k - 1) * 4;
        return this.wmem.getFloat((long)offset);
    }

    @Override
    int getM() {
        return KllPreambleUtil.getMemoryM((Memory)this.wmem);
    }

    @Override
    float getMaxFloatValue() {
        int offset = 20 + this.getLevelsArray().length * 4 + 4;
        return this.wmem.getFloat((long)offset);
    }

    @Override
    float getMinFloatValue() {
        int offset = 20 + this.getLevelsArray().length * 4;
        return this.wmem.getFloat((long)offset);
    }

    @Override
    int getMinK() {
        return KllPreambleUtil.getMemoryMinK((Memory)this.wmem);
    }

    @Override
    void incN() {
        if (this.readOnly) {
            KllSketch.Error.kllSketchThrow(KllSketch.Error.TGT_IS_READ_ONLY);
        }
        long n = KllPreambleUtil.getMemoryN((Memory)this.wmem);
        KllPreambleUtil.setMemoryN(this.wmem, ++n);
    }

    @Override
    void incNumLevels() {
        if (this.readOnly) {
            KllSketch.Error.kllSketchThrow(KllSketch.Error.TGT_IS_READ_ONLY);
        }
        int numLevels = KllPreambleUtil.getMemoryNumLevels((Memory)this.wmem);
        KllPreambleUtil.setMemoryNumLevels(this.wmem, ++numLevels);
    }

    @Override
    boolean isLevelZeroSorted() {
        return KllPreambleUtil.getMemoryLevelZeroSortedFlag((Memory)this.wmem);
    }

    @Override
    void setFloatItemsArray(float[] floatItems) {
        if (this.readOnly) {
            KllSketch.Error.kllSketchThrow(KllSketch.Error.TGT_IS_READ_ONLY);
        }
        int offset = 20 + this.getLevelsArray().length * 4 + 8;
        this.wmem.putFloatArray((long)offset, floatItems, 0, floatItems.length);
    }

    @Override
    void setFloatItemsArrayAt(int index, float value) {
        if (this.readOnly) {
            KllSketch.Error.kllSketchThrow(KllSketch.Error.TGT_IS_READ_ONLY);
        }
        int offset = 20 + this.getLevelsArray().length * 4 + (index + 2) * 4;
        this.wmem.putFloat((long)offset, value);
    }

    @Override
    void setLevelZeroSorted(boolean sorted) {
        if (this.readOnly) {
            KllSketch.Error.kllSketchThrow(KllSketch.Error.TGT_IS_READ_ONLY);
        }
        KllPreambleUtil.setMemoryLevelZeroSortedFlag(this.wmem, sorted);
    }

    @Override
    void setMaxFloatValue(float value) {
        if (this.readOnly) {
            KllSketch.Error.kllSketchThrow(KllSketch.Error.TGT_IS_READ_ONLY);
        }
        int offset = 20 + this.getLevelsArray().length * 4 + 4;
        this.wmem.putFloat((long)offset, value);
    }

    @Override
    void setMinFloatValue(float value) {
        if (this.readOnly) {
            KllSketch.Error.kllSketchThrow(KllSketch.Error.TGT_IS_READ_ONLY);
        }
        int offset = 20 + this.getLevelsArray().length * 4;
        this.wmem.putFloat((long)offset, value);
    }

    @Override
    void setMinK(int minK) {
        if (this.readOnly) {
            KllSketch.Error.kllSketchThrow(KllSketch.Error.TGT_IS_READ_ONLY);
        }
        KllPreambleUtil.setMemoryMinK(this.wmem, minK);
    }

    @Override
    void setN(long n) {
        if (this.readOnly) {
            KllSketch.Error.kllSketchThrow(KllSketch.Error.TGT_IS_READ_ONLY);
        }
        KllPreambleUtil.setMemoryN(this.wmem, n);
    }

    @Override
    void setNumLevels(int numLevels) {
        if (this.readOnly) {
            KllSketch.Error.kllSketchThrow(KllSketch.Error.TGT_IS_READ_ONLY);
        }
        KllPreambleUtil.setMemoryNumLevels(this.wmem, numLevels);
    }
}

