/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.linalg;

import java.util.Random;
import org.apache.spark.ml.linalg.DenseMatrix;
import org.apache.spark.ml.linalg.Vector;
import scala.Array$;
import scala.Function0;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple4;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction2;

public final class DenseMatrix$
implements Serializable {
    public static DenseMatrix$ MODULE$;

    static {
        new DenseMatrix$();
    }

    public Option<Tuple4<Object, Object, double[], Object>> unapply(DenseMatrix dm) {
        return new Some((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)dm.numRows()), (Object)BoxesRunTime.boxToInteger((int)dm.numCols()), (Object)dm.values(), (Object)BoxesRunTime.boxToBoolean((boolean)dm.isTransposed())));
    }

    public DenseMatrix fromVectors(Seq<Vector> vectors) {
        int numRows = vectors.length();
        int numCols = ((Vector)vectors.head()).size();
        double[] values = (double[])Array$.MODULE$.ofDim(numRows * numCols, ClassTag$.MODULE$.Double());
        IntRef offset = IntRef.create((int)0);
        for (int j = 0; j < numRows; ++j) {
            ((Vector)vectors.apply(j)).foreachNonZero((Function2<Object, Object, BoxedUnit>)(JFunction2.mcVID.sp & java.io.Serializable & Serializable)(i, v) -> {
                values$1[offset$1.elem + i] = v;
            });
            offset.elem += numCols;
        }
        return new DenseMatrix(numRows, numCols, values, true);
    }

    public DenseMatrix zeros(int numRows, int numCols) {
        Predef$.MODULE$.require((long)numRows * (long)numCols <= Integer.MAX_VALUE, (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(41).append(numRows).append(" x ").append(numCols).append(" dense matrix is too large to allocate").toString());
        return new DenseMatrix(numRows, numCols, new double[numRows * numCols]);
    }

    public DenseMatrix ones(int numRows, int numCols) {
        Predef$.MODULE$.require((long)numRows * (long)numCols <= Integer.MAX_VALUE, (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(41).append(numRows).append(" x ").append(numCols).append(" dense matrix is too large to allocate").toString());
        return new DenseMatrix(numRows, numCols, (double[])Array$.MODULE$.fill(numRows * numCols, (Function0)(JFunction0.mcD.sp & java.io.Serializable & Serializable)() -> 1.0, ClassTag$.MODULE$.Double()));
    }

    public DenseMatrix eye(int n) {
        DenseMatrix identity = this.zeros(n, n);
        for (int i = 0; i < n; ++i) {
            identity.update(i, i, 1.0);
        }
        return identity;
    }

    public DenseMatrix rand(int numRows, int numCols, Random rng) {
        Predef$.MODULE$.require((long)numRows * (long)numCols <= Integer.MAX_VALUE, (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(41).append(numRows).append(" x ").append(numCols).append(" dense matrix is too large to allocate").toString());
        return new DenseMatrix(numRows, numCols, (double[])Array$.MODULE$.fill(numRows * numCols, (Function0)(JFunction0.mcD.sp & java.io.Serializable & Serializable)() -> rng.nextDouble(), ClassTag$.MODULE$.Double()));
    }

    public DenseMatrix randn(int numRows, int numCols, Random rng) {
        Predef$.MODULE$.require((long)numRows * (long)numCols <= Integer.MAX_VALUE, (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(41).append(numRows).append(" x ").append(numCols).append(" dense matrix is too large to allocate").toString());
        return new DenseMatrix(numRows, numCols, (double[])Array$.MODULE$.fill(numRows * numCols, (Function0)(JFunction0.mcD.sp & java.io.Serializable & Serializable)() -> rng.nextGaussian(), ClassTag$.MODULE$.Double()));
    }

    public DenseMatrix diag(Vector vector) {
        int n = vector.size();
        DenseMatrix matrix = this.zeros(n, n);
        double[] values = vector.toArray();
        for (int i = 0; i < n; ++i) {
            matrix.update(i, i, values[i]);
        }
        return matrix;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private DenseMatrix$() {
        MODULE$ = this;
    }
}

