/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.ui;

import java.util.concurrent.TimeUnit;
import org.apache.commons.text.StringEscapeUtils;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.UnprefixedAttribute;

public final class UIUtils$ {
    public static UIUtils$ MODULE$;

    static {
        new UIUtils$();
    }

    public String shortTimeUnitString(TimeUnit unit) {
        TimeUnit timeUnit = unit;
        if (((Object)((Object)TimeUnit.NANOSECONDS)).equals((Object)timeUnit)) {
            return "ns";
        }
        if (((Object)((Object)TimeUnit.MICROSECONDS)).equals((Object)timeUnit)) {
            return "us";
        }
        if (((Object)((Object)TimeUnit.MILLISECONDS)).equals((Object)timeUnit)) {
            return "ms";
        }
        if (((Object)((Object)TimeUnit.SECONDS)).equals((Object)timeUnit)) {
            return "sec";
        }
        if (((Object)((Object)TimeUnit.MINUTES)).equals((Object)timeUnit)) {
            return "min";
        }
        if (((Object)((Object)TimeUnit.HOURS)).equals((Object)timeUnit)) {
            return "hrs";
        }
        if (((Object)((Object)TimeUnit.DAYS)).equals((Object)timeUnit)) {
            return "days";
        }
        throw new MatchError((Object)timeUnit);
    }

    public Tuple2<Object, TimeUnit> normalizeDuration(long milliseconds) {
        if (milliseconds < 1000L) {
            return new Tuple2((Object)BoxesRunTime.boxToDouble((double)milliseconds), (Object)TimeUnit.MILLISECONDS);
        }
        double seconds = (double)milliseconds / (double)1000;
        if (seconds < (double)60) {
            return new Tuple2((Object)BoxesRunTime.boxToDouble((double)seconds), (Object)TimeUnit.SECONDS);
        }
        double minutes = seconds / (double)60;
        if (minutes < (double)60) {
            return new Tuple2((Object)BoxesRunTime.boxToDouble((double)minutes), (Object)TimeUnit.MINUTES);
        }
        double hours = minutes / (double)60;
        if (hours < (double)24) {
            return new Tuple2((Object)BoxesRunTime.boxToDouble((double)hours), (Object)TimeUnit.HOURS);
        }
        double days = hours / (double)24;
        return new Tuple2((Object)BoxesRunTime.boxToDouble((double)days), (Object)TimeUnit.DAYS);
    }

    public double convertToTimeUnit(long milliseconds, TimeUnit unit) {
        TimeUnit timeUnit = unit;
        if (((Object)((Object)TimeUnit.NANOSECONDS)).equals((Object)timeUnit)) {
            return milliseconds * 1000L * 1000L;
        }
        if (((Object)((Object)TimeUnit.MICROSECONDS)).equals((Object)timeUnit)) {
            return milliseconds * 1000L;
        }
        if (((Object)((Object)TimeUnit.MILLISECONDS)).equals((Object)timeUnit)) {
            return milliseconds;
        }
        if (((Object)((Object)TimeUnit.SECONDS)).equals((Object)timeUnit)) {
            return (double)milliseconds / 1000.0;
        }
        if (((Object)((Object)TimeUnit.MINUTES)).equals((Object)timeUnit)) {
            return (double)milliseconds / 1000.0 / 60.0;
        }
        if (((Object)((Object)TimeUnit.HOURS)).equals((Object)timeUnit)) {
            return (double)milliseconds / 1000.0 / 60.0 / 60.0;
        }
        if (((Object)((Object)TimeUnit.DAYS)).equals((Object)timeUnit)) {
            return (double)milliseconds / 1000.0 / 60.0 / 60.0 / 24.0;
        }
        throw new MatchError((Object)timeUnit);
    }

    public String createOutputOperationFailureForUI(String failure) {
        if (failure.startsWith("org.apache.spark.Spark")) {
            return new StringBuilder(30).append("Failed due to Spark job error\n").append(failure).toString();
        }
        int nextLineIndex = failure.indexOf("\n");
        if (nextLineIndex < 0) {
            nextLineIndex = failure.length();
        }
        String firstLine = failure.substring(0, nextLineIndex);
        return new StringBuilder(22).append("Failed due to error: ").append(firstLine).append("\n").append(failure).toString();
    }

    public Seq<Node> failureReasonCell(String failureReason, int rowspan, boolean includeFirstLineInExpandDetails) {
        boolean isMultiline = failureReason.indexOf(10) >= 0;
        String failureReasonSummary = StringEscapeUtils.escapeHtml4((String)(isMultiline ? failureReason.substring(0, failureReason.indexOf(10)) : failureReason));
        String failureDetails = isMultiline && !includeFirstLineInExpandDetails ? failureReason.substring(failureReason.indexOf(10) + 1) : failureReason;
        Seq details = org.apache.spark.ui.UIUtils$.MODULE$.detailsUINode(isMultiline, failureDetails);
        if (rowspan == 1) {
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("style", (Seq)new Text("max-width: 300px"), (MetaData)$md);
            $md = new UnprefixedAttribute("valign", (Seq)new Text("middle"), (MetaData)$md);
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)failureReasonSummary);
            $buf.$amp$plus((Object)details);
            return new Elem(null, "td", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
        }
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("rowspan", Integer.toString(rowspan), (MetaData)$md);
        $md = new UnprefixedAttribute("style", (Seq)new Text("max-width: 300px"), (MetaData)$md);
        $md = new UnprefixedAttribute("valign", (Seq)new Text("middle"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n        "));
        $buf.$amp$plus((Object)failureReasonSummary);
        $buf.$amp$plus((Object)details);
        $buf.$amp$plus((Object)new Text("\n      "));
        return new Elem(null, "td", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
    }

    public int failureReasonCell$default$2() {
        return 1;
    }

    public boolean failureReasonCell$default$3() {
        return true;
    }

    private UIUtils$() {
        MODULE$ = this;
    }
}

