/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.io.Serializable;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.CatalogUtils$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.trees.LeafLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.command.CreateDataSourceTableCommand$;
import org.apache.spark.sql.execution.command.LeafRunnableCommand;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.internal.SessionState;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.types.StructType;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005ud\u0001B\f\u0019\u0001\u0016B\u0001\"\u0010\u0001\u0003\u0016\u0004%\tA\u0010\u0005\t\u000b\u0002\u0011\t\u0012)A\u0005\u007f!Aa\t\u0001BK\u0002\u0013\u0005q\t\u0003\u0005L\u0001\tE\t\u0015!\u0003I\u0011\u0015a\u0005\u0001\"\u0001N\u0011\u0015\t\u0006\u0001\"\u0011S\u0011\u001dA\u0007!!A\u0005\u0002%Dq\u0001\u001c\u0001\u0012\u0002\u0013\u0005Q\u000eC\u0004y\u0001E\u0005I\u0011A=\t\u000fm\u0004\u0011\u0011!C!y\"I\u00111\u0002\u0001\u0002\u0002\u0013\u0005\u0011Q\u0002\u0005\n\u0003+\u0001\u0011\u0011!C\u0001\u0003/A\u0011\"a\t\u0001\u0003\u0003%\t%!\n\t\u0013\u0005M\u0002!!A\u0005\u0002\u0005U\u0002\"CA\u001d\u0001\u0005\u0005I\u0011IA\u001e\u000f%\ty\u0004GA\u0001\u0012\u0003\t\tE\u0002\u0005\u00181\u0005\u0005\t\u0012AA\"\u0011\u0019a\u0015\u0003\"\u0001\u0002R!I\u00111K\t\u0002\u0002\u0013\u0015\u0013Q\u000b\u0005\n\u0003/\n\u0012\u0011!CA\u00033B\u0011\"a\u0018\u0012\u0003\u0003%\t)!\u0019\t\u0013\u0005M\u0014#!A\u0005\n\u0005U$\u0001H\"sK\u0006$X\rR1uCN{WO]2f)\u0006\u0014G.Z\"p[6\fg\u000e\u001a\u0006\u00033i\tqaY8n[\u0006tGM\u0003\u0002\u001c9\u0005IQ\r_3dkRLwN\u001c\u0006\u0003;y\t1a]9m\u0015\ty\u0002%A\u0003ta\u0006\u00148N\u0003\u0002\"E\u00051\u0011\r]1dQ\u0016T\u0011aI\u0001\u0004_J<7\u0001A\n\u0006\u0001\u0019\u0002DG\u000f\t\u0003O9j\u0011\u0001\u000b\u0006\u0003S)\nq\u0001\\8hS\u000e\fGN\u0003\u0002,Y\u0005)\u0001\u000f\\1og*\u0011Q\u0006H\u0001\tG\u0006$\u0018\r\\=ti&\u0011q\u0006\u000b\u0002\f\u0019><\u0017nY1m!2\fg\u000e\u0005\u00022e5\t\u0001$\u0003\u000241\t\u0019B*Z1g%Vtg.\u00192mK\u000e{W.\\1oIB\u0011Q\u0007O\u0007\u0002m)\tq'A\u0003tG\u0006d\u0017-\u0003\u0002:m\t9\u0001K]8ek\u000e$\bCA\u001b<\u0013\tadG\u0001\u0007TKJL\u0017\r\\5{C\ndW-A\u0003uC\ndW-F\u0001@!\t\u00015)D\u0001B\u0015\t\u0011E&A\u0004dCR\fGn\\4\n\u0005\u0011\u000b%\u0001D\"bi\u0006dwn\u001a+bE2,\u0017A\u0002;bE2,\u0007%\u0001\bjO:|'/Z%g\u000bbL7\u000f^:\u0016\u0003!\u0003\"!N%\n\u0005)3$a\u0002\"p_2,\u0017M\\\u0001\u0010S\u001etwN]3JM\u0016C\u0018n\u001d;tA\u00051A(\u001b8jiz\"2AT(Q!\t\t\u0004\u0001C\u0003>\u000b\u0001\u0007q\bC\u0003G\u000b\u0001\u0007\u0001*A\u0002sk:$\"aU2\u0011\u0007QcvL\u0004\u0002V5:\u0011a+W\u0007\u0002/*\u0011\u0001\fJ\u0001\u0007yI|w\u000e\u001e \n\u0003]J!a\u0017\u001c\u0002\u000fA\f7m[1hK&\u0011QL\u0018\u0002\u0004'\u0016\f(BA.7!\t\u0001\u0017-D\u0001\u001d\u0013\t\u0011GDA\u0002S_^DQ\u0001\u001a\u0004A\u0002\u0015\fAb\u001d9be.\u001cVm]:j_:\u0004\"\u0001\u00194\n\u0005\u001dd\"\u0001D*qCJ\\7+Z:tS>t\u0017\u0001B2paf$2A\u00146l\u0011\u001dit\u0001%AA\u0002}BqAR\u0004\u0011\u0002\u0003\u0007\u0001*\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u00039T#aP8,\u0003A\u0004\"!\u001d<\u000e\u0003IT!a\u001d;\u0002\u0013Ut7\r[3dW\u0016$'BA;7\u0003)\tgN\\8uCRLwN\\\u0005\u0003oJ\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\u0012A\u001f\u0016\u0003\u0011>\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DX#A?\u0011\u0007y\f9!D\u0001\u0000\u0015\u0011\t\t!a\u0001\u0002\t1\fgn\u001a\u0006\u0003\u0003\u000b\tAA[1wC&\u0019\u0011\u0011B@\u0003\rM#(/\u001b8h\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\ty\u0001E\u00026\u0003#I1!a\u00057\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\tI\"a\b\u0011\u0007U\nY\"C\u0002\u0002\u001eY\u00121!\u00118z\u0011%\t\t\u0003DA\u0001\u0002\u0004\ty!A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003O\u0001b!!\u000b\u00020\u0005eQBAA\u0016\u0015\r\tiCN\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u0019\u0003W\u0011\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR\u0019\u0001*a\u000e\t\u0013\u0005\u0005b\"!AA\u0002\u0005e\u0011AB3rk\u0006d7\u000fF\u0002I\u0003{A\u0011\"!\t\u0010\u0003\u0003\u0005\r!!\u0007\u00029\r\u0013X-\u0019;f\t\u0006$\u0018mU8ve\u000e,G+\u00192mK\u000e{W.\\1oIB\u0011\u0011'E\n\u0005#\u0005\u0015#\bE\u0004\u0002H\u00055s\b\u0013(\u000e\u0005\u0005%#bAA&m\u00059!/\u001e8uS6,\u0017\u0002BA(\u0003\u0013\u0012\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83)\t\t\t%\u0001\u0005u_N#(/\u001b8h)\u0005i\u0018!B1qa2LH#\u0002(\u0002\\\u0005u\u0003\"B\u001f\u0015\u0001\u0004y\u0004\"\u0002$\u0015\u0001\u0004A\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u0003G\ny\u0007E\u00036\u0003K\nI'C\u0002\u0002hY\u0012aa\u00149uS>t\u0007#B\u001b\u0002l}B\u0015bAA7m\t1A+\u001e9mKJB\u0001\"!\u001d\u0016\u0003\u0003\u0005\rAT\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a\u001e\u0011\u0007y\fI(C\u0002\u0002|}\u0014aa\u00142kK\u000e$\b")
public class CreateDataSourceTableCommand
extends LogicalPlan
implements LeafRunnableCommand,
scala.Serializable {
    private final CatalogTable table;
    private final boolean ignoreIfExists;
    private Map<String, SQLMetric> metrics;
    private final Seq<Enumeration.Value> nodePatterns;
    private volatile boolean bitmap$0;

    public static Option<Tuple2<CatalogTable, Object>> unapply(CreateDataSourceTableCommand createDataSourceTableCommand) {
        return CreateDataSourceTableCommand$.MODULE$.unapply(createDataSourceTableCommand);
    }

    public static Function1<Tuple2<CatalogTable, Object>, CreateDataSourceTableCommand> tupled() {
        return CreateDataSourceTableCommand$.MODULE$.tupled();
    }

    public static Function1<CatalogTable, Function1<Object, CreateDataSourceTableCommand>> curried() {
        return CreateDataSourceTableCommand$.MODULE$.curried();
    }

    @Override
    public final Seq<LogicalPlan> children() {
        return LeafLike.children$((LeafLike)this);
    }

    public final TreeNode mapChildren(Function1 f) {
        return LeafLike.mapChildren$((LeafLike)this, (Function1)f);
    }

    public TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return LeafLike.withNewChildrenInternal$((LeafLike)this, (IndexedSeq)newChildren);
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public AttributeSet producedAttributes() {
        return Command.producedAttributes$((Command)this);
    }

    public Statistics stats() {
        return Command.stats$((Command)this);
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        CreateDataSourceTableCommand createDataSourceTableCommand = this;
        synchronized (createDataSourceTableCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$(this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    @Override
    public Map<String, SQLMetric> metrics() {
        if (!this.bitmap$0) {
            return this.metrics$lzycompute();
        }
        return this.metrics;
    }

    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    public final void org$apache$spark$sql$catalyst$plans$logical$Command$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public CatalogTable table() {
        return this.table;
    }

    public boolean ignoreIfExists() {
        return this.ignoreIfExists;
    }

    @Override
    public Seq<Row> run(SparkSession sparkSession) {
        CatalogTable catalogTable;
        HadoopFsRelation hadoopFsRelation;
        Seq seq;
        CatalogTableType catalogTableType = this.table().tableType();
        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
        Predef$.MODULE$.assert(catalogTableType == null ? catalogTableType2 != null : !catalogTableType.equals(catalogTableType2));
        Predef$.MODULE$.assert(this.table().provider().isDefined());
        SessionState sessionState = sparkSession.sessionState();
        if (sessionState.catalog().tableExists(this.table().identifier())) {
            if (this.ignoreIfExists()) {
                return (Seq)Nil$.MODULE$;
            }
            throw QueryCompilationErrors$.MODULE$.tableAlreadyExistsError(this.table().identifier().unquotedString());
        }
        Option pathOption = this.table().storage().locationUri().map((Function1 & Serializable & scala.Serializable)x$1 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)CatalogUtils$.MODULE$.URIToString(x$1)));
        Some x$12 = new Some(this.table().identifier().database().getOrElse((Function0 & Serializable & scala.Serializable)() -> sessionState.catalog().getCurrentDatabase()));
        String x$2 = this.table().identifier().copy$default$1();
        Option x$3 = this.table().identifier().copy$default$3();
        TableIdentifier x$4 = this.table().identifier().copy(x$2, (Option)x$12, x$3);
        boolean x$5 = sessionState.conf().manageFilesourcePartitions();
        CatalogTableType x$6 = this.table().copy$default$2();
        CatalogStorageFormat x$7 = this.table().copy$default$3();
        StructType x$8 = this.table().copy$default$4();
        Option x$9 = this.table().copy$default$5();
        Seq x$10 = this.table().copy$default$6();
        Option x$11 = this.table().copy$default$7();
        String x$122 = this.table().copy$default$8();
        long x$13 = this.table().copy$default$9();
        long x$14 = this.table().copy$default$10();
        String x$15 = this.table().copy$default$11();
        Map x$16 = this.table().copy$default$12();
        Option x$17 = this.table().copy$default$13();
        Option x$18 = this.table().copy$default$14();
        Option x$19 = this.table().copy$default$15();
        Seq x$20 = this.table().copy$default$16();
        boolean x$21 = this.table().copy$default$18();
        Map x$22 = this.table().copy$default$19();
        Option x$23 = this.table().copy$default$20();
        CatalogTable tableWithDefaultOptions = this.table().copy(x$4, x$6, x$7, x$8, x$9, x$10, x$11, x$122, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$5, x$21, x$22, x$23);
        SparkSession x$24 = sparkSession;
        None$ x$25 = this.table().schema().isEmpty() ? None$.MODULE$ : new Some((Object)this.table().schema());
        Seq x$26 = this.table().partitionColumnNames();
        String x$27 = (String)this.table().provider().get();
        Option x$28 = this.table().bucketSpec();
        Map x$29 = this.table().storage().properties().$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(pathOption));
        Some x$30 = new Some((Object)tableWithDefaultOptions);
        Seq<String> x$31 = DataSource$.MODULE$.apply$default$3();
        BaseRelation dataSource = new DataSource(x$24, x$27, x$31, (Option<StructType>)x$25, (Seq<String>)x$26, (Option<BucketSpec>)x$28, (Map<String, String>)x$29, (Option<CatalogTable>)x$30).resolveRelation(false);
        if (this.table().schema().nonEmpty()) {
            seq = this.table().partitionColumnNames();
        } else {
            Predef$.MODULE$.assert(this.table().partitionColumnNames().isEmpty());
            BaseRelation baseRelation = dataSource;
            if (baseRelation instanceof HadoopFsRelation) {
                HadoopFsRelation hadoopFsRelation2 = (HadoopFsRelation)baseRelation;
                seq = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])hadoopFsRelation2.partitionSchema().fieldNames())).toSeq();
            } else {
                seq = Nil$.MODULE$;
            }
        }
        Seq partitionColumnNames = seq;
        BaseRelation baseRelation = dataSource;
        if (baseRelation instanceof HadoopFsRelation && (hadoopFsRelation = (HadoopFsRelation)baseRelation).overlappedPartCols().nonEmpty()) {
            this.logWarning((Function0 & Serializable & scala.Serializable)() -> "It is not recommended to create a table with overlapped data and partition columns, as Spark cannot store a valid table schema and has to infer it at runtime, which hurts performance. Please check your data files and remove the partition columns in it.");
            StructType x$32 = new StructType();
            Nil$ x$33 = Nil$.MODULE$;
            TableIdentifier x$34 = this.table().copy$default$1();
            CatalogTableType x$35 = this.table().copy$default$2();
            CatalogStorageFormat x$36 = this.table().copy$default$3();
            Option x$37 = this.table().copy$default$5();
            Option x$38 = this.table().copy$default$7();
            String x$39 = this.table().copy$default$8();
            long x$40 = this.table().copy$default$9();
            long x$41 = this.table().copy$default$10();
            String x$42 = this.table().copy$default$11();
            Map x$43 = this.table().copy$default$12();
            Option x$44 = this.table().copy$default$13();
            Option x$45 = this.table().copy$default$14();
            Option x$46 = this.table().copy$default$15();
            Seq x$47 = this.table().copy$default$16();
            boolean x$48 = this.table().copy$default$17();
            boolean x$49 = this.table().copy$default$18();
            Map x$50 = this.table().copy$default$19();
            Option x$51 = this.table().copy$default$20();
            catalogTable = this.table().copy(x$34, x$35, x$36, x$32, x$37, (Seq)x$33, x$38, x$39, x$40, x$41, x$42, x$43, x$44, x$45, x$46, x$47, x$48, x$49, x$50, x$51);
        } else {
            StructType x$52 = dataSource.schema();
            Seq x$53 = partitionColumnNames;
            boolean x$54 = partitionColumnNames.nonEmpty() && sessionState.conf().manageFilesourcePartitions();
            TableIdentifier x$55 = this.table().copy$default$1();
            CatalogTableType x$56 = this.table().copy$default$2();
            CatalogStorageFormat x$57 = this.table().copy$default$3();
            Option x$58 = this.table().copy$default$5();
            Option x$59 = this.table().copy$default$7();
            String x$60 = this.table().copy$default$8();
            long x$61 = this.table().copy$default$9();
            long x$62 = this.table().copy$default$10();
            String x$63 = this.table().copy$default$11();
            Map x$64 = this.table().copy$default$12();
            Option x$65 = this.table().copy$default$13();
            Option x$66 = this.table().copy$default$14();
            Option x$67 = this.table().copy$default$15();
            Seq x$68 = this.table().copy$default$16();
            boolean x$69 = this.table().copy$default$18();
            Map x$70 = this.table().copy$default$19();
            Option x$71 = this.table().copy$default$20();
            catalogTable = this.table().copy(x$55, x$56, x$57, x$52, x$58, x$53, x$59, x$60, x$61, x$62, x$63, x$64, x$65, x$66, x$67, x$68, x$54, x$69, x$70, x$71);
        }
        CatalogTable newTable = catalogTable;
        sessionState.catalog().createTable(newTable, false, sessionState.catalog().createTable$default$3());
        return (Seq)Nil$.MODULE$;
    }

    public CreateDataSourceTableCommand copy(CatalogTable table, boolean ignoreIfExists) {
        return new CreateDataSourceTableCommand(table, ignoreIfExists);
    }

    public CatalogTable copy$default$1() {
        return this.table();
    }

    public boolean copy$default$2() {
        return this.ignoreIfExists();
    }

    public String productPrefix() {
        return "CreateDataSourceTableCommand";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.table();
            }
            case 1: {
                return BoxesRunTime.boxToBoolean((boolean)this.ignoreIfExists());
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CreateDataSourceTableCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CreateDataSourceTableCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        CreateDataSourceTableCommand createDataSourceTableCommand = (CreateDataSourceTableCommand)x$1;
        CatalogTable catalogTable = this.table();
        CatalogTable catalogTable2 = createDataSourceTableCommand.table();
        if (catalogTable == null) {
            if (catalogTable2 != null) {
                return false;
            }
        } else if (!catalogTable.equals(catalogTable2)) return false;
        if (this.ignoreIfExists() != createDataSourceTableCommand.ignoreIfExists()) return false;
        if (!createDataSourceTableCommand.canEqual(this)) return false;
        return true;
    }

    public CreateDataSourceTableCommand(CatalogTable table, boolean ignoreIfExists) {
        this.table = table;
        this.ignoreIfExists = ignoreIfExists;
        Command.$init$((Command)this);
        RunnableCommand.$init$(this);
        LeafLike.$init$((LeafLike)this);
    }
}

