/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.system.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.streampark.console.base.domain.RestRequest;
import org.apache.streampark.console.base.domain.RestResponse;
import org.apache.streampark.console.system.entity.Team;
import org.apache.streampark.console.system.service.TeamService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="TEAM_TAG")
@Validated
@RestController
@RequestMapping(value={"team"})
public class TeamController {
    private static final Logger log = LoggerFactory.getLogger(TeamController.class);
    @Autowired
    private TeamService teamService;

    @Operation(summary="List teams")
    @PostMapping(value={"list"})
    public RestResponse teamList(RestRequest restRequest, Team team) {
        IPage<Team> teamList = this.teamService.findTeams(team, restRequest);
        return RestResponse.success(teamList);
    }

    @Operation(summary="Check the team name")
    @PostMapping(value={"check/name"})
    public RestResponse checkTeamName(@NotBlank(message="{required}") @NotBlank(message="{required}") String teamName) {
        Team result = this.teamService.findByName(teamName);
        return RestResponse.success(result == null);
    }

    @Operation(summary="Create team")
    @PostMapping(value={"post"})
    @RequiresPermissions(value={"team:add"})
    public RestResponse addTeam(@Valid Team team) {
        this.teamService.createTeam(team);
        return RestResponse.success();
    }

    @Operation(summary="Delete team")
    @DeleteMapping(value={"delete"})
    @RequiresPermissions(value={"team:delete"})
    public RestResponse deleteTeam(Team team) {
        this.teamService.deleteTeam(team.getId());
        return RestResponse.success();
    }

    @Operation(summary="Update team")
    @PutMapping(value={"update"})
    @RequiresPermissions(value={"team:update"})
    public RestResponse updateTeam(Team team) {
        this.teamService.updateTeam(team);
        return RestResponse.success();
    }
}

