/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.blob.TransientBlobKey;
import org.apache.flink.runtime.clusterframework.ApplicationStatus;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceIDRetrievable;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.clusterframework.types.SlotID;
import org.apache.flink.runtime.entrypoint.ClusterInformation;
import org.apache.flink.runtime.heartbeat.HeartbeatListener;
import org.apache.flink.runtime.heartbeat.HeartbeatManager;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.heartbeat.HeartbeatTarget;
import org.apache.flink.runtime.heartbeat.NoOpHeartbeatManager;
import org.apache.flink.runtime.instance.InstanceID;
import org.apache.flink.runtime.io.network.partition.DataSetMetaInfo;
import org.apache.flink.runtime.io.network.partition.ResourceManagerPartitionTracker;
import org.apache.flink.runtime.io.network.partition.ResourceManagerPartitionTrackerFactory;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobmaster.JobMasterGateway;
import org.apache.flink.runtime.jobmaster.JobMasterId;
import org.apache.flink.runtime.jobmaster.JobMasterRegistrationSuccess;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.metrics.groups.ResourceManagerMetricGroup;
import org.apache.flink.runtime.registration.RegistrationResponse;
import org.apache.flink.runtime.resourcemanager.JobLeaderIdActions;
import org.apache.flink.runtime.resourcemanager.JobLeaderIdService;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.resourcemanager.ResourceManagerId;
import org.apache.flink.runtime.resourcemanager.ResourceOverview;
import org.apache.flink.runtime.resourcemanager.TaskExecutorRegistration;
import org.apache.flink.runtime.resourcemanager.TaskManagerInfoWithSlots;
import org.apache.flink.runtime.resourcemanager.WorkerResourceSpec;
import org.apache.flink.runtime.resourcemanager.exceptions.ResourceManagerException;
import org.apache.flink.runtime.resourcemanager.exceptions.UnknownTaskExecutorException;
import org.apache.flink.runtime.resourcemanager.registration.JobManagerRegistration;
import org.apache.flink.runtime.resourcemanager.registration.WorkerRegistration;
import org.apache.flink.runtime.resourcemanager.slotmanager.ResourceActions;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotManager;
import org.apache.flink.runtime.rest.messages.LogInfo;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerInfo;
import org.apache.flink.runtime.rest.messages.taskmanager.ThreadDumpInfo;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.FencedRpcEndpoint;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.RpcServiceUtils;
import org.apache.flink.runtime.slots.ResourceRequirement;
import org.apache.flink.runtime.slots.ResourceRequirements;
import org.apache.flink.runtime.taskexecutor.FileType;
import org.apache.flink.runtime.taskexecutor.SlotReport;
import org.apache.flink.runtime.taskexecutor.TaskExecutorGateway;
import org.apache.flink.runtime.taskexecutor.TaskExecutorHeartbeatPayload;
import org.apache.flink.runtime.taskexecutor.TaskExecutorRegistrationRejection;
import org.apache.flink.runtime.taskexecutor.TaskExecutorRegistrationSuccess;
import org.apache.flink.runtime.taskexecutor.TaskExecutorThreadInfoGateway;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.FutureUtils;
import org.apache.flink.util.concurrent.ScheduledExecutor;

public abstract class ResourceManager<WorkerType extends ResourceIDRetrievable>
extends FencedRpcEndpoint<ResourceManagerId>
implements ResourceManagerGateway {
    public static final String RESOURCE_MANAGER_NAME = "resourcemanager";
    private final ResourceID resourceId;
    private final Map<JobID, JobManagerRegistration> jobManagerRegistrations;
    private final Map<ResourceID, JobManagerRegistration> jmResourceIdRegistrations;
    private final JobLeaderIdService jobLeaderIdService;
    private final Map<ResourceID, WorkerRegistration<WorkerType>> taskExecutors;
    private final Map<ResourceID, CompletableFuture<TaskExecutorGateway>> taskExecutorGatewayFutures;
    private final HeartbeatServices heartbeatServices;
    private final FatalErrorHandler fatalErrorHandler;
    private final SlotManager slotManager;
    private final ResourceManagerPartitionTracker clusterPartitionTracker;
    private final ClusterInformation clusterInformation;
    protected final ResourceManagerMetricGroup resourceManagerMetricGroup;
    protected final Executor ioExecutor;
    private final CompletableFuture<Void> startedFuture;
    private HeartbeatManager<TaskExecutorHeartbeatPayload, Void> taskManagerHeartbeatManager;
    private HeartbeatManager<Void, Void> jobManagerHeartbeatManager;

    public ResourceManager(RpcService rpcService, UUID leaderSessionId, ResourceID resourceId, HeartbeatServices heartbeatServices, SlotManager slotManager, ResourceManagerPartitionTrackerFactory clusterPartitionTrackerFactory, JobLeaderIdService jobLeaderIdService, ClusterInformation clusterInformation, FatalErrorHandler fatalErrorHandler, ResourceManagerMetricGroup resourceManagerMetricGroup, Time rpcTimeout, Executor ioExecutor) {
        super(rpcService, RpcServiceUtils.createRandomName((String)RESOURCE_MANAGER_NAME), (Serializable)((Object)ResourceManagerId.fromUuid(leaderSessionId)));
        this.resourceId = (ResourceID)Preconditions.checkNotNull((Object)resourceId);
        this.heartbeatServices = (HeartbeatServices)Preconditions.checkNotNull((Object)heartbeatServices);
        this.slotManager = (SlotManager)Preconditions.checkNotNull((Object)slotManager);
        this.jobLeaderIdService = (JobLeaderIdService)Preconditions.checkNotNull((Object)jobLeaderIdService);
        this.clusterInformation = (ClusterInformation)Preconditions.checkNotNull((Object)clusterInformation);
        this.fatalErrorHandler = (FatalErrorHandler)Preconditions.checkNotNull((Object)fatalErrorHandler);
        this.resourceManagerMetricGroup = (ResourceManagerMetricGroup)Preconditions.checkNotNull((Object)resourceManagerMetricGroup);
        this.jobManagerRegistrations = new HashMap<JobID, JobManagerRegistration>(4);
        this.jmResourceIdRegistrations = new HashMap<ResourceID, JobManagerRegistration>(4);
        this.taskExecutors = new HashMap<ResourceID, WorkerRegistration<WorkerType>>(8);
        this.taskExecutorGatewayFutures = new HashMap<ResourceID, CompletableFuture<TaskExecutorGateway>>(8);
        this.jobManagerHeartbeatManager = NoOpHeartbeatManager.getInstance();
        this.taskManagerHeartbeatManager = NoOpHeartbeatManager.getInstance();
        this.clusterPartitionTracker = ((ResourceManagerPartitionTrackerFactory)Preconditions.checkNotNull((Object)clusterPartitionTrackerFactory)).get((taskExecutorResourceId, dataSetIds) -> this.taskExecutors.get(taskExecutorResourceId).getTaskExecutorGateway().releaseClusterPartitions(dataSetIds, rpcTimeout).exceptionally(throwable -> {
            this.log.debug("Request for release of cluster partitions belonging to data sets {} was not successful.", (Object)dataSetIds, throwable);
            throw new CompletionException((Throwable)throwable);
        }));
        this.ioExecutor = ioExecutor;
        this.startedFuture = new CompletableFuture();
    }

    public final void onStart() throws Exception {
        try {
            this.log.info("Starting the resource manager.");
            this.startResourceManagerServices();
            this.startedFuture.complete(null);
        }
        catch (Throwable t) {
            ResourceManagerException exception = new ResourceManagerException(String.format("Could not start the ResourceManager %s", this.getAddress()), t);
            this.onFatalError((Throwable)((Object)exception));
            throw exception;
        }
    }

    private void startResourceManagerServices() throws Exception {
        try {
            this.jobLeaderIdService.start(new JobLeaderIdActionsImpl());
            this.registerMetrics();
            this.startHeartbeatServices();
            this.slotManager.start((ResourceManagerId)((Object)this.getFencingToken()), (Executor)this.getMainThreadExecutor(), new ResourceActionsImpl());
            this.initialize();
        }
        catch (Exception e) {
            this.handleStartResourceManagerServicesException(e);
        }
    }

    private void handleStartResourceManagerServicesException(Exception e) throws Exception {
        try {
            this.stopResourceManagerServices();
        }
        catch (Exception inner) {
            e.addSuppressed(inner);
        }
        throw e;
    }

    public CompletableFuture<Void> getStartedFuture() {
        return this.startedFuture;
    }

    public final CompletableFuture<Void> onStop() {
        try {
            this.stopResourceManagerServices();
        }
        catch (Exception exception) {
            return FutureUtils.completedExceptionally((Throwable)new FlinkException("Could not properly shut down the ResourceManager.", (Throwable)exception));
        }
        return CompletableFuture.completedFuture(null);
    }

    private void stopResourceManagerServices() throws Exception {
        Object exception = null;
        try {
            this.terminate();
        }
        catch (Exception e) {
            exception = new ResourceManagerException("Error while shutting down resource manager", e);
        }
        this.stopHeartbeatServices();
        try {
            this.slotManager.close();
        }
        catch (Exception e) {
            exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, (Throwable)exception);
        }
        try {
            this.jobLeaderIdService.stop();
        }
        catch (Exception e) {
            exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, (Throwable)exception);
        }
        this.resourceManagerMetricGroup.close();
        this.clearStateInternal();
        ExceptionUtils.tryRethrowException((Exception)exception);
    }

    @Override
    public CompletableFuture<RegistrationResponse> registerJobManager(JobMasterId jobMasterId, ResourceID jobManagerResourceId, String jobManagerAddress, JobID jobId, Time timeout) {
        CompletableFuture<JobMasterId> jobMasterIdFuture;
        Preconditions.checkNotNull((Object)((Object)jobMasterId));
        Preconditions.checkNotNull((Object)jobManagerResourceId);
        Preconditions.checkNotNull((Object)jobManagerAddress);
        Preconditions.checkNotNull((Object)jobId);
        if (!this.jobLeaderIdService.containsJob(jobId)) {
            try {
                this.jobLeaderIdService.addJob(jobId);
            }
            catch (Exception e) {
                ResourceManagerException exception = new ResourceManagerException("Could not add the job " + jobId + " to the job id leader service.", e);
                this.onFatalError((Throwable)((Object)exception));
                this.log.error("Could not add job {} to job leader id service.", (Object)jobId, (Object)e);
                return FutureUtils.completedExceptionally((Throwable)((Object)exception));
            }
        }
        this.log.info("Registering job manager {}@{} for job {}.", new Object[]{jobMasterId, jobManagerAddress, jobId});
        try {
            jobMasterIdFuture = this.jobLeaderIdService.getLeaderId(jobId);
        }
        catch (Exception e) {
            ResourceManagerException exception = new ResourceManagerException("Cannot obtain the job leader id future to verify the correct job leader.", e);
            this.onFatalError((Throwable)((Object)exception));
            this.log.debug("Could not obtain the job leader id future to verify the correct job leader.");
            return FutureUtils.completedExceptionally((Throwable)((Object)exception));
        }
        CompletableFuture jobMasterGatewayFuture = this.getRpcService().connect(jobManagerAddress, (Serializable)((Object)jobMasterId), JobMasterGateway.class);
        CompletionStage registrationResponseFuture = jobMasterGatewayFuture.thenCombineAsync(jobMasterIdFuture, (jobMasterGateway, leadingJobMasterId) -> {
            if (Objects.equals(leadingJobMasterId, (Object)jobMasterId)) {
                return this.registerJobMasterInternal((JobMasterGateway)jobMasterGateway, jobId, jobManagerAddress, jobManagerResourceId);
            }
            String declineMessage = String.format("The leading JobMaster id %s did not match the received JobMaster id %s. This indicates that a JobMaster leader change has happened.", new Object[]{leadingJobMasterId, jobMasterId});
            this.log.debug(declineMessage);
            return new RegistrationResponse.Failure(new FlinkException(declineMessage));
        }, (Executor)this.getMainThreadExecutor());
        return ((CompletableFuture)registrationResponseFuture).handleAsync((registrationResponse, throwable) -> {
            if (throwable != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Registration of job manager {}@{} failed.", new Object[]{jobMasterId, jobManagerAddress, throwable});
                } else {
                    this.log.info("Registration of job manager {}@{} failed.", (Object)jobMasterId, (Object)jobManagerAddress);
                }
                return new RegistrationResponse.Failure((Throwable)throwable);
            }
            return registrationResponse;
        }, this.ioExecutor);
    }

    @Override
    public CompletableFuture<RegistrationResponse> registerTaskExecutor(TaskExecutorRegistration taskExecutorRegistration, Time timeout) {
        CompletableFuture taskExecutorGatewayFuture = this.getRpcService().connect(taskExecutorRegistration.getTaskExecutorAddress(), TaskExecutorGateway.class);
        this.taskExecutorGatewayFutures.put(taskExecutorRegistration.getResourceId(), taskExecutorGatewayFuture);
        return taskExecutorGatewayFuture.handleAsync((taskExecutorGateway, throwable) -> {
            ResourceID resourceId = taskExecutorRegistration.getResourceId();
            if (taskExecutorGatewayFuture == this.taskExecutorGatewayFutures.get(resourceId)) {
                this.taskExecutorGatewayFutures.remove(resourceId);
                if (throwable != null) {
                    return new RegistrationResponse.Failure((Throwable)throwable);
                }
                return this.registerTaskExecutorInternal((TaskExecutorGateway)taskExecutorGateway, taskExecutorRegistration);
            }
            this.log.debug("Ignoring outdated TaskExecutorGateway connection for {}.", (Object)resourceId.getStringWithMetadata());
            return new RegistrationResponse.Failure(new FlinkException("Decline outdated task executor registration."));
        }, (Executor)this.getMainThreadExecutor());
    }

    @Override
    public CompletableFuture<Acknowledge> sendSlotReport(ResourceID taskManagerResourceId, InstanceID taskManagerRegistrationId, SlotReport slotReport, Time timeout) {
        WorkerRegistration<WorkerType> workerTypeWorkerRegistration = this.taskExecutors.get(taskManagerResourceId);
        if (workerTypeWorkerRegistration.getInstanceID().equals((Object)taskManagerRegistrationId)) {
            if (this.slotManager.registerTaskManager(workerTypeWorkerRegistration, slotReport, workerTypeWorkerRegistration.getTotalResourceProfile(), workerTypeWorkerRegistration.getDefaultSlotResourceProfile())) {
                this.onWorkerRegistered(workerTypeWorkerRegistration.getWorker());
            }
            return CompletableFuture.completedFuture(Acknowledge.get());
        }
        return FutureUtils.completedExceptionally((Throwable)((Object)new ResourceManagerException(String.format("Unknown TaskManager registration id %s.", new Object[]{taskManagerRegistrationId}))));
    }

    protected void onWorkerRegistered(WorkerType worker) {
    }

    @Override
    public CompletableFuture<Void> heartbeatFromTaskManager(ResourceID resourceID, TaskExecutorHeartbeatPayload heartbeatPayload) {
        return this.taskManagerHeartbeatManager.receiveHeartbeat(resourceID, heartbeatPayload);
    }

    @Override
    public CompletableFuture<Void> heartbeatFromJobManager(ResourceID resourceID) {
        return this.jobManagerHeartbeatManager.receiveHeartbeat(resourceID, null);
    }

    @Override
    public void disconnectTaskManager(ResourceID resourceId, Exception cause) {
        this.closeTaskManagerConnection(resourceId, cause).ifPresent(this::stopWorker);
    }

    @Override
    public void disconnectJobManager(JobID jobId, JobStatus jobStatus, Exception cause) {
        if (jobStatus.isGloballyTerminalState()) {
            this.removeJob(jobId, cause);
        } else {
            this.closeJobManagerConnection(jobId, ResourceRequirementHandling.RETAIN, cause);
        }
    }

    @Override
    public CompletableFuture<Acknowledge> declareRequiredResources(JobMasterId jobMasterId, ResourceRequirements resourceRequirements, Time timeout) {
        JobID jobId = resourceRequirements.getJobId();
        JobManagerRegistration jobManagerRegistration = this.jobManagerRegistrations.get(jobId);
        if (null != jobManagerRegistration) {
            if (Objects.equals((Object)jobMasterId, (Object)jobManagerRegistration.getJobMasterId())) {
                this.slotManager.processResourceRequirements(resourceRequirements);
                return CompletableFuture.completedFuture(Acknowledge.get());
            }
            return FutureUtils.completedExceptionally((Throwable)((Object)new ResourceManagerException("The job leader's id " + (Object)((Object)jobManagerRegistration.getJobMasterId()) + " does not match the received id " + (Object)((Object)jobMasterId) + '.')));
        }
        return FutureUtils.completedExceptionally((Throwable)((Object)new ResourceManagerException("Could not find registered job manager for job " + jobId + '.')));
    }

    @Override
    public void notifySlotAvailable(InstanceID instanceID, SlotID slotId, AllocationID allocationId) {
        ResourceID resourceId = slotId.getResourceID();
        WorkerRegistration<WorkerType> registration = this.taskExecutors.get(resourceId);
        if (registration != null) {
            InstanceID registrationId = registration.getInstanceID();
            if (Objects.equals((Object)registrationId, (Object)instanceID)) {
                this.slotManager.freeSlot(slotId, allocationId);
            } else {
                this.log.debug("Invalid registration id for slot available message. This indicates an outdated request.");
            }
        } else {
            this.log.debug("Could not find registration for resource id {}. Discarding the slot availablemessage {}.", (Object)resourceId.getStringWithMetadata(), (Object)slotId);
        }
    }

    @Override
    public CompletableFuture<Acknowledge> deregisterApplication(ApplicationStatus finalStatus, @Nullable String diagnostics) {
        this.log.info("Shut down cluster because application is in {}, diagnostics {}.", (Object)finalStatus, (Object)diagnostics);
        try {
            this.internalDeregisterApplication(finalStatus, diagnostics);
        }
        catch (ResourceManagerException e) {
            this.log.warn("Could not properly shutdown the application.", (Throwable)((Object)e));
        }
        return CompletableFuture.completedFuture(Acknowledge.get());
    }

    @Override
    public CompletableFuture<Integer> getNumberOfRegisteredTaskManagers() {
        return CompletableFuture.completedFuture(this.taskExecutors.size());
    }

    @Override
    public CompletableFuture<Collection<TaskManagerInfo>> requestTaskManagerInfo(Time timeout) {
        ArrayList<TaskManagerInfo> taskManagerInfos = new ArrayList<TaskManagerInfo>(this.taskExecutors.size());
        for (Map.Entry<ResourceID, WorkerRegistration<WorkerType>> taskExecutorEntry : this.taskExecutors.entrySet()) {
            ResourceID resourceId = taskExecutorEntry.getKey();
            WorkerRegistration<WorkerType> taskExecutor = taskExecutorEntry.getValue();
            taskManagerInfos.add(new TaskManagerInfo(resourceId, taskExecutor.getTaskExecutorGateway().getAddress(), taskExecutor.getDataPort(), taskExecutor.getJmxPort(), this.taskManagerHeartbeatManager.getLastHeartbeatFrom(resourceId), this.slotManager.getNumberRegisteredSlotsOf(taskExecutor.getInstanceID()), this.slotManager.getNumberFreeSlotsOf(taskExecutor.getInstanceID()), this.slotManager.getRegisteredResourceOf(taskExecutor.getInstanceID()), this.slotManager.getFreeResourceOf(taskExecutor.getInstanceID()), taskExecutor.getHardwareDescription(), taskExecutor.getMemoryConfiguration()));
        }
        return CompletableFuture.completedFuture(taskManagerInfos);
    }

    @Override
    public CompletableFuture<TaskManagerInfoWithSlots> requestTaskManagerDetailsInfo(ResourceID resourceId, Time timeout) {
        WorkerRegistration<WorkerType> taskExecutor = this.taskExecutors.get(resourceId);
        if (taskExecutor == null) {
            return FutureUtils.completedExceptionally((Throwable)((Object)new UnknownTaskExecutorException(resourceId)));
        }
        InstanceID instanceId = taskExecutor.getInstanceID();
        TaskManagerInfoWithSlots taskManagerInfoWithSlots = new TaskManagerInfoWithSlots(new TaskManagerInfo(resourceId, taskExecutor.getTaskExecutorGateway().getAddress(), taskExecutor.getDataPort(), taskExecutor.getJmxPort(), this.taskManagerHeartbeatManager.getLastHeartbeatFrom(resourceId), this.slotManager.getNumberRegisteredSlotsOf(instanceId), this.slotManager.getNumberFreeSlotsOf(instanceId), this.slotManager.getRegisteredResourceOf(instanceId), this.slotManager.getFreeResourceOf(instanceId), taskExecutor.getHardwareDescription(), taskExecutor.getMemoryConfiguration()), this.slotManager.getAllocatedSlotsOf(instanceId));
        return CompletableFuture.completedFuture(taskManagerInfoWithSlots);
    }

    @Override
    public CompletableFuture<ResourceOverview> requestResourceOverview(Time timeout) {
        int numberSlots = this.slotManager.getNumberRegisteredSlots();
        int numberFreeSlots = this.slotManager.getNumberFreeSlots();
        ResourceProfile totalResource = this.slotManager.getRegisteredResource();
        ResourceProfile freeResource = this.slotManager.getFreeResource();
        return CompletableFuture.completedFuture(new ResourceOverview(this.taskExecutors.size(), numberSlots, numberFreeSlots, totalResource, freeResource));
    }

    @Override
    public CompletableFuture<Collection<Tuple2<ResourceID, String>>> requestTaskManagerMetricQueryServiceAddresses(Time timeout) {
        ArrayList<CompletionStage> metricQueryServiceAddressFutures = new ArrayList<CompletionStage>(this.taskExecutors.size());
        for (Map.Entry<ResourceID, WorkerRegistration<WorkerType>> workerRegistrationEntry : this.taskExecutors.entrySet()) {
            ResourceID tmResourceId = workerRegistrationEntry.getKey();
            WorkerRegistration<WorkerType> workerRegistration = workerRegistrationEntry.getValue();
            TaskExecutorGateway taskExecutorGateway = workerRegistration.getTaskExecutorGateway();
            CompletionStage metricQueryServiceAddressFuture = taskExecutorGateway.requestMetricQueryServiceAddress(timeout).thenApply(o -> o.toOptional().map(address -> Tuple2.of((Object)tmResourceId, (Object)address)));
            metricQueryServiceAddressFutures.add(metricQueryServiceAddressFuture);
        }
        return FutureUtils.combineAll(metricQueryServiceAddressFutures).thenApply(collection -> collection.stream().filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()));
    }

    @Override
    public CompletableFuture<TransientBlobKey> requestTaskManagerFileUploadByType(ResourceID taskManagerId, FileType fileType, Time timeout) {
        this.log.debug("Request {} file upload from TaskExecutor {}.", (Object)fileType, (Object)taskManagerId.getStringWithMetadata());
        WorkerRegistration<WorkerType> taskExecutor = this.taskExecutors.get(taskManagerId);
        if (taskExecutor == null) {
            this.log.debug("Request upload of file {} from unregistered TaskExecutor {}.", (Object)fileType, (Object)taskManagerId.getStringWithMetadata());
            return FutureUtils.completedExceptionally((Throwable)((Object)new UnknownTaskExecutorException(taskManagerId)));
        }
        return taskExecutor.getTaskExecutorGateway().requestFileUploadByType(fileType, timeout);
    }

    @Override
    public CompletableFuture<TransientBlobKey> requestTaskManagerFileUploadByName(ResourceID taskManagerId, String fileName, Time timeout) {
        this.log.debug("Request upload of file {} from TaskExecutor {}.", (Object)fileName, (Object)taskManagerId.getStringWithMetadata());
        WorkerRegistration<WorkerType> taskExecutor = this.taskExecutors.get(taskManagerId);
        if (taskExecutor == null) {
            this.log.debug("Request upload of file {} from unregistered TaskExecutor {}.", (Object)fileName, (Object)taskManagerId.getStringWithMetadata());
            return FutureUtils.completedExceptionally((Throwable)((Object)new UnknownTaskExecutorException(taskManagerId)));
        }
        return taskExecutor.getTaskExecutorGateway().requestFileUploadByName(fileName, timeout);
    }

    @Override
    public CompletableFuture<Collection<LogInfo>> requestTaskManagerLogList(ResourceID taskManagerId, Time timeout) {
        WorkerRegistration<WorkerType> taskExecutor = this.taskExecutors.get(taskManagerId);
        if (taskExecutor == null) {
            this.log.debug("Requested log list from unregistered TaskExecutor {}.", (Object)taskManagerId.getStringWithMetadata());
            return FutureUtils.completedExceptionally((Throwable)((Object)new UnknownTaskExecutorException(taskManagerId)));
        }
        return taskExecutor.getTaskExecutorGateway().requestLogList(timeout);
    }

    @Override
    public CompletableFuture<Void> releaseClusterPartitions(IntermediateDataSetID dataSetId) {
        return this.clusterPartitionTracker.releaseClusterPartitions(dataSetId);
    }

    @Override
    public CompletableFuture<Map<IntermediateDataSetID, DataSetMetaInfo>> listDataSets() {
        return CompletableFuture.completedFuture(this.clusterPartitionTracker.listDataSets());
    }

    @Override
    public CompletableFuture<ThreadDumpInfo> requestThreadDump(ResourceID taskManagerId, Time timeout) {
        WorkerRegistration<WorkerType> taskExecutor = this.taskExecutors.get(taskManagerId);
        if (taskExecutor == null) {
            this.log.debug("Requested thread dump from unregistered TaskExecutor {}.", (Object)taskManagerId.getStringWithMetadata());
            return FutureUtils.completedExceptionally((Throwable)((Object)new UnknownTaskExecutorException(taskManagerId)));
        }
        return taskExecutor.getTaskExecutorGateway().requestThreadDump(timeout);
    }

    @Override
    public CompletableFuture<TaskExecutorThreadInfoGateway> requestTaskExecutorThreadInfoGateway(ResourceID taskManagerId, Time timeout) {
        WorkerRegistration<WorkerType> taskExecutor = this.taskExecutors.get(taskManagerId);
        if (taskExecutor == null) {
            return FutureUtils.completedExceptionally((Throwable)((Object)new UnknownTaskExecutorException(taskManagerId)));
        }
        return CompletableFuture.completedFuture(taskExecutor.getTaskExecutorGateway());
    }

    private RegistrationResponse registerJobMasterInternal(JobMasterGateway jobMasterGateway, JobID jobId, String jobManagerAddress, ResourceID jobManagerResourceId) {
        if (this.jobManagerRegistrations.containsKey(jobId)) {
            JobManagerRegistration oldJobManagerRegistration = this.jobManagerRegistrations.get(jobId);
            if (Objects.equals((Object)oldJobManagerRegistration.getJobMasterId(), jobMasterGateway.getFencingToken())) {
                this.log.debug("Job manager {}@{} was already registered.", (Object)jobMasterGateway.getFencingToken(), (Object)jobManagerAddress);
            } else {
                this.closeJobManagerConnection(oldJobManagerRegistration.getJobID(), ResourceRequirementHandling.RETAIN, new Exception("New job leader for job " + jobId + " found."));
                JobManagerRegistration jobManagerRegistration = new JobManagerRegistration(jobId, jobManagerResourceId, jobMasterGateway);
                this.jobManagerRegistrations.put(jobId, jobManagerRegistration);
                this.jmResourceIdRegistrations.put(jobManagerResourceId, jobManagerRegistration);
            }
        } else {
            JobManagerRegistration jobManagerRegistration = new JobManagerRegistration(jobId, jobManagerResourceId, jobMasterGateway);
            this.jobManagerRegistrations.put(jobId, jobManagerRegistration);
            this.jmResourceIdRegistrations.put(jobManagerResourceId, jobManagerRegistration);
        }
        this.log.info("Registered job manager {}@{} for job {}.", new Object[]{jobMasterGateway.getFencingToken(), jobManagerAddress, jobId});
        this.jobManagerHeartbeatManager.monitorTarget(jobManagerResourceId, new JobMasterHeartbeatTarget(jobMasterGateway));
        return new JobMasterRegistrationSuccess((ResourceManagerId)((Object)this.getFencingToken()), this.resourceId);
    }

    private RegistrationResponse registerTaskExecutorInternal(TaskExecutorGateway taskExecutorGateway, TaskExecutorRegistration taskExecutorRegistration) {
        ResourceID taskExecutorResourceId = taskExecutorRegistration.getResourceId();
        WorkerRegistration<WorkerType> oldRegistration = this.taskExecutors.remove(taskExecutorResourceId);
        if (oldRegistration != null) {
            this.log.debug("Replacing old registration of TaskExecutor {}.", (Object)taskExecutorResourceId.getStringWithMetadata());
            this.slotManager.unregisterTaskManager(oldRegistration.getInstanceID(), (Exception)((Object)new ResourceManagerException(String.format("TaskExecutor %s re-connected to the ResourceManager.", taskExecutorResourceId.getStringWithMetadata()))));
        }
        WorkerType newWorker = this.workerStarted(taskExecutorResourceId);
        String taskExecutorAddress = taskExecutorRegistration.getTaskExecutorAddress();
        if (newWorker == null) {
            this.log.warn("Discard registration from TaskExecutor {} at ({}) because the framework did not recognize it", (Object)taskExecutorResourceId.getStringWithMetadata(), (Object)taskExecutorAddress);
            return new TaskExecutorRegistrationRejection("The ResourceManager does not recognize this TaskExecutor.");
        }
        WorkerRegistration<WorkerType> registration = new WorkerRegistration<WorkerType>(taskExecutorGateway, newWorker, taskExecutorRegistration.getDataPort(), taskExecutorRegistration.getJmxPort(), taskExecutorRegistration.getHardwareDescription(), taskExecutorRegistration.getMemoryConfiguration(), taskExecutorRegistration.getTotalResourceProfile(), taskExecutorRegistration.getDefaultSlotResourceProfile());
        this.log.info("Registering TaskManager with ResourceID {} ({}) at ResourceManager", (Object)taskExecutorResourceId.getStringWithMetadata(), (Object)taskExecutorAddress);
        this.taskExecutors.put(taskExecutorResourceId, registration);
        this.taskManagerHeartbeatManager.monitorTarget(taskExecutorResourceId, new TaskExecutorHeartbeatTarget(taskExecutorGateway));
        return new TaskExecutorRegistrationSuccess(registration.getInstanceID(), this.resourceId, this.clusterInformation);
    }

    protected void registerMetrics() {
        this.resourceManagerMetricGroup.gauge("numRegisteredTaskManagers", () -> (long)this.taskExecutors.size());
    }

    private void clearStateInternal() {
        this.jobManagerRegistrations.clear();
        this.jmResourceIdRegistrations.clear();
        this.taskExecutors.clear();
        try {
            this.jobLeaderIdService.clear();
        }
        catch (Exception e) {
            this.onFatalError((Throwable)((Object)new ResourceManagerException("Could not properly clear the job leader id service.", e)));
        }
    }

    protected void closeJobManagerConnection(JobID jobId, ResourceRequirementHandling resourceRequirementHandling, Exception cause) {
        JobManagerRegistration jobManagerRegistration = this.jobManagerRegistrations.remove(jobId);
        if (jobManagerRegistration != null) {
            ResourceID jobManagerResourceId = jobManagerRegistration.getJobManagerResourceID();
            JobMasterGateway jobMasterGateway = jobManagerRegistration.getJobManagerGateway();
            JobMasterId jobMasterId = jobManagerRegistration.getJobMasterId();
            this.log.info("Disconnect job manager {}@{} for job {} from the resource manager.", new Object[]{jobMasterId, jobMasterGateway.getAddress(), jobId});
            this.jobManagerHeartbeatManager.unmonitorTarget(jobManagerResourceId);
            this.jmResourceIdRegistrations.remove(jobManagerResourceId);
            if (resourceRequirementHandling == ResourceRequirementHandling.CLEAR) {
                this.slotManager.clearResourceRequirements(jobId);
            }
            jobMasterGateway.disconnectResourceManager((ResourceManagerId)((Object)this.getFencingToken()), cause);
        } else {
            this.log.debug("There was no registered job manager for job {}.", (Object)jobId);
        }
    }

    protected Optional<WorkerType> closeTaskManagerConnection(ResourceID resourceID, Exception cause) {
        this.taskManagerHeartbeatManager.unmonitorTarget(resourceID);
        WorkerRegistration<WorkerType> workerRegistration = this.taskExecutors.remove(resourceID);
        if (workerRegistration != null) {
            this.log.info("Closing TaskExecutor connection {} because: {}", (Object)resourceID.getStringWithMetadata(), (Object)cause.getMessage());
            this.slotManager.unregisterTaskManager(workerRegistration.getInstanceID(), cause);
            this.clusterPartitionTracker.processTaskExecutorShutdown(resourceID);
            workerRegistration.getTaskExecutorGateway().disconnectResourceManager(cause);
        } else {
            this.log.debug("No open TaskExecutor connection {}. Ignoring close TaskExecutor connection. Closing reason was: {}", (Object)resourceID.getStringWithMetadata(), (Object)cause.getMessage());
        }
        return Optional.ofNullable(workerRegistration).map(WorkerRegistration::getWorker);
    }

    protected void removeJob(JobID jobId, Exception cause) {
        try {
            this.jobLeaderIdService.removeJob(jobId);
        }
        catch (Exception e) {
            this.log.warn("Could not properly remove the job {} from the job leader id service.", (Object)jobId, (Object)e);
        }
        if (this.jobManagerRegistrations.containsKey(jobId)) {
            this.closeJobManagerConnection(jobId, ResourceRequirementHandling.CLEAR, cause);
        }
    }

    protected void jobLeaderLostLeadership(JobID jobId, JobMasterId oldJobMasterId) {
        if (this.jobManagerRegistrations.containsKey(jobId)) {
            JobManagerRegistration jobManagerRegistration = this.jobManagerRegistrations.get(jobId);
            if (Objects.equals((Object)jobManagerRegistration.getJobMasterId(), (Object)oldJobMasterId)) {
                this.closeJobManagerConnection(jobId, ResourceRequirementHandling.RETAIN, new Exception("Job leader lost leadership."));
            } else {
                this.log.debug("Discarding job leader lost leadership, because a new job leader was found for job {}. ", (Object)jobId);
            }
        } else {
            this.log.debug("Discard job leader lost leadership for outdated leader {} for job {}.", (Object)oldJobMasterId, (Object)jobId);
        }
    }

    protected void releaseResource(InstanceID instanceId, Exception cause) {
        ResourceIDRetrievable worker = null;
        for (Map.Entry<ResourceID, WorkerRegistration<WorkerType>> entry : this.taskExecutors.entrySet()) {
            if (!entry.getValue().getInstanceID().equals((Object)instanceId)) continue;
            worker = entry.getValue().getWorker();
            break;
        }
        if (worker != null) {
            if (this.stopWorker(worker)) {
                this.closeTaskManagerConnection(worker.getResourceID(), cause);
            } else {
                this.log.debug("Worker {} could not be stopped.", (Object)worker.getResourceID().getStringWithMetadata());
            }
        } else {
            this.slotManager.unregisterTaskManager(instanceId, cause);
        }
    }

    protected void onFatalError(Throwable t) {
        try {
            this.log.error("Fatal error occurred in ResourceManager.", t);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.fatalErrorHandler.onFatalError(t);
    }

    private void startHeartbeatServices() {
        this.taskManagerHeartbeatManager = this.heartbeatServices.createHeartbeatManagerSender(this.resourceId, new TaskManagerHeartbeatListener(), (ScheduledExecutor)this.getMainThreadExecutor(), this.log);
        this.jobManagerHeartbeatManager = this.heartbeatServices.createHeartbeatManagerSender(this.resourceId, new JobManagerHeartbeatListener(), (ScheduledExecutor)this.getMainThreadExecutor(), this.log);
    }

    private void stopHeartbeatServices() {
        this.taskManagerHeartbeatManager.stop();
        this.jobManagerHeartbeatManager.stop();
    }

    protected abstract void initialize() throws ResourceManagerException;

    protected abstract void terminate() throws Exception;

    protected abstract void internalDeregisterApplication(ApplicationStatus var1, @Nullable String var2) throws ResourceManagerException;

    @VisibleForTesting
    public abstract boolean startNewWorker(WorkerResourceSpec var1);

    protected abstract WorkerType workerStarted(ResourceID var1);

    public abstract boolean stopWorker(WorkerType var1);

    protected void setFailUnfulfillableRequest(boolean failUnfulfillableRequest) {
        this.slotManager.setFailUnfulfillableRequest(failUnfulfillableRequest);
    }

    protected int getNumberRequiredTaskManagers() {
        return this.getRequiredResources().values().stream().reduce(0, Integer::sum);
    }

    protected Map<WorkerResourceSpec, Integer> getRequiredResources() {
        return this.slotManager.getRequiredResources();
    }

    private class JobManagerHeartbeatListener
    implements HeartbeatListener<Void, Void> {
        private JobManagerHeartbeatListener() {
        }

        @Override
        public void notifyHeartbeatTimeout(ResourceID resourceID) {
            String message = String.format("The heartbeat of JobManager with id %s timed out.", resourceID.getStringWithMetadata());
            ResourceManager.this.log.info(message);
            this.handleJobManagerConnectionLoss(resourceID, new TimeoutException(message));
        }

        private void handleJobManagerConnectionLoss(ResourceID resourceID, Exception cause) {
            JobManagerRegistration jobManagerRegistration;
            ResourceManager.this.validateRunsInMainThread();
            if (ResourceManager.this.jmResourceIdRegistrations.containsKey(resourceID) && (jobManagerRegistration = (JobManagerRegistration)ResourceManager.this.jmResourceIdRegistrations.get(resourceID)) != null) {
                ResourceManager.this.closeJobManagerConnection(jobManagerRegistration.getJobID(), ResourceRequirementHandling.RETAIN, cause);
            }
        }

        @Override
        public void notifyTargetUnreachable(ResourceID resourceID) {
            String message = String.format("JobManager with id %s is no longer reachable.", resourceID.getStringWithMetadata());
            ResourceManager.this.log.info(message);
            this.handleJobManagerConnectionLoss(resourceID, (Exception)((Object)new ResourceManagerException(message)));
        }

        @Override
        public void reportPayload(ResourceID resourceID, Void payload) {
        }

        @Override
        public Void retrievePayload(ResourceID resourceID) {
            return null;
        }
    }

    private class TaskManagerHeartbeatListener
    implements HeartbeatListener<TaskExecutorHeartbeatPayload, Void> {
        private TaskManagerHeartbeatListener() {
        }

        @Override
        public void notifyHeartbeatTimeout(ResourceID resourceID) {
            String message = String.format("The heartbeat of TaskManager with id %s timed out.", resourceID.getStringWithMetadata());
            ResourceManager.this.log.info(message);
            this.handleTaskManagerConnectionLoss(resourceID, new TimeoutException(message));
        }

        private void handleTaskManagerConnectionLoss(ResourceID resourceID, Exception cause) {
            ResourceManager.this.validateRunsInMainThread();
            ResourceManager.this.closeTaskManagerConnection(resourceID, cause).ifPresent(ResourceManager.this::stopWorker);
        }

        @Override
        public void notifyTargetUnreachable(ResourceID resourceID) {
            String message = String.format("TaskManager with id %s is no longer reachable.", resourceID.getStringWithMetadata());
            ResourceManager.this.log.info(message);
            this.handleTaskManagerConnectionLoss(resourceID, (Exception)((Object)new ResourceManagerException(message)));
        }

        @Override
        public void reportPayload(ResourceID resourceID, TaskExecutorHeartbeatPayload payload) {
            ResourceManager.this.validateRunsInMainThread();
            WorkerRegistration workerRegistration = (WorkerRegistration)ResourceManager.this.taskExecutors.get(resourceID);
            if (workerRegistration == null) {
                ResourceManager.this.log.debug("Received slot report from TaskManager {} which is no longer registered.", (Object)resourceID.getStringWithMetadata());
            } else {
                InstanceID instanceId = workerRegistration.getInstanceID();
                ResourceManager.this.slotManager.reportSlotStatus(instanceId, payload.getSlotReport());
                ResourceManager.this.clusterPartitionTracker.processTaskExecutorClusterPartitionReport(resourceID, payload.getClusterPartitionReport());
            }
        }

        @Override
        public Void retrievePayload(ResourceID resourceID) {
            return null;
        }
    }

    private class JobLeaderIdActionsImpl
    implements JobLeaderIdActions {
        private JobLeaderIdActionsImpl() {
        }

        @Override
        public void jobLeaderLostLeadership(final JobID jobId, final JobMasterId oldJobMasterId) {
            ResourceManager.this.runAsync(new Runnable(){

                @Override
                public void run() {
                    ResourceManager.this.jobLeaderLostLeadership(jobId, oldJobMasterId);
                }
            });
        }

        @Override
        public void notifyJobTimeout(final JobID jobId, final UUID timeoutId) {
            ResourceManager.this.runAsync(new Runnable(){

                @Override
                public void run() {
                    if (ResourceManager.this.jobLeaderIdService.isValidTimeout(jobId, timeoutId)) {
                        ResourceManager.this.removeJob(jobId, new Exception("Job " + jobId + "was removed because of timeout"));
                    }
                }
            });
        }

        @Override
        public void handleError(Throwable error) {
            ResourceManager.this.onFatalError(error);
        }
    }

    private class ResourceActionsImpl
    implements ResourceActions {
        private ResourceActionsImpl() {
        }

        @Override
        public void releaseResource(InstanceID instanceId, Exception cause) {
            ResourceManager.this.validateRunsInMainThread();
            ResourceManager.this.releaseResource(instanceId, cause);
        }

        @Override
        public boolean allocateResource(WorkerResourceSpec workerResourceSpec) {
            ResourceManager.this.validateRunsInMainThread();
            return ResourceManager.this.startNewWorker(workerResourceSpec);
        }

        @Override
        public void notifyAllocationFailure(JobID jobId, AllocationID allocationId, Exception cause) {
            ResourceManager.this.validateRunsInMainThread();
            JobManagerRegistration jobManagerRegistration = (JobManagerRegistration)ResourceManager.this.jobManagerRegistrations.get(jobId);
            if (jobManagerRegistration != null) {
                jobManagerRegistration.getJobManagerGateway().notifyAllocationFailure(allocationId, cause);
            }
        }

        @Override
        public void notifyNotEnoughResourcesAvailable(JobID jobId, Collection<ResourceRequirement> acquiredResources) {
            ResourceManager.this.validateRunsInMainThread();
            JobManagerRegistration jobManagerRegistration = (JobManagerRegistration)ResourceManager.this.jobManagerRegistrations.get(jobId);
            if (jobManagerRegistration != null) {
                jobManagerRegistration.getJobManagerGateway().notifyNotEnoughResourcesAvailable(acquiredResources);
            }
        }
    }

    private static final class TaskExecutorHeartbeatTarget
    implements HeartbeatTarget<Void> {
        private final TaskExecutorGateway taskExecutorGateway;

        private TaskExecutorHeartbeatTarget(TaskExecutorGateway taskExecutorGateway) {
            this.taskExecutorGateway = taskExecutorGateway;
        }

        @Override
        public CompletableFuture<Void> receiveHeartbeat(ResourceID resourceID, Void payload) {
            return FutureUtils.unsupportedOperationFuture();
        }

        @Override
        public CompletableFuture<Void> requestHeartbeat(ResourceID resourceID, Void payload) {
            return this.taskExecutorGateway.heartbeatFromResourceManager(resourceID);
        }
    }

    private static final class JobMasterHeartbeatTarget
    implements HeartbeatTarget<Void> {
        private final JobMasterGateway jobMasterGateway;

        private JobMasterHeartbeatTarget(JobMasterGateway jobMasterGateway) {
            this.jobMasterGateway = jobMasterGateway;
        }

        @Override
        public CompletableFuture<Void> receiveHeartbeat(ResourceID resourceID, Void payload) {
            return FutureUtils.unsupportedOperationFuture();
        }

        @Override
        public CompletableFuture<Void> requestHeartbeat(ResourceID resourceID, Void payload) {
            return this.jobMasterGateway.heartbeatFromResourceManager(resourceID);
        }
    }

    private static enum ResourceRequirementHandling {
        RETAIN,
        CLEAR;

    }
}

