/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.toolkit.support;

import com.baomidou.mybatisplus.core.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.core.toolkit.ClassUtils;
import com.baomidou.mybatisplus.core.toolkit.ReflectionKit;
import com.baomidou.mybatisplus.core.toolkit.support.LambdaMeta;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectLambdaMeta
implements LambdaMeta {
    private static final Logger log;
    private static final Field FIELD_CAPTURING_CLASS;
    private final SerializedLambda lambda;

    public ReflectLambdaMeta(SerializedLambda lambda) {
        this.lambda = lambda;
    }

    @Override
    public String getImplMethodName() {
        return this.lambda.getImplMethodName();
    }

    @Override
    public Class<?> getInstantiatedClass() {
        String instantiatedMethodType = this.lambda.getInstantiatedMethodType();
        String instantiatedType = instantiatedMethodType.substring(2, instantiatedMethodType.indexOf(";")).replace("/", ".");
        return ClassUtils.toClassConfident(instantiatedType, this.getCapturingClassClassLoader());
    }

    private ClassLoader getCapturingClassClassLoader() {
        if (FIELD_CAPTURING_CLASS == null) {
            return null;
        }
        try {
            return ((Class)FIELD_CAPTURING_CLASS.get(this.lambda)).getClassLoader();
        }
        catch (IllegalAccessException e) {
            throw new MybatisPlusException(e);
        }
    }

    static {
        Field fieldCapturingClass;
        log = LoggerFactory.getLogger(ReflectLambdaMeta.class);
        try {
            Class<SerializedLambda> aClass = SerializedLambda.class;
            fieldCapturingClass = ReflectionKit.setAccessible(aClass.getDeclaredField("capturingClass"));
        }
        catch (Throwable e) {
            log.warn(e.getMessage());
            fieldCapturingClass = null;
        }
        FIELD_CAPTURING_CLASS = fieldCapturingClass;
    }
}

