/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.constraint;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import net.sf.oval.Validator;
import net.sf.oval.configuration.annotation.AbstractAnnotationCheck;
import net.sf.oval.constraint.MaxSize;
import net.sf.oval.context.OValContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaxSizeCheck
extends AbstractAnnotationCheck<MaxSize> {
    private static final long serialVersionUID = 1L;
    private int max;

    @Override
    public void configure(MaxSize constraintAnnotation) {
        super.configure(constraintAnnotation);
        this.setMax(constraintAnnotation.value());
    }

    protected Map<String, String> createMessageVariables() {
        Map<String, String> messageVariables = Validator.getCollectionFactory().createMap(2);
        messageVariables.put("max", Integer.toString(this.max));
        return messageVariables;
    }

    public int getMax() {
        return this.max;
    }

    @Override
    public boolean isSatisfied(Object validatedObject, Object valueToValidate, OValContext context, Validator validator) {
        if (valueToValidate == null) {
            return true;
        }
        if (valueToValidate instanceof Collection) {
            int size = ((Collection)valueToValidate).size();
            return size <= this.max;
        }
        if (valueToValidate instanceof Map) {
            int size = ((Map)valueToValidate).size();
            return size <= this.max;
        }
        if (valueToValidate.getClass().isArray()) {
            int size = Array.getLength(valueToValidate);
            return size <= this.max;
        }
        return false;
    }

    public void setMax(int max) {
        this.max = max;
        this.requireMessageVariablesRecreation();
    }
}

