/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.constraint;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import net.sf.oval.Validator;
import net.sf.oval.configuration.annotation.AbstractAnnotationCheck;
import net.sf.oval.constraint.MinSize;
import net.sf.oval.context.OValContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinSizeCheck
extends AbstractAnnotationCheck<MinSize> {
    private static final long serialVersionUID = 1L;
    private int min;

    @Override
    public void configure(MinSize constraintAnnotation) {
        super.configure(constraintAnnotation);
        this.setMin(constraintAnnotation.value());
    }

    protected Map<String, String> createMessageVariables() {
        Map<String, String> messageVariables = Validator.getCollectionFactory().createMap(2);
        messageVariables.put("min", Integer.toString(this.min));
        return messageVariables;
    }

    public int getMin() {
        return this.min;
    }

    @Override
    public boolean isSatisfied(Object validatedObject, Object valueToValidate, OValContext context, Validator validator) {
        if (valueToValidate == null) {
            return true;
        }
        if (valueToValidate instanceof Collection) {
            int size = ((Collection)valueToValidate).size();
            return size >= this.min;
        }
        if (valueToValidate instanceof Map) {
            int size = ((Map)valueToValidate).size();
            return size >= this.min;
        }
        if (valueToValidate.getClass().isArray()) {
            int size = Array.getLength(valueToValidate);
            return size >= this.min;
        }
        return false;
    }

    public void setMin(int min) {
        this.min = min;
        this.requireMessageVariablesRecreation();
    }
}

