/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.constraint;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.sf.oval.ConstraintTarget;
import net.sf.oval.Validator;
import net.sf.oval.configuration.annotation.AbstractAnnotationCheck;
import net.sf.oval.constraint.NotMatchPattern;
import net.sf.oval.context.OValContext;
import net.sf.oval.internal.util.ArrayUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotMatchPatternCheck
extends AbstractAnnotationCheck<NotMatchPattern> {
    private static final long serialVersionUID = 1L;
    private final List<Pattern> patterns = Validator.getCollectionFactory().createList(2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configure(NotMatchPattern constraintAnnotation) {
        super.configure(constraintAnnotation);
        List<Pattern> list = this.patterns;
        synchronized (list) {
            this.patterns.clear();
            String[] stringPatterns = constraintAnnotation.pattern();
            int[] f = constraintAnnotation.flags();
            int i = 0;
            int l = stringPatterns.length;
            while (i < l) {
                int flag = f.length > i ? f[i] : 0;
                Pattern p = Pattern.compile(stringPatterns[i], flag);
                this.patterns.add(p);
                ++i;
            }
            this.requireMessageVariablesRecreation();
        }
    }

    protected Map<String, String> createMessageVariables() {
        Map<String, String> messageVariables = Validator.getCollectionFactory().createMap(2);
        messageVariables.put("pattern", this.patterns.size() == 1 ? this.patterns.get(0).toString() : this.patterns.toString());
        return messageVariables;
    }

    @Override
    protected ConstraintTarget[] getAppliesToDefault() {
        return new ConstraintTarget[]{ConstraintTarget.VALUES};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pattern[] getPatterns() {
        List<Pattern> list = this.patterns;
        synchronized (list) {
            return this.patterns.toArray(new Pattern[this.patterns.size()]);
        }
    }

    @Override
    public boolean isSatisfied(Object validatedObject, Object valueToValidate, OValContext context, Validator validator) {
        if (valueToValidate == null) {
            return true;
        }
        for (Pattern p : this.patterns) {
            if (!p.matcher(valueToValidate.toString()).matches()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPattern(Pattern pattern) {
        List<Pattern> list = this.patterns;
        synchronized (list) {
            this.patterns.clear();
            this.patterns.add(pattern);
        }
        this.requireMessageVariablesRecreation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPattern(String pattern, int flags) {
        List<Pattern> list = this.patterns;
        synchronized (list) {
            this.patterns.clear();
            this.patterns.add(Pattern.compile(pattern, flags));
        }
        this.requireMessageVariablesRecreation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPatterns(Collection<Pattern> patterns) {
        List<Pattern> list = this.patterns;
        synchronized (list) {
            this.patterns.clear();
            this.patterns.addAll(patterns);
        }
        this.requireMessageVariablesRecreation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPatterns(Pattern ... patterns) {
        List<Pattern> list = this.patterns;
        synchronized (list) {
            this.patterns.clear();
            ArrayUtils.addAll(this.patterns, patterns);
        }
        this.requireMessageVariablesRecreation();
    }
}

