/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.localization.message;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import net.sf.oval.Validator;
import net.sf.oval.internal.Log;
import net.sf.oval.internal.util.Assert;
import net.sf.oval.localization.message.MessageResolver;

public class ResourceBundleMessageResolver
implements MessageResolver {
    private static final Log LOG = Log.getLog(ResourceBundleMessageResolver.class);
    public static final ResourceBundleMessageResolver INSTANCE = new ResourceBundleMessageResolver();
    protected static final Locale ROOT_LOCALE = new Locale("", "", "");
    private BundlesAndKeys bundlesAndKeys = new BundlesAndKeys();
    private final Object writeLock = new Object();

    protected void addMessageBundle(BundlesAndKeys context, ResourceBundle bundle, Locale locale) {
        Set bundlesOfLocale = (Set)context.bundlesOfLocales.get(locale);
        if (bundlesOfLocale == null) {
            bundlesOfLocale = Validator.getCollectionFactory().createSet();
            context.bundlesOfLocales.put(locale, bundlesOfLocale);
        }
        if (bundlesOfLocale.contains(bundle)) {
            return;
        }
        bundlesOfLocale.add(bundle);
        Set keys = Validator.getCollectionFactory().createSet();
        Enumeration<String> keysEnum = bundle.getKeys();
        while (keysEnum.hasMoreElements()) {
            keys.add(keysEnum.nextElement());
        }
        context.keysOfBundles.put(bundle, keys);
    }

    public boolean addMessageBundle(ResourceBundle bundle) {
        Assert.argumentNotNull("bundle", bundle);
        return this.addMessageBundle(bundle, bundle.getLocale());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean addMessageBundle(ResourceBundle bundle, Locale locale) {
        Object object = this.writeLock;
        synchronized (object) {
            Set bundlesOfLocale;
            block7: {
                bundlesOfLocale = (Set)this.bundlesAndKeys.bundlesOfLocales.get(locale);
                if (bundlesOfLocale == null || !bundlesOfLocale.contains(bundle)) break block7;
                return false;
            }
            BundlesAndKeys copy = this.bundlesAndKeys.clone();
            bundlesOfLocale = (Set)copy.bundlesOfLocales.get(locale);
            if (bundlesOfLocale == null) {
                bundlesOfLocale = Validator.getCollectionFactory().createSet();
                copy.bundlesOfLocales.put(locale, bundlesOfLocale);
                try {
                    this.addMessageBundle(copy, ResourceBundle.getBundle("net/sf/oval/Messages", locale), locale);
                }
                catch (MissingResourceException ex) {
                    LOG.debug("No message bundle net.sf.oval.Messages for locale [%s] found.", (Object)ex, locale);
                }
            }
            this.addMessageBundle(copy, bundle, locale);
            this.bundlesAndKeys = copy;
        }
        return true;
    }

    public String getMessage(String key) {
        Locale currentLocale = Validator.getLocaleProvider().getLocale();
        String msg = this.getMessage(key, currentLocale);
        if (msg != null) {
            return msg;
        }
        Locale defaultLocale = Locale.getDefault();
        if (!currentLocale.equals(defaultLocale)) {
            return this.getMessage(key, defaultLocale);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getMessage(String key, Locale locale) {
        BundlesAndKeys context = this.bundlesAndKeys;
        Set bundlesOfLocale = (Set)context.bundlesOfLocales.get(locale);
        if (bundlesOfLocale == null) {
            Object object = this.writeLock;
            synchronized (object) {
                bundlesOfLocale = (Set)this.bundlesAndKeys.bundlesOfLocales.get(locale);
                if (bundlesOfLocale == null) {
                    BundlesAndKeys copy = this.bundlesAndKeys.clone();
                    bundlesOfLocale = Validator.getCollectionFactory().createSet();
                    copy.bundlesOfLocales.put(locale, bundlesOfLocale);
                    try {
                        this.addMessageBundle(copy, ResourceBundle.getBundle("net/sf/oval/Messages", locale), locale);
                    }
                    catch (MissingResourceException ex) {
                        LOG.debug("No message bundle net.sf.oval.Messages for locale [%s] found.", (Object)ex, locale);
                    }
                    this.bundlesAndKeys = copy;
                }
                context = this.bundlesAndKeys;
            }
        }
        for (ResourceBundle bundle : bundlesOfLocale) {
            Set keys = (Set)context.keysOfBundles.get(bundle);
            if (!keys.contains(key)) continue;
            return bundle.getString(key);
        }
        if (locale.getCountry().length() > 0) {
            return this.getMessage(key, new Locale(locale.getLanguage(), "", ""));
        }
        if (locale.getLanguage().length() > 0) {
            return this.getMessage(key, ROOT_LOCALE);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeMessageBundle(ResourceBundle bundle) {
        Assert.argumentNotNull("bundle", bundle);
        Locale bundleLocale = bundle.getLocale();
        Object object = this.writeLock;
        synchronized (object) {
            block4: {
                Set bundlesOfLocale = (Set)this.bundlesAndKeys.bundlesOfLocales.get(bundleLocale);
                if (bundlesOfLocale != null && bundlesOfLocale.contains(bundle)) break block4;
                return false;
            }
            BundlesAndKeys copy = this.bundlesAndKeys.clone();
            ((Set)copy.bundlesOfLocales.get(bundleLocale)).remove(bundle);
            copy.keysOfBundles.remove(bundle);
            this.bundlesAndKeys = copy;
        }
        return true;
    }

    private static class BundlesAndKeys {
        private final Map<Locale, Set<ResourceBundle>> bundlesOfLocales = Validator.getCollectionFactory().createMap(8);
        private final Map<ResourceBundle, Set<String>> keysOfBundles = Validator.getCollectionFactory().createMap(8);

        private BundlesAndKeys() {
        }

        public BundlesAndKeys clone() {
            BundlesAndKeys clone = new BundlesAndKeys();
            for (Map.Entry<Locale, Set<ResourceBundle>> entry : this.bundlesOfLocales.entrySet()) {
                Set keys = Validator.getCollectionFactory().createSet();
                keys.addAll((Collection)entry.getValue());
                clone.bundlesOfLocales.put(entry.getKey(), keys);
            }
            clone.keysOfBundles.putAll(this.keysOfBundles);
            return clone;
        }
    }
}

