/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.request.freemarker.render;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tiles.request.Request;
import org.apache.tiles.request.freemarker.FreemarkerRequestException;
import org.apache.tiles.request.freemarker.render.AttributeValueFreemarkerServlet;
import org.apache.tiles.request.render.CannotRenderException;
import org.apache.tiles.request.render.Renderer;
import org.apache.tiles.request.servlet.ExternalWriterHttpServletResponse;
import org.apache.tiles.request.servlet.ServletRequest;
import org.apache.tiles.request.servlet.ServletUtil;

public class FreemarkerRenderer
implements Renderer {
    private AttributeValueFreemarkerServlet servlet;

    public FreemarkerRenderer(AttributeValueFreemarkerServlet servlet) {
        this.servlet = servlet;
    }

    public void render(String path, Request request) throws IOException {
        if (path == null) {
            throw new CannotRenderException("Cannot dispatch a null path");
        }
        ServletRequest servletRequest = ServletUtil.getServletRequest((Request)request);
        HttpServletRequest httpRequest = servletRequest.getRequest();
        HttpServletResponse httpResponse = servletRequest.getResponse();
        this.servlet.setValue(path);
        try {
            this.servlet.doGet(httpRequest, (HttpServletResponse)new ExternalWriterHttpServletResponse(httpResponse, request.getPrintWriter()));
        }
        catch (ServletException e) {
            throw new FreemarkerRequestException("Exception when rendering a FreeMarker attribute", e);
        }
    }

    public boolean isRenderable(String path, Request request) {
        return path != null && path.startsWith("/") && path.endsWith(".ftl");
    }
}

