/*
 * Decompiled with CFR 0.152.
 */
package uk.ltd.getahead.dwr.convert;

import uk.ltd.getahead.dwr.ConversionException;
import uk.ltd.getahead.dwr.Converter;
import uk.ltd.getahead.dwr.ConverterManager;
import uk.ltd.getahead.dwr.InboundContext;
import uk.ltd.getahead.dwr.InboundVariable;
import uk.ltd.getahead.dwr.Messages;
import uk.ltd.getahead.dwr.OutboundContext;
import uk.ltd.getahead.dwr.compat.BaseV10Converter;
import uk.ltd.getahead.dwr.util.JavascriptUtil;
import uk.ltd.getahead.dwr.util.LocalUtil;

public class PrimitiveConverter
extends BaseV10Converter
implements Converter {
    private JavascriptUtil jsutil = new JavascriptUtil();
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;

    public void setConverterManager(ConverterManager config) {
    }

    public Object convertInbound(Class paramType, InboundVariable iv, InboundContext inctx) throws ConversionException {
        String value = iv.getValue();
        try {
            if (paramType == Boolean.TYPE || paramType == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = PrimitiveConverter.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                return Boolean.valueOf(value.trim());
            }
            if (paramType == Byte.TYPE || paramType == (class$java$lang$Byte == null ? (class$java$lang$Byte = PrimitiveConverter.class$("java.lang.Byte")) : class$java$lang$Byte)) {
                if (value.length() == 0) {
                    byte b = 0;
                    return new Byte(b);
                }
                return new Byte(value.trim());
            }
            if (paramType == Short.TYPE || paramType == (class$java$lang$Short == null ? (class$java$lang$Short = PrimitiveConverter.class$("java.lang.Short")) : class$java$lang$Short)) {
                if (value.length() == 0) {
                    short s = 0;
                    return new Short(s);
                }
                return new Short(value.trim());
            }
            if (paramType == Character.TYPE || paramType == (class$java$lang$Character == null ? (class$java$lang$Character = PrimitiveConverter.class$("java.lang.Character")) : class$java$lang$Character)) {
                String decode = LocalUtil.decode(value);
                if (decode.length() == 1) {
                    return new Character(decode.charAt(0));
                }
                throw new ConversionException(Messages.getString("PrimitiveConverter.StringTooLong", value));
            }
            if (paramType == Integer.TYPE || paramType == (class$java$lang$Integer == null ? (class$java$lang$Integer = PrimitiveConverter.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                if (value.length() == 0) {
                    return new Integer(0);
                }
                return new Integer(value.trim());
            }
            if (paramType == Long.TYPE || paramType == (class$java$lang$Long == null ? (class$java$lang$Long = PrimitiveConverter.class$("java.lang.Long")) : class$java$lang$Long)) {
                if (value.length() == 0) {
                    return new Long(0L);
                }
                return new Long(value.trim());
            }
            if (paramType == Float.TYPE || paramType == (class$java$lang$Float == null ? (class$java$lang$Float = PrimitiveConverter.class$("java.lang.Float")) : class$java$lang$Float)) {
                if (value.length() == 0) {
                    return new Float(0.0f);
                }
                return new Float(LocalUtil.decode(value.trim()));
            }
            if (paramType == Double.TYPE || paramType == (class$java$lang$Double == null ? (class$java$lang$Double = PrimitiveConverter.class$("java.lang.Double")) : class$java$lang$Double)) {
                if (value.length() == 0) {
                    return new Double(0.0);
                }
                return new Double(LocalUtil.decode(value.trim()));
            }
            throw new ConversionException(Messages.getString("PrimitiveConverter.TypeNotPrimitive", paramType.getName()));
        }
        catch (NumberFormatException ex) {
            throw new ConversionException(Messages.getString("PrimitiveConverter.FormatError", value, paramType.getName()), ex);
        }
    }

    public String convertOutbound(Object object, String varname, OutboundContext outctx) {
        Class<?> paramType = object.getClass();
        if (object.equals(Boolean.TRUE)) {
            return "var " + varname + "=true;";
        }
        if (object.equals(Boolean.FALSE)) {
            return "var " + varname + "=false;";
        }
        if (paramType == (class$java$lang$Character == null ? (class$java$lang$Character = PrimitiveConverter.class$("java.lang.Character")) : class$java$lang$Character)) {
            return "var " + varname + "=\"" + this.jsutil.escapeJavaScript(object.toString()) + "\";";
        }
        return "var " + varname + '=' + object.toString() + ';';
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

