/*
 * Decompiled with CFR 0.152.
 */
package uk.ltd.getahead.dwr.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import uk.ltd.getahead.dwr.Creator;
import uk.ltd.getahead.dwr.CreatorManager;
import uk.ltd.getahead.dwr.Messages;
import uk.ltd.getahead.dwr.util.LocalUtil;
import uk.ltd.getahead.dwr.util.Logger;

public class DefaultCreatorManager
implements CreatorManager {
    private static final Logger log = Logger.getLogger(class$uk$ltd$getahead$dwr$impl$DefaultCreatorManager == null ? (class$uk$ltd$getahead$dwr$impl$DefaultCreatorManager = DefaultCreatorManager.class$("uk.ltd.getahead.dwr.impl.DefaultCreatorManager")) : class$uk$ltd$getahead$dwr$impl$DefaultCreatorManager);
    private Map creatorTypes = new HashMap();
    private Map creators = new HashMap();
    private boolean debug = false;
    static /* synthetic */ Class class$uk$ltd$getahead$dwr$Creator;
    static /* synthetic */ Class class$uk$ltd$getahead$dwr$impl$DefaultCreatorManager;

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void addCreatorType(String typeName, Class clazz) {
        if (!(class$uk$ltd$getahead$dwr$Creator == null ? (class$uk$ltd$getahead$dwr$Creator = DefaultCreatorManager.class$("uk.ltd.getahead.dwr.Creator")) : class$uk$ltd$getahead$dwr$Creator).isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(Messages.getString("DefaultCreatorManager.CreatorNotAssignable", clazz.getName(), (class$uk$ltd$getahead$dwr$Creator == null ? (class$uk$ltd$getahead$dwr$Creator = DefaultCreatorManager.class$("uk.ltd.getahead.dwr.Creator")) : class$uk$ltd$getahead$dwr$Creator).getName()));
        }
        try {
            clazz.newInstance();
        }
        catch (InstantiationException ex) {
            throw new IllegalArgumentException(Messages.getString("DefaultCreatorManager.CreatorNotInstantiatable", clazz.getName(), ex.toString()));
        }
        catch (IllegalAccessException ex) {
            throw new IllegalArgumentException(Messages.getString("DefaultCreatorManager.CreatorNotAccessable", clazz.getName(), ex.toString()));
        }
        this.creatorTypes.put(typeName, clazz);
    }

    public void addCreator(String typeName, String scriptName, Map params) throws InstantiationException, IllegalAccessException, IllegalArgumentException {
        Class clazz = (Class)this.creatorTypes.get(typeName);
        if (clazz == null) {
            log.error("Missing creator: " + typeName + " (while initializing creator for: " + scriptName + ".js)");
            return;
        }
        Creator creator = (Creator)clazz.newInstance();
        Iterator it = params.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            try {
                LocalUtil.setProperty(creator, key, value);
            }
            catch (NoSuchMethodException ex) {
                if (key.equals("creator") || key.equals("class")) continue;
                log.debug("No property '" + key + "' on " + creator.getClass().getName());
            }
            catch (InvocationTargetException ex) {
                log.warn("Error setting " + key + "=" + value + " on " + creator.getClass().getName(), ex.getTargetException());
            }
            catch (Exception ex) {
                log.warn("Error setting " + key + "=" + value + " on " + creator.getClass().getName(), ex);
            }
        }
        creator.setProperties(params);
        this.addCreator(scriptName, creator);
    }

    public void addCreator(String scriptName, Creator creator) throws IllegalArgumentException {
        Creator other = (Creator)this.creators.get(scriptName);
        if (other != null) {
            throw new IllegalArgumentException(Messages.getString("DefaultCreatorManager.DuplicateName", scriptName, other.getType().getName(), creator));
        }
        try {
            Class test = creator.getType();
            if (test == null) {
                log.error("Creator: '" + creator + "' for " + scriptName + ".js is returning null for type queries.");
            } else {
                this.creators.put(scriptName, creator);
            }
        }
        catch (NoClassDefFoundError ex) {
            log.error("Missing class for creator '" + creator + "'. Cause: " + ex.getMessage());
        }
        catch (Exception ex) {
            log.error("Error loading class for creator '" + creator + "'.", ex);
        }
    }

    public Collection getCreatorNames() throws SecurityException {
        if (!this.debug) {
            throw new SecurityException();
        }
        return Collections.unmodifiableSet(this.creators.keySet());
    }

    public Creator getCreator(String scriptName) throws SecurityException {
        Creator creator = (Creator)this.creators.get(scriptName);
        if (creator == null) {
            StringBuffer buffer = new StringBuffer("Names of known classes are: ");
            Iterator it = this.creators.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                buffer.append(key);
                buffer.append(' ');
            }
            log.warn(buffer.toString());
            throw new SecurityException(Messages.getString("DefaultCreatorManager.MissingName", scriptName));
        }
        return creator;
    }

    public void setCreators(Map creators) {
        this.creators = creators;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

