/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.config.providers;

import com.opensymphony.xwork2.config.providers.ValueSubstitutor;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EnvsValueSubstitutor
implements ValueSubstitutor {
    private static final Logger LOG = LogManager.getLogger(EnvsValueSubstitutor.class);
    protected StrSubstitutor strSubstitutor = new StrSubstitutor(System.getenv());

    public EnvsValueSubstitutor() {
        this.strSubstitutor.setVariablePrefix("${env.");
        this.strSubstitutor.setVariableSuffix('}');
        this.strSubstitutor.setValueDelimiter(":");
    }

    @Override
    public String substitute(String value) {
        LOG.debug("Substituting value {} with proper System variable or environment variable", (Object)value);
        String substituted = StrSubstitutor.replaceSystemProperties((Object)value);
        return this.strSubstitutor.replace(substituted);
    }
}

