/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.java;

import com.google.gxp.com.google.common.base.CharEscapers;
import com.google.gxp.com.google.common.base.Join;
import com.google.gxp.com.google.common.collect.Lists;
import com.google.gxp.com.google.common.collect.Sets;
import com.google.gxp.compiler.alerts.AlertSink;
import com.google.gxp.compiler.alerts.SourcePosition;
import com.google.gxp.compiler.base.AbbrExpression;
import com.google.gxp.compiler.base.AttrBundleParam;
import com.google.gxp.compiler.base.AttrBundleReference;
import com.google.gxp.compiler.base.BooleanConstant;
import com.google.gxp.compiler.base.BoundCall;
import com.google.gxp.compiler.base.Call;
import com.google.gxp.compiler.base.CallVisitor;
import com.google.gxp.compiler.base.Callable;
import com.google.gxp.compiler.base.CallableVisitor;
import com.google.gxp.compiler.base.Concatenation;
import com.google.gxp.compiler.base.Conditional;
import com.google.gxp.compiler.base.ConstructedConstant;
import com.google.gxp.compiler.base.ConvertibleToContent;
import com.google.gxp.compiler.base.DefaultingExpressionVisitor;
import com.google.gxp.compiler.base.EscapeExpression;
import com.google.gxp.compiler.base.ExampleExpression;
import com.google.gxp.compiler.base.ExceptionExpression;
import com.google.gxp.compiler.base.Expression;
import com.google.gxp.compiler.base.ExpressionVisitor;
import com.google.gxp.compiler.base.ExtractedMessage;
import com.google.gxp.compiler.base.FormalParameter;
import com.google.gxp.compiler.base.InstanceCallable;
import com.google.gxp.compiler.base.IsXmlExpression;
import com.google.gxp.compiler.base.JavaAnnotation;
import com.google.gxp.compiler.base.LoopExpression;
import com.google.gxp.compiler.base.NativeExpression;
import com.google.gxp.compiler.base.ObjectConstant;
import com.google.gxp.compiler.base.OutputLanguage;
import com.google.gxp.compiler.base.Parameter;
import com.google.gxp.compiler.base.StringConstant;
import com.google.gxp.compiler.base.Template;
import com.google.gxp.compiler.base.ThrowsDeclaration;
import com.google.gxp.compiler.base.UnboundCall;
import com.google.gxp.compiler.base.UnexpectedNodeException;
import com.google.gxp.compiler.base.ValidatedCall;
import com.google.gxp.compiler.codegen.LoopMissingBothIterableAndIteratorError;
import com.google.gxp.compiler.codegen.MissingExpressionError;
import com.google.gxp.compiler.java.BaseJavaCodeGenerator;
import com.google.gxp.compiler.java.IllegalJavaPrimitiveError;
import com.google.gxp.compiler.java.JavaUtil;
import com.google.gxp.compiler.java.NoMessageSourceError;
import com.google.gxp.compiler.msgextract.MessageExtractedTree;
import com.google.gxp.compiler.reparent.Attribute;
import com.google.gxp.compiler.schema.AttributeValidator;
import com.google.gxp.compiler.schema.ContentFamilyVisitor;
import com.google.gxp.compiler.schema.Schema;
import com.google.transconsole.common.messages.Message;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JavaCodeGenerator
extends BaseJavaCodeGenerator<MessageExtractedTree> {
    public JavaCodeGenerator(MessageExtractedTree tree, String runtimeMessageSource) {
        super(tree, runtimeMessageSource);
    }

    @Override
    protected TemplateWorker createTemplateWorker(Appendable appendable, AlertSink alertSink, Template template, String runtimeMessageSource) {
        return new TemplateWorker(appendable, alertSink, template, runtimeMessageSource);
    }

    protected static class TemplateWorker
    extends BaseJavaCodeGenerator.TemplateWorker {
        private int varCounter = 0;
        private final String runtimeMessageSource;
        protected final Set<Schema> anonymousSchemas = Sets.newTreeSet();
        private static final int MAX_JAVA_STRING_LENGTH = 65534;
        private final StatementVisitor statementVisitor = this.getStatementVisitor();
        private final ExpressionVisitor<String> toExpressionVisitor = new ToExpressionVisitor();
        private final ExpressionVisitor<String> toEscapableExpressionVisitor = this.getToEscapableExpressionVisitor();
        protected final Deque<String> instantiatedGxps = new ArrayDeque<String>();

        TemplateWorker(Appendable appendable, AlertSink alertSink, Template template, String runtimeMessageSource) {
            super(appendable, alertSink, template);
            this.runtimeMessageSource = runtimeMessageSource;
        }

        public TemplateWorker createSubWorker(Appendable newAppendable) {
            return new TemplateWorker(newAppendable, this.alertSink, this.template, this.runtimeMessageSource);
        }

        protected final String createVarName(String token) {
            return "gxp$" + token + "$" + this.varCounter++;
        }

        @Override
        protected String getBaseClassName() {
            return "com.google.gxp.base.GxpTemplate";
        }

        @Override
        protected void appendClass() {
            this.appendAnnotations(this.template.getJavaAnnotations(JavaAnnotation.Element.CLASS));
            this.appendClassDecl();
            this.appendLine();
            if (this.runtimeMessageSource != null) {
                this.formatLine("private static final String GXP$MESSAGE_SOURCE = %s;", OutputLanguage.JAVA.toStringLiteral(this.runtimeMessageSource));
                this.appendLine();
            }
            this.appendWriteMethod();
            this.appendDefaultAccessors();
            this.appendParamConstructors();
            this.appendAnonymousInterfaces();
            this.appendGetArgListMethod();
            this.appendGetGxpClosureMethod(true);
            this.appendInterface();
            this.appendInstance();
            this.appendLine("}");
        }

        protected void appendClassDecl() {
            this.formatLine(this.template.getSourcePosition(), "public class %s extends %s {", this.getClassName(this.template.getName()), this.getBaseClassName());
        }

        private String getAnonymousJavaType(Schema schema) {
            return "Anonymous" + this.getBaseName(schema.getJavaType());
        }

        private void appendAnonymousInterfaces() {
            for (Schema schema : this.anonymousSchemas) {
                this.appendLine();
                this.appendLine("private abstract static class " + this.getAnonymousJavaType(schema));
                this.appendLine("    extends GxpTemplate.AnonymousGxpClosure");
                this.appendLine("    implements " + schema.getJavaType() + " {");
                this.appendLine("}");
            }
        }

        private void appendDefaultAccessors() {
            for (Parameter param : this.template.getAllParameters()) {
                Expression defaultValue = param.getDefaultValue();
                if (defaultValue == null) continue;
                String paramType = this.toJavaType(param.getType());
                this.appendLine();
                this.formatLine(param.getDefaultValue().getSourcePosition(), "private static final %s GXP_DEFAULT$%s = %s;", paramType, param.getPrimaryName(), this.getJavaExpression(param.getDefaultValue()));
                this.appendLine();
                String methodName = JavaCodeGenerator.getDefaultMethodName(param);
                this.formatLine("public static %s %s() {", paramType, methodName);
                this.formatLine("return GXP_DEFAULT$%s;", param.getPrimaryName());
                this.appendLine("}");
            }
        }

        private void appendParamConstructors() {
            for (Parameter param : this.template.getParameters()) {
                if (param.getConstructor() == null) continue;
                this.appendLine();
                this.formatLine(param.getSourcePosition(), "public static %s %s(String %s) {", this.toJavaType(param.getType()), JavaCodeGenerator.getConstructorMethodName(param), param.getPrimaryName());
                this.appendLine(param.getSourcePosition(), "return " + param.getConstructor().acceptVisitor(this.toExpressionVisitor) + ";");
                this.appendLine("}");
            }
        }

        private List<String> getCallArguments(Callable callee, Map<String, Attribute> callerAttrs) {
            ArrayList<String> fParams = Lists.newArrayList();
            String calleeName = this.getCalleeName(callee);
            for (FormalParameter parameter : callee.getParameters()) {
                String defaultFetchString;
                String paramName = parameter.getPrimaryName();
                if ("this".equals(paramName)) continue;
                Attribute value = callerAttrs.get(paramName);
                String string = defaultFetchString = parameter.getType().getDefaultValue() == null ? calleeName + "." + JavaCodeGenerator.getDefaultMethodName(parameter) + "()" : this.getJavaExpression(parameter.getType().getDefaultValue());
                if (value == null) {
                    fParams.add(defaultFetchString);
                    continue;
                }
                if (value.getCondition() != null) {
                    String s = "(" + this.getJavaExpression(value.getCondition()) + " ? " + this.getJavaExpression(value.getValue()) + " : " + defaultFetchString + ")";
                    fParams.add(s);
                    continue;
                }
                fParams.add(this.getJavaExpression(value.getValue()));
            }
            return fParams;
        }

        @Override
        protected void appendWriteMethodBody() {
            this.appendLine("final java.util.Locale gxp_locale = gxp_context.getLocale();");
            List<ThrowsDeclaration> throwsDecls = this.template.getThrowsDeclarations();
            if (!throwsDecls.isEmpty()) {
                this.appendLine("try {");
            }
            this.template.getContent().acceptVisitor(this.statementVisitor);
            if (!throwsDecls.isEmpty()) {
                String runtimeExceptionVar = this.createVarName("runtimeException");
                String causeVar = this.createVarName("cause");
                this.formatLine("} catch (com.google.gxp.base.GxpRuntimeException %s) {", runtimeExceptionVar);
                this.formatLine("final java.lang.Throwable %s = %s.getCause();", causeVar, runtimeExceptionVar);
                for (ThrowsDeclaration throwsDecl : throwsDecls) {
                    String excType = throwsDecl.getExceptionType();
                    this.formatLine(throwsDecl.getSourcePosition(), "if (%s instanceof %s) throw (%s) %s;", causeVar, excType, excType, causeVar);
                }
                this.formatLine("throw %s;", runtimeExceptionVar);
                this.appendLine("}");
            }
        }

        protected void writeExpression(SourcePosition sourcePosition, String expr) {
            this.appendLine(sourcePosition, "gxp$out.append(" + expr + ");");
        }

        protected void writeString(SourcePosition pos, String s) {
            int length = s.length();
            if (length != 0) {
                int curPos = 0;
                while (length - curPos > 65534) {
                    this.writeExpression(pos, OutputLanguage.JAVA.toStringLiteral(s.substring(curPos, curPos + 65534)));
                    curPos += 65534;
                }
                this.writeExpression(pos, OutputLanguage.JAVA.toStringLiteral(s.substring(curPos, length)));
            }
        }

        protected StatementVisitor getStatementVisitor() {
            return new StatementVisitor();
        }

        protected String getCalleeName(Callable callee) {
            return callee.acceptCallableVisitor(new CallableVisitor<String>(){

                @Override
                public String visitCallable(Callable callable) {
                    return callable.getName().toString();
                }

                @Override
                public String visitInstanceCallable(InstanceCallable callable) {
                    return TemplateWorker.this.instantiatedGxps.peek();
                }
            });
        }

        protected final String getJavaExpression(Expression value) {
            return value.acceptVisitor(this.toExpressionVisitor);
        }

        protected final String getEscapedString(Expression value) {
            StringBuilder sb = new StringBuilder(value.getSchema().getJavaAppender());
            sb.append(".INSTANCE.append(new java.lang.StringBuilder(), ");
            sb.append("gxp_context");
            sb.append(", ");
            sb.append(this.getJavaExpression(value));
            sb.append(").toString()");
            return sb.toString();
        }

        private String getEscapableExpression(Expression value) {
            return value.acceptVisitor(this.toEscapableExpressionVisitor);
        }

        protected ToEscapableExpressionVisitor getToEscapableExpressionVisitor() {
            return new ToEscapableExpressionVisitor();
        }

        private String toAnonymousClosure(Expression value) {
            StringBuilder sb = new StringBuilder();
            TemplateWorker subWorker = this.createSubWorker(sb);
            subWorker.toAnonymousClosureImpl(value);
            this.anonymousSchemas.addAll(subWorker.anonymousSchemas);
            sb.append("}");
            return sb.toString();
        }

        private void toAnonymousClosureImpl(Expression value) {
            this.anonymousSchemas.add(value.getSchema());
            this.appendLine(value.getSourcePosition(), "new " + this.getAnonymousJavaType(value.getSchema()) + "() {");
            StringBuilder sb = new StringBuilder();
            TemplateWorker.appendJavaThrowsDeclaration(sb, this.template.getThrowsDeclarations());
            this.formatLine(value.getSourcePosition(), "protected void writeImpl(%s) %s {", GXP_SIG, sb.toString());
            value.acceptVisitor(this.statementVisitor);
            this.appendLine("}");
        }

        private class ToExpressionVisitor
        extends DefaultingExpressionVisitor<String>
        implements CallVisitor<String> {
            private ContentFamilyVisitor<StringConstant, String> STRING_CONSTANT_VISITOR = new ContentFamilyVisitor<StringConstant, String>(){

                @Override
                public String visitCss(StringConstant value) {
                    return TemplateWorker.this.toAnonymousClosure(value);
                }

                @Override
                public String visitJavaScript(StringConstant value) {
                    return TemplateWorker.this.toAnonymousClosure(value);
                }

                @Override
                public String visitMarkup(StringConstant value) {
                    return TemplateWorker.this.toAnonymousClosure(value);
                }

                @Override
                public String visitPlaintext(StringConstant value) {
                    String s = CharEscapers.javaStringEscaper().escape(value.evaluate());
                    return "\"" + s + "\"";
                }
            };

            private ToExpressionVisitor() {
            }

            @Override
            public String defaultVisitExpression(Expression value) {
                throw new UnexpectedNodeException(value);
            }

            @Override
            public String visitAttrBundleParam(AttrBundleParam bundle) {
                if (bundle.getIncludeAttrs().isEmpty() && bundle.getAttrs().isEmpty() && bundle.getSubBundles().size() == 1) {
                    return bundle.getSubBundles().get(0);
                }
                StringBuilder sb = new StringBuilder("new GxpAttrBundle.Builder<");
                sb.append(bundle.getSchema().getJavaType());
                sb.append(">(");
                ArrayList<String> includeAttrs = Lists.newArrayList();
                for (String string : bundle.getIncludeAttrs()) {
                    includeAttrs.add(OutputLanguage.JAVA.toStringLiteral(string));
                }
                Join.join(sb, ", ", includeAttrs);
                sb.append(')');
                for (Map.Entry entry : bundle.getAttrs().entrySet()) {
                    AttributeValidator validator = (AttributeValidator)entry.getKey();
                    Expression condition = ((Attribute)entry.getValue()).getCondition();
                    Expression value = ((Attribute)entry.getValue()).getValue();
                    sb.append(".attr(");
                    sb.append(OutputLanguage.JAVA.toStringLiteral(validator.getName()));
                    sb.append(", ");
                    sb.append(validator.isFlagSet(AttributeValidator.Flag.BOOLEAN) ? value.acceptVisitor(this) : TemplateWorker.this.toAnonymousClosure(value));
                    if (condition != null) {
                        sb.append(", ");
                        sb.append(condition.acceptVisitor(this));
                    }
                    sb.append(")");
                }
                for (String string : bundle.getSubBundles()) {
                    sb.append(".addBundle(");
                    sb.append(string);
                    sb.append(")");
                }
                sb.append(".build()");
                return sb.toString();
            }

            @Override
            public String visitBooleanConstant(BooleanConstant value) {
                return value.getValue().toString();
            }

            @Override
            public String visitStringConstant(StringConstant value) {
                if (value.getSchema() == null) {
                    throw new AssertionError();
                }
                return value.getSchema().getContentFamily().acceptVisitor(this.STRING_CONSTANT_VISITOR, value);
            }

            @Override
            public String visitObjectConstant(ObjectConstant node) {
                String value = node.getValue();
                String type = TemplateWorker.this.toJavaType(node.getType());
                if (!JavaUtil.isPrimitiveType(type)) {
                    value = type + ".valueOf(\"" + CharEscapers.javaStringEscaper().escape(value) + "\")";
                } else if (!JavaUtil.isValidPrimitive(value, type)) {
                    TemplateWorker.this.alertSink.add(new IllegalJavaPrimitiveError(node, value, type));
                }
                return value;
            }

            @Override
            public String visitConstructedConstant(ConstructedConstant node) {
                StringBuilder sb = new StringBuilder();
                sb.append(TemplateWorker.this.getCalleeName(node.getCallee()));
                sb.append(".");
                sb.append(JavaCodeGenerator.getConstructorMethodName(node.getParam()));
                sb.append("(\"");
                sb.append(node.getValue());
                sb.append("\")");
                return sb.toString();
            }

            @Override
            public String visitEscapeExpression(EscapeExpression value) {
                return value.getSubexpression().acceptVisitor(this);
            }

            @Override
            public String visitExampleExpression(ExampleExpression value) {
                return value.getSubexpression().acceptVisitor(this);
            }

            @Override
            public String visitNativeExpression(NativeExpression value) {
                return OutputLanguage.JAVA.validateExpression(TemplateWorker.this.alertSink, value);
            }

            @Override
            public String visitConvertibleToContent(ConvertibleToContent value) {
                return TemplateWorker.this.toAnonymousClosure(value);
            }

            @Override
            public String visitConcatenation(Concatenation value) {
                return TemplateWorker.this.toAnonymousClosure(value);
            }

            @Override
            public String visitConditional(Conditional value) {
                return TemplateWorker.this.toAnonymousClosure(value);
            }

            @Override
            public String visitLoopExpression(LoopExpression value) {
                return TemplateWorker.this.toAnonymousClosure(value);
            }

            @Override
            public String visitCall(Call value) {
                return value.acceptCallVisitor(this);
            }

            @Override
            public String visitBoundCall(BoundCall call) {
                throw new UnexpectedNodeException(call);
            }

            @Override
            public String visitUnboundCall(UnboundCall call) {
                throw new UnexpectedNodeException(call);
            }

            @Override
            public String visitValidatedCall(final ValidatedCall call) {
                final Callable callee = call.getCallee();
                final StringBuilder sb = new StringBuilder();
                callee.acceptCallableVisitor(new CallableVisitor<Void>(){

                    @Override
                    public Void visitCallable(Callable callable) {
                        sb.append(callee.getName().toString());
                        sb.append(".getGxpClosure(");
                        sb.append(Join.join(", ", TemplateWorker.this.getCallArguments(callee, call.getAttributes())));
                        sb.append(")");
                        return null;
                    }

                    @Override
                    public Void visitInstanceCallable(InstanceCallable callable) {
                        sb.append(TemplateWorker.this.toAnonymousClosure(call));
                        return null;
                    }
                });
                return sb.toString();
            }

            @Override
            public String visitAbbrExpression(AbbrExpression value) {
                return TemplateWorker.this.toAnonymousClosure(value);
            }

            @Override
            public String visitExtractedMessage(ExtractedMessage msg) {
                return TemplateWorker.this.toAnonymousClosure(msg);
            }

            @Override
            public String visitIsXmlExpression(IsXmlExpression ixe) {
                return "gxp_context.isUsingXmlSyntax()";
            }
        }

        protected class ToEscapableExpressionVisitor
        extends DefaultingExpressionVisitor<String>
        implements CallVisitor<String> {
            protected ToEscapableExpressionVisitor() {
            }

            @Override
            public String defaultVisitExpression(Expression value) {
                throw new UnexpectedNodeException(value);
            }

            @Override
            public String visitAttrBundleReference(AttrBundleReference value) {
                return value.getName();
            }

            @Override
            public String visitNativeExpression(NativeExpression value) {
                StringBuilder sb = new StringBuilder();
                sb.append('(');
                sb.append(OutputLanguage.JAVA.validateExpression(TemplateWorker.this.alertSink, value));
                sb.append(')');
                return sb.toString();
            }

            @Override
            public String visitEscapeExpression(EscapeExpression value) {
                StringBuilder sb = new StringBuilder();
                sb.append(value.getSchema().getJavaAppender());
                sb.append(".INSTANCE.append(new StringBuilder(), ");
                sb.append("gxp_context");
                sb.append(", ");
                sb.append(TemplateWorker.this.getEscapableExpression(value.getSubexpression()));
                sb.append(")");
                return sb.toString();
            }

            @Override
            public String visitExtractedMessage(ExtractedMessage msg) {
                if (TemplateWorker.this.runtimeMessageSource == null) {
                    TemplateWorker.this.alertSink.add(new NoMessageSourceError(msg));
                }
                Message tcMessage = msg.getTcMessage();
                StringBuilder sb = new StringBuilder("GxpTemplate.getMessage(GXP$MESSAGE_SOURCE, ");
                sb.append("gxp_context.getLocale(), ");
                sb.append(String.format("/* \"%s\" */ ", CharEscapers.javaStringUnicodeEscaper().escape(tcMessage.getOriginal().replace("\n", " ").replace("\\*/", "*/"))));
                sb.append(tcMessage.getId());
                sb.append("L");
                for (Expression param : msg.getParameters()) {
                    sb.append(", ");
                    sb.append(TemplateWorker.this.getEscapedString(param));
                }
                sb.append(")");
                return sb.toString();
            }

            @Override
            public String visitCall(Call call) {
                return call.acceptCallVisitor(this);
            }

            @Override
            public String visitBoundCall(BoundCall call) {
                throw new UnexpectedNodeException(call);
            }

            @Override
            public String visitUnboundCall(UnboundCall call) {
                throw new UnexpectedNodeException(call);
            }

            @Override
            public String visitValidatedCall(ValidatedCall call) {
                StringBuilder sb = new StringBuilder("gxp_context");
                sb.append(".getString(");
                sb.append(TemplateWorker.this.getJavaExpression(call));
                sb.append(")");
                return sb.toString();
            }
        }

        protected class StatementVisitor
        extends DefaultingExpressionVisitor<Void>
        implements CallVisitor<Void> {
            protected StatementVisitor() {
            }

            @Override
            public Void defaultVisitExpression(Expression node) {
                throw new UnexpectedNodeException(node);
            }

            @Override
            public Void visitExceptionExpression(ExceptionExpression value) {
                String excClass;
                switch (value.getKind()) {
                    case NOT_SUPPORTED_IN_SGML_MODE: {
                        excClass = "java.lang.IllegalStateException";
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unsupported ExceptionExpression.Kind: " + (Object)((Object)value.getKind())));
                    }
                }
                TemplateWorker.this.appendLine(value.getSourcePosition(), "throw new " + excClass + "(" + OutputLanguage.JAVA.toStringLiteral(value.getMessage()) + ");");
                return null;
            }

            @Override
            public Void visitStringConstant(StringConstant value) {
                if (value.getSchema() == null) {
                    throw new AssertionError();
                }
                TemplateWorker.this.writeString(value.getSourcePosition(), value.evaluate());
                return null;
            }

            @Override
            public Void visitEscapeExpression(EscapeExpression value) {
                TemplateWorker.this.formatLine(value.getSourcePosition(), "%s.INSTANCE.append(%s, %s, %s);", new Object[]{value.getSchema().getJavaAppender(), "gxp$out", "gxp_context", TemplateWorker.this.getEscapableExpression(value.getSubexpression())});
                return null;
            }

            @Override
            public Void visitExampleExpression(ExampleExpression value) {
                return value.getSubexpression().acceptVisitor(this);
            }

            @Override
            public Void visitConvertibleToContent(ConvertibleToContent value) {
                value.getSubexpression().acceptVisitor(this);
                return null;
            }

            @Override
            public Void visitConcatenation(Concatenation value) {
                for (Expression subValue : value.getValues()) {
                    subValue.acceptVisitor(this);
                }
                return null;
            }

            @Override
            public Void visitConditional(Conditional value) {
                Iterator<Conditional.Clause> clauses = value.getClauses().iterator();
                if (clauses.hasNext()) {
                    this.appendIf("if (", clauses.next());
                    while (clauses.hasNext()) {
                        this.appendIf("} else if (", clauses.next());
                    }
                    Expression elseExpression = value.getElseExpression();
                    if (!elseExpression.alwaysEmpty()) {
                        TemplateWorker.this.appendLine("} else {");
                        elseExpression.acceptVisitor(this);
                    }
                } else {
                    throw new AssertionError((Object)"No clauses in Conditional!");
                }
                TemplateWorker.this.appendLine("}");
                return null;
            }

            private void appendIf(String prefix, Conditional.Clause clause) {
                Expression predicate = clause.getPredicate();
                TemplateWorker.this.appendLine(predicate.getSourcePosition(), prefix + TemplateWorker.this.getJavaExpression(predicate) + ") {");
                clause.getExpression().acceptVisitor(this);
            }

            private void writeConditionalDelim(Expression delimiter, String boolVar) {
                if (!delimiter.alwaysEmpty()) {
                    TemplateWorker.this.formatLine("if (%s) {", new Object[]{boolVar});
                    delimiter.acceptVisitor(this);
                    TemplateWorker.this.appendLine("} else {");
                    TemplateWorker.this.formatLine("%s = true;", new Object[]{boolVar});
                    TemplateWorker.this.appendLine("}");
                }
            }

            @Override
            public Void visitLoopExpression(LoopExpression loop) {
                TemplateWorker.this.appendLine("{");
                Expression delimiter = loop.getDelimiter();
                String boolVar = TemplateWorker.this.createVarName("bool");
                if (!delimiter.alwaysEmpty()) {
                    TemplateWorker.this.formatLine("boolean %s = false;", new Object[]{boolVar});
                }
                String tmpKeyVar = null;
                String keyVar = null;
                if (loop.getKey() != null) {
                    tmpKeyVar = TemplateWorker.this.createVarName("key");
                    keyVar = OutputLanguage.JAVA.validateName(TemplateWorker.this.alertSink, loop, loop.getKey());
                    TemplateWorker.this.formatLine("int %s = 0;", new Object[]{tmpKeyVar});
                }
                if (loop.getIterator() != null && loop.getIterator().canEvaluateAs(OutputLanguage.JAVA)) {
                    String iterVar = TemplateWorker.this.createVarName("iter");
                    Expression iter = loop.getIterator();
                    TemplateWorker.this.formatLine(iter.getSourcePosition(), "final java.util.Iterator<? extends %s> %s = %s;", new Object[]{JavaUtil.toReferenceType(TemplateWorker.this.toJavaType(loop.getType())), iterVar, TemplateWorker.this.getJavaExpression(iter)});
                    TemplateWorker.this.formatLine(loop.getSourcePosition(), "while (%s.hasNext()) {", new Object[]{iterVar});
                    String itemExpr = JavaUtil.unbox(iterVar + ".next()", TemplateWorker.this.toJavaType(loop.getType()));
                    TemplateWorker.this.formatLine(loop.getType().getSourcePosition(), "final %s %s = %s;", new Object[]{TemplateWorker.this.toJavaType(loop.getType()), OutputLanguage.JAVA.validateName(TemplateWorker.this.alertSink, loop, loop.getVar()), itemExpr});
                    this.writeConditionalDelim(delimiter, boolVar);
                    if (keyVar != null) {
                        TemplateWorker.this.formatLine("final int %s = %s++;", new Object[]{keyVar, tmpKeyVar});
                    }
                    loop.getSubexpression().acceptVisitor(this);
                    TemplateWorker.this.appendLine("}");
                } else if (loop.getIterable() != null && loop.getIterable().canEvaluateAs(OutputLanguage.JAVA)) {
                    TemplateWorker.this.formatLine(loop.getSourcePosition(), "for (final %s %s : %s) {", new Object[]{TemplateWorker.this.toJavaType(loop.getType()), OutputLanguage.JAVA.validateName(TemplateWorker.this.alertSink, loop, loop.getVar()), TemplateWorker.this.getJavaExpression(loop.getIterable())});
                    this.writeConditionalDelim(delimiter, boolVar);
                    if (keyVar != null) {
                        TemplateWorker.this.formatLine("final int %s = %s++;", new Object[]{keyVar, tmpKeyVar});
                    }
                    loop.getSubexpression().acceptVisitor(this);
                    TemplateWorker.this.appendLine("}");
                } else if (loop.getIterable() == null && loop.getIterator() != null) {
                    TemplateWorker.this.alertSink.add(new MissingExpressionError(loop.getIterator(), OutputLanguage.JAVA));
                } else if (loop.getIterator() == null && loop.getIterable() != null) {
                    TemplateWorker.this.alertSink.add(new MissingExpressionError(loop.getIterable(), OutputLanguage.JAVA));
                } else {
                    TemplateWorker.this.alertSink.add(new LoopMissingBothIterableAndIteratorError(loop, OutputLanguage.JAVA));
                }
                TemplateWorker.this.appendLine("}");
                return null;
            }

            @Override
            public Void visitAbbrExpression(AbbrExpression abbr) {
                TemplateWorker.this.appendLine("{");
                TemplateWorker.this.formatLine(abbr.getSourcePosition(), "final %s %s = %s;", new Object[]{TemplateWorker.this.toJavaType(abbr.getType()), OutputLanguage.JAVA.validateName(TemplateWorker.this.alertSink, abbr, abbr.getName()), TemplateWorker.this.getJavaExpression(abbr.getValue())});
                abbr.getContent().acceptVisitor(this);
                TemplateWorker.this.appendLine("}");
                return null;
            }

            @Override
            public Void visitCall(Call value) {
                return value.acceptCallVisitor(this);
            }

            @Override
            public Void visitUnboundCall(UnboundCall call) {
                throw new UnexpectedNodeException(call);
            }

            @Override
            public Void visitBoundCall(BoundCall call) {
                throw new UnexpectedNodeException(call);
            }

            @Override
            public Void visitValidatedCall(final ValidatedCall call) {
                Callable callee = call.getCallee();
                final Map<String, Attribute> params = call.getAttributes();
                StringBuilder sb = new StringBuilder();
                boolean isInstance = callee.acceptCallableVisitor(new CallableVisitor<Boolean>(){

                    @Override
                    public Boolean visitCallable(Callable callable) {
                        return false;
                    }

                    @Override
                    public Boolean visitInstanceCallable(InstanceCallable callable) {
                        TemplateWorker.this.instantiatedGxps.push(TemplateWorker.this.createVarName("inst"));
                        Attribute thisAttr = (Attribute)params.get("this");
                        TemplateWorker.this.appendLine("{");
                        if (thisAttr != null) {
                            TemplateWorker.this.formatLine(call.getSourcePosition(), "%s %s = %s;", new Object[]{TemplateWorker.this.toJavaType(callable.getInstanceType()), TemplateWorker.this.instantiatedGxps.peek(), thisAttr.getValue().acceptVisitor(TemplateWorker.this.toExpressionVisitor)});
                        }
                        return true;
                    }
                });
                sb.append(TemplateWorker.this.getCalleeName(callee));
                sb.append(".write(");
                sb.append("gxp$out");
                sb.append(", ");
                sb.append("gxp_context");
                for (String param : TemplateWorker.this.getCallArguments(callee, params)) {
                    sb.append(", ");
                    sb.append(param);
                }
                sb.append(");");
                TemplateWorker.this.appendLine(call.getSourcePosition(), sb);
                if (isInstance) {
                    TemplateWorker.this.instantiatedGxps.pop();
                    TemplateWorker.this.appendLine("}");
                }
                return null;
            }

            @Override
            public Void visitExtractedMessage(ExtractedMessage msg) {
                if (TemplateWorker.this.runtimeMessageSource == null) {
                    TemplateWorker.this.alertSink.add(new NoMessageSourceError(msg));
                }
                Message tcMessage = msg.getTcMessage();
                TemplateWorker.this.formatLine("// MSG %s=%s", new Object[]{tcMessage.getId(), CharEscapers.javaStringUnicodeEscaper().escape(tcMessage.getOriginal().replace("\n", " "))});
                StringBuilder sb = new StringBuilder("GxpTemplate.getMessage(GXP$MESSAGE_SOURCE, ");
                sb.append("gxp_context.getLocale(), ");
                sb.append(tcMessage.getId());
                sb.append("L");
                for (Expression param : msg.getParameters()) {
                    sb.append(", ");
                    sb.append(TemplateWorker.this.getEscapedString(param));
                }
                sb.append(")");
                String getMessage = sb.toString();
                TemplateWorker.this.writeExpression(msg.getSourcePosition(), getMessage);
                return null;
            }
        }
    }
}

