/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler;

import com.google.gxp.com.google.common.base.Charsets;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.compiler.CompilationUnit;
import com.google.gxp.compiler.alerts.AlertCounter;
import com.google.gxp.compiler.alerts.AlertPolicy;
import com.google.gxp.compiler.alerts.AlertSink;
import com.google.gxp.compiler.alerts.SourcePosition;
import com.google.gxp.compiler.alerts.common.IOError;
import com.google.gxp.compiler.alerts.common.ProgressAlert;
import com.google.gxp.compiler.base.OutputLanguage;
import com.google.gxp.compiler.codegen.CodeGenerator;
import com.google.gxp.compiler.codegen.CodeGeneratorFactory;
import com.google.gxp.compiler.fs.FileRef;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.UnmappableCharacterException;

public final class CompilationTask {
    private final CompilationUnit compilationUnit;
    private final CodeGeneratorFactory codeGeneratorFactory;
    private final OutputLanguage language;
    private final FileRef outputFileRef;

    CompilationTask(CompilationUnit compilationUnit, CodeGeneratorFactory codeGeneratorFactory, OutputLanguage language, FileRef outputFileRef) {
        this.compilationUnit = Preconditions.checkNotNull(compilationUnit);
        this.codeGeneratorFactory = Preconditions.checkNotNull(codeGeneratorFactory);
        this.language = Preconditions.checkNotNull(language);
        this.outputFileRef = Preconditions.checkNotNull(outputFileRef);
    }

    public FileRef getOutputFileRef() {
        return this.outputFileRef;
    }

    public CompilationUnit getCompilationUnit() {
        return this.compilationUnit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void execute(AlertSink alertSink, AlertPolicy alertPolicy) {
        SourcePosition outputPosition;
        block6: {
            outputPosition = new SourcePosition(this.outputFileRef);
            alertSink.add(new ProgressAlert(outputPosition, "Generating"));
            CodeGenerator codeGenerator = this.codeGeneratorFactory.getCodeGenerator(this.language, this.compilationUnit);
            AlertCounter counter = new AlertCounter(alertSink, alertPolicy);
            StringBuilder sb = new StringBuilder();
            try {
                codeGenerator.generateCode(sb, counter);
                if (counter.getErrorCount() != 0) break block6;
                Writer writer = this.outputFileRef.openWriter(Charsets.US_ASCII);
                try {
                    writer.write(sb.toString());
                }
                finally {
                    writer.close();
                }
            }
            catch (UnmappableCharacterException uce) {
                throw new AssertionError((Object)uce);
            }
            catch (IOException iox) {
                FileRef sourceFileRef = this.compilationUnit.getSourceFileRef();
                alertSink.add(new IOError(sourceFileRef, iox));
            }
        }
        alertSink.add(new ProgressAlert(outputPosition, "Generate finished"));
    }
}

