/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.internal;

import java.util.HashMap;
import java.util.Map;
import net.sf.oval.internal.util.StringUtils;
import net.sf.oval.logging.Logger;
import net.sf.oval.logging.LoggerFactory;
import net.sf.oval.logging.LoggerFactoryJDKImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Log {
    private static LoggerFactory loggerFactory = new LoggerFactoryJDKImpl();
    private static final Map<String, Log> LOG_REGISTRY = new HashMap<String, Log>(32);
    private Logger logger;

    public static synchronized Log getLog(Class<?> clazz) throws IllegalArgumentException {
        String name = clazz.getName();
        Log log = LOG_REGISTRY.get(name);
        if (log == null) {
            return new Log(loggerFactory.createLogger(name));
        }
        return log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LoggerFactory getLoggerFactory() {
        Map<String, Log> map = LOG_REGISTRY;
        synchronized (map) {
            return loggerFactory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLoggerFactory(LoggerFactory loggerFactory) throws IllegalArgumentException {
        Map<String, Log> map = LOG_REGISTRY;
        synchronized (map) {
            Log.loggerFactory = loggerFactory;
            for (Map.Entry<String, Log> entry : LOG_REGISTRY.entrySet()) {
                entry.getValue().setLogger(loggerFactory.createLogger(entry.getKey()));
            }
        }
    }

    private Log(Logger logger) {
        this.setLogger(logger);
    }

    public void debug(String msg) {
        this.logger.debug(msg);
    }

    public void debug(String msgFormat, Object arg1) {
        if (this.logger.isDebug()) {
            this.logger.debug(StringUtils.replaceAll(msgFormat, "{1}", arg1 == null ? "null" : arg1.toString()));
        }
    }

    public void debug(String msgFormat, Object arg1, Object arg2) {
        if (this.logger.isDebug()) {
            String msg = StringUtils.replaceAll(msgFormat, "{1}", arg1 == null ? "null" : arg1.toString());
            msg = StringUtils.replaceAll(msg, "{2}", arg2 == null ? "null" : arg2.toString());
            this.logger.debug(msg);
        }
    }

    public void debug(String msgFormat, Object arg1, Object arg2, Object arg3) {
        if (this.logger.isDebug()) {
            String msg = StringUtils.replaceAll(msgFormat, "{1}", arg1 == null ? "null" : arg1.toString());
            msg = StringUtils.replaceAll(msg, "{2}", arg2 == null ? "null" : arg2.toString());
            msg = StringUtils.replaceAll(msg, "{3}", arg3 == null ? "null" : arg3.toString());
            this.logger.debug(msg);
        }
    }

    public void debug(String msgFormat, Object arg1, Object arg2, Throwable t) {
        if (this.logger.isDebug()) {
            String msg = StringUtils.replaceAll(msgFormat, "{1}", arg1 == null ? "null" : arg1.toString());
            msg = StringUtils.replaceAll(msg, "{2}", arg2 == null ? "null" : arg2.toString());
            this.logger.debug(msg, t);
        }
    }

    public void debug(String msgFormat, Object arg1, Throwable t) {
        if (this.logger.isDebug()) {
            this.logger.debug(StringUtils.replaceAll(msgFormat, "{1}", arg1 == null ? "null" : arg1.toString()), t);
        }
    }

    public void debug(String msg, Throwable t) {
        this.logger.debug(msg, t);
    }

    public void error(String msg) {
        this.logger.error(msg);
    }

    public void error(String msgFormat, Object arg1) {
        if (this.logger.isError()) {
            this.logger.error(StringUtils.replaceAll(msgFormat, "{1}", arg1 == null ? "null" : arg1.toString()));
        }
    }

    public void error(String msgFormat, Object arg1, Object arg2) {
        if (this.logger.isError()) {
            String msg = StringUtils.replaceAll(msgFormat, "{1}", arg1 == null ? "null" : arg1.toString());
            msg = StringUtils.replaceAll(msg, "{2}", arg2 == null ? "null" : arg2.toString());
            this.logger.error(msg);
        }
    }

    public void error(String msgFormat, Object arg1, Object arg2, Object arg3) {
        if (this.logger.isError()) {
            String msg = StringUtils.replaceAll(msgFormat, "{1}", arg1 == null ? "null" : arg1.toString());
            msg = StringUtils.replaceAll(msg, "{2}", arg2 == null ? "null" : arg2.toString());
            msg = StringUtils.replaceAll(msg, "{3}", arg3 == null ? "null" : arg3.toString());
            this.logger.error(msg);
        }
    }

    public void error(String msgFormat, Object arg1, Object arg2, Throwable t) {
        if (this.logger.isError()) {
            String msg = StringUtils.replaceAll(msgFormat, "{1}", arg1 == null ? "null" : arg1.toString());
            msg = StringUtils.replaceAll(msg, "{2}", arg2 == null ? "null" : arg2.toString());
            this.logger.error(msg, t);
        }
    }

    public void error(String msgFormat, Object arg1, Throwable t) {
        if (this.logger.isError()) {
            this.logger.error(StringUtils.replaceAll(msgFormat, "{1}", arg1 == null ? "null" : arg1.toString()), t);
        }
    }

    public void error(String msg, Throwable t) {
        this.logger.error(msg, t);
    }

    public void info(String msg) {
        this.logger.info(msg);
    }

    public void info(String msgFormat, Object arg1) {
        if (this.logger.isInfo()) {
            this.logger.info(StringUtils.replaceAll(msgFormat, "{1}", arg1 == null ? "null" : arg1.toString()));
        }
    }

    public void info(String msgFormat, Object arg1, Object arg2) {
        if (this.logger.isInfo()) {
            String msg = StringUtils.replaceAll(msgFormat, "{1}", arg1 == null ? "null" : arg1.toString());
            msg = StringUtils.replaceAll(msg, "{2}", arg2 == null ? "null" : arg2.toString());
            this.logger.info(msg);
        }
    }

    public void info(String msgFormat, Object arg1, Object arg2, Object arg3) {
        if (this.logger.isInfo()) {
            String msg = StringUtils.replaceAll(msgFormat, "{1}", arg1 == null ? "null" : arg1.toString());
            msg = StringUtils.replaceAll(msg, "{2}", arg2 == null ? "null" : arg2.toString());
            msg = StringUtils.replaceAll(msg, "{3}", arg3 == null ? "null" : arg3.toString());
            this.logger.info(msg);
        }
    }

    public void info(String msgFormat, Object arg1, Object arg2, Throwable t) {
        if (this.logger.isInfo()) {
            String msg = StringUtils.replaceAll(msgFormat, "{1}", arg1 == null ? "null" : arg1.toString());
            msg = StringUtils.replaceAll(msg, "{2}", arg2 == null ? "null" : arg2.toString());
            this.logger.info(msg, t);
        }
    }

    public void info(String msgFormat, Object arg1, Throwable t) {
        if (this.logger.isInfo()) {
            this.logger.info(StringUtils.replaceAll(msgFormat, "{1}", arg1 == null ? "null" : arg1.toString()), t);
        }
    }

    public void info(String msg, Throwable t) {
        this.logger.info(msg, t);
    }

    public boolean isDebug() {
        return this.logger.isDebug();
    }

    public boolean isError() {
        return this.logger.isError();
    }

    public boolean isInfo() {
        return this.logger.isInfo();
    }

    public boolean isTrace() {
        return this.logger.isTrace();
    }

    public boolean isWarn() {
        return this.logger.isWarn();
    }

    private void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void trace(String msg) {
        this.logger.debug(msg);
    }

    public void trace(String msgFormat, Object arg1) {
        if (this.logger.isDebug()) {
            this.logger.trace(StringUtils.replaceAll(msgFormat, "{1}", arg1 == null ? "null" : arg1.toString()));
        }
    }

    public void trace(String msgFormat, Object arg1, Object arg2) {
        if (this.logger.isTrace()) {
            String msg = StringUtils.replaceAll(msgFormat, "{1}", arg1 == null ? "null" : arg1.toString());
            msg = StringUtils.replaceAll(msg, "{2}", arg2 == null ? "null" : arg2.toString());
            this.logger.trace(msg);
        }
    }

    public void trace(String msgFormat, Object arg1, Object arg2, Object arg3) {
        if (this.logger.isTrace()) {
            String msg = StringUtils.replaceAll(msgFormat, "{1}", arg1 == null ? "null" : arg1.toString());
            msg = StringUtils.replaceAll(msg, "{2}", arg2 == null ? "null" : arg2.toString());
            msg = StringUtils.replaceAll(msg, "{3}", arg3 == null ? "null" : arg3.toString());
            this.logger.trace(msg);
        }
    }

    public void trace(String msgFormat, Object arg1, Object arg2, Throwable t) {
        if (this.logger.isTrace()) {
            String msg = StringUtils.replaceAll(msgFormat, "{1}", arg1 == null ? "null" : arg1.toString());
            msg = StringUtils.replaceAll(msg, "{2}", arg2 == null ? "null" : arg2.toString());
            this.logger.trace(msg, t);
        }
    }

    public void trace(String msgFormat, Object arg1, Throwable t) {
        if (this.logger.isDebug()) {
            this.logger.trace(StringUtils.replaceAll(msgFormat, "{1}", arg1 == null ? "null" : arg1.toString()), t);
        }
    }

    public void trace(String msg, Throwable t) {
        this.logger.trace(msg, t);
    }

    public void warn(String msg) {
        this.logger.warn(msg);
    }

    public void warn(String msgFormat, Object arg1) {
        if (this.logger.isWarn()) {
            this.logger.warn(StringUtils.replaceAll(msgFormat, "{1}", arg1 == null ? "null" : arg1.toString()));
        }
    }

    public void warn(String msgFormat, Object arg1, Object arg2) {
        if (this.logger.isWarn()) {
            String msg = StringUtils.replaceAll(msgFormat, "{1}", arg1 == null ? "null" : arg1.toString());
            msg = StringUtils.replaceAll(msg, "{2}", arg2 == null ? "null" : arg2.toString());
            this.logger.warn(msg);
        }
    }

    public void warn(String msgFormat, Object arg1, Object arg2, Object arg3) {
        if (this.logger.isWarn()) {
            String msg = StringUtils.replaceAll(msgFormat, "{1}", arg1 == null ? "null" : arg1.toString());
            msg = StringUtils.replaceAll(msg, "{2}", arg2 == null ? "null" : arg2.toString());
            msg = StringUtils.replaceAll(msg, "{3}", arg3 == null ? "null" : arg3.toString());
            this.logger.warn(msg);
        }
    }

    public void warn(String msgFormat, Object arg1, Object arg2, Throwable t) {
        if (this.logger.isWarn()) {
            String msg = StringUtils.replaceAll(msgFormat, "{1}", arg1 == null ? "null" : arg1.toString());
            msg = StringUtils.replaceAll(msg, "{2}", arg2 == null ? "null" : arg2.toString());
            this.logger.warn(msg, t);
        }
    }

    public void warn(String msgFormat, Object arg1, Throwable t) {
        if (this.logger.isWarn()) {
            this.logger.warn(StringUtils.replaceAll(msgFormat, "{1}", arg1 == null ? "null" : arg1.toString()), t);
        }
    }

    public void warn(String msg, Throwable t) {
        this.logger.warn(msg, t);
    }
}

