<!--
Licensed to the Apache Software Foundation (ASF) under one
or more contributor license agreements.  See the NOTICE file
distributed with this work for additional information
regarding copyright ownership.  The ASF licenses this file
to you under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance
with the License.  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing,
software distributed under the License is distributed on an
"AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, either express or implied.  See the License for the
specific language governing permissions and limitations
under the License.
-->

## Change Log

### 2.0 (Tue Jun 28 08:53:02 2022 -0400)

**Database Migrations**

- [#20385](https://github.com/apache/superset/pull/20385) fix(migration): Ensure key_value LargeBinary is encoded as a MEDIUMBLOB as opposed to BLOB for MySQL (@john-bodley)
- [#20284](https://github.com/apache/superset/pull/20284) chore(migrations): Renaming migration files so that they're easier to keep track of (@craig-rueda)
- [#20108](https://github.com/apache/superset/pull/20108) fix: None dataset and schema permissions (@dpgaspar)
- [#18794](https://github.com/apache/superset/pull/18794) feat(business-types): initial implementation of SIP-78 (@cccs-RyanS)
- [#20073](https://github.com/apache/superset/pull/20073) fix(dataset): handle missing sqla uri in migration (@villebro)
- [#19941](https://github.com/apache/superset/pull/19941) fix(reports): Clear last value when state is WORKING (@john-bodley)
- [#19675](https://github.com/apache/superset/pull/19675) chore(docs): Spelling (@jsoref)
- [#19793](https://github.com/apache/superset/pull/19793) fix(SIP-68): handle empty table name during migration (@ktmud)
- [#19786](https://github.com/apache/superset/pull/19786) fix(migrations): coalesce is_temporal when inserting into sl_columns (@cemremengu)
- [#19421](https://github.com/apache/superset/pull/19421) perf: refactor SIP-68 db migrations with INSERT SELECT FROM (@ktmud)
- [#19767](https://github.com/apache/superset/pull/19767) fix: Fix migration for removing time_range_endpoints 3 (@hughhhh)
- [#19728](https://github.com/apache/superset/pull/19728) fix: Removetime_range_endpoints from query context object pt 2 (@hughhhh)
- [#19630](https://github.com/apache/superset/pull/19630) chore: clean up unused imports in db migration scripts (@ktmud)
- [#19577](https://github.com/apache/superset/pull/19577) fix: merge multiple db heads (@eschutho)
- [#19243](https://github.com/apache/superset/pull/19243) fix: cannot delete a database if team member has SQL editor tab that uses that db (@diegomedina248)
- [#19537](https://github.com/apache/superset/pull/19537) chore: block unsafe functions (@betodealmeida)
- [#19513](https://github.com/apache/superset/pull/19513) chore: postpone timerange endpoint removal (@villebro)
- [#19495](https://github.com/apache/superset/pull/19495) perf: speed up db migration for deprecating time_range_endpoints (@ktmud)
- [#19474](https://github.com/apache/superset/pull/19474) fix: handle null params in #18936 migration (@serenajiang)
- [#19423](https://github.com/apache/superset/pull/19423) fix: Remove`time_range_endpoints` from query context object (@hughhhh)
- [#18936](https://github.com/apache/superset/pull/18936) chore: Remove legacy SIP-15 interim logic/flags (@john-bodley)

**Features**

- [#20377](https://github.com/apache/superset/pull/20377) feat(standardized form data): keep all columns and metrics (@zhaoyongjie)
- [#20114](https://github.com/apache/superset/pull/20114) feat(chart): Enable caching per user when user impersonation is enabled (@Samira-El)
- [#20408](https://github.com/apache/superset/pull/20408) feat(plugin-chart-echarts): Support stacking negative and positive values (@kgabryje)
- [#20278](https://github.com/apache/superset/pull/20278) feat: Prevent dataset edit modal closing on click-away in edit mode (@reesercollins)
- [#20392](https://github.com/apache/superset/pull/20392) feat: setting limit value when Pie chart switches (@zhaoyongjie)
- [#20373](https://github.com/apache/superset/pull/20373) feat: adding truncate metric control on timeseries charts (@zhaoyongjie)
- [#20248](https://github.com/apache/superset/pull/20248) feat(explore): Implement viz switcher redesign (@kgabryje)
- [#20113](https://github.com/apache/superset/pull/20113) feat(api): Added "kind" to dataset/<pk> endpoint (@reesercollins)
- [#20299](https://github.com/apache/superset/pull/20299) feat(explore): Dataset Panel Options when Source = Query II (@lyndsiWilliams)
- [#20320](https://github.com/apache/superset/pull/20320) feat: Databricks native driver (@betodealmeida)
- [#20313](https://github.com/apache/superset/pull/20313) feat(explore): Denormalize form data in echarts, world map and nvd3 bar and line charts (@kgabryje)
- [#20277](https://github.com/apache/superset/pull/20277) feat: multiple results pane on explore and dashboard (@zhaoyongjie)
- [#19898](https://github.com/apache/superset/pull/19898) feat: When editing the label/title in the Metrics popover, hitting Enter should save what you've typed (@diegomedina248)
- [#16493](https://github.com/apache/superset/pull/16493) feat(plugin-chart-echarts): [feature-parity] support extra control for the area chart V2 (@stephenLYZ)
- [#19855](https://github.com/apache/superset/pull/19855) feat(explore): Frontend implementation of dataset creation from infobox (@lyndsiWilliams)
- [#20165](https://github.com/apache/superset/pull/20165) feat: add modfied col and timezone info to schedule col (@pkdotson)
- [#20144](https://github.com/apache/superset/pull/20144) feat: showing results pane in dashboard (@zhaoyongjie)
- [#20242](https://github.com/apache/superset/pull/20242) feat: derived metrics use different line style (@zhaoyongjie)
- [#20010](https://github.com/apache/superset/pull/20010) feat: standardized form_data (@zhaoyongjie)
- [#19987](https://github.com/apache/superset/pull/19987) feat(superset-ui-core): add feature flag for the analogous colors (@stephenLYZ)
- [#19881](https://github.com/apache/superset/pull/19881) feat(world-map): support color by metric or country column (@stephenLYZ)
- [#19981](https://github.com/apache/superset/pull/19981) feat!: pass datasource_type and datasource_id to form_data (@eschutho)
- [#15241](https://github.com/apache/superset/pull/15241) feat: query datasets from SQL Lab (@betodealmeida)
- [#20129](https://github.com/apache/superset/pull/20129) feat(explore): Fill dashboard name when adding new chart from dashboard view (@kgabryje)
- [#20160](https://github.com/apache/superset/pull/20160) feat(explore): Add empty state to annotations (@kgabryje)
- [#20134](https://github.com/apache/superset/pull/20134) feat: add Query.columns for bootstrap_data (@hughhhh)
- [#20158](https://github.com/apache/superset/pull/20158) feat: add statsd metrics for notifications (@dpgaspar)
- [#20052](https://github.com/apache/superset/pull/20052) feat(Helm Chart): Support resource limits and requests for each component (@rathberm)
- [#20170](https://github.com/apache/superset/pull/20170) feat: add samples endpoint (@zhaoyongjie)
- [#19381](https://github.com/apache/superset/pull/19381) feat: add drag and drop column rearrangement for table viz (@stevetracvc)
- [#20136](https://github.com/apache/superset/pull/20136) feat: Add Certified filter to Datasets (@hughhhh)
- [#20111](https://github.com/apache/superset/pull/20111) feat(dashboard): Chart title click redirects to Explore in new tab (@kgabryje)
- [#20097](https://github.com/apache/superset/pull/20097) feat(plugin-chart-echarts): add support for generic axis to mixed chart (@villebro)
- [#20126](https://github.com/apache/superset/pull/20126) feat(dashboard): Add create chart button in dashboard edit mode (@kgabryje)
- [#20059](https://github.com/apache/superset/pull/20059) feat: Save column data into json_metadata for all Query executions (@hughhhh)
- [#19918](https://github.com/apache/superset/pull/19918) feat(plugin-chart-echarts): support horizontal bar chart (@stephenLYZ)
- [#19902](https://github.com/apache/superset/pull/19902) feat: Explore popovers should close on escape (@diegomedina248)
- [#20049](https://github.com/apache/superset/pull/20049) feat(dashboard): Rearrange items in chart header controls dropdown (@kgabryje)
- [#20030](https://github.com/apache/superset/pull/20030) feat(sip-68): Add DatasourceDAO class to manage querying different datasources easier (@hughhhh)
- [#19581](https://github.com/apache/superset/pull/19581) feat(viz-gallery): add search weight for viz-name (@stephenLYZ)
- [#19999](https://github.com/apache/superset/pull/19999) feat: RLS for SQL Lab (@betodealmeida)
- [#19993](https://github.com/apache/superset/pull/19993) feat(explore): Show confirmation modal if user exits Explore without saving changes (@kgabryje)
- [#19873](https://github.com/apache/superset/pull/19873) feat(css): adds `chartId`-based class to dashboard chart holder (@rusackas)
- [#20002](https://github.com/apache/superset/pull/20002) feat: deprecate /superset/testconn and migrate to api v1 (@zephyring)
- [#19935](https://github.com/apache/superset/pull/19935) feat: deprecate /superset/validate_sql_json migrate to api v1 (@dpgaspar)
- [#20015](https://github.com/apache/superset/pull/20015) feat: add new enums for datasource types (@hughhhh)
- [#19956](https://github.com/apache/superset/pull/19956) feat: Applitools Cypress workflow (@geido)
- [#19852](https://github.com/apache/superset/pull/19852) feat: Run Applitools on public Storybook (@geido)
- [#19963](https://github.com/apache/superset/pull/19963) feat: Add cypress test for downloading chart as image (@codemaster08240328)
- [#19957](https://github.com/apache/superset/pull/19957) feat: switch from `sqlalchemy-trino` to `trino-python-client` (@dungdm93)
- [#19921](https://github.com/apache/superset/pull/19921) feat: deprecate /superset/extra_table_metadata migrate to api v1 (@dpgaspar)
- [#19745](https://github.com/apache/superset/pull/19745) feat: simplify SQLite time grain (@betodealmeida)
- [#19927](https://github.com/apache/superset/pull/19927) feat(chart & legend): make to enable show legend by default (@prosdev0107)
- [#19754](https://github.com/apache/superset/pull/19754) feat: deprecate old API on core superset fave_dashboards (@dpgaspar)
- [#19905](https://github.com/apache/superset/pull/19905) feat: simplify `memoized_func` (@betodealmeida)
- [#19871](https://github.com/apache/superset/pull/19871) feat(filter): make to hide sort filter when time range (@prosdev0107)
- [#19851](https://github.com/apache/superset/pull/19851) feat: add Advanced Analytics into mixed time series chart (@zhaoyongjie)
- [#19692](https://github.com/apache/superset/pull/19692) feat: Update ShortKey for stop query running in SqlLab editor (@codemaster08240328)
- [#17903](https://github.com/apache/superset/pull/17903) feat: Adds plugin-chart-handlebars (@jdbranham)
- [#19748](https://github.com/apache/superset/pull/19748) feat(explore): improve UI in the control panel (@stephenLYZ)
- [#19724](https://github.com/apache/superset/pull/19724) feat: 10/15/30 min grain to Pinot (@hughhhh)
- [#19696](https://github.com/apache/superset/pull/19696) feat(explore): Replace overlay with alert banner when chart controls change (@kgabryje)
- [#19751](https://github.com/apache/superset/pull/19751) feat(explore): Implement data panel redesign (@kgabryje)
- [#19598](https://github.com/apache/superset/pull/19598) feat: add empty states to sqlab editor and select (@pkdotson)
- [#19450](https://github.com/apache/superset/pull/19450) feat: Remove legacy sql alchemy db connection link from G Sheet connection (@codemaster08240328)
- [#19710](https://github.com/apache/superset/pull/19710) feat: Enabling source maps full time (@rusackas)
- [#19671](https://github.com/apache/superset/pull/19671) feat: UI override registry (@suddjian)
- [#19691](https://github.com/apache/superset/pull/19691) feat(explore): More explicit labels of adhoc filter operators (@kgabryje)
- [#19558](https://github.com/apache/superset/pull/19558) feat(explore): Redesign of Run/Save buttons (@kgabryje)
- [#19650](https://github.com/apache/superset/pull/19650) feat(embedded): API get embedded dashboard config by uuid (@lilykuang)
- [#19310](https://github.com/apache/superset/pull/19310) feat(CRUD): add new empty state (@stephenLYZ)
- [#19622](https://github.com/apache/superset/pull/19622) feat(plugin-chart-echarts): add aggregate total for the Pie/Donuct chart (@stephenLYZ)
- [#19314](https://github.com/apache/superset/pull/19314) feat: Move Database Import option into DB Connection modal (@lyndsiWilliams)
- [#19434](https://github.com/apache/superset/pull/19434) feat: deprecate old API and create new API for dashes created by me (@dpgaspar)
- [#19482](https://github.com/apache/superset/pull/19482) feat: add success toast to alerts and reports (@pkdotson)
- [#19574](https://github.com/apache/superset/pull/19574) feat: add a `where_in` filter for Jinja2 (@betodealmeida)
- [#19458](https://github.com/apache/superset/pull/19458) feat(explore): Move timer, row counter and cached pills to chart container (@kgabryje)
- [#19529](https://github.com/apache/superset/pull/19529) feat(explore): Move chart header to top of the page (@kgabryje)
- [#19489](https://github.com/apache/superset/pull/19489) feat(CI): clean up Python tests output (@ktmud)
- [#19308](https://github.com/apache/superset/pull/19308) feat(explore): SQL popover in datasource panel (@kgabryje)
- [#19325](https://github.com/apache/superset/pull/19325) feat(color): support analogous colors to prevent color conflict (@stephenLYZ)
- [#19408](https://github.com/apache/superset/pull/19408) feat(dashboard): Implement empty states for empty tabs (@kgabryje)
- [#19446](https://github.com/apache/superset/pull/19446) feat(explore): Move chart actions into dropdown (@kgabryje)
- [#19394](https://github.com/apache/superset/pull/19394) feat(explore): UI changes in dataset panel on Explore page (@kgabryje)

**Fixes**

- [#20382](https://github.com/apache/superset/pull/20382) fix: Allow dataset owners to explore their datasets (@reesercollins)
- [#20419](https://github.com/apache/superset/pull/20419) fix(embedded): Retry when executing alert queries to avoid sending transient errors to users as alert failure notifications (@zhaorui2022)
- [#20555](https://github.com/apache/superset/pull/20555) fix: Respecting max/min opacities, and adding tests. (@rusackas)
- [#20571](https://github.com/apache/superset/pull/20571) fix: Revert #20408 (stacking negative values in echarts bar chart) (@rusackas)
- [#20487](https://github.com/apache/superset/pull/20487) fix(database-modal): form in database model effects results of the database list (@stephenLYZ)
- [#20488](https://github.com/apache/superset/pull/20488) fix(big-number): big number gets cut off on a Dashboard (@stephenLYZ)
- [#16326](https://github.com/apache/superset/pull/16326) fix: SQL Lab cancel query in Redshift database connection does not wo… (@yourssvk)
- [#20362](https://github.com/apache/superset/pull/20362) fix: Unable to download the Dashboard as image in case there's an image added through Markdown (@diegomedina248)
- [#20543](https://github.com/apache/superset/pull/20543) fix: Removes psycopg2 as a required dependency
- [#20442](https://github.com/apache/superset/pull/20442) fix(db): Show the only db install guide when the db is already installed and error is existed while importing file. (@prosdev0107)
- [#20483](https://github.com/apache/superset/pull/20483) fix: bump FAB to 4.1.2 (@dpgaspar)
- [#20493](https://github.com/apache/superset/pull/20493) fix: correction from mmsql to mssql in setup.py (@mdeshmu)
- [#20460](https://github.com/apache/superset/pull/20460) fix: new column UUID conflicts in dual write (@eschutho)
- [#20485](https://github.com/apache/superset/pull/20485) fix: Re-add filter-box time granularity/column (@john-bodley)
- [#20480](https://github.com/apache/superset/pull/20480) fix(docs): prevent some symbols from being copied in docs (@stephenLYZ)
- [#19920](https://github.com/apache/superset/pull/19920) fix(table viz): correctly sort by multiple columns in a table (@stevetracvc)
- [#20402](https://github.com/apache/superset/pull/20402) fix: alert & reports active toggle optimistic update (@diegomedina248)
- [#20472](https://github.com/apache/superset/pull/20472) fix: Changes the return type of get_permissions to be JSON friendly (@michael-s-molina)
- [#20468](https://github.com/apache/superset/pull/20468) fix: async queries limit bug (@AAfghahi)
- [#20257](https://github.com/apache/superset/pull/20257) fix(home): Show home page tabs as pills instead of links (@prosdev0107)
- [#20340](https://github.com/apache/superset/pull/20340) fix: ensure column name in description is string (@betodealmeida)
- [#20350](https://github.com/apache/superset/pull/20350) fix(viz): BigQuery time grain 'minute'/'second' throws an error (@diegomedina248)
- [#20384](https://github.com/apache/superset/pull/20384) fix(chart & table): Prevent the dates from wrapping in table chart (@prosdev0107)
- [#20404](https://github.com/apache/superset/pull/20404) fix: suppress translation warning in jest (@zhaoyongjie)
- [#20451](https://github.com/apache/superset/pull/20451) fix: should raise exception when apply a categorical axis (@zhaoyongjie)
- [#20447](https://github.com/apache/superset/pull/20447) fix: table viz sort icon bottom aligned (@diegomedina248)
- [#20326](https://github.com/apache/superset/pull/20326) fix(fbprophet): Fix weekly frequencies (@john-bodley)
- [#20434](https://github.com/apache/superset/pull/20434) fix(20428): Address-Presto/Trino-Poll-Issue-Refactor (@Thelin90)
- [#20411](https://github.com/apache/superset/pull/20411) fix(dashboard): new created chart did not have high lighted effect when using the permalink of chart share in dashboard (@diegomedina248)
- [#20261](https://github.com/apache/superset/pull/20261) fix(embedded): CSV download for chart (@lilykuang)
- [#20276](https://github.com/apache/superset/pull/20276) fix(cosmetic): cannot find m-r-10 class in superset.less (@Renderz)
- [#20420](https://github.com/apache/superset/pull/20420) fix: rm eslint-plugin-translation-vars engines requirement (@stephenLYZ)
- [#20409](https://github.com/apache/superset/pull/20409) fix(bar-chart-v2): remove marker control from bar chart V2 (@stephenLYZ)
- [#20333](https://github.com/apache/superset/pull/20333) fix(presto): use milliseconds timespec for presto (@mohittt8)
- [#20414](https://github.com/apache/superset/pull/20414) fix: key error on permalink fetch for old permalinks (@eschutho)
- [#20410](https://github.com/apache/superset/pull/20410) fix: Adding extra metrics issue after chart configuration (@codemaster08240328)
- [#20405](https://github.com/apache/superset/pull/20405) fix: Incorrect translations in Chinese in messages.po (@chuancyzhang)
- [#20396](https://github.com/apache/superset/pull/20396) fix(plugin-chart-pivot-table): color weight of Conditional formatting metrics not work (@stephenLYZ)
- [#20361](https://github.com/apache/superset/pull/20361) fix(fonts): Show the all the A's in our workspace correctly, not funky (@prosdev0107)
- [#20383](https://github.com/apache/superset/pull/20383) fix: Unable to export multiple Dashboards with the same name (@diegomedina248)
- [#20363](https://github.com/apache/superset/pull/20363) fix: A newly connected database doesn't appear in the databases list if user connected database using the 'plus' button (@diegomedina248)
- [#20372](https://github.com/apache/superset/pull/20372) fix: update connection modal to use existing catalog (@pkdotson)
- [#20368](https://github.com/apache/superset/pull/20368) fix(VERSIONED_EXPORTS): Ensure dashboards and charts adhere to the VERSIONED_EXPORTS feature flag (@john-bodley)
- [#20351](https://github.com/apache/superset/pull/20351) fix: catch some potential errors on dual write (@eschutho)
- [#20364](https://github.com/apache/superset/pull/20364) fix: query execution time is not fully displayed in bubble icon (@diegomedina248)
- [#20365](https://github.com/apache/superset/pull/20365) fix: Fix typo in Error handling message (@codemaster08240328)
- [#19967](https://github.com/apache/superset/pull/19967) fix: A newly connected database doesn't appear in the databases list if user connected database using the 'plus' button (@diegomedina248)
- [#20348](https://github.com/apache/superset/pull/20348) fix(docker): Make Gunicorn Keepalive Adjustable (@mdeshmu)
- [#19670](https://github.com/apache/superset/pull/19670) fix: Add serviceAccountName to celerybeat pods (@paulinjo)
- [#20315](https://github.com/apache/superset/pull/20315) fix(chart): chart gets cut off on the dashboard (@stephenLYZ)
- [#20324](https://github.com/apache/superset/pull/20324) fix: superset-ui/core coverage (@zhaoyongjie)
- [#20282](https://github.com/apache/superset/pull/20282) fix(explore): Make that see more/see less works correctly with scrolling when error msg is long text. (@prosdev0107)
- [#20296](https://github.com/apache/superset/pull/20296) fix: Alpha are unable to perform a second modification to a Dataset when in Explore (@hughhhh)
- [#20290](https://github.com/apache/superset/pull/20290) fix: Faulty datetime parser regex (@reesercollins)
- [#19761](https://github.com/apache/superset/pull/19761) fix(plugin-chart-echarts): [feature-parity] apply button of annotation layer doesn't work as expected (@stephenLYZ)
- [#20263](https://github.com/apache/superset/pull/20263) fix(embedded): accessing variable response before initialization (@zhaorui2022)
- [#20274](https://github.com/apache/superset/pull/20274) fix(codecov): improve core code coverage (@stephenLYZ)
- [#20187](https://github.com/apache/superset/pull/20187) fix: Database import with cancel_query.. extra field (@codemaster08240328)
- [#20237](https://github.com/apache/superset/pull/20237) fix(cosmetic): Fix Datasource Modal Out Of Box (@Renderz)
- [#20058](https://github.com/apache/superset/pull/20058) fix: Support the Clipboard API in modern browsers (@diegomedina248)
- [#20164](https://github.com/apache/superset/pull/20164) fix(sql lab): View result button is not showing consistently (@diegomedina248)
- [#20171](https://github.com/apache/superset/pull/20171) fix(charts list): do not trigger ListViewError exception for anonymous user (@trepmag)
- [#20178](https://github.com/apache/superset/pull/20178) fix: While exporting CSV , only the entries on first page are getting downloaded even when user is on other pages #17861 (@LahmerIlyas)
- [#20204](https://github.com/apache/superset/pull/20204) fix: Fixes issue where results panel height was incorrect [sc-49045] (@eric-briscoe)
- [#20235](https://github.com/apache/superset/pull/20235) fix: Box Plot Chart throws an error when the average (AVG) / SUM is being calculated on the Metrics (@diegomedina248)
- [#20088](https://github.com/apache/superset/pull/20088) fix: datatype tracking issue on virtual dataset (@codemaster08240328)
- [#20220](https://github.com/apache/superset/pull/20220) fix: dashbaord unable to refresh (@zhaoyongjie)
- [#20228](https://github.com/apache/superset/pull/20228) fix: failed samples should throw exception (@zhaoyongjie)
- [#20203](https://github.com/apache/superset/pull/20203) fix: move columns to datasource object for bootstrap data (@hughhhh)
- [#20151](https://github.com/apache/superset/pull/20151) fix(csv): Ensure df_to_escaped_csv does not coerce integer columns to float (@john-bodley)
- [#20221](https://github.com/apache/superset/pull/20221) fix(legacy-plugin-chart-sunburst): linear color scheme not work when secondary metric is provided (@stephenLYZ)
- [#20223](https://github.com/apache/superset/pull/20223) fix(legacy-plugin-chart-sunburst): chart broken when secondary metric is removed (@stephenLYZ)
- [#20147](https://github.com/apache/superset/pull/20147) fix(cosmetic): Limiting modal height (@rusackas)
- [#20206](https://github.com/apache/superset/pull/20206) fix(sql lab): SQL Lab Compile Query Delay (@diegomedina248)
- [#20201](https://github.com/apache/superset/pull/20201) fix: unable to set destroyOnClose on ModalTrigger (@zhaoyongjie)
- [#20186](https://github.com/apache/superset/pull/20186) fix(db): make to allow to show/hide the password when only creating (@prosdev0107)
- [#20127](https://github.com/apache/superset/pull/20127) fix(database): retrival of tables and views from schema for exasol backend (@Nicoretti)
- [#19899](https://github.com/apache/superset/pull/19899) fix: always create parameter json field (@pkdotson)
- [#20173](https://github.com/apache/superset/pull/20173) fix: avoid while cycle in computeMaxFontSize for big Number run forever when css rule applied (@diegomedina248)
- [#20086](https://github.com/apache/superset/pull/20086) fix(css): transparent linear gradient not working in safari (@stephenLYZ)
- [#19102](https://github.com/apache/superset/pull/19102) fix: string aggregation is incorrect in PivotTableV2 (@diegomedina248)
- [#20011](https://github.com/apache/superset/pull/20011) fix(chart & heatmap): make to fix that y label is rendering out of bounds (@prosdev0107)
- [#20142](https://github.com/apache/superset/pull/20142) fix(explore): handle null control sections (@villebro)
- [#20128](https://github.com/apache/superset/pull/20128) fix: advanced data type API spec and permission name (@dpgaspar)
- [#20107](https://github.com/apache/superset/pull/20107) fix(generic-chart-axes): set x-axis if unset and ff is enabled (@villebro)
- [#20018](https://github.com/apache/superset/pull/20018) fix(modal): add primary button loading state to modals (@kgopal492)
- [#20099](https://github.com/apache/superset/pull/20099) fix: Add cypress test for report page direct link issue (@codemaster08240328)
- [#20068](https://github.com/apache/superset/pull/20068) fix: dbmodal test connection error timeout (@pkdotson)
- [#20092](https://github.com/apache/superset/pull/20092) fix: Revert "feat(explore): Show confirmation modal if user exits Explore without saving changes (#19993) (@kgabryje)
- [#19939](https://github.com/apache/superset/pull/19939) fix(chart & alert): make to show metrics properly (@prosdev0107)
- [#20085](https://github.com/apache/superset/pull/20085) fix: typo in `importexport/api.py` OpenAPI (@betodealmeida)
- [#20051](https://github.com/apache/superset/pull/20051) fix(CRUD): make to fix the dancing when crud view is on hover (@prosdev0107)
- [#20064](https://github.com/apache/superset/pull/20064) fix(chart & gallery): make to add mixed time-series into recommended charts (@prosdev0107)
- [#20013](https://github.com/apache/superset/pull/20013) fix: The dynamic form to connect to Snowflake DB is not returning any errors (@diegomedina248)
- [#20029](https://github.com/apache/superset/pull/20029) fix(plugin-chart-echarts): tooltip of big number truncated at then bottom (@stephenLYZ)
- [#19914](https://github.com/apache/superset/pull/19914) fix: Refactor SQL engine username logic (@john-bodley)
- [#20050](https://github.com/apache/superset/pull/20050) fix: Fixes Tabs style (@michael-s-molina)
- [#20048](https://github.com/apache/superset/pull/20048) fix(homepage): make to show indicator when tab is chosen (@prosdev0107)
- [#20026](https://github.com/apache/superset/pull/20026) fix(chart & filters): make to padding between textarea and buttons (@prosdev0107)
- [#20019](https://github.com/apache/superset/pull/20019) fix(embedded): third party cookies (@lilykuang)
- [#20033](https://github.com/apache/superset/pull/20033) fix: Direct Linking issue on report list: 404 status code. (@codemaster08240328)
- [#19977](https://github.com/apache/superset/pull/19977) fix(word-cloud): fix randomness of each word's rotation (@ebaratte)
- [#20021](https://github.com/apache/superset/pull/20021) fix: native filter truncation rerendering loop on hover (@diegomedina248)
- [#20004](https://github.com/apache/superset/pull/20004) fix: URI form is blank when trying to connect from sql lab (@diegomedina248)
- [#19841](https://github.com/apache/superset/pull/19841) fix: Table chart column config issue (@codemaster08240328)
- [#19877](https://github.com/apache/superset/pull/19877) fix: Making chart update more truthful (@Gwitchr)
- [#19996](https://github.com/apache/superset/pull/19996) fix: Use pull_request_target in Cypress Applitools workflow (@geido)
- [#19972](https://github.com/apache/superset/pull/19972) fix: revert chore(deps): bump d3-svg-legend in /superset-frontend (#19846) (@villebro)
- [#19889](https://github.com/apache/superset/pull/19889) fix: Fix auto-reversion of label/title in the Metrics popover (@diegomedina248)
- [#19903](https://github.com/apache/superset/pull/19903) fix(explore): Explore data table tooltip (@Gwitchr)
- [#19938](https://github.com/apache/superset/pull/19938) fix(chart & table): make to allow highlight in case of numeric column (@prosdev0107)
- [#19839](https://github.com/apache/superset/pull/19839) fix(dashboard): allow users to resize the markdown widget easier (@cccs-Dustin)
- [#19887](https://github.com/apache/superset/pull/19887) fix(hive): Workaround for Python 3.9 s3 transfer issue (@john-bodley)
- [#19936](https://github.com/apache/superset/pull/19936) fix: OpenAPI docs small fixes (@dpgaspar)
- [#19932](https://github.com/apache/superset/pull/19932) fix: can not correctly set force in store (@zhaoyongjie)
- [#19930](https://github.com/apache/superset/pull/19930) fix: memoize primitives (@betodealmeida)
- [#19926](https://github.com/apache/superset/pull/19926) fix(dataset): DAO update (@betodealmeida)
- [#19826](https://github.com/apache/superset/pull/19826) fix: Missing `f` prefix on f-strings (@code-review-doctor)
- [#18988](https://github.com/apache/superset/pull/18988) fix(column-header-tooltip): make that hide the tooltip when the cloum… (@prosdev0107)
- [#19782](https://github.com/apache/superset/pull/19782) fix: chart import error with virtual dataset (@codemaster08240328)
- [#19485](https://github.com/apache/superset/pull/19485) fix: Set fixed maxWidth of the cron schedule modal (@codemaster08240328)
- [#19885](https://github.com/apache/superset/pull/19885) fix: Chart download as image issue (@codemaster08240328)
- [#19883](https://github.com/apache/superset/pull/19883) fix(allow-db-explore): make to check the allow virtual table explore option by default (@prosdev0107)
- [#19835](https://github.com/apache/superset/pull/19835) fix(helm): fix postgresql values (@benjamin-texier)
- [#19758](https://github.com/apache/superset/pull/19758) fix(plugin-chart-echarts): [feature parity] annotation line chart color does not work (@stephenLYZ)
- [#19879](https://github.com/apache/superset/pull/19879) fix(plugin-chart-handlebars): fix overflow, debounce and control reset (@villebro)
- [#19668](https://github.com/apache/superset/pull/19668) fix: Dates alignment in Table viz (@geido)
- [#19876](https://github.com/apache/superset/pull/19876) fix: Cannot re-order metrics by drag and drop (@diegomedina248)
- [#19840](https://github.com/apache/superset/pull/19840) fix(dashboard-css): make to load saved css template (@prosdev0107)
- [#19859](https://github.com/apache/superset/pull/19859) fix: Dashboard report creation error handling (@etr2460)
- [#19857](https://github.com/apache/superset/pull/19857) fix: Update eslint error message to reflect location of antd components (@etr2460)
- [#19605](https://github.com/apache/superset/pull/19605) fix: Query execution time is displayed as invalid date (@diegomedina248)
- [#19694](https://github.com/apache/superset/pull/19694) fix(db & connection): make to show/hide the password when only creating db connection (@prosdev0107)
- [#19778](https://github.com/apache/superset/pull/19778) fix: deck.gl GeoJsonLayer Autozoom & fill/stroke options (@diegomedina248)
- [#19850](https://github.com/apache/superset/pull/19850) fix: Regression on Data and Alerts & Reports Headers (@diegomedina248)
- [#19842](https://github.com/apache/superset/pull/19842) fix: count(distinct column_name) in metrics (@zhaoyongjie)
- [#19843](https://github.com/apache/superset/pull/19843) fix(explore): ignore temporary controls in altered pill (@villebro)
- [#19800](https://github.com/apache/superset/pull/19800) fix: Cypress tests reliability improvements (@diegomedina248)
- [#19575](https://github.com/apache/superset/pull/19575) fix: Show full long number in text email report for table chart. (@codemaster08240328)
- [#19429](https://github.com/apache/superset/pull/19429) fix(dashboard): make to filter the correct certified or non-certified… (@prosdev0107)
- [#13082](https://github.com/apache/superset/pull/13082) fix(sql_lab): Add custom timestamp type for literal casting for presto timestamps (@kekwan)
- [#19797](https://github.com/apache/superset/pull/19797) fix: add missing init files (@suddjian)
- [#19672](https://github.com/apache/superset/pull/19672) fix: trap SQLAlchemy common exceptions & throw 422 error instead (@diegomedina248)
- [#19288](https://github.com/apache/superset/pull/19288) fix: AlertReportCronScheduler tests (@diegomedina248)
- [#19781](https://github.com/apache/superset/pull/19781) fix(world-map): remove categorical color control (@serenajiang)
- [#19792](https://github.com/apache/superset/pull/19792) fix(plugin-chart-table): Resetting controls when switching query mode (@kgabryje)
- [#19755](https://github.com/apache/superset/pull/19755) fix: small cleanup for created by me dashboards API (@dpgaspar)
- [#19784](https://github.com/apache/superset/pull/19784) fix(readme): Remove broken link to legacy gallery (@drluckyspin)
- [#19722](https://github.com/apache/superset/pull/19722) fix: dashboard top level tabs edit (@diegomedina248)
- [#19777](https://github.com/apache/superset/pull/19777) fix(explore): Double divider if no permissions for adding reports (@kgabryje)
- [#19673](https://github.com/apache/superset/pull/19673) fix(import): Add the error alert on failed database import (@prosdev0107)
- [#19518](https://github.com/apache/superset/pull/19518) fix: alert/report created by filter inconsistency with table display (@diegomedina248)
- [#19700](https://github.com/apache/superset/pull/19700) fix: remove expose (@AAfghahi)
- [#19626](https://github.com/apache/superset/pull/19626) fix: deactivate embedding on a dashboard (@suddjian)
- [#19472](https://github.com/apache/superset/pull/19472) fix: Dashboard Edit View Tab Headers Hidden when Dashboard Name is Long (@diegomedina248)
- [#19311](https://github.com/apache/superset/pull/19311) fix(sql lab): add quotes when autocompleting table names with spaces in the editor (@diegomedina248)
- [#19290](https://github.com/apache/superset/pull/19290) fix(sql lab): select edit on query from history doesn't upload editor properly (@diegomedina248)
- [#19420](https://github.com/apache/superset/pull/19420) fix: sql lab ctrl t behaved differently from clicking (@Gwitchr)
- [#19357](https://github.com/apache/superset/pull/19357) fix: Redirect to full url on 401 (@geido)
- [#19001](https://github.com/apache/superset/pull/19001) fix: Line Chart Annotation Info Update (@codemaster08240328)
- [#19714](https://github.com/apache/superset/pull/19714) fix: create virtual table with exotic type (@villebro)
- [#19708](https://github.com/apache/superset/pull/19708) fix(nav): infinite redirect and upload dataset nav permissions (@ktmud)
- [#19430](https://github.com/apache/superset/pull/19430) fix(data-upload): make to change err message (@prosdev0107)
- [#19419](https://github.com/apache/superset/pull/19419) fix(alert & report): make to fix the issue when recreate report (@prosdev0107)
- [#19371](https://github.com/apache/superset/pull/19371) fix: Reset sorting bar issue in Barchart (@codemaster08240328)
- [#19362](https://github.com/apache/superset/pull/19362) fix(sql lab): display the 'View Results' button consistently in the history tab on sync mode (@diegomedina248)
- [#19294](https://github.com/apache/superset/pull/19294) fix: improve alerts & reports modal on small devices (@diegomedina248)
- [#19257](https://github.com/apache/superset/pull/19257) fix(sql lab): table selector should display all the selected tables (@diegomedina248)
- [#19686](https://github.com/apache/superset/pull/19686) fix(plugin-chart-echarts): xAxis scale is not correct when time grain is quarter (@stephenLYZ)
- [#19646](https://github.com/apache/superset/pull/19646) fix(explore): Change copy of cross filters checkbox (@kgabryje)
- [#19586](https://github.com/apache/superset/pull/19586) fix: Navbar styles and Welcome page text (@geido)
- [#19662](https://github.com/apache/superset/pull/19662) fix(database-api): allow search for all columns (@villebro)
- [#19656](https://github.com/apache/superset/pull/19656) fix: allow_browser_login in import/export API (@betodealmeida)
- [#19628](https://github.com/apache/superset/pull/19628) fix: Table Autosizing Has Unnecessary Horizontal Scroll Bars (@diegomedina248)
- [#19573](https://github.com/apache/superset/pull/19573) fix(chart & polygon): make to fix the issue the polygon chart (@prosdev0107)
- [#19051](https://github.com/apache/superset/pull/19051) fix: update Permissions for right nav (@AAfghahi)
- [#19625](https://github.com/apache/superset/pull/19625) fix(test): make test_clean_requests_after_schema_grant more idempotent (@ktmud)
- [#19571](https://github.com/apache/superset/pull/19571) fix: Catch literal colors when theme top level (@geido)
- [#19594](https://github.com/apache/superset/pull/19594) fix: spelling of following (@lzm0)
- [#19569](https://github.com/apache/superset/pull/19569) fix: check type of url before performing string actions (@eschutho)
- [#19570](https://github.com/apache/superset/pull/19570) fix: sqloxide optional (@betodealmeida)
- [#19397](https://github.com/apache/superset/pull/19397) fix: weight tooltip issue (@codemaster08240328)
- [#19313](https://github.com/apache/superset/pull/19313) fix(sql lab): increase the size of the action icons in the history tab (@diegomedina248)
- [#19039](https://github.com/apache/superset/pull/19039) fix(explore): clean data when hidding control (@stephenLYZ)
- [#19444](https://github.com/apache/superset/pull/19444) fix: Error Message is cut off in alerts & reports log page (@codemaster08240328)
- [#19312](https://github.com/apache/superset/pull/19312) fix: adaptive formatting typo in explore dropdowns (@diegomedina248)
- [#19534](https://github.com/apache/superset/pull/19534) fix(explore): Chart header icon paddings (@kgabryje)
- [#19399](https://github.com/apache/superset/pull/19399) fix: native filter dropdown not attached to parent node (@diegomedina248)
- [#19112](https://github.com/apache/superset/pull/19112) fix: Dashboard import holding issue (@codemaster08240328)
- [#19342](https://github.com/apache/superset/pull/19342) fix: Clean up custom css when dashboard unmounted (@codemaster08240328)
- [#19491](https://github.com/apache/superset/pull/19491) fix: Dynamic form to connect to Snowflake DB is not displaying authentication errors (@diegomedina248)
- [#19528](https://github.com/apache/superset/pull/19528) fix: Correct Ukraine map (@wacken89)
- [#19522](https://github.com/apache/superset/pull/19522) fix: add back view for report reload error (@pkdotson)
- [#19519](https://github.com/apache/superset/pull/19519) fix: GSheets rendering from global nav (@hughhhh)
- [#19358](https://github.com/apache/superset/pull/19358) fix(sqllab): make to hide the delete button of most recent query history (@prosdev0107)
- [#19307](https://github.com/apache/superset/pull/19307) fix: Logo resizing on page load (@geido)
- [#19166](https://github.com/apache/superset/pull/19166) fix: time filter should be [start, end) (@zhaoyongjie)

**Others**

- [#20620](https://github.com/apache/superset/pull/20620) docs: fix link for Apache Superset source code (@dpgaspar)
- [#20621](https://github.com/apache/superset/pull/20621) chore: bump FAB to 4.1.3 (@dpgaspar)
- [#20486](https://github.com/apache/superset/pull/20486) chore: Updated copy in chart drop down to "View as table" (@lauderbaugh)
- [#20116](https://github.com/apache/superset/pull/20116) style(typo): occured -> occurred (@sfirke)
- [#20401](https://github.com/apache/superset/pull/20401) chore: add action to welcome new users (@eschutho)
- [#20269](https://github.com/apache/superset/pull/20269) chore(docs): Remove cache warming documentation (@ajwhite)
- [#20194](https://github.com/apache/superset/pull/20194) chore: Removes unused vars (@michael-s-molina)
- [#20321](https://github.com/apache/superset/pull/20321) chore: add breaking change information about form_data datasource_type (@eschutho)
- [#20298](https://github.com/apache/superset/pull/20298) chore: Removes no-use-before-define warnings (@michael-s-molina)
- [#20337](https://github.com/apache/superset/pull/20337) chore(dashboard): update Edit Dashboard side panel tabs (@codyml)
- [#20318](https://github.com/apache/superset/pull/20318) chore: Updates the final steps of the release README (@michael-s-molina)
- [#20307](https://github.com/apache/superset/pull/20307) docs: Updates CHANGELOG.md with 1.5.1 fixes (@michael-s-molina)
- [#20308](https://github.com/apache/superset/pull/20308) docs(jinja): Detail how to use Jinja parameters (@EBoisseauSierra)
- [#20304](https://github.com/apache/superset/pull/20304) chore: superset-ui/core code coverage (@zhaoyongjie)
- [#20297](https://github.com/apache/superset/pull/20297) chore(deps): pinning pyjwt to 2.4.0 (@sadpandajoe)
- [#20287](https://github.com/apache/superset/pull/20287) chore(deps): bump numpy 1.22.1 and PyJWT to 2.4.0 (@sadpandajoe)
- [#20272](https://github.com/apache/superset/pull/20272) chore: remove unused codes for samples (@zhaoyongjie)
- [#20289](https://github.com/apache/superset/pull/20289) chore: Adjusts release emails (@michael-s-molina)
- [#20180](https://github.com/apache/superset/pull/20180) docs: facelift the docs (@mistercrunch)
- [#20249](https://github.com/apache/superset/pull/20249) chore: add event logger to reports/alerts CRUD (@AAfghahi)
- [#20273](https://github.com/apache/superset/pull/20273) chore: adjust the psycopg2 version of k8s installation guide (@ensky)
- [#20152](https://github.com/apache/superset/pull/20152) refactor(trino): Handful of updates for the Trino engine (@john-bodley)
- [#20252](https://github.com/apache/superset/pull/20252) chore: use exc_info to pass errors to log warnings (@eschutho)
- [#20154](https://github.com/apache/superset/pull/20154) chore(requirements): Cleanup of Python requirements (@john-bodley)
- [#20226](https://github.com/apache/superset/pull/20226) refactor: decouple DataTableControl (@zhaoyongjie)
- [#20243](https://github.com/apache/superset/pull/20243) docs: Add beans to users list (@kakoni)
- [#20231](https://github.com/apache/superset/pull/20231) docs: Updates release scripts and docs (@michael-s-molina)
- [#20196](https://github.com/apache/superset/pull/20196) chore: bumping min version of shillelagh (@AAfghahi)
- [#20192](https://github.com/apache/superset/pull/20192) chore: Moves date utils to utils folder (@michael-s-molina)
- [#20210](https://github.com/apache/superset/pull/20210) docs: update release instructions (@villebro)
- [#20205](https://github.com/apache/superset/pull/20205) chore(deps): bump swagger-ui-react from 4.1.2 to 4.1.3 in /docs (@dependabot[bot])
- [#20195](https://github.com/apache/superset/pull/20195) docs: correct case of ClickHouse (@DanRoscigno)
- [#20109](https://github.com/apache/superset/pull/20109) refactor: decouple DataTablesPane (@zhaoyongjie)
- [#20193](https://github.com/apache/superset/pull/20193) refactor: Removes embedded/index.tsx warnings (@michael-s-molina)
- [#20185](https://github.com/apache/superset/pull/20185) docs(security): a typo: Gamma should be in quotes (@jimmytheneutrino)
- [#20146](https://github.com/apache/superset/pull/20146) chore: Implement global header in Dashboard (@geido)
- [#20174](https://github.com/apache/superset/pull/20174) chore: Disable flaky assert in reports cypress test (@kgabryje)
- [#20163](https://github.com/apache/superset/pull/20163) chore: change button name in Sql Lab (@AAfghahi)
- [#20157](https://github.com/apache/superset/pull/20157) chore: filter undefined operators (@zhaoyongjie)
- [#20140](https://github.com/apache/superset/pull/20140) chore(data-table): make formatted dttm the default (@villebro)
- [#20104](https://github.com/apache/superset/pull/20104) chore: fix INTHEWILD sort order and indentation (@villebro)
- [#20093](https://github.com/apache/superset/pull/20093) chore: Add the tnum font property to Table components (@geido)
- [#20103](https://github.com/apache/superset/pull/20103) docs: Update INTHEWILD.md (@fccoelho)
- [#20102](https://github.com/apache/superset/pull/20102) chore: Update aiohttp to 3.8.1 (@diegomedina248)
- [#20066](https://github.com/apache/superset/pull/20066) chore: Set limit for a query in execute_sql_statement (@AAfghahi)
- [#20032](https://github.com/apache/superset/pull/20032) chore: Change copy to Edit chart in Dashboard dropdown (@geido)
- [#20071](https://github.com/apache/superset/pull/20071) chore: Fix and enhance Applitools workflows (@geido)
- [#19966](https://github.com/apache/superset/pull/19966) test: make tabbed dashboard a little more complex (@ktmud)
- [#19976](https://github.com/apache/superset/pull/19976) perf(plugin-chart-table): Add memoization to avoid rerenders (@kgabryje)
- [#20044](https://github.com/apache/superset/pull/20044) chore: Create a generic header component for Explore and Dashboard (@kgabryje)
- [#20046](https://github.com/apache/superset/pull/20046) docs: add changelog and updating entries for 1.5.0 (@villebro)
- [#19962](https://github.com/apache/superset/pull/19962) chore: add doc link for db migration conflict warning (@ktmud)
- [#20034](https://github.com/apache/superset/pull/20034) chore: Changes the no-literal-colors lint rule to throw errors instead of warnings (@michael-s-molina)
- [#20031](https://github.com/apache/superset/pull/20031) chore: Run Applitools + Cypress nightly (@geido)
- [#20006](https://github.com/apache/superset/pull/20006) chore: Removes hard-coded colors from the plugins - iteration 2 (@michael-s-molina)
- [#19130](https://github.com/apache/superset/pull/19130) refactor: Refactor reports for Charts and Dashboards (@AAfghahi)
- [#20016](https://github.com/apache/superset/pull/20016) chore: Removes hard-coded colors - iteration 3 (@michael-s-molina)
- [#19870](https://github.com/apache/superset/pull/19870) docs: Detail front-end development instructions (@EBoisseauSierra)
- [#19971](https://github.com/apache/superset/pull/19971) docs: Add config for running on a WSGI HTTP server (@thinhnd2104)
- [#20008](https://github.com/apache/superset/pull/20008) chore: Upgrades Storybook from 6.4.19 to 6.4.22 (@michael-s-molina)
- [#20009](https://github.com/apache/superset/pull/20009) docs: typo in chart-params markdown file (@JakobMiksch)
- [#19923](https://github.com/apache/superset/pull/19923) chore: Removes hard-coded colors from the plugins - iteration 1 (@michael-s-molina)
- [#19954](https://github.com/apache/superset/pull/19954) chore: convert URLShortLinkButton to typescript (@ktmud)
- [#19929](https://github.com/apache/superset/pull/19929) chore: change subject name from no_name to named for PNGs in (@AAfghahi)
- [#19942](https://github.com/apache/superset/pull/19942) refactor(ReportModal): simplify state reducer and improve error handling (@ktmud)
- [#19770](https://github.com/apache/superset/pull/19770) chore: remove druid datasource from the config (@eschutho)
- [#19911](https://github.com/apache/superset/pull/19911) chore: Fix broken link for DouroECI (@mavimo)
- [#19951](https://github.com/apache/superset/pull/19951) chore: Adds the theme object to chart properties (@michael-s-molina)
- [#19813](https://github.com/apache/superset/pull/19813) chore: get embedded user with roles and permissions (@suddjian)
- [#19897](https://github.com/apache/superset/pull/19897) chore: Adds a storybook to FilterableTable (@michael-s-molina)
- [#19924](https://github.com/apache/superset/pull/19924) chore(reports): Improving logging around failed scheduled reports (@craig-rueda)
- [#19906](https://github.com/apache/superset/pull/19906) revert: "fix(sql lab): display the 'View Results' button consistently in the history tab on sync mode" (@Gwitchr)
- [#19916](https://github.com/apache/superset/pull/19916) chore(deps): bump react-virtualized-auto-sizer from 1.0.2 to 1.0.6 in /superset-frontend (@dependabot[bot])
- [#19888](https://github.com/apache/superset/pull/19888) chore(deps): bump cross-fetch from 3.1.4 to 3.1.5 in /docs (@dependabot[bot])
- [#19894](https://github.com/apache/superset/pull/19894) chore(deps-dev): bump eslint-plugin-prettier from 3.3.1 to 4.0.0 in /superset-frontend (@dependabot[bot])
- [#19602](https://github.com/apache/superset/pull/19602) docs: Added gtag to docusaurus (@AAfghahi)
- [#19878](https://github.com/apache/superset/pull/19878) chore(deps-dev): bump @storybook/client-api from 6.4.19 to 6.4.22 in /superset-frontend (@dependabot[bot])
- [#19821](https://github.com/apache/superset/pull/19821) test(native filter): refactor and add new test (@jinghua-qa)
- [#19613](https://github.com/apache/superset/pull/19613) chore: Update line-height in SliceHeaderControl (@geido)
- [#19616](https://github.com/apache/superset/pull/19616) chore: Update font-sizes in DatabaseModal (@geido)
- [#19866](https://github.com/apache/superset/pull/19866) chore: fix explore pills (@villebro)
- [#19872](https://github.com/apache/superset/pull/19872) chore: Update aiohttp>=3.7.4 in requirements (@hughhhh)
- [#19874](https://github.com/apache/superset/pull/19874) chore: bump rockset>=0.8.10, <0.9 (@hughhhh)
- [#19864](https://github.com/apache/superset/pull/19864) chore(deps): bump react-syntax-highlighter from 15.4.5 to 15.5.0 in /superset-frontend (@dependabot[bot])
- [#19828](https://github.com/apache/superset/pull/19828) chore: add custom eslint plugin to prevent translation variables (@stephenLYZ)
- [#19845](https://github.com/apache/superset/pull/19845) chore(deps): bump react-split from 2.0.9 to 2.0.14 in /superset-frontend (@dependabot[bot])
- [#19846](https://github.com/apache/superset/pull/19846) chore(deps): bump d3-svg-legend from 1.13.0 to 2.25.6 in /superset-frontend (@dependabot[bot])
- [#19847](https://github.com/apache/superset/pull/19847) chore(deps-dev): bump eslint-plugin-jsx-a11y from 6.4.1 to 6.5.1 in /superset-frontend (@dependabot[bot])
- [#19853](https://github.com/apache/superset/pull/19853) chore(frontend-tests): Spelling (@jsoref)
- [#19823](https://github.com/apache/superset/pull/19823) docs: updated links for country map scripts (@ktmud)
- [#19829](https://github.com/apache/superset/pull/19829) chore(deps-dev): bump babel-loader from 8.2.4 to 8.2.5 in /superset-frontend (@dependabot[bot])
- [#19830](https://github.com/apache/superset/pull/19830) chore(deps): bump react-hot-loader from 4.12.20 to 4.13.0 in /superset-frontend (@dependabot[bot])
- [#19403](https://github.com/apache/superset/pull/19403) chore(deps-dev): bump babel-loader from 8.2.2 to 8.2.4 in /superset-frontend (@dependabot[bot])
- [#19637](https://github.com/apache/superset/pull/19637) chore(deps): bump moment from 2.29.1 to 2.29.2 in /superset-frontend (@dependabot[bot])
- [#19681](https://github.com/apache/superset/pull/19681) chore(deps): bump async from 3.2.0 to 3.2.3 in /superset-frontend/cypress-base (@dependabot[bot])
- [#19680](https://github.com/apache/superset/pull/19680) chore(deps): bump async from 3.2.0 to 3.2.3 in /superset-websocket (@dependabot[bot])
- [#19020](https://github.com/apache/superset/pull/19020) chore(deps): bump url-parse from 1.5.7 to 1.5.10 in /superset-frontend (@dependabot[bot])
- [#17978](https://github.com/apache/superset/pull/17978) chore(deps): bump @types/d3-time from 1.1.1 to 3.0.0 in /superset-frontend (@dependabot[bot])
- [#19727](https://github.com/apache/superset/pull/19727) chore(deps): bump async from 2.6.3 to 2.6.4 in /docs (@dependabot[bot])
- [#19551](https://github.com/apache/superset/pull/19551) chore(deps): bump minimist from 1.2.5 to 1.2.6 in /superset-websocket (@dependabot[bot])
- [#19165](https://github.com/apache/superset/pull/19165) chore: simplify error messaging in database modal (@pkdotson)
- [#19790](https://github.com/apache/superset/pull/19790) chore: bump postgres from 10 to 14 (@dpgaspar)
- [#19480](https://github.com/apache/superset/pull/19480) chore: Update UPDATING.md (@john-bodley)
- [#19740](https://github.com/apache/superset/pull/19740) chore: fix grammar error (@zhaoyongjie)
- [#19703](https://github.com/apache/superset/pull/19703) chore(build): upgrade less-loader (@ktmud)
- [#19736](https://github.com/apache/superset/pull/19736) chore: Updates the Select code owners (@michael-s-molina)
- [#19715](https://github.com/apache/superset/pull/19715) docs(install): ubuntu default-libmysqlclient-dev (@cemremengu)
- [#19726](https://github.com/apache/superset/pull/19726) chore: bumping shillelagh (@AAfghahi)
- [#19699](https://github.com/apache/superset/pull/19699) chore: fix typo (@betodealmeida)
- [#19674](https://github.com/apache/superset/pull/19674) chore: upgrade Pillow (@betodealmeida)
- [#19647](https://github.com/apache/superset/pull/19647) chore(explore): Change labels "Group by"/"Series" to "Dimensions" (@kgabryje)
- [#19679](https://github.com/apache/superset/pull/19679) chore(deps): bump urijs from 1.19.8 to 1.19.11 in /superset-frontend (@dependabot[bot])
- [#19638](https://github.com/apache/superset/pull/19638) chore(deps): bump moment from 2.29.1 to 2.29.2 in /docs (@dependabot[bot])
- [#19617](https://github.com/apache/superset/pull/19617) chore: updated two github issue templates (@srinify)
- [#19666](https://github.com/apache/superset/pull/19666) chore: Remove TwoTone icons (@geido)
- [#19614](https://github.com/apache/superset/pull/19614) chore: Remove wrong usage of font-size in ExploreViewContainer (@geido)
- [#19593](https://github.com/apache/superset/pull/19593) chore: Update font-sizes in ReportModal (@geido)
- [#19611](https://github.com/apache/superset/pull/19611) chore: Update font-sizes in ImportModal (@geido)
- [#19615](https://github.com/apache/superset/pull/19615) chore: Update font-sizes in AlertReportModal (@geido)
- [#19620](https://github.com/apache/superset/pull/19620) chore: Update font-sizes in QueryPreviewModal (@geido)
- [#19641](https://github.com/apache/superset/pull/19641) chore: clean up dynamic translation strings (@villebro)
- [#19635](https://github.com/apache/superset/pull/19635) refactor: consistent migration tests organization (@ktmud)
- [#19634](https://github.com/apache/superset/pull/19634) test: freeze time for dashboard export test (@ktmud)
- [#19606](https://github.com/apache/superset/pull/19606) test(jinja): refactor to functional tests (@villebro)
- [#19587](https://github.com/apache/superset/pull/19587) chore: cleanup as unknown conversion (@zhaoyongjie)
- [#19562](https://github.com/apache/superset/pull/19562) refactor: Removes the CSS files from the Horizon plugin (@michael-s-molina)
- [#19563](https://github.com/apache/superset/pull/19563) refactor: Removes the CSS files from the Paired T-Test plugin (@michael-s-molina)
- [#19539](https://github.com/apache/superset/pull/19539) refactor: Removes the CSS files from the Parallel Coordinates plugin (@michael-s-molina)
- [#19521](https://github.com/apache/superset/pull/19521) refactor: Removes the CSS files from the Partition plugin (@michael-s-molina)
- [#19493](https://github.com/apache/superset/pull/19493) chore: Removes hard-coded colors from legacy-plugin-chart-sankey (@michael-s-molina)
- [#19462](https://github.com/apache/superset/pull/19462) chore: Remove FilterBox.less (@geido)
- [#19438](https://github.com/apache/superset/pull/19438) chore: Remove crud.less from Datasource (@geido)
- [#19517](https://github.com/apache/superset/pull/19517) chore: Enhance ReactChord style with theme vars (@geido)
- [#19463](https://github.com/apache/superset/pull/19463) chore: Remove TimeTable.less (@geido)
- [#19550](https://github.com/apache/superset/pull/19550) chore(deps): bump minimist from 1.2.5 to 1.2.6 in /superset-embedded-sdk (@dependabot[bot])
- [#19566](https://github.com/apache/superset/pull/19566) chore(deps): bump node-forge from 1.2.1 to 1.3.1 in /docs (@dependabot[bot])
- [#19552](https://github.com/apache/superset/pull/19552) chore(deps): bump minimist from 1.2.5 to 1.2.6 in /docs (@dependabot[bot])
- [#19549](https://github.com/apache/superset/pull/19549) chore(deps): bump minimist from 1.2.5 to 1.2.6 in /superset-frontend/cypress-base (@dependabot[bot])
- [#19559](https://github.com/apache/superset/pull/19559) docs: update the typo in the documentation (@fatosmorina)
- [#19538](https://github.com/apache/superset/pull/19538) refactor: Removes the CSS files from the Country Map plugin (@michael-s-molina)
- [#19536](https://github.com/apache/superset/pull/19536) chore: Removes hard-coded opacity and spacing from the BigNumber plugin (@michael-s-molina)
- [#19494](https://github.com/apache/superset/pull/19494) refactor: Removes the CSS files from the Sankey Loop plugin (@michael-s-molina)
- [#19492](https://github.com/apache/superset/pull/19492) chore: Remove Legacy Force Directed viz plugin (@geido)
- [#19524](https://github.com/apache/superset/pull/19524) chore: Deprecating /my_queries endpoint (@AAfghahi)
- [#19467](https://github.com/apache/superset/pull/19467) chore(Explore): Change text when saving a chart in a new dashboard (@geido)
- [#19526](https://github.com/apache/superset/pull/19526) chore(database): Creating helper make_url_safe to wrap potential errors (@craig-rueda)
- [#19415](https://github.com/apache/superset/pull/19415) chore: Remove Control.less in Explore (@geido)
- [#19413](https://github.com/apache/superset/pull/19413) chore: Remove unused less file from profile (@geido)
- [#19460](https://github.com/apache/superset/pull/19460) chore: Switch to gender neutral terms (@inclusive-coding-bot)
- [#19486](https://github.com/apache/superset/pull/19486) refactor: Removes the CSS files from the Treemap plugin (@michael-s-molina)
- [#19488](https://github.com/apache/superset/pull/19488) refactor: Removes the CSS files from the Sunburst plugin (@michael-s-molina)
- [#19490](https://github.com/apache/superset/pull/19490) chore: Add theme color to ParallelCoordinates (@geido)
- [#19442](https://github.com/apache/superset/pull/19442) chore: Remove FilterbaleTableStyles.less (@geido)
- [#19441](https://github.com/apache/superset/pull/19441) chore: Remove StyledQueryButton.less (@geido)
- [#19473](https://github.com/apache/superset/pull/19473) refactor: Removes the CSS files from the Rose plugin (@michael-s-molina)
- [#19466](https://github.com/apache/superset/pull/19466) chore: Removes hard-coded colors from legacy-plugin-chart-world-map (@michael-s-molina)
- [#19465](https://github.com/apache/superset/pull/19465) refactor: Removes the CSS files from the DeckGL plugin (@michael-s-molina)
- [#19440](https://github.com/apache/superset/pull/19440) chore: Remove index.less from showSavedQuery (@geido)
- [#19230](https://github.com/apache/superset/pull/19230) chore!: remove `ROW_LEVEL_SECURITY` feature flag (permanently enable) (@suddjian)
- [#19361](https://github.com/apache/superset/pull/19361) chore: remove deprecated config keys and endpoints code 2.0 (@pkdotson)
- [#19261](https://github.com/apache/superset/pull/19261) chore: remove old alerts and configs keys (@pkdotson)
- [#19168](https://github.com/apache/superset/pull/19168) chore: bump celery and Flask (@dpgaspar)
- [#19049](https://github.com/apache/superset/pull/19049) chore: Remove logo forced width (@geido)
- [#19274](https://github.com/apache/superset/pull/19274) chore: remove PUBLIC_ROLE_LIKE_GAMMA deprecated config key (@dpgaspar)
- [#19273](https://github.com/apache/superset/pull/19273) chore: remove deprecated celery cli (@dpgaspar)
- [#19262](https://github.com/apache/superset/pull/19262) chore: update updating with druid no sql deprecation (@eschutho)
- [#19083](https://github.com/apache/superset/pull/19083) chore!: update mutator to take kwargs (@eschutho)
- [#19231](https://github.com/apache/superset/pull/19231) chore!: remove `ENABLE_REACT_CRUD_VIEWS` feature flag (permanently enable) (@suddjian)
- [#19241](https://github.com/apache/superset/pull/19241) chore(superset 2.0): remove front-end deprecated code (@graceguo-supercat)
- [#19107](https://github.com/apache/superset/pull/19107) chore: turn on SQLLAB_BACKEND_PERSISTENCE by default (@ktmud)
- [#19142](https://github.com/apache/superset/pull/19142) chore!: turn on Versioned Export in config.py (@AAfghahi)
- [#19108](https://github.com/apache/superset/pull/19108) chore: Update UPDATING.md with info about flipping dnd feature flag (@kgabryje)
- [#19146](https://github.com/apache/superset/pull/19146) chore!: Remove remove SQLALCHEMY_DOCS_URL and SQLALCHEMY_DISPLAY_TEXT from the config from the config (@hughhhh)
- [#19017](https://github.com/apache/superset/pull/19017) chore: Deprecate Python 3.7 (@john-bodley)
- [#19113](https://github.com/apache/superset/pull/19113) chore(config): Migrating `ENABLE_JAVASCRIPT_CONTROLS` from app config to a feature flag (@rusackas)
- [#19046](https://github.com/apache/superset/pull/19046) chore(explore): Set Drag&Drop feature flags to True by default (@kgabryje)
- [#19016](https://github.com/apache/superset/pull/19016) chore: Adding PR to Updating.md (@AAfghahi)
- [#18970](https://github.com/apache/superset/pull/18970) chore: Change Dataset legacy editor flag to true (@AAfghahi)

### 1.5.1 (Thu May 26 14:45:20 2022 +0300)

**Fixes**

- [#19685](https://github.com/apache/superset/pull/19685) fix: login button does not render (@villebro)
- [#20181](https://github.com/apache/superset/pull/20181) fix(temporary-cache): when user is anonymous (@villebro)
- [#20091](https://github.com/apache/superset/pull/20091) fix: "Week Staring Monday" time grain for BigQuery (@ramunas-omnisend)
- [#20135](https://github.com/apache/superset/pull/20135) fix: Allow dataset owners to see their datasets (@cccs-tom)
- [#20123](https://github.com/apache/superset/pull/20123) fix(presto,trino): use correct literal dttm separator (@villebro)
- [#20077](https://github.com/apache/superset/pull/20077) fix(generic-axes): apply contribution before flatten (@villebro)
- [#19970](https://github.com/apache/superset/pull/19970) fix: Athena timestamp literal format (@thinhnd2104)
- [#20055](https://github.com/apache/superset/pull/20055) fix(plugin-chart-echarts): support adhoc x-axis (@villebro)
- [#18873](https://github.com/apache/superset/pull/18873) fix(sqllab/charts): casting from timestamp[us] to timestamp[ns] would result in out of bounds timestamp (@yeachan153)
- [#19917](https://github.com/apache/superset/pull/19917) fix(sqla): replace custom dttm type with literal_column (@villebro)
- [#19854](https://github.com/apache/superset/pull/19854) fix: Alpha should not be able to edit datasets that they don't own (@hughhhh)

### 1.5.0 (Fri Apr 22 17:23:30 2022 -0400)

- **Database Migrations**
- [#19805](https://github.com/apache/superset/pull/19805) fix(key_value): use longblob on mysql (@villebro)
- [#19543](https://github.com/apache/superset/pull/19543) fix(migrations): reorder skipped 1.4 migrations (@villebro)
- [#19416](https://github.com/apache/superset/pull/19416) perf: improve perf in SIP-68 migration (@betodealmeida)
- [#19225](https://github.com/apache/superset/pull/19225) fix(sql lab): deleting the last saved query or the last executed from history (@diegomedina248)
- [#19078](https://github.com/apache/superset/pull/19078) feat: add permalink to dashboard and explore (@villebro)
- [#18998](https://github.com/apache/superset/pull/18998) fix(plugin-chart-echarts): Apply temporary filters to Query B in explore (@kgabryje)
- [#19022](https://github.com/apache/superset/pull/19022) fix: remove unneeded complexity in migration (@betodealmeida)
- [#18992](https://github.com/apache/superset/pull/18992) fix(sqllab): Replace stringified 'null' schema column values with NULL (@john-bodley)
- [#18948](https://github.com/apache/superset/pull/18948) fix(dataset): handle missing database in migration (@villebro)
- [#17543](https://github.com/apache/superset/pull/17543) feat: new dataset/table/column models (@betodealmeida)
- [#18561](https://github.com/apache/superset/pull/18561) feat: embedded dashboard (@lilykuang)
- [#18093](https://github.com/apache/superset/pull/18093) feat: allow assets to be managed externally (@betodealmeida)
- [#17925](https://github.com/apache/superset/pull/17925) refactor: Migration for Tabbed Sql Editor (@AAfghahi)
- [#17928](https://github.com/apache/superset/pull/17928) fix: force_screenshot migration (@betodealmeida)
- [#17853](https://github.com/apache/superset/pull/17853) feat: add force option to report screenshots (@betodealmeida)
- [#17803](https://github.com/apache/superset/pull/17803) feat(plugin-chart-pivot-table): support series limit (@kgabryje)
- [#17587](https://github.com/apache/superset/pull/17587) chore(explore): Migrate BigNumber to v1 api [ID-28][id-55] (@kgabryje)
- [#17360](https://github.com/apache/superset/pull/17360) fix: Change datatype of column type in BaseColumn to allow larger datatype names for complexed columns (@cccs-joel)
- [#17728](https://github.com/apache/superset/pull/17728) fix: migration out-of-scope bind (@betodealmeida)
- [#17604](https://github.com/apache/superset/pull/17604) feat(alerts): Column for select tabs to send (@m-ajay)
- [#17323](https://github.com/apache/superset/pull/17323) fix: rename to schemas_allowed_for_file_upload in dbs.extra (@exemplary-citizen)
- [#17275](https://github.com/apache/superset/pull/17275) fix: drop check constraint on dbs to rename column (@betodealmeida)
- [#16756](https://github.com/apache/superset/pull/16756) refactor: Repeated boilerplate code between upload to database forms (@exemplary-citizen)

**Features**

- [#19776](https://github.com/apache/superset/pull/19776) feat: add renameOperator (@zhaoyongjie)
- [#19328](https://github.com/apache/superset/pull/19328) feat(sql lab): enable ACE editor search in SQL editors (@diegomedina248)
- [#19454](https://github.com/apache/superset/pull/19454) feat: improve adhoc SQL validation (@betodealmeida)
- [#19364](https://github.com/apache/superset/pull/19364) feat: Embedded dashboard configuration (@suddjian)
- [#19344](https://github.com/apache/superset/pull/19344) feat: disable edits on external assets (@betodealmeida)
- [#19393](https://github.com/apache/superset/pull/19393) feat: linear imputation in Resample (@zhaoyongjie)
- [#19259](https://github.com/apache/superset/pull/19259) feat(explore): Dataset panel option tooltips (@kgabryje)
- [#19324](https://github.com/apache/superset/pull/19324) feat: introduce hashids permalink keys (@villebro)
- [#19315](https://github.com/apache/superset/pull/19315) feat: import external management columns (@betodealmeida)
- [#19317](https://github.com/apache/superset/pull/19317) feat: add duckdb as DataSource - Fixes #14563 (@rwhaling)
- [#19318](https://github.com/apache/superset/pull/19318) feat: external management flags in CRUD (@betodealmeida)
- [#19116](https://github.com/apache/superset/pull/19116) feat(advanced analysis): support MultiIndex column in post processing stage (@zhaoyongjie)
- [#19289](https://github.com/apache/superset/pull/19289) feat: Implements Docusearch into docusaurus docs (@AAfghahi)
- [#19220](https://github.com/apache/superset/pull/19220) feat: API for asset sync (@betodealmeida)
- [#18953](https://github.com/apache/superset/pull/18953) feat: allow uploads in crud view (@pkdotson)
- [#19232](https://github.com/apache/superset/pull/19232) feat(key-value): add superset metastore cache (@villebro)
- [#19144](https://github.com/apache/superset/pull/19144) feat: SupersetClient config to override 401 behavior (@suddjian)
- [#19038](https://github.com/apache/superset/pull/19038) feat: improve color consistency (save all labels) (@stephenLYZ)
- [#19248](https://github.com/apache/superset/pull/19248) feat: add support for comments in adhoc clauses (@villebro)
- [#19217](https://github.com/apache/superset/pull/19217) feat: import/export assets commands (@betodealmeida)
- [#19141](https://github.com/apache/superset/pull/19141) feat(ui): Adding manifest prefix config (@craig-rueda)
- [#19104](https://github.com/apache/superset/pull/19104) feat(sqllab): Add a configuration option to disable data preview (@cccs-Dustin)
- [#19053](https://github.com/apache/superset/pull/19053) feat: scroll to bottom when adding a new native filter and the page is filled (@diegomedina248)
- [#19215](https://github.com/apache/superset/pull/19215) feat: add export_related flag (@betodealmeida)
- [#19055](https://github.com/apache/superset/pull/19055) feat: helper functions for RLS (@betodealmeida)
- [#19085](https://github.com/apache/superset/pull/19085) feat(select): keep options order when not in async mode (@ktmud)
- [#19031](https://github.com/apache/superset/pull/19031) feat(embedded): add optional dashboard ui configuration (@lilykuang)
- [#18662](https://github.com/apache/superset/pull/18662) feat(viz-gallery): add 'feature' tag and fuzzy search weighting (@stephenLYZ)
- [#18856](https://github.com/apache/superset/pull/18856) feat(select): sort exact and startsWith match to first (@ktmud)
- [#18795](https://github.com/apache/superset/pull/18795) feat: Allow users to bust cache in report dashboard + alerts charts + alert dashboards (@hughhhh)
- [#18793](https://github.com/apache/superset/pull/18793) feat: Adds support to multiple dependencies to the native filters (@michael-s-molina)
- [#18799](https://github.com/apache/superset/pull/18799) feat: remove loading indicator when typing in select (@ktmud)
- [#19004](https://github.com/apache/superset/pull/19004) feat: show user email in dashboard API (@betodealmeida)
- [#18896](https://github.com/apache/superset/pull/18896) feat(TimeTableViz): sort by first metric (@serenajiang)
- [#18945](https://github.com/apache/superset/pull/18945) feat(legacy-preset-chart-deckgl): Add ,.1f and ,.2f value formats to deckgl charts (@kgabryje)
- [#18722](https://github.com/apache/superset/pull/18722) feat: DBC-UI Globally available across the app 🌎 (@hughhhh)
- [#18773](https://github.com/apache/superset/pull/18773) feat: On window focus, redirect to login if the user has been logged out (@suddjian)
- [#18848](https://github.com/apache/superset/pull/18848) feat(helm): allow adding pod labels (@vuongxuongminh)
- [#18874](https://github.com/apache/superset/pull/18874) feat(native-filters): Implement filter cards (@kgabryje)
- [#18876](https://github.com/apache/superset/pull/18876) feat(native-filters): Don't scroll main window when scrolling filter bar (@kgabryje)
- [#18784](https://github.com/apache/superset/pull/18784) feat(native-filters): Re-arrange controls in FilterBar (@kgabryje)
- [#18745](https://github.com/apache/superset/pull/18745) feat(maps): Adding country maps: BI/ET/RW/TZ/UG (+updated NG) (@Yann-J)
- [#18748](https://github.com/apache/superset/pull/18748) feat(embedded): make guest token JWT audience callable or str (@lilykuang)
- [#18576](https://github.com/apache/superset/pull/18576) feat: Improve state key generation for dashboards and charts (@michael-s-molina)
- [#18651](https://github.com/apache/superset/pull/18651) feat(embedded): aud claim and type for guest token (@lilykuang)
- [#18678](https://github.com/apache/superset/pull/18678) feat(explore): Implement chart empty states (@kgabryje)
- [#18681](https://github.com/apache/superset/pull/18681) feat(explore): Implement metrics and columns popovers empty states (@kgabryje)
- [#18712](https://github.com/apache/superset/pull/18712) feat(dashboard): Implement empty states for dashboard (@kgabryje)
- [#18679](https://github.com/apache/superset/pull/18679) feat(explore): Implement data table empty states (@kgabryje)
- [#18652](https://github.com/apache/superset/pull/18652) feat: Introduce a library for embedded iframe <-> host communication (@suddjian)
- [#18676](https://github.com/apache/superset/pull/18676) feat: Implement EmptyState components (@kgabryje)
- [#18653](https://github.com/apache/superset/pull/18653) feat: add prop to `setDBEngine` in DatabaseModal (@hughhhh)
- [#18642](https://github.com/apache/superset/pull/18642) feat(Helm): Redis with password supported in helm charts and redis chart version updated (@wiktor2200)
- [#18649](https://github.com/apache/superset/pull/18649) feat(helm): allow to customize init image (@avakarev)
- [#18626](https://github.com/apache/superset/pull/18626) feat: editable title xl certified badge (@opus-42)
- [#18624](https://github.com/apache/superset/pull/18624) feat: Improves key expiration handling in Explore (@michael-s-molina)
- [#17208](https://github.com/apache/superset/pull/17208) feat: Dynamic dashboard component (@simcha90)
- [#18064](https://github.com/apache/superset/pull/18064) feat: datasource access to allow more granular access to tables on SQL Lab (@Painyjames)
- [#18569](https://github.com/apache/superset/pull/18569) feat(explore): Allow using time formatter on temporal columns in data table (@kgabryje)
- [#18618](https://github.com/apache/superset/pull/18618) feat(chart-data-api): download multiple csvs as zip (@villebro)
- [#18620](https://github.com/apache/superset/pull/18620) feat: log decorator util - adding automatic logs out of the box (@ofekisr)
- [#18080](https://github.com/apache/superset/pull/18080) feat: smart tooltip in datasourcepanel (@zhaoyongjie)
- [#18250](https://github.com/apache/superset/pull/18250) feat: Embedded SDK (@suddjian)
- [#18560](https://github.com/apache/superset/pull/18560) feat: 🚀 Docs V2 CI Script (@hughhhh)
- [#18215](https://github.com/apache/superset/pull/18215) feat(explore): Keep or reset chart config after datasource change (@kgabryje)
- [#18190](https://github.com/apache/superset/pull/18190) feat: Added success toasts for database, dataset, chart, dashboard, and query imports (@lyndsiWilliams)
- [#18214](https://github.com/apache/superset/pull/18214) feat(docker-compose): add TAG option (@villebro)
- [#17411](https://github.com/apache/superset/pull/17411) feat: Upgrade documentation V2 (@hughhhh)
- [#18169](https://github.com/apache/superset/pull/18169) feat: Add toast for successful table or schema refreshes in Sqllab (@hughhhh)
- [#18183](https://github.com/apache/superset/pull/18183) feat: add success message for database modal (@pkdotson)
- [#17530](https://github.com/apache/superset/pull/17530) feat: embedded dashboard core (@suddjian)
- [#18161](https://github.com/apache/superset/pull/18161) feat(helm): Add schema of values in Helm Chart (@ad-m)
- [#18108](https://github.com/apache/superset/pull/18108) feat(explore): more toast feedback on user actions in Explore (@kgabryje)
- [#18114](https://github.com/apache/superset/pull/18114) feat(dashboard): add toast feedback to dashboard actions (@kgabryje)
- [#18116](https://github.com/apache/superset/pull/18116) feat: add toast feedback to annotation templates (@kgabryje)
- [#18081](https://github.com/apache/superset/pull/18081) feat(country-map): added new countries in country-chart-map (@Hammad-Raza)
- [#17917](https://github.com/apache/superset/pull/17917) feat(plugin-chart-echarts): support non-timeseries x-axis (@villebro)
- [#17882](https://github.com/apache/superset/pull/17882) feat: Adds a key-value endpoint to store charts form data (@michael-s-molina)
- [#17207](https://github.com/apache/superset/pull/17207) feat: add chart description in info tooltip (@stephenLYZ)
- [#18045](https://github.com/apache/superset/pull/18045) feat(advanced analytics): support groupby in resample (@zhaoyongjie)
- [#17593](https://github.com/apache/superset/pull/17593) feat: Trino Authentications (@dungdm93)
- [#18041](https://github.com/apache/superset/pull/18041) feat: stop running CI on doc updates (@hughhhh)
- [#18001](https://github.com/apache/superset/pull/18001) feat: shorter timeout on test_connection (@betodealmeida)
- [#17758](https://github.com/apache/superset/pull/17758) feat(timeseries-chart): add percentage threshold input control (@corbinrobb)
- [#18007](https://github.com/apache/superset/pull/18007) feat(chart): add Mexico to country map viz (@ktmud)
- [#17749](https://github.com/apache/superset/pull/17749) feat(alerts): Select tabs to send backend (@m-ajay)
- [#17968](https://github.com/apache/superset/pull/17968) feat: update time comparison choices (again) (@serenajiang)
- [#17898](https://github.com/apache/superset/pull/17898) feat: Add support for Azure Data Explorer (Kusto) db engine spec (@Ceridan)
- [#17804](https://github.com/apache/superset/pull/17804) feat: Update query states to use spinner vs. progress bar (@hughhhh)
- [#17880](https://github.com/apache/superset/pull/17880) feat: Helm - custom service account creation and management (@wiktor2200)
- [#17855](https://github.com/apache/superset/pull/17855) feat: configure force_screenshot (@betodealmeida)
- [#17695](https://github.com/apache/superset/pull/17695) feat: bypass cache on screenshots for alerts (@betodealmeida)
- [#17708](https://github.com/apache/superset/pull/17708) feat: Persist SQL Lab autocomplete setting across tabs and visits (@etr2460)
- [#17776](https://github.com/apache/superset/pull/17776) feat: don't ask for password when DB exists (@betodealmeida)
- [#17739](https://github.com/apache/superset/pull/17739) feat: add main datetime column to dataset editor (@betodealmeida)
- [#17734](https://github.com/apache/superset/pull/17734) feat: Update makefile with frontend build (@hughhhh)
- [#17655](https://github.com/apache/superset/pull/17655) feat: convert dataframe tests (@betodealmeida)
- [#17589](https://github.com/apache/superset/pull/17589) feat: customize recent activity access (@villebro)
- [#17658](https://github.com/apache/superset/pull/17658) feat(prophet): enable confidence intervals and y_hat without forecast (@exemplary-citizen)
- [#17657](https://github.com/apache/superset/pull/17657) feat(viz): export csv with verbose_name (@chuancyzhang)
- [#17512](https://github.com/apache/superset/pull/17512) feat(explore): export csv data pivoted for Pivot Table [ID-9] (@kgabryje)
- [#17307](https://github.com/apache/superset/pull/17307) feat(explore): support show annotation label [ID-8] (@stephenLYZ)
- [#17615](https://github.com/apache/superset/pull/17615) feat(legacy-preset-chart-nvd3): add richtooltip in nvd3 bar chart (@stephenLYZ)
- [#17372](https://github.com/apache/superset/pull/17372) feat: Add single select and inverse selection to numeric range (#16722) (@mhoustonataegis)
- [#17536](https://github.com/apache/superset/pull/17536) feat: Adds a key-value endpoint to store the state of dashboard filters (@michael-s-molina)
- [#17581](https://github.com/apache/superset/pull/17581) feat: added option to set pod annotations on init-db pod to Helm chart. (@caviliar)
- [#17554](https://github.com/apache/superset/pull/17554) feat: add classNames for apply and clearAll buttons for superset filters (@Nithin-George-Philips)
- [#16346](https://github.com/apache/superset/pull/16346) feat: trino support server-cert (@dungdm93)
- [#17410](https://github.com/apache/superset/pull/17410) feat(dashboard): Add divider component in native filters (@m-ajay)
- [#17409](https://github.com/apache/superset/pull/17409) feat: add a config to enable retina quality images in screenshots (@eschutho)
- [#17379](https://github.com/apache/superset/pull/17379) feat(explore): adhoc column expressions [ID-3] (@villebro)
- [#17416](https://github.com/apache/superset/pull/17416) feat: Add quarter unit to datetrunc (@john-bodley)
- [#16992](https://github.com/apache/superset/pull/16992) feat(native_filter_migration): add transition mode (@graceguo-supercat)
- [#17202](https://github.com/apache/superset/pull/17202) feat(metrics): Provide override for disabling ad-hoc metrics (@john-bodley)
- [#17336](https://github.com/apache/superset/pull/17336) feat: apply d3NumberFormat to table reports (@betodealmeida)
- [#17329](https://github.com/apache/superset/pull/17329) feat: improve logic in is_select (@betodealmeida)
- [#17252](https://github.com/apache/superset/pull/17252) feat: add possibility to set ingress class name in Helm chart (@Jolcik)
- [#17237](https://github.com/apache/superset/pull/17237) feat: Make Jinja template applied in timestamp columns (@xingyc15)
- [#17025](https://github.com/apache/superset/pull/17025) feat(dashboard): Add description to the native filter (@m-ajay)
- [#17157](https://github.com/apache/superset/pull/17157) feat: Hide nav create with RBAC (@hughhhh)
- [#17177](https://github.com/apache/superset/pull/17177) feat: support disabling domain sharding with a query param (@etr2460)
- [#17134](https://github.com/apache/superset/pull/17134) feat: Add prettier to pre-commit workflow (@hughhhh)
- [#17055](https://github.com/apache/superset/pull/17055) feat(Filter-sets): connect to api (@simcha90)
- [#16856](https://github.com/apache/superset/pull/16856) feat: DBC UI Snowflake Form (@hughhhh)
- [#16154](https://github.com/apache/superset/pull/16154) feat(dashboard): Let users re-arrange native filters (@m-ajay)
- [#17039](https://github.com/apache/superset/pull/17039) feat(config): Add none force-refresh option for auto refresh (@yongchand)
- [#17001](https://github.com/apache/superset/pull/17001) feat(linting): restrict direct use of supersetTheme in favor of ThemeProvider (@rusackas)

**Fixes**

- [#19448](https://github.com/apache/superset/pull/19448) fix(sql lab): when editing a saved query, the status is lost when switching tabs (@diegomedina248)
- [#19806](https://github.com/apache/superset/pull/19806) fix(plugin-chart-table): Fix display of column config in table chart (@kgabryje)
- [#19802](https://github.com/apache/superset/pull/19802) fix: lost renameOperator in mixed timeseries chart (@zhaoyongjie)
- [#19765](https://github.com/apache/superset/pull/19765) fix(chart & explore): Show labels for `SliderControl` (@prosdev0107)
- [#16619](https://github.com/apache/superset/pull/16619) fix: dashboard standalone class not added when parameter set (@trepmag)
- [#19783](https://github.com/apache/superset/pull/19783) fix: SQL Lab UI Error: Objects are not valid as a React child (@diegomedina248)
- [#19370](https://github.com/apache/superset/pull/19370) fix(sql lab): replace the output column in the query history table (@diegomedina248)
- [#19772](https://github.com/apache/superset/pull/19772) fix(dashboard): copy permalink to dashboard chart (@villebro)
- [#19603](https://github.com/apache/superset/pull/19603) fix(explore): make to show the null value as N/A in view result (@prosdev0107)
- [#19749](https://github.com/apache/superset/pull/19749) fix(permalink): remove memoize on get salt func (@villebro)
- [#19698](https://github.com/apache/superset/pull/19698) fix: Filter dependencies are not being applied in default values (@michael-s-molina)
- [#19651](https://github.com/apache/superset/pull/19651) fix(dnd&column): make to fix the blank state issue when only one column select (@prosdev0107)
- [#19716](https://github.com/apache/superset/pull/19716) fix: drop the first level of MultiIndex (@zhaoyongjie)
- [#19688](https://github.com/apache/superset/pull/19688) fix(dashboard): Fix BigNumber causing dashboard to crash when overflowing (@kgabryje)
- [#19664](https://github.com/apache/superset/pull/19664) fix(sql-lab): do not replace undefined schema with empty object (@villebro)
- [#19659](https://github.com/apache/superset/pull/19659) fix: time comparision (@zhaoyongjie)
- [#19553](https://github.com/apache/superset/pull/19553) fix(dataset): handle missing python_type gracefully (@villebro)
- [#19612](https://github.com/apache/superset/pull/19612) fix(select): render when empty multiselect (@villebro)
- [#19565](https://github.com/apache/superset/pull/19565) fix(sqla): apply jinja to metrics (@villebro)
- [#19582](https://github.com/apache/superset/pull/19582) fix(dataset): avoid crash if database missing (@villebro)
- [#19542](https://github.com/apache/superset/pull/19542) fix: big number with trendline can't calculate cumsum (@zhaoyongjie)
- [#19548](https://github.com/apache/superset/pull/19548) fix(sqllab): null database with backend persistence (@villebro)
- [#19409](https://github.com/apache/superset/pull/19409) fix(dashboard list): do not show favorite star for anonymous users #18210 (@dudasaron)
- [#19483](https://github.com/apache/superset/pull/19483) fix: flaky test for charts changed on (@zhaoyongjie)
- [#19366](https://github.com/apache/superset/pull/19366) fix: can't sync temporal flag on virtual table (@zhaoyongjie)
- [#19456](https://github.com/apache/superset/pull/19456) fix: request samples with default row limit (@villebro)
- [#19252](https://github.com/apache/superset/pull/19252) fix(drill): specify an SA URL parm of `impersonation_target` for drill+sadrill (@jnturton)
- [#19372](https://github.com/apache/superset/pull/19372) fix(dashboard): make to show the correct owned objects (@prosdev0107)
- [#19452](https://github.com/apache/superset/pull/19452) fix: can't save dataset modal (@zhaoyongjie)
- [#19435](https://github.com/apache/superset/pull/19435) fix: missing init on importexport pkg (@dpgaspar)
- [#19428](https://github.com/apache/superset/pull/19428) fix: add missing init on python pkg key_value (@dpgaspar)
- [#19337](https://github.com/apache/superset/pull/19337) fix(database): make to allow the expose db as default in sqlalchemy form db (@prosdev0107)
- [#19321](https://github.com/apache/superset/pull/19321) fix(readme): fix add-driver-docker url in Readme (@jqueguiner)
- [#19369](https://github.com/apache/superset/pull/19369) fix(caching): support metastore cache for non-required caches (@villebro)
- [#19010](https://github.com/apache/superset/pull/19010) fix(explore-sqllab): make that Timestamp column keep the Is temporal … (@prosdev0107)
- [#19351](https://github.com/apache/superset/pull/19351) fix: number format should editable in time comparison (@zhaoyongjie)
- [#19122](https://github.com/apache/superset/pull/19122) fix(report-add): make to add error toast message when already attached report is added again into dashboard or chart (@prosdev0107)
- [#19138](https://github.com/apache/superset/pull/19138) fix: Remove gap from SQLLab results bottom (@codemaster08240328)
- [#19355](https://github.com/apache/superset/pull/19355) fix: Fix NoAuthorizationError in /me endpoint (@geido)
- [#19359](https://github.com/apache/superset/pull/19359) fix: [Explore] Adaptive formatting spelling (@kasiazjc)
- [#19346](https://github.com/apache/superset/pull/19346) fix: typo (@etr2460)
- [#19341](https://github.com/apache/superset/pull/19341) fix: Null values on Explore filter (@michael-s-molina)
- [#19338](https://github.com/apache/superset/pull/19338) fix(docs): spelling (@ndbu)
- [#19339](https://github.com/apache/superset/pull/19339) fix(embedded): download chart as image (@lilykuang)
- [#19327](https://github.com/apache/superset/pull/19327) fix(dashboard): Chart stuck in loading state when when datasets request and chart request fail (@kgabryje)
- [#19316](https://github.com/apache/superset/pull/19316) fix(explore): make to convert null to N/A in view results (@prosdev0107)
- [#19326](https://github.com/apache/superset/pull/19326) fix: regression on Select component when handling null values (@diegomedina248)
- [#18741](https://github.com/apache/superset/pull/18741) fix(dashboard): fix default filter bar visibility + add docs (@villebro)
- [#19305](https://github.com/apache/superset/pull/19305) fix(cache): only warn about fallback cache for non-debug mode (@villebro)
- [#19283](https://github.com/apache/superset/pull/19283) fix: Don't allow duplicated tag values in the Select (@michael-s-molina)
- [#19296](https://github.com/apache/superset/pull/19296) fix: default toast position (@suddjian)
- [#19258](https://github.com/apache/superset/pull/19258) fix(sql lab): most recently selected table should appear at the top of the list on the left panel (@diegomedina248)
- [#19223](https://github.com/apache/superset/pull/19223) fix(dashboard): make to show the correct owned objects (@prosdev0107)
- [#19263](https://github.com/apache/superset/pull/19263) fix(presto/trino): Add TIME/TIMESTAMP WITH TIME ZONE (@john-bodley)
- [#19269](https://github.com/apache/superset/pull/19269) fix: write new dataset on update table if it doesn't exist (@eschutho)
- [#19069](https://github.com/apache/superset/pull/19069) fix: custom SQL in Sort By Breaks Bar Chart (@diegomedina248)
- [#19140](https://github.com/apache/superset/pull/19140) fix(chart-crud): make to update Viz type Filter label to Chart type (@prosdev0107)
- [#19242](https://github.com/apache/superset/pull/19242) fix: allow subquery in ad-hoc SQL (@lilykuang)
- [#18926](https://github.com/apache/superset/pull/18926) fix(explore comma): make that the comma can be added by removing it from token separators… (@prosdev0107)
- [#19234](https://github.com/apache/superset/pull/19234) fix: adhoc column in legacy chart (@zhaoyongjie)
- [#19076](https://github.com/apache/superset/pull/19076) fix: allow to select <NULL> in a native filter single mode (@diegomedina248)
- [#19159](https://github.com/apache/superset/pull/19159) fix(select): make to consider the case sensitive in case of d3 format selector (@prosdev0107)
- [#19139](https://github.com/apache/superset/pull/19139) fix: Popovers in Explore not attached to the fields they are triggered by (@diegomedina248)
- [#19152](https://github.com/apache/superset/pull/19152) fix: auto-complete of tables and names are not working in SQL lab (@diegomedina248)
- [#19226](https://github.com/apache/superset/pull/19226) fix: Revert "refactor: converted QueryAutoRefresh to functional component … (@hughhhh)
- [#19158](https://github.com/apache/superset/pull/19158) fix: Logic for showing extension in Global Nav (@hughhhh)
- [#19111](https://github.com/apache/superset/pull/19111) fix(sqllab): Updated blank states for query results and query history (@lyndsiWilliams)
- [#19143](https://github.com/apache/superset/pull/19143) fix: clean up chart metadata config (@suddjian)
- [#19084](https://github.com/apache/superset/pull/19084) fix(dashboard-css): make to stay custom css when reload (@prosdev0107)
- [#19125](https://github.com/apache/superset/pull/19125) fix(dbs-dropdown): make to allow the search in supported db dropdown (@prosdev0107)
- [#19121](https://github.com/apache/superset/pull/19121) fix(dashboard): scrolling table viz overlaps next chart (@diegomedina248)
- [#19023](https://github.com/apache/superset/pull/19023) fix: Add perm for showing DBC-UI in Global Nav (@hughhhh)
- [#19080](https://github.com/apache/superset/pull/19080) fix(dashboard-edge-cutting): make to be not cut without Filter (@prosdev0107)
- [#19110](https://github.com/apache/superset/pull/19110) fix: cache key with guest token rls (@lilykuang)
- [#19095](https://github.com/apache/superset/pull/19095) fix(dashboard): Empty states overflowing small chart containers (@kgabryje)
- [#18947](https://github.com/apache/superset/pull/18947) fix(plugin-chart-echarts): make to allow the custome of x & y axis title margin i… (@prosdev0107)
- [#19088](https://github.com/apache/superset/pull/19088) fix(dashboard): import handle missing excluded charts (@villebro)
- [#19072](https://github.com/apache/superset/pull/19072) fix: Show Totals error with sort and group by together (@codemaster08240328)
- [#19037](https://github.com/apache/superset/pull/19037) fix: Database import error with a new field (@codemaster08240328)
- [#19047](https://github.com/apache/superset/pull/19047) fix: SQL Lab autocomplete for selected tables (@hughhhh)
- [#19071](https://github.com/apache/superset/pull/19071) fix: Pivot Table Conditional Formatting Doesn't Show All Options (@diegomedina248)
- [#19030](https://github.com/apache/superset/pull/19030) fix(allow-db-explore): make that the set the allow-db-explore option (@prosdev0107)
- [#18822](https://github.com/apache/superset/pull/18822) fix(altered-modal): make specified text fields wrap in table (@prosdev0107)
- [#19061](https://github.com/apache/superset/pull/19061) fix: enable find text browser functionality inside SQL Lab editor (@diegomedina248)
- [#19054](https://github.com/apache/superset/pull/19054) fix: show the total row count in the SQL Lab Query History tab when limited by DISPLAY_MAX_ROW (@diegomedina248)
- [#19070](https://github.com/apache/superset/pull/19070) fix: Select clear and loading icons overlap (@michael-s-molina)
- [#19065](https://github.com/apache/superset/pull/19065) fix: Dataset search when creating a chart (@michael-s-molina)
- [#19024](https://github.com/apache/superset/pull/19024) fix(time-series table): display null values in time-series table and sortable (@graceguo-supercat)
- [#19018](https://github.com/apache/superset/pull/19018) fix: ensure validation for db modal for googlesheets (@pkdotson)
- [#19052](https://github.com/apache/superset/pull/19052) fix: add previous line hotkey to SQL Lab for macOS (@diegomedina248)
- [#18690](https://github.com/apache/superset/pull/18690) fix: Update time grain expressions for Spark >= 3.x (@thomasdesr)
- [#19048](https://github.com/apache/superset/pull/19048) fix: remove unnecessary divider (@pkdotson)
- [#19059](https://github.com/apache/superset/pull/19059) fix(deck.gl): make Deck.gl Javascript tooltip generator works correctly (@chanyou0311)
- [#19044](https://github.com/apache/superset/pull/19044) fix: improve cypress flakiness (@etr2460)
- [#19043](https://github.com/apache/superset/pull/19043) fix(big-number): Big Number with Trendline Chart is not working if Time Grain is set to Month (@stephenLYZ)
- [#19040](https://github.com/apache/superset/pull/19040) fix(docs): update impala.mdx with correct product name (@DLT1412)
- [#18951](https://github.com/apache/superset/pull/18951) fix(SQL Editor): names new query tabs correctly (@cccs-Dustin)
- [#18877](https://github.com/apache/superset/pull/18877) fix(nested-tab-available): make the another tabs into one tabs available (@prosdev0107)
- [#18960](https://github.com/apache/superset/pull/18960) fix(chart): deprecate persisting url_params (@villebro)
- [#18973](https://github.com/apache/superset/pull/18973) fix(packages): Fixing users packages (@craig-rueda)
- [#18892](https://github.com/apache/superset/pull/18892) fix(tooltip-not-dissapeared): make the tooltip disappear when mouse away (@prosdev0107)
- [#18982](https://github.com/apache/superset/pull/18982) fix(external-link): change the external link in creating chart dashboard (@prosdev0107)
- [#18963](https://github.com/apache/superset/pull/18963) fix(native-filters): Default value not shown in native filters (@kgabryje)
- [#18958](https://github.com/apache/superset/pull/18958) fix(plugin-chart-echarts): fix customize margin (@stephenLYZ)
- [#18971](https://github.com/apache/superset/pull/18971) fix: add/find owners from report/alert modal (@graceguo-supercat)
- [#18835](https://github.com/apache/superset/pull/18835) fix(Explore): Pivot table V2 sort by failure with D&D enabled (@geido)
- [#18817](https://github.com/apache/superset/pull/18817) fix(sql Lab tabs): Empty SQL Lab tabs (@AAfghahi)
- [#18758](https://github.com/apache/superset/pull/18758) fix: CSV upload with overprescribed table/schema (@john-bodley)
- [#18849](https://github.com/apache/superset/pull/18849) fix: Null schema issue in the list of saved queries. (@codemaster08240328)
- [#18939](https://github.com/apache/superset/pull/18939) fix(deck.gl): multiple layers map size is shrunk (@stephenLYZ)
- [#18695](https://github.com/apache/superset/pull/18695) fix(native-filter): fix required filters of a dashboard won't load properly (@stephenLYZ)
- [#18796](https://github.com/apache/superset/pull/18796) fix: Monospacing errors in dashboards & charts (@codemaster08240328)
- [#18855](https://github.com/apache/superset/pull/18855) fix: Metadata browser in SQL not render nicely in Safari (@codemaster08240328)
- [#18934](https://github.com/apache/superset/pull/18934) fix(sqllab): Un-render deselected tabs (@etr2460)
- [#18853](https://github.com/apache/superset/pull/18853) fix: filter indicator pointing issue on popover (@codemaster08240328)
- [#18911](https://github.com/apache/superset/pull/18911) fix: Set force=true for exporting CSV on dashboard charts (@hughhhh)
- [#18920](https://github.com/apache/superset/pull/18920) fix(docs): add missing static files to build (@villebro)
- [#18894](https://github.com/apache/superset/pull/18894) fix: Source from Apache Foundation's website link (@paulocauca)
- [#18852](https://github.com/apache/superset/pull/18852) fix(dashboard): incorrect chart error with slow dataset api request (@ktmud)
- [#18886](https://github.com/apache/superset/pull/18886) fix: Database list in Docusaurus (@geido)
- [#18857](https://github.com/apache/superset/pull/18857) fix: FilterBox date endpoints to use [inclusive, exclusive) (@etr2460)
- [#18846](https://github.com/apache/superset/pull/18846) fix(key-value): lost url_params after long-url feature (@zhaoyongjie)
- [#18739](https://github.com/apache/superset/pull/18739) fix: Position of arrows in Table chart (@geido)
- [#18789](https://github.com/apache/superset/pull/18789) fix(hive): stop query on the processing engine when user clicks STOP on SQL Lab (@saurabh3091)
- [#18788](https://github.com/apache/superset/pull/18788) fix(Explore): Annotation cache should be ignore when adding new / updated annotation (@geido)
- [#18746](https://github.com/apache/superset/pull/18746) fix(mssql): support top syntax for limiting queries (@sujiplr)
- [#18813](https://github.com/apache/superset/pull/18813) fix(altered-modal): displayed the metric value in altered modal correctly (@prosdev0107)
- [#18749](https://github.com/apache/superset/pull/18749) fix(sqllab): Removed the tooltip from CopyToClipboard button in sqllab (@prosdev0107)
- [#18782](https://github.com/apache/superset/pull/18782) fix: contribution operator meets nan value (@zhaoyongjie)
- [#18756](https://github.com/apache/superset/pull/18756) fix: update standalone url for slack reports (@hughhhh)
- [#18786](https://github.com/apache/superset/pull/18786) fix(delete-modal): Changed the color of the help text with grayScale.dark1 in DeleteModal (@prosdev0107)
- [#18717](https://github.com/apache/superset/pull/18717) fix(Dashboard): Fix blinking native filters on zoom (@geido)
- [#18751](https://github.com/apache/superset/pull/18751) fix(helm): bump Helm chart release version (@wiktor2200)
- [#18738](https://github.com/apache/superset/pull/18738) fix(Explore): Fix cache timeout field not being saved and unit tests (@geido)
- [#18725](https://github.com/apache/superset/pull/18725) fix: report list search by created_by (@graceguo-supercat)
- [#18056](https://github.com/apache/superset/pull/18056) fix(CRUD/listviews): Errors with rison and search strings using special characters (@corbinrobb)
- [#18714](https://github.com/apache/superset/pull/18714) fix: Only redirect to relative paths when authentication expires (@geido)
- [#15246](https://github.com/apache/superset/pull/15246) fix: passing url params in sqllab (@maltoze)
- [#18666](https://github.com/apache/superset/pull/18666) fix(sqllab): fix query results sorting (@corbinrobb)
- [#18686](https://github.com/apache/superset/pull/18686) fix: Fixed dancing tooltip in database list action buttons (@lyndsiWilliams)
- [#18683](https://github.com/apache/superset/pull/18683) fix: unambiguous trino driver (@betodealmeida)
- [#18685](https://github.com/apache/superset/pull/18685) fix(build): update webpack jsx paths (@anoojkinaginlsn)
- [#18684](https://github.com/apache/superset/pull/18684) fix: revert handle null values in time-series table (@graceguo-supercat)
- [#17826](https://github.com/apache/superset/pull/17826) fix(deck.gl): update view state on property changes (#17720) (@hbruch)
- [#18603](https://github.com/apache/superset/pull/18603) fix(Explore): Force different color for same metrics in Mixed Time-Series (@geido)
- [#18658](https://github.com/apache/superset/pull/18658) fix: dataset modal doesn't work in dev mode (@stephenLYZ)
- [#18567](https://github.com/apache/superset/pull/18567) fix(mssql): support cte in virtual tables (@sujiplr)
- [#18633](https://github.com/apache/superset/pull/18633) fix(csv-export): pivot v2 with verbose names (@villebro)
- [#18084](https://github.com/apache/superset/pull/18084) fix(histogram): display correct percentile value instead of formula (@hoangminhquan-lhsdt)
- [#18628](https://github.com/apache/superset/pull/18628) fix: check embedded feature flag in request loader (@lilykuang)
- [#18562](https://github.com/apache/superset/pull/18562) fix: user UUIDs on export for Native Filter Configuration (@hughhhh)
- [#18619](https://github.com/apache/superset/pull/18619) fix(helm): Fix support for ingress.ingressClassName (@ad-m)
- [#18609](https://github.com/apache/superset/pull/18609) fix: change database database selector (@pkdotson)
- [#18601](https://github.com/apache/superset/pull/18601) fix(jest): add superset-frontend to testRegex (@villebro)
- [#18564](https://github.com/apache/superset/pull/18564) fix: sqllab schema select error msg (@pkdotson)
- [#18579](https://github.com/apache/superset/pull/18579) fix(sqla): avoid unnecessary groupby in samples request (@villebro)
- [#18246](https://github.com/apache/superset/pull/18246) fix(listview): add nowrap to view mode container (@villebro)
- [#18577](https://github.com/apache/superset/pull/18577) fix: Update docusaurus.config.js (@hughhhh)
- [#18575](https://github.com/apache/superset/pull/18575) fix: superset-doc.yaml workflow to not be immutable on deploy (@hughhhh)
- [#18182](https://github.com/apache/superset/pull/18182) fix: new alert should have force_screenshot be true (@graceguo-supercat)
- [#18252](https://github.com/apache/superset/pull/18252) fix(plugin-chart-echarts): fix forecasts on verbose metrics (@villebro)
- [#18240](https://github.com/apache/superset/pull/18240) fix(teradata): LIMIT syntax (@dmcnulla)
- [#18224](https://github.com/apache/superset/pull/18224) fix(alert): remove extra < character in email report (@graceguo-supercat)
- [#18201](https://github.com/apache/superset/pull/18201) fix: Build scripts (@geido)
- [#18219](https://github.com/apache/superset/pull/18219) fix: Add mexico back to country map (@etr2460)
- [#18181](https://github.com/apache/superset/pull/18181) fix: Explore long URL problem (@michael-s-molina)
- [#18217](https://github.com/apache/superset/pull/18217) fix(plugin-chart-echarts): use verbose x-axis name when defined (@villebro)
- [#18216](https://github.com/apache/superset/pull/18216) fix(explore): Pie chart label formatting when series is temporal (@kgabryje)
- [#17881](https://github.com/apache/superset/pull/17881) fix(sql): unable to filter text with quotes (@stephenLYZ)
- [#18205](https://github.com/apache/superset/pull/18205) fix(tests): Remove walrus operator for Python 3.7 compatiblity (@ad-m)
- [#18145](https://github.com/apache/superset/pull/18145) fix(native-filters): values is not sorted when setting sort option (@stephenLYZ)
- [#18174](https://github.com/apache/superset/pull/18174) fix(helm): allows extra top-level properties (@ad-m)
- [#18180](https://github.com/apache/superset/pull/18180) fix: Default values getting cleared in native filters form (@geido)
- [#17986](https://github.com/apache/superset/pull/17986) fix: Assign an owner when creating a dataset from a csv, excel or tabular (@cccs-joel)
- [#18171](https://github.com/apache/superset/pull/18171) fix: null value and empty string in filter (@zhaoyongjie)
- [#18137](https://github.com/apache/superset/pull/18137) fix(dashboard): support input undo when editing chart title (@stephenLYZ)
- [#18157](https://github.com/apache/superset/pull/18157) fix: remove standalone (@AAfghahi)
- [#18164](https://github.com/apache/superset/pull/18164) fix: Dataset column names are no longer editable (@lyndsiWilliams)
- [#18117](https://github.com/apache/superset/pull/18117) fix: exclude node_modules from ts tracking (@etr2460)
- [#18146](https://github.com/apache/superset/pull/18146) fix(textarea-control): ace editor input exception (@stephenLYZ)
- [#18046](https://github.com/apache/superset/pull/18046) fix(import_datasources): --sync flag works correctly (@cccs-Dustin)
- [#18152](https://github.com/apache/superset/pull/18152) fix: undefined error when adding extra sequential color scheme (@kgabryje)
- [#17843](https://github.com/apache/superset/pull/17843) fix(explore): fix chart embed code modal glitch (@stephenLYZ)
- [#18111](https://github.com/apache/superset/pull/18111) fix: logging warning on dataframe (don't use python's warnings) (@dpgaspar)
- [#18089](https://github.com/apache/superset/pull/18089) fix(docs): load correctly image for "Create New Chart" (@ad-m)
- [#18097](https://github.com/apache/superset/pull/18097) fix: contributing misspelling (@em0227)
- [#18086](https://github.com/apache/superset/pull/18086) fix: can't use examples helpers on non app context based environment (@ofekisr)
- [#18087](https://github.com/apache/superset/pull/18087) fix(docs): Correction of proper names format in README (@ad-m)
- [#18073](https://github.com/apache/superset/pull/18073) fix(generator): add lockfile and fix styling issues (@villebro)
- [#18027](https://github.com/apache/superset/pull/18027) fix(generator): more cleanup to plugin framework (@villebro)
- [#18051](https://github.com/apache/superset/pull/18051) fix: revert "feat: stop running CI on doc updates" (@hughhhh)
- [#18039](https://github.com/apache/superset/pull/18039) fix: handle null values in time-series table (@graceguo-supercat)
- [#18021](https://github.com/apache/superset/pull/18021) fix: Disable filtering on wide result sets (@etr2460)
- [#18017](https://github.com/apache/superset/pull/18017) fix: revert #17654 to fix subselect table name parsing (@etr2460)
- [#17995](https://github.com/apache/superset/pull/17995) fix: Workaround for sqlparse issue #652 (@john-bodley)
- [#17388](https://github.com/apache/superset/pull/17388) fix(sqla): Adhere to series limit ordering for pre-query (@john-bodley)
- [#17999](https://github.com/apache/superset/pull/17999) fix(helm): pin correct psycopg2 version (@villebro)
- [#17988](https://github.com/apache/superset/pull/17988) fix: Keep Report modal open when there's an error (@lyndsiWilliams)
- [#17985](https://github.com/apache/superset/pull/17985) fix: dashboard full screen layout (@pkdotson)
- [#17931](https://github.com/apache/superset/pull/17931) fix(sqllab): Dancing Tooltip in SQL editor dropdown (@lyndsiWilliams)
- [#17974](https://github.com/apache/superset/pull/17974) fix: null dates in table chart (@etr2460)
- [#17878](https://github.com/apache/superset/pull/17878) fix: Returns 404 instead of 500 for unknown dashboard filter state keys (@michael-s-molina)
- [#17982](https://github.com/apache/superset/pull/17982) fix(native-filters): apply default value correctly when it's set (@kgabryje)
- [#17937](https://github.com/apache/superset/pull/17937) fix(docs): update clickhouse.mdx (@rfraposa)
- [#17951](https://github.com/apache/superset/pull/17951) fix(Select): options in the select component will be overwritten due to timing of React.setState (@stephenLYZ)
- [#17957](https://github.com/apache/superset/pull/17957) fix: package.json local file dependencies (@etr2460)
- [#17786](https://github.com/apache/superset/pull/17786) fix: process color scheme configs correctly (@suddjian)
- [#17918](https://github.com/apache/superset/pull/17918) fix(cypress): flake cypress test case (@zhaoyongjie)
- [#17920](https://github.com/apache/superset/pull/17920) fix(helm): service account apiVersion indentation (@wiktor2200)
- [#17877](https://github.com/apache/superset/pull/17877) fix(translation): include babel-compile in Dockerfile (#17876) (@hbruch)
- [#17872](https://github.com/apache/superset/pull/17872) fix(explore): simple tab content input problem in the filter control (@stephenLYZ)
- [#17887](https://github.com/apache/superset/pull/17887) fix: Removes duplicated import in dashboard filter state tests (@michael-s-molina)
- [#17885](https://github.com/apache/superset/pull/17885) fix: tests can failed on different order executions (@ofekisr)
- [#17886](https://github.com/apache/superset/pull/17886) fix: failed mypy in master branch (@ofekisr)
- [#17854](https://github.com/apache/superset/pull/17854) fix(ui): show SCHEDULED_QUERIES template in SqlLab (@cemremengu)
- [#17851](https://github.com/apache/superset/pull/17851) fix(deckgl): deckgl unable to load map (@zhaoyongjie)
- [#17856](https://github.com/apache/superset/pull/17856) fix: corrected misspelling in percent_metrics (@briannguyen4)
- [#17784](https://github.com/apache/superset/pull/17784) fix: extra column in metrics (@betodealmeida)
- [#17740](https://github.com/apache/superset/pull/17740) fix: dataset extra import/export (@betodealmeida)
- [#17680](https://github.com/apache/superset/pull/17680) fix: replace datamask with key from new key value api (@pkdotson)
- [#17726](https://github.com/apache/superset/pull/17726) fix(explore): make SORT DESCENDING visible if SORT BY has value (@stephenLYZ)
- [#17823](https://github.com/apache/superset/pull/17823) fix: import typeddict from extensions (@villebro)
- [#17813](https://github.com/apache/superset/pull/17813) fix: map schemes json to SequentialScheme (#17812) (@hbruch)
- [#17788](https://github.com/apache/superset/pull/17788) fix: accept null params for validation (@eschutho)
- [#17800](https://github.com/apache/superset/pull/17800) fix(docs): bump broken packages (@villebro)
- [#17751](https://github.com/apache/superset/pull/17751) fix: [alert] allow decimal for alert threshold value (@graceguo-supercat)
- [#17783](https://github.com/apache/superset/pull/17783) fix: New Members per Month time range (@betodealmeida)
- [#17775](https://github.com/apache/superset/pull/17775) fix: running dev-server on a different port (@betodealmeida)
- [#17499](https://github.com/apache/superset/pull/17499) fix: [alert] should run alert query from report account (@graceguo-supercat)
- [#17777](https://github.com/apache/superset/pull/17777) fix(filter-sets): 404 on dashboard load (@villebro)
- [#17774](https://github.com/apache/superset/pull/17774) fix(alembic): Making Alembic logger config optional (@craig-rueda)
- [#17768](https://github.com/apache/superset/pull/17768) fix: change 401 response to a 403 for Security Exceptions (@rusackas)
- [#17760](https://github.com/apache/superset/pull/17760) fix: miss-spelling on CONTRIBUTING.md line 1351 (@MayUWish)
- [#17765](https://github.com/apache/superset/pull/17765) fix(plugin-chart-table): sort alphanumeric columns case insensitive (@kgabryje)
- [#17730](https://github.com/apache/superset/pull/17730) fix: add **init**.py to key_value (@bkyryliuk)
- [#17727](https://github.com/apache/superset/pull/17727) fix: local warning in the frontend development (@stephenLYZ)
- [#17738](https://github.com/apache/superset/pull/17738) fix: column extra in import/export (@betodealmeida)
- [#17748](https://github.com/apache/superset/pull/17748) fix: import DB errors (@betodealmeida)
- [#17741](https://github.com/apache/superset/pull/17741) fix: import dashboard stale filter_scopes (@betodealmeida)
- [#17649](https://github.com/apache/superset/pull/17649) fix(Mixed Timeseries Chart): Custom Metric Label (@Yahyakiani)
- [#17732](https://github.com/apache/superset/pull/17732) fix: import dash with missing immune ID (@betodealmeida)
- [#17713](https://github.com/apache/superset/pull/17713) fix(postgres): remove redundant tz factory (@villebro)
- [#17711](https://github.com/apache/superset/pull/17711) fix(explore): don't apply time range filter to Samples table (@kgabryje)
- [#17690](https://github.com/apache/superset/pull/17690) fix: Dashboard header negative margin on save (@geido)
- [#17703](https://github.com/apache/superset/pull/17703) fix(explore): deck.gl Multiple chart broken (@stephenLYZ)
- [#17638](https://github.com/apache/superset/pull/17638) fix(select): select component sort functionality on certain options (@corbinrobb)
- [#17692](https://github.com/apache/superset/pull/17692) fix(Dashboard): Undefined error in default value in Native Filters (@geido)
- [#17597](https://github.com/apache/superset/pull/17597) fix: Redirect on 401 (@geido)
- [#17654](https://github.com/apache/superset/pull/17654) fix: extract tables doesn't work with reserved keywords (@betodealmeida)
- [#17673](https://github.com/apache/superset/pull/17673) fix(translations): extract messages from js and ts files (@hbruch)
- [#17664](https://github.com/apache/superset/pull/17664) fix(legacy-plugin-chart-calendar): fix timestamp timezone in Calendar (@kgabryje)
- [#17644](https://github.com/apache/superset/pull/17644) fix: Allows PUT and DELETE only for owners of dashboard filter state (@michael-s-molina)
- [#17641](https://github.com/apache/superset/pull/17641) fix(sqla): make text clause escaping optional (@villebro)
- [#17636](https://github.com/apache/superset/pull/17636) fix: allow for multiple columns in pivot table report (@eschutho)
- [#17612](https://github.com/apache/superset/pull/17612) fix(dataset): modal sql editor error (@stephenLYZ)
- [#17620](https://github.com/apache/superset/pull/17620) fix(api): add missing fields to dataset schemas (@villebro)
- [#17618](https://github.com/apache/superset/pull/17618) fix: Revert "fix(Dashboard): Only apply changes when editing properties" (@geido)
- [#17613](https://github.com/apache/superset/pull/17613) fix: Dashboard export loading indicator (@michael-s-molina)
- [#17611](https://github.com/apache/superset/pull/17611) fix: Dashboard API flaky test (@michael-s-molina)
- [#17600](https://github.com/apache/superset/pull/17600) fix: Ch31968query context (@AAfghahi)
- [#17547](https://github.com/apache/superset/pull/17547) fix: fix text overflow in toast (@pkdotson)
- [#17542](https://github.com/apache/superset/pull/17542) fix: Visualizations don't load when using keyboard shortcuts (@michael-s-molina)
- [#17539](https://github.com/apache/superset/pull/17539) fix(superset.cli): superset cli group doesn't support superset extension app (@ofekisr)
- [#14512](https://github.com/apache/superset/pull/14512) fix: update kubernetes.mdx (@shicholas)
- [#17527](https://github.com/apache/superset/pull/17527) fix: RBAC for `can_export` for any resource (@hughhhh)
- [#17555](https://github.com/apache/superset/pull/17555) fix(lint): remove redis xadd type ignore (@villebro)
- [#17048](https://github.com/apache/superset/pull/17048) fix(elasticsearch): time_zone setting does not work for cast datetime expressions (@aniaan)
- [#17503](https://github.com/apache/superset/pull/17503) fix(explore): Metric control breaks when saved metric deleted from dataset (@kgabryje)
- [#17515](https://github.com/apache/superset/pull/17515) fix(CRUD views): change empty rows layout in TableCollection to be consistent with its headers (@corbinrobb)
- [#15182](https://github.com/apache/superset/pull/15182) fix: hiding HiddenControl inputs for real, so they don't add height (@rusackas)
- [#17511](https://github.com/apache/superset/pull/17511) fix: Dashboard access when DASHBOARD_RBAC is disabled (@michael-s-molina)
- [#16799](https://github.com/apache/superset/pull/16799) fix: Bulk update Spanish translations (@dreglad)
- [#14302](https://github.com/apache/superset/pull/14302) fix(hive): Update \_latest_partition_from_df in HiveEngineSpec to work on tables with multiple indexes (@codenamelxl)
- [#17458](https://github.com/apache/superset/pull/17458) fix: Always use temporal type for dttm columns [ID-2] (@kgabryje)
- [#17470](https://github.com/apache/superset/pull/17470) fix(presto): expand data with null item (@ganczarek)
- [#15254](https://github.com/apache/superset/pull/15254) fix: feature flags typing (@dpgaspar)
- [#17480](https://github.com/apache/superset/pull/17480) fix: Update Makefile (@hughhhh)
- [#17471](https://github.com/apache/superset/pull/17471) fix: create-admin command in Makefile (@hughhhh)
- [#17462](https://github.com/apache/superset/pull/17462) fix(Dashboard): Save empty label_colors in json_metadata (@geido)
- [#14305](https://github.com/apache/superset/pull/14305) fix(views/core): iteration over None type (@rasta-rocket)
- [#16566](https://github.com/apache/superset/pull/16566) fix(docker): add ecpg to docker image (@villebro)
- [#10811](https://github.com/apache/superset/pull/10811) fix(mssql): week time grain should respect datefirst setting (@binome74)
- [#17440](https://github.com/apache/superset/pull/17440) fix: should not show migration toast if user not enable dashboard filter components (@graceguo-supercat)
- [#17385](https://github.com/apache/superset/pull/17385) fix(sql lab): NULL styling in grid cell (@lyndsiWilliams)
- [#12092](https://github.com/apache/superset/pull/12092) fix: 'DataFrame' object has no attribute 'ix' (@minzhang2110)
- [#17429](https://github.com/apache/superset/pull/17429) fix: allow POST chart/data request without CSRF token (@etr2460)
- [#16900](https://github.com/apache/superset/pull/16900) fix(chart): ensure samples data is displayed (@pkdotson)
- [#17426](https://github.com/apache/superset/pull/17426) fix: Workaround for Pandas Timestamp.isoformat issue (@john-bodley)
- [#17392](https://github.com/apache/superset/pull/17392) fix(Dashboard): Only apply changes when editing properties (@geido)
- [#17380](https://github.com/apache/superset/pull/17380) fix(Dashboard): Missing dashboardId when refreshing Explore (@geido)
- [#17106](https://github.com/apache/superset/pull/17106) fix(dashboard): don't show report modal for anonymous user (@Mayur)
- [#17135](https://github.com/apache/superset/pull/17135) fix: title case in menus (@Maxime Beauchemin)
- [#17383](https://github.com/apache/superset/pull/17383) fix: Partial revert of 17236 (@john-bodley)
- [#17348](https://github.com/apache/superset/pull/17348) fix: Users being able to update datasets across DBs (@hughhhh)
- [#17382](https://github.com/apache/superset/pull/17382) fix(sqllab): Query limit dropdown number breaks to separate lines (@lyndsiWilliams)
- [#17309](https://github.com/apache/superset/pull/17309) fix: various typo fixes in MD files (@PApostol)
- [#17370](https://github.com/apache/superset/pull/17370) fix: failed timezone selector UT (@zhaoyongjie)
- [#17369](https://github.com/apache/superset/pull/17369) fix: Database selector overflow (@michael-s-molina)
- [#17356](https://github.com/apache/superset/pull/17356) fix: Remove horizontal scroll navigation from SQL Lab (@etr2460)
- [#17357](https://github.com/apache/superset/pull/17357) fix(Dashboard): Make color scheme optional (@geido)
- [#17287](https://github.com/apache/superset/pull/17287) fix(dashboard): Return columns and verbose_map for groupby values of Pivot Table v2 [ID-7] (@kgabryje)
- [#17331](https://github.com/apache/superset/pull/17331) fix: Show sqllab state when deleting databases (@hughhhh)
- [#17289](https://github.com/apache/superset/pull/17289) fix: removed redundant logger definition (@gnought)
- [#17236](https://github.com/apache/superset/pull/17236) fix: revert default series sort-by metric (@john-bodley)
- [#17312](https://github.com/apache/superset/pull/17312) fix(sqla): Normalize prequery result type (@john-bodley)
- [#17268](https://github.com/apache/superset/pull/17268) fix: Unable to select None for Alert's log retention (@michael-s-molina)
- [#17228](https://github.com/apache/superset/pull/17228) fix: remove variables from styled component (@pkdotson)
- [#17200](https://github.com/apache/superset/pull/17200) fix(Dashboard): Sidepanel positioning (@geido)
- [#17184](https://github.com/apache/superset/pull/17184) fix(Explore): Remove changes to the properties on cancel (@geido)
- [#17314](https://github.com/apache/superset/pull/17314) fix: run npm install to fix a bad package version (@eschutho)
- [#17303](https://github.com/apache/superset/pull/17303) fix: datatable crash when column is empty string [ID-59] (@zhaoyongjie)
- [#17292](https://github.com/apache/superset/pull/17292) fix: Change 500 error to 422 in Sql Lab (@AAfghahi)
- [#17239](https://github.com/apache/superset/pull/17239) fix: revert "feat(sqla): apply time grain to all temporal groupbys" (@john-bodley)
- [#17223](https://github.com/apache/superset/pull/17223) fix(reports): Owners no longer showing undefined in reports (@lyndsiWilliams)
- [#17242](https://github.com/apache/superset/pull/17242) fix: Updated connection string for Firebolt (@raghavSharmaCode)
- [#17234](https://github.com/apache/superset/pull/17234) fix(annotations): handle required fields properly (@villebro)
- [#17217](https://github.com/apache/superset/pull/17217) fix(dashboard): Fix issue #17144 - Resetting native filter form does not clear the values. (@m-ajay)
- [#17221](https://github.com/apache/superset/pull/17221) fix(Dashboard): Position of the tools of the Tabs component in Edit Dashboard (@geido)
- [#17047](https://github.com/apache/superset/pull/17047) fix: Allow chart owners to edit title (@belgren)
- [#17205](https://github.com/apache/superset/pull/17205) fix: reenabling terser plugin for webpack (@rusackas)
- [#17194](https://github.com/apache/superset/pull/17194) fix: use cache for csv download (@eschutho)
- [#17169](https://github.com/apache/superset/pull/17169) fix: Order of Select items when unselecting (@michael-s-molina)
- [#17213](https://github.com/apache/superset/pull/17213) fix: CI is blocked by mypy checking (@zhaoyongjie)
- [#17196](https://github.com/apache/superset/pull/17196) fix(bigquery): calculated column cannot orderby in BigQuery (@zhaoyongjie)
- [#17195](https://github.com/apache/superset/pull/17195) fix(sqla): convert prequery results to native python types (@villebro)
- [#17112](https://github.com/apache/superset/pull/17112) fix: auto refresh interval won't be updated (@yougyoung94)
- [#17046](https://github.com/apache/superset/pull/17046) fix: dropdown placement for cascading filters popover (@pkdotson)
- [#17166](https://github.com/apache/superset/pull/17166) fix(explore): timestamp format when copy datatable to clipboard (@kgabryje)
- [#17168](https://github.com/apache/superset/pull/17168) fix: avoid filters containing null value (@zhaoyongjie)
- [#17155](https://github.com/apache/superset/pull/17155) fix: preventing sql lab None limit value (@amitmiran137)
- [#17147](https://github.com/apache/superset/pull/17147) fix: Remove title from the Cancel SVG (@AAfghahi)
- [#17125](https://github.com/apache/superset/pull/17125) fix: Update package-lock.json of superset-frontend and cypress-base (@lyndsiWilliams)
- [#17079](https://github.com/apache/superset/pull/17079) fix(druid): Fix regression with ISO 8601 format (@john-bodley)
- [#17024](https://github.com/apache/superset/pull/17024) fix(DB Connections): removing paramProperties (@AAfghahi)
- [#17008](https://github.com/apache/superset/pull/17008) fix: Strict check to allow null values in the SelectControl component (@geido)
- [#16838](https://github.com/apache/superset/pull/16838) fix: remove duplicate line in docstring (@exemplary-citizen)

**Others**

- [#19732](https://github.com/apache/superset/pull/19732) chore: Clean redundant dependency from useMemo dep array (@kgabryje)
- [#19636](https://github.com/apache/superset/pull/19636) chore: skip SIP-68 shadow writing for LTS (@ktmud)
- [#19530](https://github.com/apache/superset/pull/19530) docs: release notes for 1.5 (@villebro)
- [#19557](https://github.com/apache/superset/pull/19557) chore: remove redundant adodbapi warning (@villebro)
- [#19481](https://github.com/apache/superset/pull/19481) chore(plugin-chart-echarts): upgrade echarts 5.3.2 (@villebro)
- [#19392](https://github.com/apache/superset/pull/19392) test(native filter): add new test for dependent filter (@jinghua-qa)
- [#19417](https://github.com/apache/superset/pull/19417) refactor: Removes the CSS files from the Heatmap plugin (@michael-s-molina)
- [#19436](https://github.com/apache/superset/pull/19436) refactor: Removes the CSS files from the Calendar Heatmap plugin (@michael-s-molina)
- [#19439](https://github.com/apache/superset/pull/19439) chore: Removes hard-coded colors from plugin-chart-pivot-table (@michael-s-molina)
- [#19443](https://github.com/apache/superset/pull/19443) chore: Removes hard-coded colors from legacy-preset-chart-nvd3 (@michael-s-molina)
- [#19411](https://github.com/apache/superset/pull/19411) docs: add 1.4.2 changelog entries (@villebro)
- [#19437](https://github.com/apache/superset/pull/19437) chore: Disables no-literal-colors for the theme configuration (@michael-s-molina)
- [#19424](https://github.com/apache/superset/pull/19424) chore: attempt to force docs deploy (@srinify)
- [#19412](https://github.com/apache/superset/pull/19412) chore: update slack invite url (@srinify)
- [#19368](https://github.com/apache/superset/pull/19368) chore: Removes direct theme imports (@michael-s-molina)
- [#19245](https://github.com/apache/superset/pull/19245) chore: bump storybook to 6.4.19, migrating config, and linting storybook config (@rusackas)
- [#19239](https://github.com/apache/superset/pull/19239) chore: Eslint custom plugin to warn about hex and literal colors (@geido)
- [#19390](https://github.com/apache/superset/pull/19390) docs: Correcting the document font size (@sujiplr)
- [#19387](https://github.com/apache/superset/pull/19387) chore: add type checking in plugin's test directory (@stephenLYZ)
- [#19365](https://github.com/apache/superset/pull/19365) chore: add support for npm8 (@villebro)
- [#19350](https://github.com/apache/superset/pull/19350) docs: update lock + general cleanup (@villebro)
- [#19331](https://github.com/apache/superset/pull/19331) docs: fix: Use three backticks for code blocks (@kaapstorm)
- [#19320](https://github.com/apache/superset/pull/19320) chore: add type checking in package tests directory (@stephenLYZ)
- [#19233](https://github.com/apache/superset/pull/19233) docs: SECRET_KEY Rotation Documentation (@sujiplr)
- [#19323](https://github.com/apache/superset/pull/19323) chore: bump FAB to 3.4.5 (@dpgaspar)
- [#19322](https://github.com/apache/superset/pull/19322) ci: add more code owners to helm chart source (@dpgaspar)
- [#19295](https://github.com/apache/superset/pull/19295) chore: fixing a pluralization typo (@rusackas)
- [#19236](https://github.com/apache/superset/pull/19236) chore: Make font-weights themable, fix font faces (@kgabryje)
- [#19293](https://github.com/apache/superset/pull/19293) chore: allow overriding the guest token pyjwt instance (@suddjian)
- [#19161](https://github.com/apache/superset/pull/19161) chore: add missing keys in components inside lists (@diegomedina248)
- [#18221](https://github.com/apache/superset/pull/18221) chore: Various docstring fixes (@PApostol)
- [#19270](https://github.com/apache/superset/pull/19270) docs: update readme.md (@prassanna-helixsense-com)
- [#18648](https://github.com/apache/superset/pull/18648) chore: update changelog and updating files from 1.4.1 (@eschutho)
- [#19235](https://github.com/apache/superset/pull/19235) docs: fix broken links in the documentation (@vchrombie)
- [#19172](https://github.com/apache/superset/pull/19172) chore: use order_desc shared control consistently (@stephenLYZ)
- [#19227](https://github.com/apache/superset/pull/19227) chore: upgrade mypy check in pre-commit (@ktmud)
- [#19216](https://github.com/apache/superset/pull/19216) chore: refactor import command (@betodealmeida)
- [#19156](https://github.com/apache/superset/pull/19156) test: fix TimezoneSelector tests on daylight saving time (@ktmud)
- [#19115](https://github.com/apache/superset/pull/19115) test(native filter): add new native filter test (@jinghua-qa)
- [#19132](https://github.com/apache/superset/pull/19132) chore(embedded): refresh the guest token (@suddjian)
- [#19090](https://github.com/apache/superset/pull/19090) refactor(TimezoneSelector): simplify override logics and tests (@ktmud)
- [#19091](https://github.com/apache/superset/pull/19091) docs: Modified alerts and reports docs for clarity (@7vikpeculiar)
- [#19077](https://github.com/apache/superset/pull/19077) perf(dashboard): Send chart requests before native filter requests (@kgabryje)
- [#19064](https://github.com/apache/superset/pull/19064) perf(dashboard): Improve performance of complex dashboards (@kgabryje)
- [#18950](https://github.com/apache/superset/pull/18950) chore: Change Sort by and Sort descending controls for Time-series Bar Chart (@geido)
- [#14064](https://github.com/apache/superset/pull/14064) chore: log multiple errors (@eschutho)
- [#19068](https://github.com/apache/superset/pull/19068) docs: renamed yugabyte to yugabytedb (@srinify)
- [#19029](https://github.com/apache/superset/pull/19029) chore: Moves Chart components to src/components folder (@michael-s-molina)
- [#19050](https://github.com/apache/superset/pull/19050) docs(building): link frontend asset instructions correctly (@cancan101)
- [#19041](https://github.com/apache/superset/pull/19041) chore(plugin-chart-echarts): bump echarts 5.3.1 (@villebro)
- [#18965](https://github.com/apache/superset/pull/18965) chore: adding Dutch language translations (NL) (@pablo-guerra)
- [#19032](https://github.com/apache/superset/pull/19032) chore: Moves CRUD components to the Datasource component (@michael-s-molina)
- [#19042](https://github.com/apache/superset/pull/19042) chore: Fix deprecated unittest aliases. (@tirkarthi)
- [#18999](https://github.com/apache/superset/pull/18999) refactor: Deletes the common/components folder (@michael-s-molina)
- [#19021](https://github.com/apache/superset/pull/19021) chore: change case for upload selection (@pkdotson)
- [#19019](https://github.com/apache/superset/pull/19019) chore(deps): bump url-parse from 1.5.7 to 1.5.10 in /docs (@dependabot[bot])
- [#18976](https://github.com/apache/superset/pull/18976) chore(cache): default to SimpleCache in debug mode (@villebro)
- [#18983](https://github.com/apache/superset/pull/18983) docs: renamed yugabytedb to yugabyte as per request by Yugabyte team (@srinify)
- [#18179](https://github.com/apache/superset/pull/18179) refactor: converted QueryAutoRefresh to functional component (@briannguyen4)
- [#18922](https://github.com/apache/superset/pull/18922) chore(deps): bump urijs and xss (@villebro)
- [#18967](https://github.com/apache/superset/pull/18967) chore(native-filters): Add unit tests for filter cards (@kgabryje)
- [#16860](https://github.com/apache/superset/pull/16860) chore(security): Remove obsolete FAB metric_access permission (@john-bodley)
- [#18955](https://github.com/apache/superset/pull/18955) docs: fix sql templating typos (@garyng)
- [#18931](https://github.com/apache/superset/pull/18931) chore: Moves components out of the commons folder (@michael-s-molina)
- [#18915](https://github.com/apache/superset/pull/18915) test(Native Filter): User can create parent filters using "Filter is hierarchical (@jinghua-qa)
- [#18811](https://github.com/apache/superset/pull/18811) chore: add intersect method from backend to fontend for upload extensions (@pkdotson)
- [#18935](https://github.com/apache/superset/pull/18935) chore: update `UPDATING.md` re: SIP-68 (@betodealmeida)
- [#18866](https://github.com/apache/superset/pull/18866) refactor(ImportModelsCommand): clean code, extract logic into methods (@michael-hoffman-26)
- [#18850](https://github.com/apache/superset/pull/18850) test(native filter): add new native filter test for time column filter (@jinghua-qa)
- [#18923](https://github.com/apache/superset/pull/18923) refactor(docs): clean up deploy of static files (@villebro)
- [#18914](https://github.com/apache/superset/pull/18914) docs: remove old viz plugin docs (@villebro)
- [#17977](https://github.com/apache/superset/pull/17977) chore(deps-dev): bump css-loader from 6.2.0 to 6.5.1 in /superset-frontend (@dependabot[bot])
- [#18882](https://github.com/apache/superset/pull/18882) docs(Import API): update function description, overwrite real meaning (@michael-hoffman-26)
- [#18854](https://github.com/apache/superset/pull/18854) chore(tests-backend): migrate snowflake and sqlite to unit tests (@corbinrobb)
- [#18878](https://github.com/apache/superset/pull/18878) docs: fix toc position scroll bug (#18868) (@michaelzusev)
- [#18861](https://github.com/apache/superset/pull/18861) docs: add GA conf to config (@villebro)
- [#18820](https://github.com/apache/superset/pull/18820) chore: npm audit fix in cypress-base (@rusackas)
- [#18828](https://github.com/apache/superset/pull/18828) chore: unify usages of nvd3 library (@stephenLYZ)
- [#18819](https://github.com/apache/superset/pull/18819) docs: fix typo in configuring-superset.mdx (@ardeego)
- [#18824](https://github.com/apache/superset/pull/18824) docs: add Unvired to INTHEWILD.md (@srinisubramanian)
- [#18818](https://github.com/apache/superset/pull/18818) docs: add_db_logos (@srinify)
- [#18815](https://github.com/apache/superset/pull/18815) docs: Added reference and link to configure instructions for docker-compose… (@jacobcroope)
- [#18810](https://github.com/apache/superset/pull/18810) refactor: move date_parser to unittest (@zhaoyongjie)
- [#18798](https://github.com/apache/superset/pull/18798) chore(readme): Adding pinot logo into Readme Supported Databases Section (@xiangfu0)
- [#18800](https://github.com/apache/superset/pull/18800) docs(pinot): Update pinot docs with fixed pinot connection (@xiangfu0)
- [#18805](https://github.com/apache/superset/pull/18805) chore(deps): bump hosted-git-info from 2.7.1 to 2.8.9 in /superset-frontend (@dependabot[bot])
- [#18804](https://github.com/apache/superset/pull/18804) chore(deps): bump url-parse from 1.5.3 to 1.5.7 in /docs (@dependabot[bot])
- [#18801](https://github.com/apache/superset/pull/18801) chore(FF): adding generic X axis Feature Flag (default: False) (@rusackas)
- [#18142](https://github.com/apache/superset/pull/18142) refactor: migrate ExploreCtasResultsButton component to typescript (@EugeneTorap)
- [#18761](https://github.com/apache/superset/pull/18761) chore(deps): bump cached-path-relative from 1.0.2 to 1.1.0 in /superset-frontend/cypress-base (@dependabot[bot])
- [#18765](https://github.com/apache/superset/pull/18765) chore(deps): bump y18n from 4.0.0 to 4.0.3 in /superset-frontend (@dependabot[bot])
- [#18769](https://github.com/apache/superset/pull/18769) chore(deps): bump ws from 5.2.2 to 5.2.3 in /superset-frontend (@dependabot[bot])
- [#18779](https://github.com/apache/superset/pull/18779) refactor: move post_processing to unittest (@zhaoyongjie)
- [#18767](https://github.com/apache/superset/pull/18767) chore(deps): bump shelljs from 0.8.4 to 0.8.5 in /superset-frontend (@dependabot[bot])
- [#18764](https://github.com/apache/superset/pull/18764) chore(deps): bump follow-redirects from 1.14.3 to 1.14.8 in /superset-frontend (@dependabot[bot])
- [#18762](https://github.com/apache/superset/pull/18762) chore(deps): bump underscore from 1.12.0 to 1.12.1 in /superset-frontend (@dependabot[bot])
- [#18772](https://github.com/apache/superset/pull/18772) chore(deps): bump path-parse from 1.0.6 to 1.0.7 in /superset-frontend (@dependabot[bot])
- [#18759](https://github.com/apache/superset/pull/18759) chore(deps): bump shelljs from 0.8.4 to 0.8.5 in /docs (@dependabot[bot])
- [#18760](https://github.com/apache/superset/pull/18760) chore(deps): bump follow-redirects from 1.14.5 to 1.14.8 in /docs (@dependabot[bot])
- [#18763](https://github.com/apache/superset/pull/18763) chore(deps): bump nanoid from 3.1.30 to 3.3.1 in /docs (@dependabot[bot])
- [#18766](https://github.com/apache/superset/pull/18766) chore(deps-dev): bump node-fetch from 2.6.1 to 2.6.7 in /superset-frontend (@dependabot[bot])
- [#18768](https://github.com/apache/superset/pull/18768) chore(deps): bump tmpl from 1.0.4 to 1.0.5 in /superset-frontend (@dependabot[bot])
- [#18770](https://github.com/apache/superset/pull/18770) chore(deps): bump dns-packet from 1.3.1 to 1.3.4 in /superset-frontend (@dependabot[bot])
- [#18771](https://github.com/apache/superset/pull/18771) chore(deps): bump url-parse from 1.4.7 to 1.5.7 in /superset-frontend (@dependabot[bot])
- [#18629](https://github.com/apache/superset/pull/18629) chore: move data nav menu to plus menu (@pkdotson)
- [#18705](https://github.com/apache/superset/pull/18705) chore: bumping caniuse-lite from 1.0.30001257 to 1.0.30001312 (@rusackas)
- [#18728](https://github.com/apache/superset/pull/18728) chore: use switchboard as dependency for embedded sdk (@suddjian)
- [#18121](https://github.com/apache/superset/pull/18121) refactor: migrate QueryAndSaveBtns to TypeScript and add stories (@ad-m)
- [#18664](https://github.com/apache/superset/pull/18664) chore: Remove non-breaking changes from UPDATING.md (@john-bodley)
- [#18707](https://github.com/apache/superset/pull/18707) chore: updating link to newer viz plugin blog post (@rusackas)
- [#18710](https://github.com/apache/superset/pull/18710) refactor: decouple pandas postprocessing operator (@zhaoyongjie)
- [#18708](https://github.com/apache/superset/pull/18708) chore: remove config of temporary_superset_ui (@zhaoyongjie)
- [#18709](https://github.com/apache/superset/pull/18709) docs: add docs for viz plugin development (@villebro)
- [#18706](https://github.com/apache/superset/pull/18706) chore: removing temporary_superset_ui folder (no longer needed) (@rusackas)
- [#18669](https://github.com/apache/superset/pull/18669) test(Native filter): add cypress test user can add time grain filter (@jinghua-qa)
- [#18621](https://github.com/apache/superset/pull/18621) chore: Add craig-rueda as codeowner of Helm Chart (@ad-m)
- [#18136](https://github.com/apache/superset/pull/18136) refactor: migrate DeleteComponentButton to TypeScript (@Scrip7)
- [#17944](https://github.com/apache/superset/pull/17944) chore: migrate QueryTable component from jsx to tsx (@MayUWish)
- [#18608](https://github.com/apache/superset/pull/18608) chore: improve React.useRef etc. import consistency (@ad-m)
- [#18647](https://github.com/apache/superset/pull/18647) test(native filter): add test for time range filter (@jinghua-qa)
- [#18581](https://github.com/apache/superset/pull/18581) chore: Update Docusaurus links (@geido)
- [#18120](https://github.com/apache/superset/pull/18120) refactor: migrate SliderControl to TypeScript & added story (@ad-m)
- [#18657](https://github.com/apache/superset/pull/18657) chore(docs): add note about quote handling in filters (@villebro)
- [#17939](https://github.com/apache/superset/pull/17939) refactor(ExploreCtasResultsButton): convert to functional component (@ChristopherCFleming)
- [#18558](https://github.com/apache/superset/pull/18558) chore: Rename and reposition native filter modal fields (@michael-s-molina)
- [#18143](https://github.com/apache/superset/pull/18143) refactor: migrate ExploreResultsButton component to FC & tsx (@EugeneTorap)
- [#18200](https://github.com/apache/superset/pull/18200) chore: upgrade BoundsControl to TS (@ad-m)
- [#18585](https://github.com/apache/superset/pull/18585) chore: allow sqla docs to use supersettext (@pkdotson)
- [#18144](https://github.com/apache/superset/pull/18144) refactor: remove redundant propTypes in ColumnElement (@EugeneTorap)
- [#18600](https://github.com/apache/superset/pull/18600) docs: fixed URL for contributing landing page (@srinify)
- [#18580](https://github.com/apache/superset/pull/18580) docs: add password example to dataset import API (@villebro)
- [#17921](https://github.com/apache/superset/pull/17921) chore(explore): make adhoc columns available without UX BETA ff (@kgabryje)
- [#18574](https://github.com/apache/superset/pull/18574) chore: update gitignore in the main folder, to hide PyCharm configuration (@michael-hoffman-26)
- [#18568](https://github.com/apache/superset/pull/18568) chore: Remove outdated roadmap page from Docusaurus (@geido)
- [#18254](https://github.com/apache/superset/pull/18254) docs(i18n): make translation guide more explicit (@villebro)
- [#18231](https://github.com/apache/superset/pull/18231) chore: add ci for docs-v2 (@ad-m)
- [#18559](https://github.com/apache/superset/pull/18559) chore: Update Docusaurus dependencies (@geido)
- [#18229](https://github.com/apache/superset/pull/18229) chore: Reference Github code in Docusaurus (@geido)
- [#18251](https://github.com/apache/superset/pull/18251) chore(tests): migrate mssql tests to pytest (@villebro)
- [#18188](https://github.com/apache/superset/pull/18188) refactor: upgrade ControlHeader to TSX & FC and add storybook (@ad-m)
- [#18230](https://github.com/apache/superset/pull/18230) chore: Docusaurus throw on broken links (@geido)
- [#18170](https://github.com/apache/superset/pull/18170) refactor: extract json_required view decorator (@ad-m)
- [#17926](https://github.com/apache/superset/pull/17926) refactor: sqleditorleftbar to typescript (@JosueLugaro)
- [#18199](https://github.com/apache/superset/pull/18199) chore: Update links and navigation in Docusaurus (@geido)
- [#18206](https://github.com/apache/superset/pull/18206) chore: added release notes for 1.4 (@srinify)
- [#18196](https://github.com/apache/superset/pull/18196) docs(docker compose installation): add pull command to avoid errors when installing superset using docker compose (@ancasarb)
- [#18160](https://github.com/apache/superset/pull/18160) chore: move controlPanel into time_table (@zhaoyongjie)
- [#18162](https://github.com/apache/superset/pull/18162) chore: bump echarts to 5.3.0 (@villebro)
- [#18134](https://github.com/apache/superset/pull/18134) chore: bump pillow to major version (@eschutho)
- [#18151](https://github.com/apache/superset/pull/18151) refactor: Moves the Explore form_data endpoint (@michael-s-molina)
- [#18130](https://github.com/apache/superset/pull/18130) chore: use pkg_resources for cleaner config (@betodealmeida)
- [#18125](https://github.com/apache/superset/pull/18125) docs: fix typo on security page (@proteusvacuum)
- [#18133](https://github.com/apache/superset/pull/18133) chore: migrating storybook jsx to typescript #18100 (@jayakrishnankk)
- [#18083](https://github.com/apache/superset/pull/18083) chore: update changelog and updating for 1.4.0 (@eschutho)
- [#18105](https://github.com/apache/superset/pull/18105) refactor: migrate RowCountLabel to TypeScript & added story (@ad-m)
- [#18101](https://github.com/apache/superset/pull/18101) refactor: migrate Checkbox story to TypeScript - see #18100 (@ad-m)
- [#17807](https://github.com/apache/superset/pull/17807) refactor: sqleditorleftbar to functional (@JosueLugaro)
- [#18082](https://github.com/apache/superset/pull/18082) chore: split CLI into multiple files (@betodealmeida)
- [#18060](https://github.com/apache/superset/pull/18060) refactor(example_data): replace the way the birth_names data is loaded to DB (@ofekisr)
- [#17771](https://github.com/apache/superset/pull/17771) refactor(sql_lab): SQL Lab Persistent Saved State (@AAfghahi)
- [#18059](https://github.com/apache/superset/pull/18059) chore(plugin-chart-echarts): add types to controls (@villebro)
- [#18058](https://github.com/apache/superset/pull/18058) chore(supeset.utils.core): move all database utils to database utils module (@ofekisr)
- [#18037](https://github.com/apache/superset/pull/18037) chore: important change to MakeFile (@AAfghahi)
- [#17569](https://github.com/apache/superset/pull/17569) chore: column_type_mappings (@dungdm93)
- [#18003](https://github.com/apache/superset/pull/18003) chore(DatasourceEditor): Create Datasource Legacy Editor Feature Flag (@AAfghahi)
- [#17996](https://github.com/apache/superset/pull/17996) refactor: remove unused ts-jest (@zhaoyongjie)
- [#17893](https://github.com/apache/superset/pull/17893) refactor: examples data loading for tests (@ofekisr)
- [#17967](https://github.com/apache/superset/pull/17967) chore: use new FAB functionality for component schemas update OAS (@dpgaspar)
- [#17979](https://github.com/apache/superset/pull/17979) chore: reenable lint for test files (@zhaoyongjie)
- [#17965](https://github.com/apache/superset/pull/17965) refactor: move superset-ui dependencies to peerDependencies (@zhaoyongjie)
- [#17930](https://github.com/apache/superset/pull/17930) chore: Move edit dataset lock (@lyndsiWilliams)
- [#17718](https://github.com/apache/superset/pull/17718) docs(contributing): update contributing section on docs page to match CONTRIBUTING.md (@riahk)
- [#17975](https://github.com/apache/superset/pull/17975) docs: close bracket on helm chart reference (@brnnnfx)
- [#17971](https://github.com/apache/superset/pull/17971) chore: bump typescript to 4.5.4, and adjust storybook story. (@rusackas)
- [#17972](https://github.com/apache/superset/pull/17972) chore: fixing annoying warning about escaping in Emotion styling (@rusackas)
- [#17947](https://github.com/apache/superset/pull/17947) refactor: import value name from root of superset-ui/core (@zhaoyongjie)
- [#17959](https://github.com/apache/superset/pull/17959) chore(deps): bump underscore from 1.12.0 to 1.12.1 in /superset-frontend (@dependabot[bot])
- [#17958](https://github.com/apache/superset/pull/17958) chore(deps): bump babel from 2.5.3 to 2.9.1 in /superset/translations (@dependabot[bot])
- [#17904](https://github.com/apache/superset/pull/17904) chore(deps): bump @storybook/addon-actions from 6.3.12 to 6.4.9 in /superset-frontend (@dependabot[bot])
- [#17902](https://github.com/apache/superset/pull/17902) chore: Moves spec files to the src folder - iteration 10 (@michael-s-molina)
- [#17901](https://github.com/apache/superset/pull/17901) chore: Moves spec files to the src folder - iteration 9 (@michael-s-molina)
- [#17956](https://github.com/apache/superset/pull/17956) chore: Adding more viz category mappings for viz picker (@rusackas)
- [#17963](https://github.com/apache/superset/pull/17963) chore: unbreak pip-compile-multi (@villebro)
- [#17899](https://github.com/apache/superset/pull/17899) chore: Moves spec files to the src folder - iteration 8 (@michael-s-molina)
- [#17897](https://github.com/apache/superset/pull/17897) chore: Moves the Menu to views/components folder (@michael-s-molina)
- [#17896](https://github.com/apache/superset/pull/17896) chore: Moves the hooks folder to the src folder (@michael-s-molina)
- [#17962](https://github.com/apache/superset/pull/17962) chore(deps): bump urijs from 1.19.6 to 1.19.7 in /superset-frontend (@dependabot[bot])
- [#17942](https://github.com/apache/superset/pull/17942) chore: Fix 'button' misspelling in list_with_checkboxes (@acrks)
- [#17860](https://github.com/apache/superset/pull/17860) chore: remove unused eslintrc (@zhaoyongjie)
- [#17909](https://github.com/apache/superset/pull/17909) refactor(storybok): upgrade to webpack5 in storybook of plugins (@zhaoyongjie)
- [#17924](https://github.com/apache/superset/pull/17924) chore: fix misspelling of button (@DavidWoolner)
- [#17782](https://github.com/apache/superset/pull/17782) ci: make presto hive tests to cover only chartData and sqljson (@amitmiran137)
- [#17717](https://github.com/apache/superset/pull/17717) chore: Fix UPDATING.md (@john-bodley)
- [#17824](https://github.com/apache/superset/pull/17824) chore: Help user to find the input fields in the dataset editor (@lyndsiWilliams)
- [#17837](https://github.com/apache/superset/pull/17837) refactor(monorepo): update plugin dependencies (@zhaoyongjie)
- [#17829](https://github.com/apache/superset/pull/17829) chore(generator-superset): migrate to monorepo (@villebro)
- [#17832](https://github.com/apache/superset/pull/17832) chore: Refactor localstorage into typesafe version (@etr2460)
- [#17811](https://github.com/apache/superset/pull/17811) other: Add Helm chart option for configOverrides through file (@dd-willgan)
- [#17828](https://github.com/apache/superset/pull/17828) chore: add lerna version (@zhaoyongjie)
- [#17827](https://github.com/apache/superset/pull/17827) refactor(monorepo): migrate plugins release workflow (@zhaoyongjie)
- [#17754](https://github.com/apache/superset/pull/17754) docs: update contribuing docs (@zhaoyongjie)
- [#17650](https://github.com/apache/superset/pull/17650) chore: updated screenshots in README.md and added recent events (@srinify)
- [#17797](https://github.com/apache/superset/pull/17797) chore(plugin-chart-table): move adhoc filters control closer to the metrics (@kgabryje)
- [#17798](https://github.com/apache/superset/pull/17798) chore(plugin-chart-pivot-table): change order of Columns and Rows controls (@kgabryje)
- [#17769](https://github.com/apache/superset/pull/17769) chore(plugin-chart-pivot-table): migrate react-pivottable into superset codebase (@kgabryje)
- [#17785](https://github.com/apache/superset/pull/17785) docs: Fix typo on line 967 (@ChristopherCFleming)
- [#17780](https://github.com/apache/superset/pull/17780) chore: update fixtures scope that are loading data into the analytical db (@bkyryliuk)
- [#17770](https://github.com/apache/superset/pull/17770) chore: print test runtime (@bkyryliuk)
- [#17772](https://github.com/apache/superset/pull/17772) chore: skip flaky tests (@betodealmeida)
- [#17764](https://github.com/apache/superset/pull/17764) chore: bump react-resize-detector (@villebro)
- [#17723](https://github.com/apache/superset/pull/17723) chore: bump FAB to 3.4.1 (@dpgaspar)
- [#17698](https://github.com/apache/superset/pull/17698) refactor(monorepo): change coverage of core to 100% (@zhaoyongjie)
- [#17737](https://github.com/apache/superset/pull/17737) chore: fixed spelling error on line 1342 of CONTRIBUTING.md (@JosueLugaro)
- [#17735](https://github.com/apache/superset/pull/17735) chore: fix misspelling of apprear to appear (@jcahela)
- [#17693](https://github.com/apache/superset/pull/17693) chore(de-translations): Add missing German translations (@hbruch)
- [#17715](https://github.com/apache/superset/pull/17715) chore: Rename CertifiedIcon to CertifiedBadge (@geido)
- [#17691](https://github.com/apache/superset/pull/17691) chore: Update TS tasklist script (@etr2460)
- [#17705](https://github.com/apache/superset/pull/17705) chore: unblock ci on postgres lint (@villebro)
- [#17596](https://github.com/apache/superset/pull/17596) refactor(monorepo): relocate deckgl to Superset (@zhaoyongjie)
- [#17689](https://github.com/apache/superset/pull/17689) chore: convert feature flag tests to unit tests (@betodealmeida)
- [#17687](https://github.com/apache/superset/pull/17687) chore: removing redundant docker-entrypoint (@ofekisr)
- [#17679](https://github.com/apache/superset/pull/17679) chore: update babel doc (@zhaoyongjie)
- [#17622](https://github.com/apache/superset/pull/17622) chore: Remove unreachable return statements (@PApostol)
- [#17605](https://github.com/apache/superset/pull/17605) docs(exploring-data): add a native filters section to the exploring data docs (@riahk)
- [#17639](https://github.com/apache/superset/pull/17639) refactor(monorepo): frontend code cleanup after monorepo (@zhaoyongjie)
- [#17631](https://github.com/apache/superset/pull/17631) chore(de-translations): Add and fix German translations (@hbruch)
- [#17626](https://github.com/apache/superset/pull/17626) chore(superset-ui): clean up legacy-plugin-chart-time-table (@ktmud)
- [#17634](https://github.com/apache/superset/pull/17634) chore(plugin-chart-pivot-table): Add more descriptive tooltips for sorting [ID-29] (@kgabryje)
- [#17606](https://github.com/apache/superset/pull/17606) refactor: Add AutoSizer to react-virtualized `Grid` (@hughhhh)
- [#17624](https://github.com/apache/superset/pull/17624) chore: Added unit test to query context change (@AAfghahi)
- [#17623](https://github.com/apache/superset/pull/17623) chore: Update docstrings in presto.py (@PApostol)
- [#17575](https://github.com/apache/superset/pull/17575) chore: bumping `polished` package (@rusackas)
- [#17603](https://github.com/apache/superset/pull/17603) chore: migrate EstimateQueryCostButton component from jsx to tsx (@Damans227)
- [#17516](https://github.com/apache/superset/pull/17516) docs(exploring-data): various updates to match latest superset version (@riahk)
- [#17577](https://github.com/apache/superset/pull/17577) chore: auditing cypress-base dependencies (@rusackas)
- [#17533](https://github.com/apache/superset/pull/17533) chore(deps-dev): bump @types/jquery from 3.5.8 to 3.5.9 in /superset-frontend (@dependabot[bot])
- [#17534](https://github.com/apache/superset/pull/17534) chore(deps-dev): bump @types/enzyme from 3.10.5 to 3.10.10 in /superset-frontend (@dependabot[bot])
- [#17535](https://github.com/apache/superset/pull/17535) chore(deps-dev): bump mini-css-extract-plugin from 2.3.0 to 2.4.5 in /superset-frontend (@dependabot[bot])
- [#17585](https://github.com/apache/superset/pull/17585) chore: disable merge button (@zhaoyongjie)
- [#17584](https://github.com/apache/superset/pull/17584) chore: temporarily update .asf.yml (@zhaoyongjie)
- [#17552](https://github.com/apache/superset/pull/17552) refactor(monorepo): move superset-ui to superset(stage 2) (@zhaoyongjie)
- [#17474](https://github.com/apache/superset/pull/17474) chore: migrate Fieldset component from jsx to tsx (@Damans227)
- [#17556](https://github.com/apache/superset/pull/17556) chore: bump mysqlclient version (@gnought)
- [#17525](https://github.com/apache/superset/pull/17525) chore(translations): Add missing i18n (@hbruch)
- [#17562](https://github.com/apache/superset/pull/17562) chore: Fix deprecated unittest aliases for Python 3.11 compatibility. (@tirkarthi)
- [#17561](https://github.com/apache/superset/pull/17561) chore: disable merge commit option (@villebro)
- [#17560](https://github.com/apache/superset/pull/17560) chore: temporarily enable merge in .asf.yml (@zhaoyongjie)
- [#17326](https://github.com/apache/superset/pull/17326) chore: migrate DragHandle component from jsx to tsx (@Damans227)
- [#17521](https://github.com/apache/superset/pull/17521) chore: bump major on Pillow, optional dependency (@dpgaspar)
- [#17452](https://github.com/apache/superset/pull/17452) chore(deps-dev): bump @types/jquery from 3.3.32 to 3.5.8 in /superset-frontend (@dependabot[bot])
- [#14783](https://github.com/apache/superset/pull/14783) chore: Slovak translation, enabling language and adding first translations (@minho95)
- [#17453](https://github.com/apache/superset/pull/17453) chore(deps-dev): bump eslint-import-resolver-webpack from 0.13.1 to 0.13.2 in /superset-frontend (@dependabot[bot])
- [#17502](https://github.com/apache/superset/pull/17502) docs(exploring-data): Add upload excel notes (@aniaan)
- [#17522](https://github.com/apache/superset/pull/17522) chore: remove deprecated selects and deps (@villebro)
- [#17492](https://github.com/apache/superset/pull/17492) chore: update node version in nvmrc to v16 (@ktmud)
- [#17500](https://github.com/apache/superset/pull/17500) chore(deps-dev): bump @babel/cli from 7.15.7 to 7.16.0 in /superset-frontend (@dependabot[bot])
- [#17478](https://github.com/apache/superset/pull/17478) chore(de-translation): update German translations (based on master) (#17441) (@hbruch)
- [#17501](https://github.com/apache/superset/pull/17501) chore(translations): fix translation literals (@villebro)
- [#17504](https://github.com/apache/superset/pull/17504) docs: add dropbox to users list (@exemplary-citizen)
- [#17361](https://github.com/apache/superset/pull/17361) chore: migrate FormattedNumber component from jsx to tsx (@Damans227)
- [#17509](https://github.com/apache/superset/pull/17509) refactor(chart.commands): separate commands into two different modules (@ofekisr)
- [#17434](https://github.com/apache/superset/pull/17434) chore: Slovenian translation update (@dkrat7)
- [#17497](https://github.com/apache/superset/pull/17497) refactor(QueryContext): separate all processing concerns into QueryContextProcessor (@ofekisr)
- [#17484](https://github.com/apache/superset/pull/17484) docs: mention that username should be admin to load examples in superset docs (@jayakrishnankk)
- [#14837](https://github.com/apache/superset/pull/14837) docs: Update frequently-asked-questions-page.mdx (@kurtiswen)
- [#17496](https://github.com/apache/superset/pull/17496) refactor(QueryContext): move df methods utils to utils package (@ofekisr)
- [#17495](https://github.com/apache/superset/pull/17495) refactor(QueryContext): add QueryContextFactory to meet SRP (@ofekisr)
- [#17482](https://github.com/apache/superset/pull/17482) chore(deps): bump cachelib from 0.1.1 to 0.4.1 (@villebro)
- [#17464](https://github.com/apache/superset/pull/17464) chore(sql_lab): Added Unit Test for stop query exception (@AAfghahi)
- [#17454](https://github.com/apache/superset/pull/17454) chore(deps-dev): bump @types/react-loadable from 5.5.4 to 5.5.6 in /superset-frontend (@dependabot[bot])
- [#17479](https://github.com/apache/superset/pull/17479) refactor(QueryObject): decouple from superset (@ofekisr)
- [#17466](https://github.com/apache/superset/pull/17466) refactor(QueryObject): add QueryObjectFactory to meet SRP (@ofekisr)
- [#17465](https://github.com/apache/superset/pull/17465) refactor(QueryObject): decouple from queryContext and clean code (@ofekisr)
- [#16868](https://github.com/apache/superset/pull/16868) chore(fr-translation): update whole French translation (based on 1.3.0 release) (@audour)
- [#17461](https://github.com/apache/superset/pull/17461) refactor(ChartDataCommand): remove create queryContext command's responsibly (@ofekisr)
- [#17427](https://github.com/apache/superset/pull/17427) refactor(monorepo): stage 1 (@zhaoyongjie)
- [#17451](https://github.com/apache/superset/pull/17451) chore: Ignore docs directory for dependabot (@hughhhh)
- [#17398](https://github.com/apache/superset/pull/17398) test: add native filter default value e2e (@jinghua-qa)
- [#17439](https://github.com/apache/superset/pull/17439) chore: bumping react syntax highlighter and thusly prismjs (@rusackas)
- [#17422](https://github.com/apache/superset/pull/17422) chore: Notify user of custom label colors and related Dashboard color scheme (@geido)
- [#14576](https://github.com/apache/superset/pull/14576) chore(deps): bump hosted-git-info from 2.8.8 to 2.8.9 in /docs (@dependabot[bot])
- [#17438](https://github.com/apache/superset/pull/17438) chore: bump superset-ui 0.18.25 (@zhaoyongjie)
- [#17425](https://github.com/apache/superset/pull/17425) refactor(ChartDataCommand): into two separate commands (@ofekisr)
- [#17407](https://github.com/apache/superset/pull/17407) refactor(TestChartApi): move chart data api tests into TestChartDataApi (@ofekisr)
- [#17405](https://github.com/apache/superset/pull/17405) refactor(ChartDataCommand): separate loading query_context form cache into different module (@ofekisr)
- [#17403](https://github.com/apache/superset/pull/17403) chore: add dependencies for monorepo (@zhaoyongjie)
- [#17400](https://github.com/apache/superset/pull/17400) refactor(ChartData): move chart_data_apis from ChartRestApi ChartDataRestApi (@ofekisr)
- [#17399](https://github.com/apache/superset/pull/17399) refactor(ChartData): move ChartDataResult enums to common (@ofekisr)
- [#17350](https://github.com/apache/superset/pull/17350) docs: add mishmash io to users list (@ntsvetanov)
- [#17387](https://github.com/apache/superset/pull/17387) docs: Reorder install instructions in CONTRIBUTING.md (@willbarrett)
- [#17367](https://github.com/apache/superset/pull/17367) chore: bump @typescript-eslint/eslint-plugin to 5.3.0 (@zhaoyongjie)
- [#17362](https://github.com/apache/superset/pull/17362) chore: bump superset-ui 0.18.20 (@zhaoyongjie)
- [#17343](https://github.com/apache/superset/pull/17343) test: add native filter e2e test part3 (@jinghua-qa)
- [#17325](https://github.com/apache/superset/pull/17325) chore(websocket): bump dependencies (@villebro)
- [#17246](https://github.com/apache/superset/pull/17246) chore: Test cases for annotations and annotation layers incorrect creation through API (@geido)
- [#17306](https://github.com/apache/superset/pull/17306) docs: fix numbering on getting started with kubernetes section (@jameskim0987)
- [#17315](https://github.com/apache/superset/pull/17315) chore: migrate HiddenControl component from jsx to tsx (@Damans227)
- [#17310](https://github.com/apache/superset/pull/17310) chore: bump superset-ui to 0.18.18 (@villebro)
- [#17284](https://github.com/apache/superset/pull/17284) style: remove redundant parentheses from setup.py (@PApostol)
- [#17283](https://github.com/apache/superset/pull/17283) test: add native filter part2 (@jinghua-qa)
- [#17290](https://github.com/apache/superset/pull/17290) chore: Bumping pyarrow / pandas (@craig-rueda)
- [#17293](https://github.com/apache/superset/pull/17293) docs(UPDATING): Adding downtime for #16756 (@exemplary-citizen)
- [#17191](https://github.com/apache/superset/pull/17191) chore(doc): Update BigQuery Connection database connection UI into doc (@rosemarie-chiu)
- [#17231](https://github.com/apache/superset/pull/17231) test: added some sanity test for native filter (@jinghua-qa)
- [#17270](https://github.com/apache/superset/pull/17270) chore: bump superset-ui to 0.18.17 (@john-bodley)
- [#17266](https://github.com/apache/superset/pull/17266) chore: bump deckgl 0.4.13 (@zhaoyongjie)
- [#17069](https://github.com/apache/superset/pull/17069) chore: remove supersetTheme with withTheme (@pkdotson)
- [#17251](https://github.com/apache/superset/pull/17251) chore: bump superset-ui v0.18.16 (@zhaoyongjie)
- [#16950](https://github.com/apache/superset/pull/16950) other(revert): "fix: the calculated columns explicit type convert into date" (@john-bodley)
- [#17220](https://github.com/apache/superset/pull/17220) chore: bump Dremio to 1.2.1 (@hughhhh)
- [#17216](https://github.com/apache/superset/pull/17216) chore: Removes the ChartIcon component (@michael-s-molina)
- [#17232](https://github.com/apache/superset/pull/17232) chore: bump to superset-ui 0.18.15 (@zhaoyongjie)
- [#17171](https://github.com/apache/superset/pull/17171) chore: Add docs to the Select component props (@geido)
- [#17132](https://github.com/apache/superset/pull/17132) chore: Breaks the dataViewCommon folder into TableCollection and Pagination folders (@michael-s-molina)
- [#17215](https://github.com/apache/superset/pull/17215) chore: use official isort in pre-commmit (@zhaoyongjie)
- [#17145](https://github.com/apache/superset/pull/17145) refactor: dashboard->explore url generation (@suddjian)
- [#17130](https://github.com/apache/superset/pull/17130) chore: Moves the datasource components to the components folder (@michael-s-molina)
- [#17028](https://github.com/apache/superset/pull/17028) docs: add Symmetrics to users list (@symmetricsfyi)
- [#17151](https://github.com/apache/superset/pull/17151) chore: update ui packages to 18.14 (@pkdotson)
- [#17146](https://github.com/apache/superset/pull/17146) chore(druid): No transform without time granularity for consistency (@john-bodley)
- [#17101](https://github.com/apache/superset/pull/17101) chore(druid): Explicitly cast col to TIMESTAMP (@john-bodley)
- [#17115](https://github.com/apache/superset/pull/17115) perf(native-filters): Decrease number of unnecessary rerenders in native filters (@kgabryje)
- [#17067](https://github.com/apache/superset/pull/17067) chore: upgrade highlight.js (@suddjian)
- [#17121](https://github.com/apache/superset/pull/17121) chore: bump superset-ui packages to 18.3 (@pkdotson)
- [#17129](https://github.com/apache/superset/pull/17129) chore: remove redundant po2json dev dependency (@villebro)
- [#17102](https://github.com/apache/superset/pull/17102) chore: Include codeowners for the Select component (@michael-s-molina)
- [#16911](https://github.com/apache/superset/pull/16911) test: Cypress 7.0.0 migration (@lyndsiWilliams)
- [#17017](https://github.com/apache/superset/pull/17017) chore: enable BQ tests (@betodealmeida)
- [#14577](https://github.com/apache/superset/pull/14577) build(deps): bump lodash from 4.17.19 to 4.17.21 in /docs (@dependabot[bot])
- [#17050](https://github.com/apache/superset/pull/17050) chore(druid): Standardizing time grain transformations (@john-bodley)
- [#17045](https://github.com/apache/superset/pull/17045) docs: add vscode linter instructions to CONTRIBUTING.md (@suddjian)
- [#16993](https://github.com/apache/superset/pull/16993) style: Update text for SLL Tooltip (@gabester78)
- [#16959](https://github.com/apache/superset/pull/16959) chore(Dashboard): Implement dedicated message for missing dataset (@geido)
- [#17016](https://github.com/apache/superset/pull/17016) docs(pylint): Add context about disablement of Pylint messages (@john-bodley)
- [#17009](https://github.com/apache/superset/pull/17009) chore: bump superset-ui 0.18.10 (@zhaoyongjie)
- [#16974](https://github.com/apache/superset/pull/16974) refactor(filterset): improve response body (@ofekisr)
- [#16999](https://github.com/apache/superset/pull/16999) chore: no direct use of supersetTheme (or bad LESS vars) in SqlEditor (@rusackas)
- [#17000](https://github.com/apache/superset/pull/17000) chore: removing use of supersetTheme in favor of ThemeProvider (@rusackas)
- [#16885](https://github.com/apache/superset/pull/16885) chore: upgrade babel (@suddjian)
- [#16973](https://github.com/apache/superset/pull/16973) test: update required tests to python 3.8 (@villebro)
- [#16689](https://github.com/apache/superset/pull/16689) chore: refactor header menu to show in header grid component (@pkdotson)

### 1.4.2 (Sat Mar 19 00:08:06 2022 +0200)

**Features**

- [#19248](https://github.com/apache/superset/pull/19248) feat: add support for comments in adhoc clauses (@villebro)
- [#18214](https://github.com/apache/superset/pull/18214) feat(docker-compose): add TAG option (@villebro)

**Fixes**

- [#17641](https://github.com/apache/superset/pull/17641) fix(sqla): make text clause escaping optional (@villebro)
- [#18566](https://github.com/apache/superset/pull/18566) fix(plugin-chart-echarts): area chart opacity bug (@villebro)

### 1.4.1

**Database Migrations**

**Features**

**Fixes**

- [#17980](https://github.com/apache/superset/pull/17980) fix: css template API response, less data (@dpgaspar)
- [#17984](https://github.com/apache/superset/pull/17984) fix: Change default SECRET_KEY, improve docs and banner warning on de… (@dpgaspar)
- [#17981](https://github.com/apache/superset/pull/17981) fix: API logger output (@dpgaspar)
- [#18006](https://github.com/apache/superset/pull/18006) fix: SQL Lab sorting of non-numbers (@etr2460)
- [#17573](https://github.com/apache/superset/pull/17573) fix(sqllab): Floating numbers not sorting correctly in result column (@lyndsiWilliams)
- [#17961](https://github.com/apache/superset/pull/17961) fix: update slug name (@pkdotson)
- [#17992](https://github.com/apache/superset/pull/17992) fix: dashboard reload crash (@pkdotson)
- [#18048](https://github.com/apache/superset/pull/18048) fix(dashboard): scope status of native filter not update (@stephenLYZ)
- [#16869](https://github.com/apache/superset/pull/16869) fix: handle TIME column serialization (@frafra)

**Others**
