/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.syncope.core.persistence.jpa.entity.am;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import org.apache.syncope.core.persistence.api.entity.am.CASSPClientApp;

@Entity
@Table(name = JPACASSPClientApp.TABLE)
public class JPACASSPClientApp extends AbstractClientApp implements CASSPClientApp {

    public static final String TABLE = "CASSPClientApp";

    private static final long serialVersionUID = 6422422526695279794L;

    @Column(unique = true, nullable = false)
    private String serviceId;

    @Override
    public String getServiceId() {
        return serviceId;
    }

    @Override
    public void setServiceId(final String serviceId) {
        this.serviceId = serviceId;
    }
}
