/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.syncope.core.provisioning.java.data;

import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.ImplementationDAO;
import org.apache.syncope.core.persistence.api.dao.OIDCC4UIProviderDAO;
import org.apache.syncope.core.persistence.api.entity.OIDCC4UIEntityFactory;
import org.apache.syncope.core.provisioning.api.IntAttrNameParser;
import org.apache.syncope.core.provisioning.api.data.OIDCC4UIProviderDataBinder;
import org.apache.syncope.core.provisioning.api.jexl.JexlTools;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods = false)
public class OIDCC4UIProvisioningContext {

    @ConditionalOnMissingBean
    @Bean
    public OIDCC4UIProviderDataBinder oidcc4UIProviderDataBinder(
            final AnyTypeDAO anyTypeDAO,
            final OIDCC4UIProviderDAO oidcOPDAO,
            final ImplementationDAO implementationDAO,
            final OIDCC4UIEntityFactory entityFactory,
            final IntAttrNameParser intAttrNameParser,
            final JexlTools jexlTools) {

        return new OIDCC4UIProviderDataBinderImpl(
                anyTypeDAO,
                oidcOPDAO,
                implementationDAO,
                entityFactory,
                intAttrNameParser,
                jexlTools);
    }
}
