/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.compress.cocode;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.ArrayUtils;
import org.apache.sysml.runtime.compress.cocode.ColumnGroupPartitioner;
import org.apache.sysml.runtime.compress.cocode.PlanningCoCoder;
import org.apache.sysml.runtime.compress.utils.IntArrayList;
import org.apache.sysml.runtime.util.SortUtils;

public class ColumnGroupPartitionerBinPacking
extends ColumnGroupPartitioner {
    private static final boolean FIRST_FIT_DEC = true;
    private static final int MAX_COL_FIRST_FIT = 16384;
    private static final int MAX_COL_PER_GROUP = 1024;
    public static double BIN_CAPACITY = 3.2E-5;

    @Override
    public List<int[]> partitionColumns(List<Integer> groupCols, HashMap<Integer, PlanningCoCoder.GroupableColInfo> groupColsInfo) {
        int[] items = new int[groupCols.size()];
        double[] itemWeights = new double[groupCols.size()];
        for (int i = 0; i < groupCols.size(); ++i) {
            int col;
            items[i] = col = groupCols.get(i).intValue();
            itemWeights[i] = groupColsInfo.get((Object)Integer.valueOf((int)col)).cardRatio;
        }
        ArrayList<IntArrayList> bins = new ArrayList<IntArrayList>();
        for (int i = 0; i < items.length; i += 16384) {
            int iu = Math.min(i + 16384, items.length);
            int[] litems = Arrays.copyOfRange(items, i, iu);
            double[] litemWeights = Arrays.copyOfRange(itemWeights, i, iu);
            SortUtils.sortByValue(0, litems.length, litemWeights, litems);
            ArrayUtils.reverse((int[])litems);
            ArrayUtils.reverse((double[])litemWeights);
            bins.addAll(ColumnGroupPartitionerBinPacking.packFirstFit(litems, litemWeights));
        }
        return bins.stream().map(b -> b.extractValues(true)).collect(Collectors.toList());
    }

    private static List<IntArrayList> packFirstFit(int[] items, double[] itemWeights) {
        ArrayList<IntArrayList> bins = new ArrayList<IntArrayList>();
        double[] binWeights = new double[16];
        for (int i = 0; i < items.length; ++i) {
            boolean assigned = false;
            for (int j = 0; j < bins.size(); ++j) {
                double newBinWeight = binWeights[j] - itemWeights[i];
                if (!(newBinWeight >= 0.0) || ((IntArrayList)bins.get(j)).size() >= 1023) continue;
                ((IntArrayList)bins.get(j)).appendValue(items[i]);
                binWeights[j] = newBinWeight;
                assigned = true;
                break;
            }
            if (assigned) continue;
            if (bins.size() == binWeights.length) {
                binWeights = Arrays.copyOf(binWeights, 2 * binWeights.length);
            }
            bins.add(new IntArrayList(items[i]));
            binWeights[bins.size() - 1] = BIN_CAPACITY - itemWeights[i];
        }
        return bins;
    }
}

