/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.cp;

import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPInstruction;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.UnaryCPInstruction;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class QuantileSortCPInstruction
extends UnaryCPInstruction {
    private QuantileSortCPInstruction(CPOperand in, CPOperand out, String opcode, String istr) {
        this(in, null, out, opcode, istr);
    }

    private QuantileSortCPInstruction(CPOperand in1, CPOperand in2, CPOperand out, String opcode, String istr) {
        super(CPInstruction.CPType.QSort, null, in1, in2, out, opcode, istr);
    }

    public static QuantileSortCPInstruction parseInstruction(String str) {
        CPOperand in1 = new CPOperand("", Types.ValueType.UNKNOWN, Types.DataType.UNKNOWN);
        CPOperand in2 = null;
        CPOperand out = new CPOperand("", Types.ValueType.UNKNOWN, Types.DataType.UNKNOWN);
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        if (opcode.equalsIgnoreCase("qsort")) {
            if (parts.length == 3) {
                QuantileSortCPInstruction.parseUnaryInstruction(str, in1, out);
                return new QuantileSortCPInstruction(in1, out, opcode, str);
            }
            if (parts.length == 4) {
                in2 = new CPOperand("", Types.ValueType.UNKNOWN, Types.DataType.UNKNOWN);
                QuantileSortCPInstruction.parseUnaryInstruction(str, in1, in2, out);
                return new QuantileSortCPInstruction(in1, in2, out, opcode, str);
            }
            throw new DMLRuntimeException("Invalid number of operands in instruction: " + str);
        }
        throw new DMLRuntimeException("Unknown opcode while parsing a QuantileSortCPInstruction: " + str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        MatrixBlock matBlock = ec.getMatrixInput(this.input1.getName());
        MatrixBlock wtBlock = null;
        if (this.input2 != null) {
            wtBlock = ec.getMatrixInput(this.input2.getName());
        }
        MatrixBlock resultBlock = matBlock.sortOperations(wtBlock, new MatrixBlock());
        ec.releaseMatrixInput(this.input1.getName());
        if (this.input2 != null) {
            ec.releaseMatrixInput(this.input2.getName());
        }
        ec.setMatrixOutput(this.output.getName(), resultBlock);
    }
}

