/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.data;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import org.apache.commons.lang.NotImplementedException;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.CacheBlock;
import org.apache.sysds.runtime.data.BasicTensorBlock;
import org.apache.sysds.runtime.data.DataTensorBlock;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.data.LibTensorBincell;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.meta.DataCharacteristics;
import org.apache.sysds.runtime.meta.TensorCharacteristics;
import org.apache.sysds.runtime.util.UtilFunctions;

public class TensorBlock
implements CacheBlock,
Externalizable {
    private static final long serialVersionUID = -8768054067319422277L;
    public static final int[] DEFAULT_DIMS = new int[]{0, 0};
    public static final Types.ValueType DEFAULT_VTYPE = Types.ValueType.FP64;
    private int[] _dims;
    private boolean _basic = true;
    private DataTensorBlock _dataTensor = null;
    private BasicTensorBlock _basicTensor = null;

    public TensorBlock() {
        this(DEFAULT_DIMS, true);
    }

    public TensorBlock(int[] dims, boolean basic) {
        this._dims = dims;
        this._basic = basic;
    }

    public TensorBlock(Types.ValueType vt, int[] dims) {
        this(dims, true);
        this._basicTensor = new BasicTensorBlock(vt, dims, false);
    }

    public TensorBlock(Types.ValueType[] schema, int[] dims) {
        this(dims, false);
        this._dataTensor = new DataTensorBlock(schema, dims);
    }

    public TensorBlock(double value) {
        this._dims = new int[]{1, 1};
        this._basicTensor = new BasicTensorBlock(value);
    }

    public TensorBlock(BasicTensorBlock basicTensor) {
        this(basicTensor._dims, true);
        this._basicTensor = basicTensor;
    }

    public TensorBlock(DataTensorBlock dataTensor) {
        this(dataTensor._dims, false);
        this._dataTensor = dataTensor;
    }

    public TensorBlock(TensorBlock that) {
        this.copy(that);
    }

    public void reset() {
        if (this._basic) {
            if (this._basicTensor == null) {
                this._basicTensor = new BasicTensorBlock(DEFAULT_VTYPE, this._dims, false);
            }
            this._basicTensor.reset();
        } else {
            if (this._dataTensor == null) {
                this._dataTensor = new DataTensorBlock(DEFAULT_VTYPE, this._dims);
            }
            this._dataTensor.reset();
        }
    }

    public void reset(int[] dims) {
        this._dims = dims;
        if (this._basic) {
            if (this._basicTensor == null) {
                this._basicTensor = new BasicTensorBlock(DEFAULT_VTYPE, this._dims, false);
            }
            this._basicTensor.reset(dims);
        } else {
            if (this._dataTensor == null) {
                this._dataTensor = new DataTensorBlock(DEFAULT_VTYPE, this._dims);
            }
            this._dataTensor.reset(dims);
        }
    }

    public boolean isBasic() {
        return this._basic;
    }

    public boolean isAllocated() {
        if (this._basic) {
            return this._basicTensor != null && this._basicTensor.isAllocated();
        }
        return this._dataTensor != null && this._dataTensor.isAllocated();
    }

    public TensorBlock allocateBlock() {
        if (this._basic) {
            if (this._basicTensor == null) {
                this._basicTensor = new BasicTensorBlock(DEFAULT_VTYPE, this._dims, false);
            }
            this._basicTensor.allocateBlock();
        } else {
            if (this._dataTensor == null) {
                this._dataTensor = new DataTensorBlock(DEFAULT_VTYPE, this._dims);
            }
            this._dataTensor.allocateBlock();
        }
        return this;
    }

    public BasicTensorBlock getBasicTensor() {
        return this._basicTensor;
    }

    public DataTensorBlock getDataTensor() {
        return this._dataTensor;
    }

    public Types.ValueType getValueType() {
        if (this._basic) {
            return this._basicTensor == null ? DEFAULT_VTYPE : this._basicTensor.getValueType();
        }
        return null;
    }

    public Types.ValueType[] getSchema() {
        if (this._basic) {
            return null;
        }
        if (this._dataTensor == null) {
            Types.ValueType[] schema = new Types.ValueType[this.getDim(1)];
            Arrays.fill((Object[])schema, (Object)DEFAULT_VTYPE);
            return schema;
        }
        return this._dataTensor.getSchema();
    }

    public int getNumDims() {
        return this._dims.length;
    }

    @Override
    public int getNumRows() {
        return this.getDim(0);
    }

    @Override
    public int getNumColumns() {
        return this.getDim(1);
    }

    @Override
    public DataCharacteristics getDataCharacteristics() {
        return new TensorCharacteristics(this.getLongDims(), -1);
    }

    @Override
    public long getInMemorySize() {
        return 0L;
    }

    @Override
    public boolean isShallowSerialize() {
        return false;
    }

    @Override
    public boolean isShallowSerialize(boolean inclConvert) {
        return false;
    }

    @Override
    public void toShallowSerializeBlock() {
    }

    @Override
    public void compactEmptyBlock() {
    }

    @Override
    public CacheBlock slice(int rl, int ru, int cl, int cu, CacheBlock block) {
        return this.slice(rl, ru, cl, cu, false, block);
    }

    @Override
    public CacheBlock slice(int rl, int ru, int cl, int cu, boolean deep, CacheBlock block) {
        if (!(block instanceof TensorBlock)) {
            throw new RuntimeException("TensorBlock.slice(int,int,int,int,CacheBlock) CacheBlock was no TensorBlock");
        }
        TensorBlock tb = (TensorBlock)block;
        int[] dims = new int[this._dims.length];
        dims[0] = ru - rl + 1;
        dims[1] = cu - cl + 1;
        System.arraycopy(this._dims, 2, dims, 2, this._dims.length - 2);
        tb.reset(dims);
        int[] offsets = new int[dims.length];
        offsets[0] = rl;
        offsets[1] = cl;
        return this.slice(offsets, tb);
    }

    @Override
    public void merge(CacheBlock that, boolean appendOnly) {
    }

    @Override
    public double getDouble(int r, int c) {
        return this.get(r, c);
    }

    @Override
    public double getDoubleNaN(int r, int c) {
        return this.getDouble(r, c);
    }

    @Override
    public String getString(int r, int c) {
        double v = this.get(r, c);
        if (Double.isNaN(v)) {
            return null;
        }
        return String.valueOf(v);
    }

    public int getDim(int i) {
        return this._dims[i];
    }

    public int[] getDims() {
        return this._dims;
    }

    public long[] getLongDims() {
        return Arrays.stream(this._dims).mapToLong(i -> i).toArray();
    }

    public static void getNextIndexes(int[] dims, int[] ix) {
        int i;
        int n = i = ix.length - 1;
        ix[n] = ix[n] + 1;
        if (ix[i] == dims[i]) {
            while (ix[i] == dims[i]) {
                ix[i] = 0;
                if (--i < 0) break;
                int n2 = i;
                ix[n2] = ix[n2] + 1;
            }
        }
    }

    public void getNextIndexes(int[] ix) {
        TensorBlock.getNextIndexes(this._dims, ix);
    }

    public boolean isVector() {
        return this.getNumDims() <= 2 && (this.getDim(0) == 1 || this.getDim(1) == 1);
    }

    public boolean isMatrix() {
        return this.getNumDims() == 2 && this.getDim(0) > 1 && this.getDim(1) > 1;
    }

    public long getLength() {
        return UtilFunctions.prod(this._dims);
    }

    public boolean isEmpty() {
        return this.isEmpty(false);
    }

    public boolean isEmpty(boolean safe) {
        if (this._basic) {
            return this._basicTensor == null || this._basicTensor.isEmpty(safe);
        }
        return this._dataTensor == null || this._dataTensor.isEmpty(safe);
    }

    public long getNonZeros() {
        if (!this.isAllocated()) {
            return 0L;
        }
        if (this._basic) {
            return this._basicTensor.getNonZeros();
        }
        return this._dataTensor.getNonZeros();
    }

    public Object get(int[] ix) {
        if (this._basic && this._basicTensor != null) {
            return this._basicTensor.get(ix);
        }
        if (this._dataTensor != null) {
            return this._dataTensor.get(ix);
        }
        return 0.0;
    }

    public double get(int r, int c) {
        if (this._basic && this._basicTensor != null) {
            return this._basicTensor.get(r, c);
        }
        if (this._dataTensor != null) {
            return this._dataTensor.get(r, c);
        }
        return 0.0;
    }

    public void set(Object v) {
        if (this._basic) {
            if (this._basicTensor == null) {
                this._basicTensor = new BasicTensorBlock(DEFAULT_VTYPE, this._dims, false);
            }
            this._basicTensor.set(v);
        } else {
            if (this._dataTensor == null) {
                this._dataTensor = new DataTensorBlock(this.getSchema(), this._dims);
            }
            this._dataTensor.set(v);
        }
    }

    public void set(MatrixBlock other) {
        if (!this._basic) {
            throw new DMLRuntimeException("TensorBlock.set(MatrixBlock) is not yet implemented for heterogeneous tensors");
        }
        this._basicTensor.set(other);
    }

    public void set(int[] ix, Object v) {
        if (this._basic) {
            if (this._basicTensor == null) {
                this._basicTensor = new BasicTensorBlock(DEFAULT_VTYPE, this._dims, false);
            }
            this._basicTensor.set(ix, v);
        } else {
            if (this._dataTensor == null) {
                this._dataTensor = new DataTensorBlock(this.getSchema(), this._dims);
            }
            this._dataTensor.set(ix, v);
        }
    }

    public void set(int r, int c, double v) {
        if (this._basic) {
            if (this._basicTensor == null) {
                this._basicTensor = new BasicTensorBlock(DEFAULT_VTYPE, this._dims, false);
            }
            this._basicTensor.set(r, c, v);
        } else {
            if (this._dataTensor == null) {
                this._dataTensor = new DataTensorBlock(this.getSchema(), this._dims);
            }
            this._dataTensor.set(r, c, v);
        }
    }

    public TensorBlock slice(int[] offsets, TensorBlock outBlock) {
        int[] srcIx = (int[])offsets.clone();
        int[] destIx = new int[offsets.length];
        int l = 0;
        while ((long)l < outBlock.getLength()) {
            int i;
            outBlock.set(destIx, this.get(srcIx));
            int n = i = outBlock.getNumDims() - 1;
            destIx[n] = destIx[n] + 1;
            int n2 = i;
            srcIx[n2] = srcIx[n2] + 1;
            while (destIx[i] == outBlock.getDim(i)) {
                destIx[i] = 0;
                srcIx[i] = offsets[i];
                if (--i < 0) {
                    return outBlock;
                }
                int n3 = i;
                destIx[n3] = destIx[n3] + 1;
                int n4 = i;
                srcIx[n4] = srcIx[n4] + 1;
            }
            ++l;
        }
        return outBlock;
    }

    public TensorBlock copy(TensorBlock src) {
        this._dims = (int[])src._dims.clone();
        this._basic = src._basic;
        if (this._basic) {
            this._dataTensor = null;
            this._basicTensor = src._basicTensor == null ? null : new BasicTensorBlock(src._basicTensor);
        } else {
            this._basicTensor = null;
            this._dataTensor = src._dataTensor == null ? null : new DataTensorBlock(src._dataTensor);
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TensorBlock copy(int[] lower, int[] upper, TensorBlock src) {
        if (this._basic) {
            if (!src._basic) throw new DMLRuntimeException("Copying `DataTensor` into `BasicTensor` is not a safe operation.");
            this._basicTensor.copy(lower, upper, src._basicTensor);
            return this;
        } else if (src._basic) {
            this._dataTensor.copy(lower, upper, new DataTensorBlock(src._basicTensor));
            return this;
        } else {
            this._dataTensor.copy(lower, upper, src._dataTensor);
        }
        return this;
    }

    public TensorBlock copyExact(int[] lower, int[] upper, TensorBlock src) {
        int[] destIx = (int[])lower.clone();
        int[] srcIx = new int[lower.length];
        long length = src.getLength();
        for (long l = 0L; l < length; ++l) {
            int i;
            this.set(destIx, src.get(srcIx));
            int n = i = src.getNumDims() - 1;
            srcIx[n] = srcIx[n] + 1;
            int n2 = i;
            destIx[n2] = destIx[n2] + 1;
            while (srcIx[i] == src.getDim(i)) {
                srcIx[i] = 0;
                destIx[i] = lower[i];
                if (--i < 0) {
                    return this;
                }
                int n3 = i;
                srcIx[n3] = srcIx[n3] + 1;
                int n4 = i;
                destIx[n4] = destIx[n4] + 1;
            }
        }
        return this;
    }

    @Override
    public long getExactSerializedSize() {
        long size = 1 + 4 * (1 + this._dims.length) + 1;
        if (this.isAllocated()) {
            if (this._basic) {
                size += 1L + this.getExactBlockDataSerializedSize(this._basicTensor);
            } else {
                size += (long)this._dataTensor._schema.length;
                for (BasicTensorBlock bt : this._dataTensor._colsdata) {
                    if (bt == null) continue;
                    size += this.getExactBlockDataSerializedSize(bt);
                }
            }
        }
        return size;
    }

    public long getExactBlockDataSerializedSize(BasicTensorBlock bt) {
        long size;
        block10: {
            block9: {
                size = 9L;
                if (bt.isSparse()) break block9;
                switch (bt._vt) {
                    case UINT8: {
                        size += 1L * this.getLength();
                        break;
                    }
                    case INT32: 
                    case FP32: {
                        size += 4L * this.getLength();
                        break;
                    }
                    case INT64: 
                    case FP64: {
                        size += 8L * this.getLength();
                        break;
                    }
                    case BOOLEAN: {
                        size += this.getLength();
                        break;
                    }
                    case STRING: {
                        int[] ix = new int[bt._dims.length];
                        int i = 0;
                        while ((long)i < bt.getLength()) {
                            String s = (String)bt.get(ix);
                            size += (long)IOUtilFunctions.getUTFSize(s == null ? "" : s);
                            TensorBlock.getNextIndexes(bt.getDims(), ix);
                            ++i;
                        }
                        break block10;
                    }
                    case UNKNOWN: {
                        throw new NotImplementedException();
                    }
                }
                break block10;
            }
            throw new NotImplementedException();
        }
        return size;
    }

    public void write(DataOutput out) throws IOException {
        out.writeBoolean(this._basic);
        out.writeInt(this._dims.length);
        for (int dim : this._dims) {
            out.writeInt(dim);
        }
        if (!this.isAllocated()) {
            out.writeByte(SERIALIZED_TYPES.EMPTY.ordinal());
        } else if (this._basic) {
            out.writeByte(SERIALIZED_TYPES.BASIC.ordinal());
            out.writeByte(this._basicTensor.getValueType().ordinal());
            this.writeBlockData(out, this._basicTensor);
        } else {
            out.writeByte(SERIALIZED_TYPES.DATA.ordinal());
            for (int i = 0; i < this.getDim(1); ++i) {
                out.writeByte(this._dataTensor._schema[i].ordinal());
            }
            for (BasicTensorBlock bt : this._dataTensor._colsdata) {
                if (bt == null) continue;
                this.writeBlockData(out, bt);
            }
        }
    }

    public void writeBlockData(DataOutput out, BasicTensorBlock bt) throws IOException {
        out.writeLong(bt.getNonZeros());
        if (bt.isEmpty(false)) {
            out.writeByte(Types.BlockType.EMPTY_BLOCK.ordinal());
        } else if (!bt.isSparse()) {
            out.writeByte(Types.BlockType.DENSE_BLOCK.ordinal());
            DenseBlock a = bt.getDenseBlock();
            int odims = (int)UtilFunctions.prod(bt._dims, 1);
            int[] ix = new int[bt._dims.length];
            for (int i = 0; i < bt._dims[0]; ++i) {
                ix[0] = i;
                block9: for (int j = 0; j < odims; ++j) {
                    ix[ix.length - 1] = j;
                    switch (bt._vt) {
                        case FP32: {
                            out.writeFloat((float)a.get(i, j));
                            continue block9;
                        }
                        case FP64: {
                            out.writeDouble(a.get(i, j));
                            continue block9;
                        }
                        case INT32: {
                            out.writeInt((int)a.getLong(ix));
                            continue block9;
                        }
                        case INT64: {
                            out.writeLong(a.getLong(ix));
                            continue block9;
                        }
                        case BOOLEAN: {
                            out.writeBoolean(a.get(i, j) != 0.0);
                            continue block9;
                        }
                        case STRING: {
                            String s = a.getString(ix);
                            out.writeUTF(s == null ? "" : s);
                            continue block9;
                        }
                        default: {
                            throw new DMLRuntimeException("Unsupported value type: " + (Object)((Object)bt._vt));
                        }
                    }
                }
            }
        } else {
            throw new NotImplementedException();
        }
    }

    public void readFields(DataInput in) throws IOException {
        this._basic = in.readBoolean();
        this._dims = new int[in.readInt()];
        for (int i = 0; i < this._dims.length; ++i) {
            this._dims[i] = in.readInt();
        }
        switch (SERIALIZED_TYPES.values()[in.readByte()]) {
            case EMPTY: {
                break;
            }
            case BASIC: {
                this._basicTensor = new BasicTensorBlock(Types.ValueType.values()[in.readByte()], this._dims, false);
                this.readBlockData(in, this._basicTensor);
                break;
            }
            case DATA: {
                int i;
                Types.ValueType[] schema = new Types.ValueType[this.getDim(1)];
                for (i = 0; i < this.getDim(1); ++i) {
                    schema[i] = Types.ValueType.values()[in.readByte()];
                }
                this._dataTensor = new DataTensorBlock(schema, this._dims);
                for (i = 0; i < this._dataTensor._colsdata.length; ++i) {
                    if (this._dataTensor._colsdata[i] == null) continue;
                    this.readBlockData(in, this._dataTensor._colsdata[i]);
                }
                break;
            }
        }
    }

    protected void readBlockData(DataInput in, BasicTensorBlock bt) throws IOException {
        bt._nnz = in.readLong();
        switch (Types.BlockType.values()[in.readByte()]) {
            case EMPTY_BLOCK: {
                this.reset(bt._dims);
                return;
            }
            case DENSE_BLOCK: {
                bt.allocateDenseBlock(false);
                DenseBlock a = bt.getDenseBlock();
                int odims = (int)UtilFunctions.prod(bt._dims, 1);
                int[] ix = new int[bt._dims.length];
                for (int i = 0; i < bt._dims[0]; ++i) {
                    ix[0] = i;
                    block14: for (int j = 0; j < odims; ++j) {
                        ix[ix.length - 1] = j;
                        switch (bt._vt) {
                            case FP32: {
                                a.set(i, j, in.readFloat());
                                continue block14;
                            }
                            case FP64: {
                                a.set(i, j, in.readDouble());
                                continue block14;
                            }
                            case INT32: {
                                a.set(ix, in.readInt());
                                continue block14;
                            }
                            case INT64: {
                                a.set(ix, in.readLong());
                                continue block14;
                            }
                            case BOOLEAN: {
                                a.set(i, j, in.readByte());
                                continue block14;
                            }
                            case STRING: {
                                a.set(ix, in.readUTF());
                                continue block14;
                            }
                            default: {
                                throw new DMLRuntimeException("Unsupported value type: " + (Object)((Object)bt._vt));
                            }
                        }
                    }
                }
                break;
            }
            case SPARSE_BLOCK: 
            case ULTRA_SPARSE_BLOCK: {
                throw new NotImplementedException();
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.write(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.readFields(in);
    }

    public TensorBlock binaryOperations(BinaryOperator op, TensorBlock thatValue, TensorBlock result) {
        if (!LibTensorBincell.isValidDimensionsBinary(this, thatValue)) {
            throw new RuntimeException("Block sizes are not matched for binary cell operations");
        }
        if (!this._basic || !thatValue.isBasic()) {
            throw new RuntimeException("Binary operations on tensors only supported for BasicTensors at the moment");
        }
        Types.ValueType vt = TensorBlock.resultValueType(this.getValueType(), thatValue.getValueType());
        if (result == null || result.getValueType() != vt) {
            result = new TensorBlock(vt, this._dims);
        } else {
            result.reset(this._dims);
        }
        LibTensorBincell.bincellOp(this, thatValue, result, op);
        return result;
    }

    public static Types.ValueType resultValueType(Types.ValueType in1, Types.ValueType in2) {
        if (in1 == Types.ValueType.UNKNOWN || in2 == Types.ValueType.UNKNOWN) {
            throw new DMLRuntimeException("Operations on unknown value types not possible");
        }
        if (in1 == Types.ValueType.STRING || in2 == Types.ValueType.STRING) {
            return Types.ValueType.STRING;
        }
        if (in1 == Types.ValueType.FP64 || in2 == Types.ValueType.FP64) {
            return Types.ValueType.FP64;
        }
        if (in1 == Types.ValueType.FP32 || in2 == Types.ValueType.FP32) {
            return Types.ValueType.FP32;
        }
        if (in1 == Types.ValueType.INT64 || in2 == Types.ValueType.INT64) {
            return Types.ValueType.INT64;
        }
        if (in1 == Types.ValueType.INT32 || in2 == Types.ValueType.INT32) {
            return Types.ValueType.INT32;
        }
        return Types.ValueType.INT64;
    }

    private static enum SERIALIZED_TYPES {
        EMPTY,
        BASIC,
        DATA;

    }
}

