/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.cocode;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.CompressionSettings;
import org.apache.sysds.runtime.compress.cost.ICostEstimate;
import org.apache.sysds.runtime.compress.estim.CompressedSizeEstimator;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfo;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfoColGroup;

public abstract class AColumnCoCoder {
    protected static final Log LOG = LogFactory.getLog((String)AColumnCoCoder.class.getName());
    protected final CompressedSizeEstimator _sest;
    protected final ICostEstimate _cest;
    protected final CompressionSettings _cs;

    protected AColumnCoCoder(CompressedSizeEstimator sizeEstimator, ICostEstimate costEstimator, CompressionSettings cs) {
        this._sest = sizeEstimator;
        this._cest = costEstimator;
        this._cs = cs;
    }

    protected abstract CompressedSizeInfo coCodeColumns(CompressedSizeInfo var1, int var2);

    protected CompressedSizeInfoColGroup join(int[] joined, CompressedSizeInfoColGroup lhs, CompressedSizeInfoColGroup rhs, boolean analyze) {
        return analyze ? this._sest.estimateJoinCompressedSize(joined, lhs, rhs) : this.joinWithoutAnalysis(joined, lhs, rhs);
    }

    protected CompressedSizeInfoColGroup joinWithoutAnalysis(int[] joined, CompressedSizeInfoColGroup lhs, CompressedSizeInfoColGroup rhs) {
        int lhsV = lhs.getNumVals();
        int rhsV = rhs.getNumVals();
        int joinedMaxDistinct = (int)Math.min((long)lhsV * (long)rhsV, (long)this._sest.getNumRows());
        return new CompressedSizeInfoColGroup(joined, joinedMaxDistinct, this._sest.getNumRows());
    }

    protected CompressedSizeInfoColGroup analyze(CompressedSizeInfoColGroup g) {
        if (g.getBestCompressionType() == null) {
            return this._sest.estimateCompressedColGroupSize(g.getColumns());
        }
        return g;
    }
}

