/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.fed;

import java.util.ArrayList;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.federated.FederatedRequest;
import org.apache.sysds.runtime.controlprogram.federated.FederatedResponse;
import org.apache.sysds.runtime.controlprogram.federated.FederatedUDF;
import org.apache.sysds.runtime.controlprogram.federated.FederationMap;
import org.apache.sysds.runtime.controlprogram.federated.FederationUtils;
import org.apache.sysds.runtime.functionobjects.CM;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CM_COV_Object;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.Data;
import org.apache.sysds.runtime.instructions.cp.DoubleObject;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.instructions.fed.AggregateUnaryFEDInstruction;
import org.apache.sysds.runtime.lineage.LineageItem;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.CMOperator;
import org.apache.sysds.runtime.matrix.operators.Operator;

public class CentralMomentFEDInstruction
extends AggregateUnaryFEDInstruction {
    private CentralMomentFEDInstruction(CMOperator cm, CPOperand in1, CPOperand in2, CPOperand in3, CPOperand out, String opcode, String str) {
        super((Operator)cm, in1, in2, in3, out, opcode, str);
    }

    public static CentralMomentFEDInstruction parseInstruction(String str) {
        int cmOrder;
        CPOperand in1 = new CPOperand("", Types.ValueType.UNKNOWN, Types.DataType.UNKNOWN);
        CPOperand in2 = null;
        CPOperand in3 = null;
        CPOperand out = new CPOperand("", Types.ValueType.UNKNOWN, Types.DataType.UNKNOWN);
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        if (!opcode.equalsIgnoreCase("cm")) {
            throw new DMLRuntimeException("Unsupported opcode " + opcode);
        }
        if (parts.length == 4) {
            in2 = new CPOperand("", Types.ValueType.UNKNOWN, Types.DataType.UNKNOWN);
            CentralMomentFEDInstruction.parseUnaryInstruction(str, in1, in2, out);
        } else if (parts.length == 5) {
            in2 = new CPOperand("", Types.ValueType.UNKNOWN, Types.DataType.UNKNOWN);
            in3 = new CPOperand("", Types.ValueType.UNKNOWN, Types.DataType.UNKNOWN);
            CentralMomentFEDInstruction.parseUnaryInstruction(str, in1, in2, in3, out);
        }
        try {
            cmOrder = in3 == null ? Integer.parseInt(in2.getName()) : Integer.parseInt(in3.getName());
        }
        catch (NumberFormatException e) {
            cmOrder = -1;
        }
        CMOperator.AggregateOperationTypes opType = CMOperator.getCMAggOpType(cmOrder);
        CMOperator cm = new CMOperator(CM.getCMFnObject(opType), opType);
        return new CentralMomentFEDInstruction(cm, in1, in2, in3, out, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        MatrixObject mo = ec.getMatrixObject(this.input1.getName());
        ScalarObject order = ec.getScalarInput(this.input3 == null ? this.input2 : this.input3);
        CMOperator cm_op = (CMOperator)this._optr;
        if (cm_op.getAggOpType() == CMOperator.AggregateOperationTypes.INVALID) {
            cm_op = cm_op.setCMAggOp((int)order.getLongValue());
        }
        FederationMap fedMapping = mo.getFedMapping();
        ArrayList globalCmobj = new ArrayList();
        long varID = FederationUtils.getNextFedDataID();
        CMOperator finalCm_op = cm_op;
        fedMapping.mapParallel(varID, (range, data) -> {
            try {
                Object wtBlock;
                FederatedResponse response;
                if (this.input3 == null) {
                    response = data.executeFederatedOperation(new FederatedRequest(FederatedRequest.RequestType.EXEC_UDF, -1L, new CMFunction(data.getVarID(), finalCm_op))).get();
                } else {
                    wtBlock = ec.getMatrixInput(this.input2.getName());
                    response = data.executeFederatedOperation(new FederatedRequest(FederatedRequest.RequestType.EXEC_UDF, -1L, new CMWeightsFunction(data.getVarID(), finalCm_op, (MatrixBlock)wtBlock))).get();
                }
                if (!response.isSuccessful()) {
                    response.throwExceptionFromResponse();
                }
                wtBlock = globalCmobj;
                synchronized (wtBlock) {
                    globalCmobj.add((CM_COV_Object)response.getData()[0]);
                }
            }
            catch (Exception e) {
                throw new DMLRuntimeException(e);
            }
            return null;
        });
        Optional res = globalCmobj.stream().reduce((arg0, arg1) -> (CM_COV_Object)finalCm_op.fn.execute((Data)arg0, (Data)arg1));
        try {
            ec.setScalarOutput(this.output.getName(), new DoubleObject(((CM_COV_Object)res.get()).getRequiredResult(finalCm_op)));
        }
        catch (Exception e) {
            throw new DMLRuntimeException(e);
        }
    }

    private static class CMWeightsFunction
    extends FederatedUDF {
        private static final long serialVersionUID = -3685746246551622021L;
        private final CMOperator _op;
        private final MatrixBlock _weights;

        protected CMWeightsFunction(long input, CMOperator op, MatrixBlock weights) {
            super(new long[]{input});
            this._op = op;
            this._weights = weights;
        }

        @Override
        public FederatedResponse execute(ExecutionContext ec, Data ... data) {
            MatrixBlock mb = (MatrixBlock)((MatrixObject)data[0]).acquireReadAndRelease();
            return new FederatedResponse(FederatedResponse.ResponseType.SUCCESS, mb.cmOperations(this._op, this._weights));
        }

        @Override
        public Pair<String, LineageItem> getLineageItem(ExecutionContext ec) {
            return null;
        }
    }

    private static class CMFunction
    extends FederatedUDF {
        private static final long serialVersionUID = 7460149207607220994L;
        private final CMOperator _op;

        public CMFunction(long input, CMOperator op) {
            super(new long[]{input});
            this._op = op;
        }

        @Override
        public FederatedResponse execute(ExecutionContext ec, Data ... data) {
            MatrixBlock mb = (MatrixBlock)((MatrixObject)data[0]).acquireReadAndRelease();
            return new FederatedResponse(FederatedResponse.ResponseType.SUCCESS, mb.cmOperations(this._op));
        }

        @Override
        public Pair<String, LineageItem> getLineageItem(ExecutionContext ec) {
            return null;
        }
    }
}

