/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.broadcast;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.collections4.map.AbstractReferenceMap;
import org.apache.commons.collections4.map.ReferenceMap;
import org.apache.spark.SparkConf;
import org.apache.spark.api.python.PythonBroadcast;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.broadcast.BroadcastFactory;
import org.apache.spark.broadcast.TorrentBroadcastFactory;
import org.apache.spark.internal.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005}a!B\n\u0015\u0001Ya\u0002\u0002C\u0015\u0001\u0005\u000b\u0007I\u0011A\u0016\t\u0011=\u0002!\u0011!Q\u0001\n1B\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\u0006k\u0001!\tA\u000e\u0005\bw\u0001\u0001\r\u0011\"\u0003,\u0011\u001da\u0004\u00011A\u0005\nuBaa\u0011\u0001!B\u0013a\u0003b\u0002#\u0001\u0001\u0004%I!\u0012\u0005\b\u0013\u0002\u0001\r\u0011\"\u0003K\u0011\u0019a\u0005\u0001)Q\u0005\r\")Q\n\u0001C\u0005\u001d\")q\n\u0001C\u0001\u001d\"9\u0001\u000b\u0001b\u0001\n\u0013\t\u0006B\u00020\u0001A\u0003%!\u000b\u0003\u0005`\u0001\t\u0007I\u0011\u0001\u000ba\u0011\u0019A\u0007\u0001)A\u0005C\")\u0011\u000e\u0001C\u0001U\"9\u0011\u0011\u0002\u0001\u0005\u0002\u0005-!\u0001\u0005\"s_\u0006$7-Y:u\u001b\u0006t\u0017mZ3s\u0015\t)b#A\u0005ce>\fGmY1ti*\u0011q\u0003G\u0001\u0006gB\f'o\u001b\u0006\u00033i\ta!\u00199bG\",'\"A\u000e\u0002\u0007=\u0014xmE\u0002\u0001;\r\u0002\"AH\u0011\u000e\u0003}Q\u0011\u0001I\u0001\u0006g\u000e\fG.Y\u0005\u0003E}\u0011a!\u00118z%\u00164\u0007C\u0001\u0013(\u001b\u0005)#B\u0001\u0014\u0017\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\u0015&\u0005\u001daunZ4j]\u001e\f\u0001\"[:Ee&4XM]\u0002\u0001+\u0005a\u0003C\u0001\u0010.\u0013\tqsDA\u0004C_>dW-\u00198\u0002\u0013%\u001cHI]5wKJ\u0004\u0013\u0001B2p]\u001a\u0004\"AM\u001a\u000e\u0003YI!\u0001\u000e\f\u0003\u0013M\u0003\u0018M]6D_:4\u0017A\u0002\u001fj]&$h\bF\u00028si\u0002\"\u0001\u000f\u0001\u000e\u0003QAQ!\u000b\u0003A\u00021BQ\u0001\r\u0003A\u0002E\n1\"\u001b8ji&\fG.\u001b>fI\u0006y\u0011N\\5uS\u0006d\u0017N_3e?\u0012*\u0017\u000f\u0006\u0002?\u0003B\u0011adP\u0005\u0003\u0001~\u0011A!\u00168ji\"9!IBA\u0001\u0002\u0004a\u0013a\u0001=%c\u0005a\u0011N\\5uS\u0006d\u0017N_3eA\u0005\u0001\"M]8bI\u000e\f7\u000f\u001e$bGR|'/_\u000b\u0002\rB\u0011\u0001hR\u0005\u0003\u0011R\u0011\u0001C\u0011:pC\u0012\u001c\u0017m\u001d;GC\u000e$xN]=\u0002)\t\u0014x.\u00193dCN$h)Y2u_JLx\fJ3r)\tq4\nC\u0004C\u0013\u0005\u0005\t\u0019\u0001$\u0002#\t\u0014x.\u00193dCN$h)Y2u_JL\b%\u0001\u0006j]&$\u0018.\u00197ju\u0016$\u0012AP\u0001\u0005gR|\u0007/A\boKb$(I]8bI\u000e\f7\u000f^%e+\u0005\u0011\u0006CA*]\u001b\u0005!&BA+W\u0003\u0019\tGo\\7jG*\u0011q\u000bW\u0001\u000bG>t7-\u001e:sK:$(BA-[\u0003\u0011)H/\u001b7\u000b\u0003m\u000bAA[1wC&\u0011Q\f\u0016\u0002\u000b\u0003R|W.[2M_:<\u0017\u0001\u00058fqR\u0014%o\\1eG\u0006\u001cH/\u00133!\u00031\u0019\u0017m\u00195fIZ\u000bG.^3t+\u0005\t\u0007\u0003\u00022dK\u0016l\u0011\u0001W\u0005\u0003Ib\u00131!T1q!\tqb-\u0003\u0002h?\t\u0019\u0011I\\=\u0002\u001b\r\f7\r[3e-\u0006dW/Z:!\u00031qWm\u001e\"s_\u0006$7-Y:u+\tY'\u000fF\u0003m\u0003\u0003\t)\u0001\u0006\u0002nqB\u0019\u0001H\u001c9\n\u0005=$\"!\u0003\"s_\u0006$7-Y:u!\t\t(\u000f\u0004\u0001\u0005\u000bM\f\"\u0019\u0001;\u0003\u0003Q\u000b\"!^3\u0011\u0005y1\u0018BA< \u0005\u001dqu\u000e\u001e5j]\u001eDq!_\t\u0002\u0002\u0003\u000f!0\u0001\u0006fm&$WM\\2fIE\u00022a\u001f@q\u001b\u0005a(BA? \u0003\u001d\u0011XM\u001a7fGRL!a ?\u0003\u0011\rc\u0017m]:UC\u001eDa!a\u0001\u0012\u0001\u0004\u0001\u0018A\u0002<bYV,w\f\u0003\u0004\u0002\bE\u0001\r\u0001L\u0001\bSNdunY1m\u0003-)hN\u0019:pC\u0012\u001c\u0017m\u001d;\u0015\u000fy\ni!a\u0006\u0002\u001c!9\u0011q\u0002\nA\u0002\u0005E\u0011AA5e!\rq\u00121C\u0005\u0004\u0003+y\"\u0001\u0002'p]\u001eDa!!\u0007\u0013\u0001\u0004a\u0013\u0001\u0005:f[>4XM\u0012:p[\u0012\u0013\u0018N^3s\u0011\u0019\tiB\u0005a\u0001Y\u0005A!\r\\8dW&tw\r")
public class BroadcastManager
implements Logging {
    private final boolean isDriver;
    private final SparkConf conf;
    private boolean initialized;
    private BroadcastFactory broadcastFactory;
    private final AtomicLong nextBroadcastId;
    private final Map<Object, Object> cachedValues;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public boolean isDriver() {
        return this.isDriver;
    }

    private boolean initialized() {
        return this.initialized;
    }

    private void initialized_$eq(boolean x$1) {
        this.initialized = x$1;
    }

    private BroadcastFactory broadcastFactory() {
        return this.broadcastFactory;
    }

    private void broadcastFactory_$eq(BroadcastFactory x$1) {
        this.broadcastFactory = x$1;
    }

    private synchronized void initialize() {
        block0: {
            if (this.initialized()) break block0;
            this.broadcastFactory_$eq(new TorrentBroadcastFactory());
            this.broadcastFactory().initialize(this.isDriver(), this.conf);
            this.initialized_$eq(true);
        }
    }

    public void stop() {
        this.broadcastFactory().stop();
    }

    private AtomicLong nextBroadcastId() {
        return this.nextBroadcastId;
    }

    public Map<Object, Object> cachedValues() {
        return this.cachedValues;
    }

    public <T> Broadcast<T> newBroadcast(T value_, boolean isLocal, ClassTag<T> evidence$1) {
        long bid = this.nextBroadcastId().getAndIncrement();
        T t = value_;
        if (t instanceof PythonBroadcast) {
            PythonBroadcast pythonBroadcast = (PythonBroadcast)t;
            pythonBroadcast.setBroadcastId(bid);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        return this.broadcastFactory().newBroadcast(value_, isLocal, bid, evidence$1);
    }

    public void unbroadcast(long id, boolean removeFromDriver, boolean blocking) {
        this.broadcastFactory().unbroadcast(id, removeFromDriver, blocking);
    }

    public BroadcastManager(boolean isDriver, SparkConf conf) {
        this.isDriver = isDriver;
        this.conf = conf;
        Logging.$init$(this);
        this.initialized = false;
        this.broadcastFactory = null;
        this.initialize();
        this.nextBroadcastId = new AtomicLong(0L);
        this.cachedValues = Collections.synchronizedMap(new ReferenceMap(AbstractReferenceMap.ReferenceStrength.HARD, AbstractReferenceMap.ReferenceStrength.WEAK));
    }
}

