/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.readers;

import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.compress.readers.ReaderColumnSelection;
import org.apache.sysds.runtime.compress.utils.DblArray;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class ReaderColumnSelectionDenseSingleBlockTransposed
extends ReaderColumnSelection {
    private final double[] _data;
    private final int _nColIn;

    protected ReaderColumnSelectionDenseSingleBlockTransposed(MatrixBlock data, IColIndex colIndexes, int rl, int ru) {
        super(colIndexes, rl, Math.min(ru, data.getNumColumns()) - 1);
        this._data = data.getDenseBlockValues();
        this._nColIn = data.getNumColumns();
    }

    @Override
    protected DblArray getNextRow() {
        boolean empty = true;
        while (empty && this._rl < this._ru) {
            ++this._rl;
            for (int i = 0; i < this._colIndexes.size(); ++i) {
                double v = this._data[this._colIndexes.get(i) * this._nColIn + this._rl];
                boolean isNan = Double.isNaN(v);
                if (isNan) {
                    this.warnNaN();
                    this.reusableArr[i] = 0.0;
                    continue;
                }
                empty &= v == 0.0;
                this.reusableArr[i] = v;
            }
        }
        return empty ? null : this.reusableReturn;
    }
}

