/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.frame.data.iterators;

import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.frame.data.iterators.RowIterator;
import org.apache.sysds.runtime.util.UtilFunctions;

public class ObjectRowIterator
extends RowIterator<Object> {
    private final Types.ValueType[] _tgtSchema;

    protected ObjectRowIterator(FrameBlock fb, int rl, int ru) {
        this(fb, rl, ru, UtilFunctions.getSeqArray(1, fb.getNumColumns(), 1), null);
    }

    protected ObjectRowIterator(FrameBlock fb, int rl, int ru, Types.ValueType[] schema) {
        this(fb, rl, ru, UtilFunctions.getSeqArray(1, fb.getNumColumns(), 1), schema);
    }

    protected ObjectRowIterator(FrameBlock fb, int rl, int ru, int[] cols) {
        this(fb, rl, ru, cols, null);
    }

    protected ObjectRowIterator(FrameBlock fb, int rl, int ru, int[] cols, Types.ValueType[] schema) {
        super(fb, rl, ru, cols);
        this._tgtSchema = schema;
    }

    @Override
    protected Object[] createRow(int size) {
        return new Object[size];
    }

    @Override
    public Object[] next() {
        for (int j = 0; j < this._cols.length; ++j) {
            this._curRow[j] = this.getValue(this._curPos, this._cols[j] - 1);
        }
        ++this._curPos;
        return this._curRow;
    }

    private Object getValue(int i, int j) {
        Object val = this._fb.get(i, j);
        if (this._tgtSchema != null) {
            val = UtilFunctions.objectToObject(this._tgtSchema[j], val);
        }
        return val;
    }
}

