/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.util;

import java.util.ArrayList;
import java.util.Random;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.util.LinearRegression;

public class EMAUtils {
    public static FrameBlock exponentialMovingAverageImputation(FrameBlock block, int search_iterations, String mode, int freq, Double alpha, Double beta, Double gamma) {
        int cols = block.getNumColumns();
        int rows = block.getNumRows();
        ArrayList<Double[]> data_list = new ArrayList<Double[]>();
        for (int j = 0; j < cols; ++j) {
            String[] values = (String[])block.getColumnData(j);
            Double[] data = new Double[values.length];
            for (int i = 0; i < values.length; ++i) {
                data[i] = Double.valueOf(values[i]);
            }
            Container best_cont = new Container(new Double[]{0.0}, 1000.0);
            Random rand = new Random();
            Container lst = null;
            for (int i = 0; i < search_iterations; ++i) {
                if (Double.isNaN(alpha)) {
                    alpha = rand.nextDouble();
                }
                if (Double.isNaN(beta)) {
                    beta = rand.nextDouble();
                }
                if (Double.isNaN(gamma)) {
                    gamma = rand.nextDouble();
                }
                if (mode.equals("single")) {
                    lst = EMAUtils.single_exponential_smoothing(data, alpha);
                } else if (mode.equals("double")) {
                    lst = EMAUtils.double_exponential_smoothing(data, alpha, beta);
                } else if (mode.equals("triple")) {
                    lst = EMAUtils.triple_exponential_smoothing(data, alpha, beta, gamma, freq);
                }
                if (lst == null) {
                    throw new DMLRuntimeException("invalid null pointer");
                }
                if (i != 0 && !(lst.rsme < best_cont.rsme)) continue;
                best_cont = lst;
                data_list.add(best_cont.values);
            }
        }
        Double[][] values = new Double[][]{};
        FrameBlock new_block = EMAUtils.generateBlock(rows, cols, (Double[][])data_list.toArray((T[])values));
        return new_block;
    }

    private static FrameBlock generateBlock(int rows, int cols, Double[][] values) {
        Types.ValueType[] schema = new Types.ValueType[cols];
        for (int i = 0; i < cols; ++i) {
            schema[i] = Types.ValueType.FP64;
        }
        String[] names = new String[cols];
        for (int i = 0; i < cols; ++i) {
            names[i] = schema[i].toString();
        }
        FrameBlock frameBlock = new FrameBlock(schema, names);
        frameBlock.ensureAllocatedColumns(rows);
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < cols; ++col) {
                frameBlock.set(row, col, values[col][row]);
            }
        }
        return frameBlock;
    }

    public static Container single_exponential_smoothing(Double[] data, Double alpha) {
        int i;
        int n = data.length;
        Double[] pred = new Double[n];
        pred[0] = data[0];
        double val = 0.0;
        ArrayList<Double> not_missing = new ArrayList<Double>();
        ArrayList<Double> not_missing_pred = new ArrayList<Double>();
        int n_size = 0;
        for (i = 1; i < n; ++i) {
            val = Double.isNaN(data[i]) ? pred[i - 1].doubleValue() : data[i].doubleValue();
            pred[i] = alpha * val + (1.0 - alpha) * pred[i - 1];
        }
        for (i = 0; i < data.length; ++i) {
            if (Double.isNaN(data[i])) continue;
            not_missing.add(data[i]);
            not_missing_pred.add(pred[i]);
            ++n_size;
        }
        double sum = 0.0;
        for (int i2 = 0; i2 < not_missing.size(); ++i2) {
            sum += Math.pow((Double)not_missing.get(i2) - (Double)not_missing_pred.get(i2), 2.0);
        }
        double rmse = Math.sqrt(sum / (double)n_size);
        return new Container(pred, rmse);
    }

    public static Container double_exponential_smoothing(Double[] data, Double alpha, Double beta) {
        int i;
        int n = data.length;
        ArrayList<Double> pred = new ArrayList<Double>(n - 1);
        Double[] s = new Double[n - 1];
        Double[] b = new Double[n - 1];
        s[0] = data[1];
        b[0] = data[1] - data[0];
        pred.add(s[0] + b[0]);
        double val = 0.0;
        ArrayList<Double> not_missing = new ArrayList<Double>();
        ArrayList<Double> not_missing_pred = new ArrayList<Double>();
        int n_size = 0;
        for (i = 1; i < n - 1; ++i) {
            val = Double.isNaN(data[i + 1]) ? ((Double)pred.get(i - 1)).doubleValue() : data[i + 1].doubleValue();
            s[i] = alpha * val + (1.0 - alpha) * (s[i - 1] + b[i - 1]);
            b[i] = beta * (s[i] - s[i - 1]) + (1.0 - beta) * b[i - 1];
            pred.add(s[i] + b[i]);
        }
        pred.add(0, data[0]);
        for (i = 0; i < data.length; ++i) {
            if (Double.isNaN(data[i])) continue;
            not_missing.add(data[i]);
            not_missing_pred.add((Double)pred.get(i));
            ++n_size;
        }
        double sum = 0.0;
        for (int i2 = 0; i2 < not_missing.size(); ++i2) {
            sum += Math.pow((Double)not_missing.get(i2) - (Double)not_missing_pred.get(i2), 2.0);
        }
        double rmse = Math.sqrt(sum / (double)n_size);
        Double[] content = new Double[pred.size()];
        return new Container(pred.toArray(content), rmse);
    }

    public static Container triple_exponential_smoothing(Double[] data, Double alpha, Double beta, Double gamma, Integer freq) {
        int i;
        double l = freq * 2;
        ArrayList<Double> start_data = new ArrayList<Double>();
        int i2 = 0;
        while ((double)i2 < l) {
            start_data.add(data[i2]);
            ++i2;
        }
        ArrayList<Double> filt = new ArrayList<Double>();
        ArrayList<Double> trend = new ArrayList<Double>();
        double len = freq.intValue();
        if (freq % 2 == 0) {
            len = freq - 1;
        }
        int i3 = 0;
        while ((double)i3 < len) {
            filt.add(1.0 / (double)freq.intValue());
            ++i3;
        }
        if (freq % 2 == 0) {
            filt.add(0, 0.5 / (double)freq.intValue());
            filt.add(0.5 / (double)freq.intValue());
        }
        double trend_len = l - (double)filt.size() + 1.0;
        int i4 = 0;
        while ((double)i4 < l - trend_len) {
            double sum = 0.0;
            for (int j = i4; j < i4 + filt.size(); ++j) {
                sum += (Double)start_data.get(j) * (Double)filt.get(j - i4);
            }
            trend.add(sum);
            ++i4;
        }
        int cut = (int)(l - (double)trend.size()) / 2;
        ArrayList<Double> season_tmp = new ArrayList<Double>();
        for (int i5 = cut; i5 < start_data.size() - cut; ++i5) {
            season_tmp.add((Double)start_data.get(i5) - (Double)trend.get(i5 - cut));
        }
        Double[] season = new Double[freq.intValue()];
        for (int i6 = 0; i6 < freq; ++i6) {
            double combined = 0.0;
            combined = i6 + freq < trend.size() ? ((Double)season_tmp.get(i6) + (Double)season_tmp.get(i6 + freq)) / 2.0 : (Double)season_tmp.get(i6);
            season[(i6 + freq.intValue() / 2) % freq.intValue()] = combined;
        }
        double sum = 0.0;
        for (int i7 = 0; i7 < season.length; ++i7) {
            sum += season[i7].doubleValue();
        }
        double mean = sum / (double)season.length;
        for (int i8 = 0; i8 < season.length; ++i8) {
            season[i8] = season[i8] - mean;
        }
        double[] x = new double[trend.size()];
        double[] y = new double[trend.size()];
        for (int i9 = 0; i9 < trend.size(); ++i9) {
            x[i9] = i9 + 1;
            y[i9] = (Double)trend.get(i9);
        }
        LinearRegression linreg = new LinearRegression(x, y);
        int n = data.length;
        double[] s = new double[n - freq];
        s[0] = linreg.intercept();
        double[] b = new double[n - freq];
        b[0] = linreg.coef();
        double[] c = new double[n];
        for (int i10 = 0; i10 < freq; ++i10) {
            c[i10] = season[i10];
        }
        ArrayList<Double> pred = new ArrayList<Double>();
        pred.add(s[0] + b[0] + c[0]);
        double val = 0.0;
        ArrayList<Double> not_missing = new ArrayList<Double>();
        ArrayList<Double> not_missing_pred = new ArrayList<Double>();
        int n_size = 0;
        for (i = 1; i < n - freq; ++i) {
            val = Double.isNaN(data[i + freq - 1]) ? ((Double)pred.get(i - 1)).doubleValue() : data[i + freq - 1].doubleValue();
            s[i] = alpha * (val - c[i - 1]) + (1.0 - alpha) * (s[i - 1] + b[i - 1]);
            b[i] = beta * (s[i] - s[i - 1]) + (1.0 - beta) * b[i - 1];
            c[i + freq.intValue() - 1] = gamma * (val - s[i]) + (1.0 - gamma) * c[i - 1];
            pred.add(s[i] + b[i] + c[i]);
        }
        for (i = 0; i < freq; ++i) {
            pred.add(i, data[i]);
        }
        for (i = 0; i < data.length; ++i) {
            if (Double.isNaN(data[i])) continue;
            not_missing.add(data[i]);
            not_missing_pred.add((Double)pred.get(i));
            ++n_size;
        }
        sum = 0.0;
        for (i = 0; i < not_missing.size(); ++i) {
            sum += Math.pow((Double)not_missing.get(i) - (Double)not_missing_pred.get(i), 2.0);
        }
        double rmse = Math.sqrt(sum / (double)n_size);
        Double[] content = new Double[pred.size()];
        return new Container(pred.toArray(content), rmse);
    }

    static class Container {
        Double[] values;
        double rsme;

        public Container(Double[] vals, double error) {
            this.values = vals;
            this.rsme = error;
        }
    }
}

