/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.context;

import org.apache.sysds.api.DMLScript;
import org.apache.sysds.common.Types;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.runtime.controlprogram.LocalVariableMap;
import org.apache.sysds.runtime.controlprogram.Program;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.context.SparkExecutionContext;

public class ExecutionContextFactory {
    public static ExecutionContext createContext() {
        return ExecutionContextFactory.createContext(true, DMLScript.LINEAGE, null);
    }

    public static ExecutionContext createContext(Program prog) {
        return ExecutionContextFactory.createContext(true, DMLScript.LINEAGE, prog);
    }

    public static SparkExecutionContext createSparkExecutionContext() {
        return (SparkExecutionContext)ExecutionContextFactory.createContext(true, DMLScript.LINEAGE, null, Types.ExecMode.SPARK);
    }

    public static ExecutionContext createContext(Types.ExecMode mode) {
        return ExecutionContextFactory.createContext(true, DMLScript.LINEAGE, null, mode);
    }

    public static ExecutionContext createContext(LocalVariableMap vars, Program prog) {
        ExecutionContext ec = ExecutionContextFactory.createContext(false, prog);
        ec.setVariables(vars);
        return ec;
    }

    public static ExecutionContext createContext(boolean allocateVars, Program prog) {
        return ExecutionContextFactory.createContext(allocateVars, DMLScript.LINEAGE, prog);
    }

    public static ExecutionContext createContext(boolean allocateVars, boolean allocateLineage, Program prog) {
        return ExecutionContextFactory.createContext(allocateVars, allocateLineage, prog, DMLScript.getGlobalExecMode());
    }

    public static ExecutionContext createContext(boolean allocateVars, boolean allocateLineage, Program prog, Types.ExecMode mode) {
        ExecutionContext ec = null;
        switch (mode) {
            case SINGLE_NODE: {
                if (!(OptimizerUtils.getDefaultExecutionMode() != Types.ExecMode.HYBRID || prog != null && prog.getDMLProg() != null && prog.getDMLProg().containsRemoteParfor())) {
                    ec = new ExecutionContext(allocateVars, allocateLineage, prog);
                    break;
                }
                ec = new SparkExecutionContext(allocateVars, allocateLineage, prog);
                break;
            }
            case SPARK: 
            case HYBRID: {
                ec = new SparkExecutionContext(allocateVars, allocateLineage, prog);
            }
        }
        return ec;
    }
}

