/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.federated.monitoring.services;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.federated.FederatedData;
import org.apache.sysds.runtime.controlprogram.federated.FederatedRequest;
import org.apache.sysds.runtime.controlprogram.federated.FederatedResponse;
import org.apache.sysds.runtime.controlprogram.federated.FederatedStatistics;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.CoordinatorConnectionModel;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.CoordinatorModel;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.DataObjectModel;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.EventModel;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.EventStageModel;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.HeavyHitterModel;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.RequestModel;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.StatisticsModel;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.StatisticsOptions;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.TrafficModel;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.UtilizationModel;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.repositories.DerbyRepository;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.repositories.IRepository;

public class StatisticsService {
    private static final IRepository entityRepository = new DerbyRepository();

    public StatisticsModel getAll(Long workerId, StatisticsOptions options) {
        CompletionStage utilizationFuture = null;
        CompletionStage trafficFuture = null;
        CompletionStage eventsFuture = null;
        CompletionStage dataObjFuture = null;
        CompletionStage requestsFuture = null;
        CompletionStage heavyHittersFuture = null;
        StatisticsModel stats = new StatisticsModel();
        if (options.utilization) {
            utilizationFuture = CompletableFuture.supplyAsync(() -> entityRepository.getAllEntitiesByField("workerId", workerId, UtilizationModel.class, options.rowCount)).thenAcceptAsync(result -> {
                stats.utilization = result;
            });
        }
        if (options.traffic) {
            trafficFuture = CompletableFuture.supplyAsync(() -> entityRepository.getAllEntitiesByField("workerId", workerId, TrafficModel.class, options.rowCount)).thenAcceptAsync(result -> {
                stats.traffic = result;
            });
        }
        if (options.events) {
            eventsFuture = CompletableFuture.supplyAsync(() -> {
                List<EventModel> events = entityRepository.getAllEntitiesByField("workerId", workerId, EventModel.class, options.rowCount);
                for (EventModel event : events) {
                    event.setCoordinatorName(StatisticsService.entityRepository.getEntity((Long)event.coordinatorId, CoordinatorModel.class).name);
                    event.stages = entityRepository.getAllEntitiesByField("eventId", event.id, EventStageModel.class);
                }
                return events;
            }).thenAcceptAsync(result -> {
                stats.events = result;
            });
        }
        if (options.dataObjects) {
            dataObjFuture = CompletableFuture.supplyAsync(() -> entityRepository.getAllEntitiesByField("workerId", workerId, DataObjectModel.class)).thenAcceptAsync(result -> {
                stats.dataObjects = result;
            });
        }
        if (options.requests) {
            requestsFuture = CompletableFuture.supplyAsync(() -> entityRepository.getAllEntitiesByField("workerId", workerId, RequestModel.class)).thenAcceptAsync(result -> {
                stats.requests = result;
            });
        }
        if (options.heavyHitters) {
            heavyHittersFuture = CompletableFuture.supplyAsync(() -> entityRepository.getAllEntitiesByField("workerId", workerId, HeavyHitterModel.class)).thenAcceptAsync(result -> {
                stats.heavyHitters = result;
            });
        }
        List<CompletableFuture> completableFutures = Arrays.asList(utilizationFuture, trafficFuture, eventsFuture, dataObjFuture, requestsFuture, heavyHittersFuture);
        completableFutures.forEach(cf -> {
            try {
                cf.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        });
        return stats;
    }

    public static StatisticsModel getWorkerStatistics(Long id, String address) {
        StatisticsModel parsedStats = null;
        try {
            FederatedResponse statisticsResponse = null;
            Future<FederatedResponse> statisticsResponseFuture = StatisticsService.sendStatisticsRequest(address);
            if (statisticsResponseFuture != null) {
                statisticsResponse = statisticsResponseFuture.get();
            }
            if (statisticsResponse != null && statisticsResponse.isSuccessful()) {
                FederatedStatistics.FedStatsCollection aggFedStats = new FederatedStatistics.FedStatsCollection();
                Object[] tmp = statisticsResponse.getData();
                if (tmp[0] instanceof FederatedStatistics.FedStatsCollection) {
                    aggFedStats.aggregate((FederatedStatistics.FedStatsCollection)tmp[0]);
                }
                parsedStats = StatisticsService.parseStatistics(id, aggFedStats);
            }
        }
        catch (DMLRuntimeException statisticsResponse) {
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return parsedStats;
    }

    private static StatisticsModel parseStatistics(Long workerId, FederatedStatistics.FedStatsCollection aggFedStats) {
        UtilizationModel utilization = aggFedStats.utilization;
        List<TrafficModel> traffic = aggFedStats.coordinatorsTrafficBytes;
        List<EventModel> events = aggFedStats.workerEvents;
        List<DataObjectModel> dataObjects = aggFedStats.workerDataObjects;
        List<RequestModel> requests = aggFedStats.workerRequests;
        ArrayList<HeavyHitterModel> heavyHitters = new ArrayList<HeavyHitterModel>();
        utilization.workerId = workerId;
        traffic.forEach(t -> {
            t.workerId = workerId;
        });
        dataObjects.forEach(o -> {
            o.workerId = workerId;
        });
        for (EventModel eventModel : events) {
            eventModel.workerId = workerId;
            StatisticsService.setCoordinatorId(eventModel);
        }
        for (TrafficModel trafficModel : traffic) {
            trafficModel.workerId = workerId;
            StatisticsService.setCoordinatorId(trafficModel);
        }
        for (RequestModel requestModel : requests) {
            requestModel.workerId = workerId;
            StatisticsService.setCoordinatorId(requestModel);
        }
        for (Map.Entry entry : aggFedStats.heavyHitters.entrySet()) {
            HeavyHitterModel newHH = new HeavyHitterModel(workerId, (String)entry.getKey(), (Double)((Pair)entry.getValue()).getValue(), (Long)((Pair)entry.getValue()).getLeft());
            heavyHitters.add(newHH);
        }
        return new StatisticsModel(List.of(utilization), traffic, events, dataObjects, requests, heavyHitters);
    }

    private static void setCoordinatorId(CoordinatorConnectionModel entity) {
        List<Object> coordinators = new ArrayList();
        String monitoringKey = entity.getCoordinatorHostId();
        if (monitoringKey != null) {
            coordinators = entityRepository.getAllEntitiesByField("monitoringHostIdKey", monitoringKey, CoordinatorModel.class);
        }
        entity.coordinatorId = !coordinators.isEmpty() ? ((CoordinatorModel)coordinators.get((int)0)).id : Long.valueOf(-1L);
    }

    private static Future<FederatedResponse> sendStatisticsRequest(String address) {
        Future<FederatedResponse> result = null;
        Pattern pattern = Pattern.compile("(.*://)?([A-Za-z0-9\\-\\.]+)(:[0-9]+)?(.*)");
        Matcher matcher = pattern.matcher(address);
        if (matcher.find()) {
            String host = matcher.group(2);
            String portStr = matcher.group(3);
            int port = 80;
            if (portStr != null && !portStr.isBlank() && !portStr.isEmpty()) {
                port = Integer.parseInt(portStr.replace(":", ""));
            }
            InetSocketAddress isa = new InetSocketAddress(host, port);
            FederatedRequest frUDF = new FederatedRequest(FederatedRequest.RequestType.EXEC_UDF, -1L, new FederatedStatistics.FedStatsCollectFunction());
            try {
                result = FederatedData.executeFederatedOperation(isa, frUDF);
            }
            catch (DMLRuntimeException dre) {
                throw dre;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }
}

