/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.frame.data;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.api.DMLException;
import org.apache.sysds.common.Types;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.codegen.CodegenUtils;
import org.apache.sysds.runtime.controlprogram.caching.CacheBlock;
import org.apache.sysds.runtime.controlprogram.parfor.stat.InfrastructureAnalyzer;
import org.apache.sysds.runtime.controlprogram.parfor.util.IDSequence;
import org.apache.sysds.runtime.frame.data.columns.Array;
import org.apache.sysds.runtime.frame.data.columns.ArrayFactory;
import org.apache.sysds.runtime.frame.data.columns.ColumnMetadata;
import org.apache.sysds.runtime.frame.data.iterators.IteratorFactory;
import org.apache.sysds.runtime.frame.data.lib.FrameFromMatrixBlock;
import org.apache.sysds.runtime.frame.data.lib.FrameLibAppend;
import org.apache.sysds.runtime.frame.data.lib.FrameLibDetectSchema;
import org.apache.sysds.runtime.frame.data.lib.FrameLibRemoveEmpty;
import org.apache.sysds.runtime.frame.data.lib.FrameUtil;
import org.apache.sysds.runtime.functionobjects.ValueComparisonFunction;
import org.apache.sysds.runtime.instructions.cp.BooleanObject;
import org.apache.sysds.runtime.instructions.cp.DoubleObject;
import org.apache.sysds.runtime.instructions.cp.IntObject;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.data.Pair;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.meta.DataCharacteristics;
import org.apache.sysds.runtime.meta.MatrixCharacteristics;
import org.apache.sysds.runtime.util.CommonThreadPool;
import org.apache.sysds.runtime.util.DMVUtils;
import org.apache.sysds.runtime.util.EMAUtils;
import org.apache.sysds.runtime.util.IndexRange;
import org.apache.sysds.runtime.util.UtilFunctions;
import org.apache.sysds.utils.MemoryEstimates;

public class FrameBlock
implements CacheBlock<FrameBlock>,
Externalizable {
    private static final Log LOG = LogFactory.getLog((String)FrameBlock.class.getName());
    private static final long serialVersionUID = -3993450030207130665L;
    private static final IDSequence CLASS_ID = new IDSequence();
    public static final int BUFFER_SIZE = 1000000;
    private Types.ValueType[] _schema = null;
    private String[] _colnames = null;
    private ColumnMetadata[] _colmeta = null;
    private Array[] _coldata = null;
    private SoftReference<Object[]> _columnLocks = null;
    private int _nRow = 0;
    private long _msize = -1L;

    public FrameBlock() {
    }

    public FrameBlock(FrameBlock that) {
        this(that.getSchema(), that.getColumnNames(false));
        this.copy(that);
        this.setColumnMetadata(that.getColumnMetadata());
    }

    public FrameBlock(int ncols, Types.ValueType vt) {
        this(UtilFunctions.nCopies(ncols, vt), null, null);
    }

    public FrameBlock(Types.ValueType[] schema) {
        this(schema, null, null);
    }

    public FrameBlock(Types.ValueType[] schema, int rlen) {
        this(schema, null, null);
        this._nRow = rlen;
    }

    public FrameBlock(Types.ValueType[] schema, String[] names) {
        this(schema, names, null);
    }

    public FrameBlock(Types.ValueType[] schema, String[] names, int rlen) {
        this(schema, names, null);
        this._nRow = rlen;
    }

    public FrameBlock(Types.ValueType[] schema, String[][] data) {
        this(schema, null, data);
    }

    public FrameBlock(Types.ValueType[] schema, String constant, int nRow) {
        this();
        this._nRow = nRow;
        for (int i = 0; i < schema.length; ++i) {
            this.appendColumn(ArrayFactory.allocate(schema[i], nRow, constant));
        }
    }

    public FrameBlock(Types.ValueType[] schema, String[] names, String[][] data) {
        this._schema = schema;
        if (names != null) {
            this._colnames = names;
            if (schema.length != names.length) {
                throw new DMLRuntimeException("Invalid FrameBlock construction, invalid schema and names combination");
            }
        }
        this.ensureAllocateMeta();
        if (data != null) {
            for (int i = 0; i < data.length; ++i) {
                this.appendRow(data[i]);
            }
        }
    }

    public FrameBlock(Types.ValueType[] schema, String[] colNames, ColumnMetadata[] meta, Array<?>[] data) {
        this._schema = schema;
        this._colnames = colNames;
        this._colmeta = meta;
        this._coldata = data;
        this._nRow = data[0].size();
    }

    @Override
    public int getNumRows() {
        return this._nRow;
    }

    @Override
    public double getDouble(int r, int c) {
        return this._coldata[c].getAsDouble(r);
    }

    @Override
    public double getDoubleNaN(int r, int c) {
        return this._coldata[c].getAsNaNDouble(r);
    }

    @Override
    public String getString(int r, int c) {
        String s;
        Object o = this.get(r, c);
        String string = s = o == null ? null : o.toString();
        if (s != null && s.isEmpty()) {
            return null;
        }
        return s;
    }

    @Override
    public int getNumColumns() {
        return this._schema != null ? this._schema.length : 0;
    }

    @Override
    public DataCharacteristics getDataCharacteristics() {
        return new MatrixCharacteristics((long)this.getNumRows(), (long)this.getNumColumns(), -1);
    }

    public Types.ValueType[] getSchema() {
        return this._schema;
    }

    public void setSchema(Types.ValueType[] schema) {
        this._schema = schema;
    }

    public String[] getColumnNames() {
        return this.getColumnNames(true);
    }

    public FrameBlock getColumnNamesAsFrame() {
        FrameBlock fb = new FrameBlock(this.getNumColumns(), Types.ValueType.STRING);
        fb.appendRow(this.getColumnNames());
        return fb;
    }

    public String[] getColumnNames(boolean alloc) {
        if (this._colnames == null && alloc) {
            this._colnames = FrameBlock.createColNames(this.getNumColumns());
        }
        return this._colnames;
    }

    public String getColumnName(int c) {
        if (this._colnames == null) {
            this._colnames = FrameBlock.createColNames(this.getNumColumns());
        }
        return this._colnames[c];
    }

    public void setColumnNames(String[] colnames) {
        this._colnames = colnames;
    }

    public void setColumnName(int index, String name) {
        if (this._colnames == null) {
            this._colnames = FrameBlock.createColNames(this.getNumColumns());
        }
        this._colnames[index] = name;
    }

    public ColumnMetadata[] getColumnMetadata() {
        return this._colmeta;
    }

    public ColumnMetadata getColumnMetadata(int c) {
        return this._colmeta[c];
    }

    public Array<?>[] getColumns() {
        return this._coldata;
    }

    public boolean isColumnMetadataDefault() {
        boolean ret = true;
        for (int j = 0; j < this.getNumColumns() && ret; ret &= this.isColumnMetadataDefault(j), ++j) {
        }
        return ret;
    }

    public boolean isColumnMetadataDefault(int c) {
        return this._colmeta[c].isDefault();
    }

    public void setColumnMetadata(ColumnMetadata[] colmeta) {
        System.arraycopy(colmeta, 0, this._colmeta, 0, this._colmeta.length);
    }

    public void setColumnMetadata(int c, ColumnMetadata colmeta) {
        this._colmeta[c] = colmeta;
    }

    public Map<String, Integer> getColumnNameIDMap() {
        HashMap<String, Integer> ret = new HashMap<String, Integer>();
        for (int j = 0; j < this.getNumColumns(); ++j) {
            ret.put(this.getColumnName(j), j + 1);
        }
        return ret;
    }

    public void ensureAllocatedColumns(int numRows) {
        this._msize = -1L;
        int nRow = this.getNumRows();
        this.ensureAllocateMeta();
        if (this._coldata != null && this._schema.length == this._coldata.length) {
            if (nRow < numRows) {
                String[] tmp = new String[this.getNumColumns()];
                int len = numRows - nRow;
                for (int i = 0; i < len; ++i) {
                    this.appendRow(tmp);
                }
            }
            return;
        }
        this._coldata = new Array[this._schema.length];
        if (numRows > 0) {
            for (int j = 0; j < this._schema.length; ++j) {
                this._coldata[j] = ArrayFactory.allocate(this._schema[j], numRows);
            }
        }
        this._nRow = numRows;
    }

    private void ensureAllocateMeta() {
        if (this._colmeta == null || this._schema.length != this._colmeta.length) {
            this._colmeta = new ColumnMetadata[this._schema.length];
            for (int j = 0; j < this._schema.length; ++j) {
                this._colmeta[j] = new ColumnMetadata();
            }
        }
    }

    public void ensureColumnCompatibility(int newLen) {
        int nRow = this.getNumRows();
        if (this._coldata != null && this._coldata.length > 0 && (nRow == 0 || nRow != newLen)) {
            throw new RuntimeException("Mismatch in number of rows: " + newLen + " (expected: " + nRow + ")");
        }
        this._nRow = newLen;
    }

    public static String[] createColNames(int size) {
        return FrameBlock.createColNames(0, size);
    }

    public static String[] createColNames(int off, int size) {
        String[] ret = new String[size];
        for (int i = off + 1; i <= off + size; ++i) {
            ret[i - off - 1] = FrameBlock.createColName(i);
        }
        return ret;
    }

    public static String createColName(int i) {
        return "C" + i;
    }

    public boolean isColNamesDefault() {
        boolean ret = this._colnames != null;
        for (int j = 0; j < this.getNumColumns() && ret; ret &= this.isColNameDefault(j), ++j) {
        }
        return ret;
    }

    public boolean isColNameDefault(int i) {
        return this._colnames == null || this._colnames[i].equals("C" + (i + 1));
    }

    public void recomputeColumnCardinality() {
        for (int j = 0; j < this.getNumColumns(); ++j) {
            int card = 0;
            for (int i = 0; i < this.getNumRows(); ++i) {
                card += this.get(i, j) != null ? 1 : 0;
            }
            this._colmeta[j].setNumDistinct(card);
        }
    }

    public Object get(int r, int c) {
        return this._coldata[c].get(r);
    }

    public void set(int r, int c, Object val) {
        this._coldata[c].set(r, UtilFunctions.objectToObject(this._schema[c], val));
    }

    public void set(int r, int c, String val) {
        this._coldata[c].set(r, val);
    }

    public void reset(int nrow, boolean clearMeta) {
        int i;
        if (clearMeta) {
            this._schema = null;
            this._colnames = null;
            if (this._colmeta != null) {
                for (i = 0; i < this._colmeta.length; ++i) {
                    if (this.isColumnMetadataDefault(i)) continue;
                    this._colmeta[i] = new ColumnMetadata();
                }
            }
        }
        if (this._coldata != null) {
            for (i = 0; i < this._coldata.length; ++i) {
                this._coldata[i].reset(nrow);
            }
        }
        this._nRow = nrow;
        this._msize = -1L;
    }

    public void reset() {
        this.reset(0, true);
    }

    public void appendRow(Object[] row) {
        if (row.length != this._schema.length) {
            throw new DMLRuntimeException("Invalid number of values in rowAppend");
        }
        if (this._nRow == 0) {
            this.ensureAllocateMeta();
            this._coldata = new Array[this._schema.length];
            for (int j = 0; j < this._schema.length; ++j) {
                this._coldata[j] = ArrayFactory.allocate(this._schema[j], 1);
                this._coldata[j].set(0, row[j]);
            }
        } else {
            for (int j = 0; j < row.length; ++j) {
                this._coldata[j].append(row[j]);
            }
        }
        ++this._nRow;
        this._msize = -1L;
    }

    public void appendRow(String[] row) {
        if (row.length != this._schema.length) {
            throw new DMLRuntimeException("Invalid number of values in rowAppend");
        }
        if (this._nRow == 0) {
            this.ensureAllocateMeta();
            this._coldata = new Array[this._schema.length];
            for (int j = 0; j < this._schema.length; ++j) {
                this._coldata[j] = ArrayFactory.allocate(this._schema[j], 1);
                this._coldata[j].set(0, row[j]);
            }
        } else {
            for (int j = 0; j < row.length; ++j) {
                this._coldata[j].append(row[j]);
            }
        }
        ++this._nRow;
        this._msize = -1L;
    }

    public void appendColumn(String[] col) {
        this.ensureColumnCompatibility(col.length);
        this.appendColumnMetaData(Types.ValueType.STRING);
        this._coldata = FrameUtil.add(this._coldata, ArrayFactory.create(col));
    }

    public void appendColumn(boolean[] col) {
        this.ensureColumnCompatibility(col.length);
        this.appendColumnMetaData(Types.ValueType.BOOLEAN);
        this._coldata = FrameUtil.add(this._coldata, ArrayFactory.create(col));
    }

    public void appendColumn(int[] col) {
        this.ensureColumnCompatibility(col.length);
        this.appendColumnMetaData(Types.ValueType.INT32);
        this._coldata = FrameUtil.add(this._coldata, ArrayFactory.create(col));
    }

    public void appendColumn(long[] col) {
        this.ensureColumnCompatibility(col.length);
        this.appendColumnMetaData(Types.ValueType.INT64);
        this._coldata = FrameUtil.add(this._coldata, ArrayFactory.create(col));
    }

    public void appendColumn(float[] col) {
        this.ensureColumnCompatibility(col.length);
        this.appendColumnMetaData(Types.ValueType.FP32);
        this._coldata = FrameUtil.add(this._coldata, ArrayFactory.create(col));
    }

    public void appendColumn(double[] col) {
        this.ensureColumnCompatibility(col.length);
        this.appendColumnMetaData(Types.ValueType.FP64);
        this._coldata = FrameUtil.add(this._coldata, ArrayFactory.create(col));
    }

    private void appendColumnMetaData(Types.ValueType vt) {
        if (this._colnames != null) {
            this._colnames = (String[])ArrayUtils.add((Object[])this.getColumnNames(), (Object)FrameBlock.createColName(this._colnames.length + 1));
        }
        this._schema = (Types.ValueType[])ArrayUtils.add((Object[])this._schema, (Object)((Object)vt));
        this._colmeta = (ColumnMetadata[])ArrayUtils.add((Object[])this.getColumnMetadata(), (Object)new ColumnMetadata());
        this._msize = -1L;
    }

    public void appendColumns(double[][] cols) {
        int ncol = cols.length;
        boolean empty = this._schema == null;
        Types.ValueType[] tmpSchema = UtilFunctions.nCopies(ncol, Types.ValueType.FP64);
        Object[] tmpData = new Array[ncol];
        for (int j = 0; j < ncol; ++j) {
            tmpData[j] = ArrayFactory.create(cols[j]);
        }
        this._colnames = empty ? null : (String[])ArrayUtils.addAll((Object[])this.getColumnNames(), (Object[])FrameBlock.createColNames(this.getNumColumns(), ncol));
        this._schema = empty ? tmpSchema : (Types.ValueType[])ArrayUtils.addAll((Object[])this._schema, (Object[])tmpSchema);
        this._coldata = empty ? tmpData : (Array[])ArrayUtils.addAll((Object[])this._coldata, (Object[])tmpData);
        this._nRow = cols[0].length;
        this._msize = -1L;
    }

    public static FrameBlock convertToFrameBlock(MatrixBlock mb, Types.ValueType[] schema, int k) {
        return FrameFromMatrixBlock.convertToFrameBlock(mb, schema, k);
    }

    public void appendColumn(Array col) {
        this.ensureColumnCompatibility(col.size());
        this.appendColumnMetaData(col.getValueType());
        this._coldata = FrameUtil.add(this._coldata, col);
    }

    public Object getColumnData(int c) {
        return this._coldata[c].get();
    }

    public Types.ValueType getColumnType(int c) {
        return this._schema[c];
    }

    public Array<?> getColumn(int c) {
        return this._coldata[c];
    }

    public void setColumn(int c, Array<?> column) {
        if (this._coldata == null) {
            this._coldata = new Array[this.getNumColumns()];
            this._nRow = column.size();
        }
        if (column.size() != this._nRow) {
            throw new DMLRuntimeException("Invalid number of rows in set column");
        }
        this._coldata[c] = column;
        this._msize = -1L;
    }

    public void write(DataOutput out) throws IOException {
        boolean isDefaultMeta = this.isColNamesDefault() && this.isColumnMetadataDefault();
        out.writeInt(this.getNumRows());
        out.writeInt(this.getNumColumns());
        out.writeBoolean(isDefaultMeta);
        for (int j = 0; j < this.getNumColumns(); ++j) {
            byte type = this.getTypeForIO(j);
            out.writeByte(type);
            if (!isDefaultMeta) {
                out.writeUTF(this.getColumnName(j));
                this._colmeta[j].write(out);
            }
            if (type < 0) continue;
            this._coldata[j].write(out);
        }
    }

    private byte getTypeForIO(int col) {
        byte type = (byte)(this._schema[col].ordinal() + 1);
        if (this._coldata == null || this._coldata[col] == null) {
            type = (byte)(type * -1);
        }
        return type;
    }

    private Types.ValueType interpretByteAsType(byte type) {
        return Types.ValueType.values()[Math.abs(type) - 1];
    }

    public void readFields(DataInput in) throws IOException {
        this._nRow = in.readInt();
        int numCols = in.readInt();
        boolean isDefaultMeta = in.readBoolean();
        Types.ValueType[] valueTypeArray = this._schema = this._schema != null && this._schema.length == numCols ? this._schema : new Types.ValueType[numCols];
        this._colnames = this._colnames != null && this._colnames.length == numCols ? this._colnames : (isDefaultMeta ? null : new String[numCols]);
        this._colmeta = this._colmeta != null && this._colmeta.length == numCols ? this._colmeta : new ColumnMetadata[numCols];
        this._coldata = this._coldata != null && this._coldata.length == numCols ? this._coldata : new Array[numCols];
        for (int j = 0; j < numCols; ++j) {
            byte type = in.readByte();
            this._schema[j] = this.interpretByteAsType(type);
            if (!isDefaultMeta) {
                this._colnames[j] = in.readUTF();
                this._colmeta[j] = ColumnMetadata.read(in);
            } else {
                this._colmeta[j] = new ColumnMetadata();
            }
            if (type < 0) continue;
            this._coldata[j] = ArrayFactory.read(in, this._nRow);
        }
        this._msize = -1L;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.write(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.readFields(in);
    }

    @Override
    public long getInMemorySize() {
        if (this._msize > 0L) {
            return this._msize;
        }
        double size = 20.0;
        int clen = this.getNumColumns();
        size += MemoryEstimates.byteArrayCost(clen);
        size += this._colnames == null ? 8.0 : MemoryEstimates.stringArrayCost(this._colnames);
        size += MemoryEstimates.objectArrayCost(clen);
        for (ColumnMetadata mtd : this._colmeta) {
            size += mtd == null ? 8.0 : (double)mtd.getInMemorySize();
        }
        size += MemoryEstimates.objectArrayCost(clen);
        this._msize = (long)(size += this.arraysSizeInMemory());
        return this._msize;
    }

    private double arraysSizeInMemory() {
        int clen = this.getNumColumns();
        int rlen = this.getNumRows();
        double size = 0.0;
        if (this._coldata == null) {
            for (int j = 0; j < clen; ++j) {
                size += (double)ArrayFactory.getInMemorySize(this._schema[j], rlen);
            }
        } else if (rlen > 1000 && clen > 10 && ConfigurationManager.isParallelIOEnabled()) {
            ExecutorService pool = CommonThreadPool.get(InfrastructureAnalyzer.getLocalParallelism());
            try {
                size += (double)pool.submit(() -> ((Stream)Arrays.stream(this._coldata).parallel()).map(x -> x.getInMemorySize()).reduce(0L, Long::sum)).get().longValue();
                pool.shutdown();
            }
            catch (InterruptedException | ExecutionException e) {
                pool.shutdown();
                LOG.error((Object)e);
                for (Array aa : this._coldata) {
                    size += (double)aa.getInMemorySize();
                }
            }
        } else {
            for (Array aa : this._coldata) {
                size += (double)aa.getInMemorySize();
            }
        }
        return size;
    }

    @Override
    public long getExactSerializedSize() {
        long size = 9L;
        size += (long)(1 * this.getNumColumns());
        boolean isDefaultMeta = this.isColNamesDefault() && this.isColumnMetadataDefault();
        for (int j = 0; j < this.getNumColumns(); ++j) {
            byte type = this.getTypeForIO(j);
            if (!isDefaultMeta) {
                size += (long)IOUtilFunctions.getUTFSize(this.getColumnName(j));
                size += this._colmeta[j].getExactSerializedSize();
            }
            if (type < 0) continue;
            size += this._coldata[j].getExactSerializedSize();
        }
        return size;
    }

    @Override
    public boolean isShallowSerialize() {
        return this.isShallowSerialize(false);
    }

    @Override
    public boolean isShallowSerialize(boolean inclConvert) {
        boolean ret = true;
        for (int j = 0; j < this._schema.length && ret; ret &= this._coldata[j].isShallowSerialize(), ++j) {
        }
        return ret;
    }

    @Override
    public void toShallowSerializeBlock() {
    }

    @Override
    public void compactEmptyBlock() {
    }

    public FrameBlock binaryOperations(BinaryOperator bop, FrameBlock that, FrameBlock out) {
        if (this.getNumColumns() != that.getNumColumns() && this.getNumRows() != that.getNumColumns()) {
            throw new DMLRuntimeException("Frame dimension mismatch " + this.getNumRows() + " * " + this.getNumColumns() + " != " + that.getNumRows() + " * " + that.getNumColumns());
        }
        String[][] outputData = new String[this.getNumRows()][this.getNumColumns()];
        if (!(bop.fn instanceof ValueComparisonFunction)) {
            throw new DMLRuntimeException("Unsupported binary operation on frames (only comparisons supported)");
        }
        ValueComparisonFunction vcomp = (ValueComparisonFunction)bop.fn;
        out = this.executeValueComparisons(this, that, vcomp, outputData);
        return out;
    }

    private FrameBlock executeValueComparisons(FrameBlock frameBlock, FrameBlock that, ValueComparisonFunction vcomp, String[][] outputData) {
        for (int i = 0; i < this.getNumColumns(); ++i) {
            ScalarObject so2;
            ScalarObject so1;
            int j;
            if (this.getSchema()[i] == Types.ValueType.STRING || that.getSchema()[i] == Types.ValueType.STRING) {
                for (j = 0; j < this.getNumRows(); ++j) {
                    if (FrameBlock.checkAndSetEmpty(frameBlock, that, outputData, j, i)) continue;
                    String v1 = UtilFunctions.objectToString(this.get(j, i));
                    String v2 = UtilFunctions.objectToString(that.get(j, i));
                    outputData[j][i] = String.valueOf(vcomp.compare(v1, v2));
                }
                continue;
            }
            if (this.getSchema()[i] == Types.ValueType.FP64 || that.getSchema()[i] == Types.ValueType.FP64 || this.getSchema()[i] == Types.ValueType.FP32 || that.getSchema()[i] == Types.ValueType.FP32) {
                for (j = 0; j < this.getNumRows(); ++j) {
                    if (FrameBlock.checkAndSetEmpty(frameBlock, that, outputData, j, i)) continue;
                    so1 = new DoubleObject(Double.parseDouble(this.get(j, i).toString()));
                    so2 = new DoubleObject(Double.parseDouble(that.get(j, i).toString()));
                    outputData[j][i] = String.valueOf(vcomp.compare(so1.getDoubleValue(), so2.getDoubleValue()));
                }
                continue;
            }
            if (this.getSchema()[i] == Types.ValueType.INT64 || that.getSchema()[i] == Types.ValueType.INT64 || this.getSchema()[i] == Types.ValueType.INT32 || that.getSchema()[i] == Types.ValueType.INT32) {
                for (j = 0; j < this.getNumRows(); ++j) {
                    if (FrameBlock.checkAndSetEmpty(frameBlock, that, outputData, j, i)) continue;
                    so1 = new IntObject(Integer.parseInt(this.get(j, i).toString()));
                    so2 = new IntObject(Integer.parseInt(that.get(j, i).toString()));
                    outputData[j][i] = String.valueOf(vcomp.compare(so1.getLongValue(), so2.getLongValue()));
                }
                continue;
            }
            for (j = 0; j < this.getNumRows(); ++j) {
                if (FrameBlock.checkAndSetEmpty(frameBlock, that, outputData, j, i)) continue;
                so1 = new BooleanObject(Boolean.parseBoolean(this.get(j, i).toString()));
                so2 = new BooleanObject(Boolean.parseBoolean(that.get(j, i).toString()));
                outputData[j][i] = String.valueOf(vcomp.compare(so1.getBooleanValue(), so2.getBooleanValue()));
            }
        }
        return new FrameBlock(UtilFunctions.nCopies(frameBlock.getNumColumns(), Types.ValueType.BOOLEAN), outputData);
    }

    private static boolean checkAndSetEmpty(FrameBlock fb1, FrameBlock fb2, String[][] out, int r, int c) {
        if (fb1.get(r, c) == null || fb2.get(r, c) == null) {
            out[r][c] = fb1.get(r, c) == null && fb2.get(r, c) == null ? "true" : "false";
            return true;
        }
        return false;
    }

    public FrameBlock leftIndexingOperations(FrameBlock rhsFrame, IndexRange ixrange, FrameBlock ret) {
        return this.leftIndexingOperations(rhsFrame, (int)ixrange.rowStart, (int)ixrange.rowEnd, (int)ixrange.colStart, (int)ixrange.colEnd, ret);
    }

    public FrameBlock leftIndexingOperations(FrameBlock rhsFrame, int rl, int ru, int cl, int cu, FrameBlock ret) {
        if (rl < 0 || rl >= this.getNumRows() || ru < rl || ru >= this.getNumRows() || cl < 0 || cu >= this.getNumColumns() || cu < cl || cu >= this.getNumColumns()) {
            throw new DMLRuntimeException("Invalid values for frame indexing: [" + (rl + 1) + ":" + (ru + 1) + "," + (cl + 1) + ":" + (cu + 1) + "] must be within frame dimensions [" + this.getNumRows() + "," + this.getNumColumns() + "].");
        }
        if (ru - rl + 1 < rhsFrame.getNumRows() || cu - cl + 1 < rhsFrame.getNumColumns()) {
            throw new DMLRuntimeException("Invalid values for frame indexing: dimensions of the source frame [" + rhsFrame.getNumRows() + "x" + rhsFrame.getNumColumns() + "] do not match the shape of the frame specified by indices [" + (rl + 1) + ":" + (ru + 1) + ", " + (cl + 1) + ":" + (cu + 1) + "].");
        }
        if (ret == null) {
            ret = new FrameBlock();
        }
        ret._schema = (Types.ValueType[])this._schema.clone();
        ret._colnames = this._colnames != null ? (String[])this._colnames.clone() : null;
        ret._colmeta = (ColumnMetadata[])this._colmeta.clone();
        ret._coldata = new Array[this.getNumColumns()];
        ret._nRow = this._nRow;
        for (int j = 0; j < this.getNumColumns(); ++j) {
            Object tmp = this._coldata[j].clone();
            if (j >= cl && j <= cu) {
                if (this._schema[j] == rhsFrame._schema[j - cl]) {
                    ((Array)tmp).set(rl, ru, rhsFrame._coldata[j - cl]);
                } else {
                    for (int i = rl; i <= ru; ++i) {
                        ((Array)tmp).set(i, UtilFunctions.objectToObject(this._schema[j], rhsFrame._coldata[j - cl].get(i - rl)));
                    }
                }
            }
            ret._coldata[j] = tmp;
        }
        return ret;
    }

    public final FrameBlock slice(IndexRange ixrange, FrameBlock ret) {
        return this.slice((int)ixrange.rowStart, (int)ixrange.rowEnd, (int)ixrange.colStart, (int)ixrange.colEnd, ret);
    }

    public final FrameBlock slice(int rl, int ru) {
        return this.slice(rl, ru, 0, this.getNumColumns() - 1, false, null);
    }

    public final FrameBlock slice(int rl, int ru, boolean deep) {
        return this.slice(rl, ru, 0, this.getNumColumns() - 1, deep, null);
    }

    public final FrameBlock slice(int rl, int ru, int cl, int cu) {
        return this.slice(rl, ru, cl, cu, false, null);
    }

    public final FrameBlock slice(int rl, int ru, int cl, int cu, FrameBlock ret) {
        return this.slice(rl, ru, cl, cu, false, ret);
    }

    public final FrameBlock slice(int rl, int ru, int cl, int cu, boolean deep) {
        return this.slice(rl, ru, cl, cu, deep, null);
    }

    public FrameBlock slice(int rl, int ru, int cl, int cu, boolean deep, FrameBlock ret) {
        int j;
        this.validateSliceArgument(rl, ru, cl, cu);
        if (ret == null) {
            ret = new FrameBlock();
        }
        int numCols = cu - cl + 1;
        boolean isDefNames = this.isColNamesDefault();
        ret._nRow = ru - rl + 1;
        ret._schema = new Types.ValueType[numCols];
        ret._colnames = !isDefNames ? new String[numCols] : null;
        ret._colmeta = new ColumnMetadata[numCols];
        for (j = cl; j <= cu; ++j) {
            ret._schema[j - cl] = this._schema[j];
            ret._colmeta[j - cl] = this._colmeta[j];
            if (isDefNames) continue;
            ret._colnames[j - cl] = this.getColumnName(j);
        }
        if (ret._coldata == null) {
            ret._coldata = new Array[numCols];
        }
        if (ret.getNumRows() == this.getNumRows() && !deep) {
            for (j = cl; j <= cu; ++j) {
                ret._coldata[j - cl] = this._coldata[j];
            }
        } else {
            for (j = cl; j <= cu; ++j) {
                if (ret._coldata[j - cl] == null) {
                    ret._coldata[j - cl] = this._coldata[j].slice(rl, ru + 1);
                    continue;
                }
                ret._coldata[j - cl].set(0, ru - rl, this._coldata[j], rl);
            }
        }
        return ret;
    }

    protected void validateSliceArgument(int rl, int ru, int cl, int cu) {
        if (rl < 0 || rl >= this.getNumRows() || ru < rl || ru >= this.getNumRows() || cl < 0 || cu >= this.getNumColumns() || cu < cl || cu >= this.getNumColumns()) {
            throw new DMLRuntimeException("Invalid values for frame indexing: [" + (rl + 1) + ":" + (ru + 1) + "," + (cl + 1) + ":" + (cu + 1) + "] must be within frame dimensions [" + this.getNumRows() + "," + this.getNumColumns() + "]");
        }
    }

    public void slice(ArrayList<Pair<Long, FrameBlock>> outList, IndexRange range, int rowCut) {
        if (this.getNumRows() > 0) {
            if (outList.size() > 1) {
                throw new NotImplementedException("Not implemented slice of more than 1 block out");
            }
            int r = (int)range.rowStart;
            FrameBlock out = outList.get(0).getValue();
            if (range.rowStart < (long)rowCut) {
                this.slice(r, (int)Math.min((long)rowCut, range.rowEnd + 1L), (int)range.colStart, (int)range.colEnd, out);
            }
            if (range.rowEnd >= (long)rowCut) {
                this.slice(r, (int)range.rowEnd, (int)range.colStart, (int)range.colEnd, out);
            }
        }
    }

    public FrameBlock append(FrameBlock that, boolean cbind) {
        return FrameLibAppend.append(this, that, cbind);
    }

    public FrameBlock copy() {
        FrameBlock ret = new FrameBlock();
        ret.copy(this);
        return ret;
    }

    public void copy(FrameBlock src) {
        int nCol = src.getNumColumns();
        this._nRow = src.getNumRows();
        this._schema = Arrays.copyOf(src._schema, nCol);
        if (src._colnames != null) {
            this._colnames = Arrays.copyOf(src._colnames, nCol);
        }
        if (!src.isColumnMetadataDefault()) {
            this._colmeta = Arrays.copyOf(src._colmeta, nCol);
        }
        if (src._coldata != null) {
            this._coldata = new Array[nCol];
            for (int i = 0; i < nCol; ++i) {
                this._coldata[i] = src._coldata[i].clone();
            }
        }
        this._msize = -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy(int rl, int ru, int cl, int cu, FrameBlock src) {
        if (rl == 0 && cl == 0 && ru + 1 == this.getNumRows() && cu + 1 == this.getNumColumns()) {
            this.copy(src);
            return;
        }
        this.ensureAllocateMeta();
        if (this._coldata == null) {
            this._coldata = new Array[this._schema.length];
        }
        FrameBlock frameBlock = this;
        synchronized (frameBlock) {
            if (this._columnLocks == null) {
                Object[] locks = new Object[this._schema.length];
                for (int i = 0; i < locks.length; ++i) {
                    locks[i] = new Object();
                }
                this._columnLocks = new SoftReference<Object[]>(locks);
            }
        }
        Object[] locks = this._columnLocks.get();
        for (int j = cl; j <= cu; ++j) {
            Object object = locks[j];
            synchronized (object) {
                this._coldata[j] = ArrayFactory.set(this._coldata[j], src._coldata[j - cl], rl, ru, this._nRow);
                continue;
            }
        }
    }

    public HashMap<Object, Long> getRecodeMap(int col) {
        return this._coldata[col].getRecodeMap();
    }

    @Override
    public void merge(FrameBlock that, boolean appendOnly) {
        this.merge(that);
    }

    public void merge(FrameBlock that) {
        int j;
        if (that == null || that.getNumRows() == 0) {
            return;
        }
        if (this.getNumRows() != that.getNumRows() || this.getNumColumns() != that.getNumColumns()) {
            throw new DMLRuntimeException("Dimension mismatch on merge disjoint (target=" + this.getNumRows() + "x" + this.getNumColumns() + ", source=" + that.getNumRows() + "x" + that.getNumColumns() + ")");
        }
        for (j = 0; j < this.getNumColumns(); ++j) {
            if (that.isColumnMetadataDefault(j)) continue;
            this._colmeta[j].setNumDistinct(that._colmeta[j].getNumDistinct());
            this._colmeta[j].setMvValue(that._colmeta[j].getMvValue());
        }
        for (j = 0; j < this.getNumColumns(); ++j) {
            if (this._coldata[j].getValueType().equals((Object)that._coldata[j].getValueType())) {
                this._coldata[j].setNz(that._coldata[j]);
                continue;
            }
            this._coldata[j].setFromOtherTypeNz(that._coldata[j]);
        }
    }

    public FrameBlock zeroOutOperations(FrameBlock result, IndexRange range, boolean complementary, int iRowStartSrc, int iRowStartDest, int blen, int iMaxRowsToCopy) {
        int clen = this.getNumColumns();
        if (result == null) {
            result = new FrameBlock(this.getSchema());
        } else {
            result.reset(0, true);
            result.setSchema(this.getSchema());
        }
        result.ensureAllocatedColumns(blen);
        if (complementary) {
            int r = (int)range.rowStart;
            while ((long)r <= range.rowEnd && r + iRowStartDest < blen) {
                int c = (int)range.colStart;
                while ((long)c <= range.colEnd) {
                    result.set(r + iRowStartDest, c, this.get(r + iRowStartSrc, c));
                    ++c;
                }
                ++r;
            }
        } else {
            int c;
            int r;
            for (r = iRowStartDest; r < (int)range.rowStart && r - iRowStartDest < iMaxRowsToCopy; ++r) {
                for (c = 0; c < clen; ++c) {
                    result.set(r, c, this.get(r + iRowStartSrc - iRowStartDest, c));
                }
            }
            while (r <= (int)range.rowEnd && r - iRowStartDest < iMaxRowsToCopy) {
                for (c = 0; c < (int)range.colStart; ++c) {
                    result.set(r, c, this.get(r + iRowStartSrc - iRowStartDest, c));
                }
                for (c = (int)range.colEnd + 1; c < clen; ++c) {
                    result.set(r, c, this.get(r + iRowStartSrc - iRowStartDest, c));
                }
                ++r;
            }
            while (r - iRowStartDest < iMaxRowsToCopy) {
                for (c = 0; c < clen; ++c) {
                    result.set(r, c, this.get(r + iRowStartSrc - iRowStartDest, c));
                }
                ++r;
            }
        }
        return result;
    }

    public FrameBlock getSchemaTypeOf() {
        FrameBlock fb = new FrameBlock(UtilFunctions.nCopies(this.getNumColumns(), Types.ValueType.STRING));
        fb.appendRow((String[])Arrays.stream(this._schema).map(vt -> vt.toString()).toArray(String[]::new));
        return fb;
    }

    public final FrameBlock detectSchema(int k) {
        return FrameLibDetectSchema.detectSchema(this, k);
    }

    public final FrameBlock detectSchema(double sampleFraction, int k) {
        return FrameLibDetectSchema.detectSchema(this, sampleFraction, k);
    }

    public FrameBlock dropInvalidType(FrameBlock schema) {
        if (this.getNumColumns() != schema.getNumColumns()) {
            throw new DMLException("mismatch in number of columns in frame and its schema " + this.getNumColumns() + " != " + schema.getNumColumns());
        }
        String[] schemaString = (String[])IteratorFactory.getStringRowIterator(schema).next();
        for (int i = 0; i < this.getNumColumns(); ++i) {
            String type;
            Array<?> obj = this.getColumn(i);
            String schemaCol = schemaString[i];
            if (schemaCol.contains("FP")) {
                type = "FP";
            } else if (schemaCol.contains("INT")) {
                type = "INT";
            } else {
                if (schemaCol.contains("STRING")) continue;
                type = schemaCol;
            }
            for (int j = 0; j < this.getNumRows(); ++j) {
                String dataValue;
                Types.ValueType dataType;
                if (obj.get(j) == null || (dataType = FrameUtil.isType(dataValue = obj.get(j).toString().trim().replace("\"", "").toLowerCase())).toString().contains(type) || dataType == Types.ValueType.BOOLEAN && type.equals("INT") || dataType == Types.ValueType.BOOLEAN && type.equals("FP")) continue;
                LOG.warn((Object)("Datatype detected: " + dataType + " where expected: " + schemaString[i] + " col: " + (i + 1) + ", row:" + (j + 1)));
                this.set(j, i, null);
            }
        }
        return this;
    }

    public FrameBlock invalidByLength(MatrixBlock feaLen) {
        if (this.getNumColumns() != feaLen.getNumColumns()) {
            throw new DMLException("mismatch in number of columns in frame and corresponding feature-length vector");
        }
        FrameBlock outBlock = new FrameBlock(this);
        for (int i = 0; i < this.getNumColumns(); ++i) {
            if (feaLen.quickGetValue(0, i) == -1.0) continue;
            int validLength = (int)feaLen.quickGetValue(0, i);
            Array<?> obj = this.getColumn(i);
            for (int j = 0; j < obj.size(); ++j) {
                String dataValue;
                if (obj.get(j) == null || (dataValue = obj.get(j).toString()).length() <= validLength) continue;
                outBlock.set(j, i, null);
            }
        }
        return outBlock;
    }

    public void mapInplace(Function<String, String> fun) {
        for (int j = 0; j < this.getNumColumns(); ++j) {
            for (int i = 0; i < this.getNumRows(); ++i) {
                Object tmp = this.get(i, j);
                this.set(i, j, tmp == null ? tmp : UtilFunctions.objectToObject(this._schema[j], fun.apply(tmp.toString())));
            }
        }
    }

    public FrameBlock map(String lambdaExpr, long margin) {
        if (!lambdaExpr.contains("->")) {
            String args = lambdaExpr.substring(lambdaExpr.indexOf(40) + 1, lambdaExpr.indexOf(41));
            if (args.contains(",")) {
                String[] arguments = args.split(",");
                return DMVUtils.syntacticalPatternDiscovery(this, Double.parseDouble(arguments[0]), arguments[1]);
            }
            if (args.contains(";")) {
                String[] arguments = args.split(";");
                return EMAUtils.exponentialMovingAverageImputation(this, Integer.parseInt(arguments[0]), arguments[1], Integer.parseInt(arguments[2]), Double.parseDouble(arguments[3]), Double.parseDouble(arguments[4]), Double.parseDouble(arguments[5]));
            }
        }
        if (lambdaExpr.contains("jaccardSim")) {
            return this.mapDist(FrameBlock.getCompiledFunction(lambdaExpr, margin));
        }
        return this.map(FrameBlock.getCompiledFunction(lambdaExpr, margin), margin);
    }

    public FrameBlock frameRowReplication(FrameBlock rowToreplicate) {
        FrameBlock out = new FrameBlock(this);
        if (this.getNumColumns() != rowToreplicate.getNumColumns()) {
            throw new DMLRuntimeException("Mismatch number of columns");
        }
        if (rowToreplicate.getNumRows() > 1) {
            throw new DMLRuntimeException("only supported single rows frames to replicate");
        }
        for (int i = 0; i < this.getNumRows(); ++i) {
            for (int j = 0; j < this.getNumColumns(); ++j) {
                out.set(i, j, rowToreplicate.get(0, j));
            }
        }
        return out;
    }

    public FrameBlock valueSwap(FrameBlock schema) {
        String[] schemaString = (String[])IteratorFactory.getStringRowIterator(schema).next();
        String dataValue2 = null;
        double minSimScore = 0.0;
        int bestIdx = 0;
        for (int i = 0; i < schemaString.length; ++i) {
            schemaString[i] = schemaString[i].replaceAll("\\d", "");
        }
        double[] minColLength = new double[this.getNumColumns()];
        double[] maxColLength = new double[this.getNumColumns()];
        for (int k = 0; k < this.getNumColumns(); ++k) {
            Pair<Integer, Integer> minMax = this._coldata[k].getMinMaxLength();
            maxColLength[k] = minMax.getKey().intValue();
            minColLength[k] = minMax.getValue().intValue();
        }
        ArrayList<Integer> probColList = new ArrayList<Integer>();
        for (int i = 0; i < this.getNumColumns(); ++i) {
            for (int j = 0; j < this.getNumRows(); ++j) {
                if (this.get(j, i) == null) continue;
                String dataValue = this.get(j, i).toString().trim().replace("\"", "").toLowerCase();
                Types.ValueType dataType = FrameUtil.isType(dataValue);
                String type = dataType.toString().replaceAll("\\d", "");
                if (dataType.toString().contains(schemaString[i]) || dataType == Types.ValueType.BOOLEAN && schemaString[i].equals("INT") || dataType == Types.ValueType.BOOLEAN && schemaString[i].equals("FP") || dataType.toString().contains("INT") && schemaString[i].equals("FP")) continue;
                LOG.warn((Object)("conflict " + dataType + " " + schemaString[i] + " " + dataValue));
                for (int w = 0; w < schemaString.length; ++w) {
                    if (!schemaString[w].equals(type) || !((double)dataValue.length() > minColLength[w]) || !((double)dataValue.length() < maxColLength[w]) || w == i) continue;
                    Object item = this.get(j, w);
                    String dataValueProb = item != null ? item.toString().trim().replace("\"", "").toLowerCase() : "0";
                    Types.ValueType dataTypeProb = FrameUtil.isType(dataValueProb);
                    if (!dataTypeProb.toString().equals(schemaString[w])) {
                        bestIdx = w;
                        break;
                    }
                    probColList.add(w);
                }
                if (probColList.size() > 1) {
                    Iterator w = probColList.iterator();
                    while (w.hasNext()) {
                        int w2 = (Integer)w.next();
                        int randomIndex = ThreadLocalRandom.current().nextInt(0, this.getNumRows() - 1);
                        Object value = this.get(randomIndex, w2);
                        if (value != null) {
                            dataValue2 = value.toString();
                        }
                        double simScore = 0.0;
                        if (dataValue != null && dataValue2 != null) {
                            simScore = StringUtils.getLevenshteinDistance((String)dataValue, (String)dataValue2);
                        }
                        if (!(simScore < minSimScore)) continue;
                        minSimScore = simScore;
                        bestIdx = w2;
                    }
                } else if (probColList.size() > 0) {
                    bestIdx = (Integer)probColList.get(0);
                }
                String tmp = dataValue;
                this.set(j, i, this.get(j, bestIdx));
                this.set(j, bestIdx, tmp);
            }
        }
        return this;
    }

    public FrameBlock map(FrameMapFunction lambdaExpr, long margin) {
        String[][] output = new String[this.getNumRows()][this.getNumColumns()];
        if (margin == 1L) {
            for (int i = 0; i < this.getNumRows(); ++i) {
                String[] row = new String[this.getNumColumns()];
                for (int j = 0; j < this.getNumColumns(); ++j) {
                    Array<?> input = this.getColumn(j);
                    row[j] = String.valueOf(input.get(i));
                }
                output[i] = lambdaExpr.apply(row);
            }
        } else if (margin == 2L) {
            for (int j = 0; j < this.getNumColumns(); ++j) {
                String[] actualColumn = Arrays.copyOfRange((String[])this.getColumnData(j), 0, this.getNumRows());
                String[] outColumn = lambdaExpr.apply(actualColumn);
                for (int i = 0; i < this.getNumRows(); ++i) {
                    output[i][j] = outColumn[i];
                }
            }
        } else {
            for (int j = 0; j < this.getNumColumns(); ++j) {
                Array<?> input = this.getColumn(j);
                for (int i = 0; i < input.size(); ++i) {
                    if (input.get(i) == null) continue;
                    output[i][j] = lambdaExpr.apply(String.valueOf(input.get(i)));
                }
            }
        }
        return new FrameBlock(UtilFunctions.nCopies(this.getNumColumns(), Types.ValueType.STRING), output);
    }

    public FrameBlock mapDist(FrameMapFunction lambdaExpr) {
        String[][] output;
        for (Object[] objectArray : output = new String[this.getNumRows()][this.getNumRows()]) {
            Arrays.fill(objectArray, "0.0");
        }
        Array<?> input = this.getColumn(0);
        for (int j = 0; j < input.size() - 1; ++j) {
            for (int i = j + 1; i < input.size(); ++i) {
                if (input.get(i) == null || input.get(j) == null) continue;
                output[j][i] = lambdaExpr.apply(String.valueOf(input.get(j)), String.valueOf(input.get(i)));
            }
        }
        return new FrameBlock(UtilFunctions.nCopies(this.getNumRows(), Types.ValueType.STRING), output);
    }

    public static FrameMapFunction getCompiledFunction(String lambdaExpr, long margin) {
        String cname = "StringProcessing" + CLASS_ID.getNextID();
        StringBuilder sb = new StringBuilder();
        String[] parts = lambdaExpr.split("->");
        if (parts.length != 2) {
            throw new DMLRuntimeException("Unsupported lambda expression: " + lambdaExpr);
        }
        String[] varname = parts[0].replaceAll("[()]", "").split(",");
        String expr = parts[1].trim();
        sb.append("import org.apache.sysds.runtime.util.UtilFunctions;\n");
        sb.append("import org.apache.sysds.runtime.util.PorterStemmer;\n");
        sb.append("import org.apache.sysds.runtime.frame.data.FrameBlock.FrameMapFunction;\n");
        sb.append("import java.util.Arrays;\n");
        sb.append("public class " + cname + " extends FrameMapFunction {\n");
        if (margin != 0L) {
            sb.append("public String[] apply(String[] " + varname[0].trim() + ") {\n");
            sb.append("  return UtilFunctions.toStringArray(" + expr + "); }}\n");
        } else if (varname.length == 1) {
            sb.append("public String apply(String " + varname[0].trim() + ") {\n");
            sb.append("  return String.valueOf(" + expr + "); }}\n");
        } else if (varname.length == 2) {
            sb.append("public String apply(String " + varname[0].trim() + ", String " + varname[1].trim() + ") {\n");
            sb.append("  return String.valueOf(" + expr + "); }}\n");
        }
        try {
            return (FrameMapFunction)CodegenUtils.compileClass(cname, sb.toString()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new DMLRuntimeException("Failed to compile FrameMapFunction.", e);
        }
    }

    public <T> FrameBlock replaceOperations(String pattern, String replacement) {
        Types.ValueType replacementType;
        Types.ValueType patternType;
        FrameBlock ret = new FrameBlock(this);
        boolean NaNp = "NaN".equals(pattern);
        boolean NaNr = "NaN".equals(replacement);
        Types.ValueType valueType = UtilFunctions.isBoolean(pattern) ? Types.ValueType.BOOLEAN : (NumberUtils.isCreatable((String)pattern) | NaNp ? (UtilFunctions.isIntegerNumber(pattern) ? Types.ValueType.INT64 : Types.ValueType.FP64) : (patternType = Types.ValueType.STRING));
        Types.ValueType valueType2 = UtilFunctions.isBoolean(replacement) ? Types.ValueType.BOOLEAN : (NumberUtils.isCreatable((String)replacement) | NaNr ? (UtilFunctions.isIntegerNumber(replacement) ? Types.ValueType.INT64 : Types.ValueType.FP64) : (replacementType = Types.ValueType.STRING));
        if (patternType != replacementType || !Types.ValueType.isSameTypeString(patternType, replacementType)) {
            throw new DMLRuntimeException("Pattern and replacement types should be same: " + patternType + " " + replacementType);
        }
        for (int i = 0; i < ret.getNumColumns(); ++i) {
            Array colData = ret._coldata[i];
            for (int j = 0; j < colData.size() && (Types.ValueType.isSameTypeString(this._schema[i], patternType) || this._schema[i] == Types.ValueType.STRING); ++j) {
                Object patternNew = UtilFunctions.stringToObject(this._schema[i], pattern);
                Object replacementNew = UtilFunctions.stringToObject(this._schema[i], replacement);
                Object ent = colData.get(j);
                if (ent != null && ent.toString().equals(patternNew.toString())) {
                    colData.set(j, replacementNew);
                    continue;
                }
                if (!(ent instanceof String) || !ent.equals(pattern)) continue;
                colData.set(j, replacement);
            }
        }
        return ret;
    }

    public FrameBlock removeEmptyOperations(boolean rows, boolean emptyReturn, MatrixBlock select) {
        return FrameLibRemoveEmpty.removeEmpty(this, rows, emptyReturn, select);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FrameBlock");
        if (this._colnames != null) {
            sb.append("\n");
            sb.append(Arrays.toString(this._colnames));
        }
        if (!this.isColumnMetadataDefault()) {
            sb.append("\n");
            sb.append(Arrays.toString(this._colmeta));
        }
        sb.append("\n");
        sb.append(Arrays.toString((Object[])this._schema));
        sb.append("\n");
        if (this._coldata != null) {
            for (int i = 0; i < this._coldata.length; ++i) {
                sb.append(this._coldata[i]);
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public static class FrameMapFunction
    implements Serializable {
        private static final long serialVersionUID = -8398572153616520873L;

        public String apply(String input) {
            return null;
        }

        public String apply(String input1, String input2) {
            return null;
        }

        public String[] apply(String[] input1) {
            return null;
        }
    }
}

