/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.utils;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.utils.DArrCounts;
import org.apache.sysds.runtime.compress.utils.DblArray;
import org.apache.sysds.runtime.compress.utils.DoubleCountHashMap;
import org.apache.sysds.runtime.compress.utils.Util;

public class DblArrayCountHashMap {
    protected static final Log LOG = LogFactory.getLog((String)DoubleCountHashMap.class.getName());
    protected static final int RESIZE_FACTOR = 2;
    protected static final float LOAD_FACTOR = 0.8f;
    protected int _size = -1;
    private Bucket[] _data = null;

    public DblArrayCountHashMap(int init_capacity, int cols) {
        this._data = cols > 10 ? new Bucket[Util.getPow2(init_capacity)] : new Bucket[Util.getPow2(init_capacity / 2)];
        this._size = 0;
    }

    public int size() {
        return this._size;
    }

    private void appendValue(DArrCounts ent) {
        int hash = ent.key.hashCode();
        int ix = DblArrayCountHashMap.indexFor(hash, this._data.length);
        Bucket l = this._data[ix];
        if (l == null) {
            this._data[ix] = new Bucket(ent);
        } else {
            while (l != null) {
                l = l.n;
            }
            Bucket ob = this._data[ix];
            this._data[ix] = new Bucket(ent);
            this._data[ix].n = ob;
        }
        ++this._size;
    }

    public int increment(DblArray key) {
        int hash = key.hashCode();
        int ix = DblArrayCountHashMap.indexFor(hash, this._data.length);
        Bucket l = this._data[ix];
        while (l != null) {
            if (l.v.key.equals(key)) {
                ++l.v.count;
                return l.v.id;
            }
            l = l.n;
        }
        return this.addNewBucket(ix, key);
    }

    private synchronized int addNewBucket(int ix, DblArray key) {
        Bucket ob = this._data[ix];
        this._data[ix] = new Bucket(new DArrCounts(new DblArray(key), this._size));
        this._data[ix].n = ob;
        int id = this._size++;
        if ((float)this._size >= 0.8f * (float)this._data.length) {
            this.resize();
        }
        return id;
    }

    public int get(DblArray key) {
        int hash = key.hashCode();
        int ix = DblArrayCountHashMap.indexFor(hash, this._data.length);
        Bucket l = this._data[ix];
        while (!l.v.key.equals(key)) {
            l = l.n;
        }
        return l.v.count;
    }

    public int getId(DblArray key) {
        int ix = DblArrayCountHashMap.indexFor(key.hashCode(), this._data.length);
        Bucket l = this._data[ix];
        if (l == null) {
            return -1;
        }
        while (!l.v.key.equals(key)) {
            l = l.n;
            if (l != null) continue;
            return -1;
        }
        return l.v.id;
    }

    public ArrayList<DArrCounts> extractValues() {
        ArrayList<DArrCounts> ret = new ArrayList<DArrCounts>(this._size);
        for (Bucket e : this._data) {
            while (e != null) {
                ret.add(e.v);
                e = e.n;
            }
        }
        return ret;
    }

    public void replaceWithUIDs() {
        int i = 0;
        for (Bucket e : this._data) {
            while (e != null) {
                e.v.count = i++;
                e = e.n;
            }
        }
    }

    public int getSumCounts() {
        int c = 0;
        for (Bucket e : this._data) {
            while (e != null) {
                c += e.v.count;
                e = e.n;
            }
        }
        return c;
    }

    public int[] getUnorderedCountsAndReplaceWithUIDs() {
        int[] counts = new int[this._size];
        int i = 0;
        for (Bucket e : this._data) {
            while (e != null) {
                counts[i] = e.v.count;
                e.v.count = i++;
                e = e.n;
            }
        }
        return counts;
    }

    public int[] getUnorderedCountsAndReplaceWithUIDsWithExtraCell() {
        int[] counts = new int[this._size + 1];
        int i = 0;
        for (Bucket e : this._data) {
            while (e != null) {
                counts[i] = e.v.count;
                e.v.count = i++;
                e = e.n;
            }
        }
        return counts;
    }

    private void resize() {
        if (this._data.length > 0x3FFFFFFF) {
            return;
        }
        Bucket[] olddata = this._data;
        this._data = new Bucket[this._data.length * 2];
        this._size = 0;
        for (Bucket e : olddata) {
            while (e != null) {
                this.appendValue(e.v);
                e = e.n;
            }
        }
    }

    private static int indexFor(int h, int length) {
        return h & length - 1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        for (int i = 0; i < this._data.length; ++i) {
            if (this._data[i] == null) continue;
            sb.append(", " + this._data[i]);
        }
        return sb.toString();
    }

    public void reset(int size) {
        int p2 = Util.getPow2(size);
        if (this._data.length > 2 * p2) {
            this._data = new Bucket[p2];
        } else {
            Arrays.fill(this._data, null);
        }
        this._size = 0;
    }

    private static class Bucket {
        protected DArrCounts v;
        protected Bucket n = null;

        protected Bucket(DArrCounts v) {
            this.v = v;
        }

        public String toString() {
            if (this.n == null) {
                return this.v.toString();
            }
            return this.v.toString() + "->" + this.n.toString();
        }
    }
}

